# -*- coding: utf-8 -*-
# © 2016 LasLabs Inc.
# License GPL-3.0 or later (http://www.gnu.org/licenses/gpl.html).

from openerp import models, fields


class MedicalMedicamentComponent(models.Model):
    _name = 'medical.medicament.component'
    _description = 'Medical Medicament Component'
    medicament_ids = fields.Many2many(
        string='Related Medicaments',
        comodel_name='medical.medicament',
    )
    name = fields.Char(
        help='Component name.',
        required=True,
    )
    is_active_ingredient = fields.Boolean(
        string='Active Ingredient?',
        help='Check this if the component is an active ingredient.',
    )
    _sql_constraints = [
        ('name_uniq', 'UNIQUE(name)', 'Component names must be unique.')
    ]
