import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [cloudwatch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html).
 *
 * @experimental
 */
export declare class Cloudwatch extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to delete a collection of alarms.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DeleteAlarms.html
     *
     * @experimental
     */
    toDeleteAlarms(): this;
    /**
     * (experimental) Grants permission to delete the specified anomaly detection model from your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DeleteAnomalyDetector.html
     *
     * @experimental
     */
    toDeleteAnomalyDetector(): this;
    /**
     * (experimental) Grants permission to delete all CloudWatch dashboards that you specify.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DeleteDashboards.html
     *
     * @experimental
     */
    toDeleteDashboards(): this;
    /**
     * (experimental) Grants permission to delete a collection of insight rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DeleteInsightRules.html
     *
     * @experimental
     */
    toDeleteInsightRules(): this;
    /**
     * (experimental) Grants permission to retrieve the history for the specified alarm.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarmHistory.html
     *
     * @experimental
     */
    toDescribeAlarmHistory(): this;
    /**
     * (experimental) Grants permission to describe all alarms, currently owned by the user's account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html
     *
     * @experimental
     */
    toDescribeAlarms(): this;
    /**
     * (experimental) Grants permission to describe all alarms configured on the specified metric, currently owned by the user's account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarmsForMetric.html
     *
     * @experimental
     */
    toDescribeAlarmsForMetric(): this;
    /**
     * (experimental) Grants permission to lists the anomaly detection models that you have created in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAnomalyDetectors.html
     *
     * @experimental
     */
    toDescribeAnomalyDetectors(): this;
    /**
     * (experimental) Grants permission to describe all insight rules, currently owned by the user's account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html
     *
     * @experimental
     */
    toDescribeInsightRules(): this;
    /**
     * (experimental) Grants permission to disable actions for a collection of alarms.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DisableAlarmActions.html
     *
     * @experimental
     */
    toDisableAlarmActions(): this;
    /**
     * (experimental) Grants permission to disable a collection of insight rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DisableInsightRules.html
     *
     * @experimental
     */
    toDisableInsightRules(): this;
    /**
     * (experimental) Grants permission to enable actions for a collection of alarms.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_EnableAlarmActions.html
     *
     * @experimental
     */
    toEnableAlarmActions(): this;
    /**
     * (experimental) Grants permission to enable a collection of insight rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_EnableInsightRules.html
     *
     * @experimental
     */
    toEnableInsightRules(): this;
    /**
     * (experimental) Grants permission to display the details of the CloudWatch dashboard you specify.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetDashboard.html
     *
     * @experimental
     */
    toGetDashboard(): this;
    /**
     * (experimental) Grants permission to return the top-N report of unique contributors over a time range for a given insight rule.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html
     *
     * @experimental
     */
    toGetInsightRuleReport(): this;
    /**
     * (experimental) Grants permission to retrieve batch amounts of CloudWatch metric data and perform metric math on retrieved data.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html
     *
     * @experimental
     */
    toGetMetricData(): this;
    /**
     * (experimental) Grants permission to retrieve statistics for the specified metric.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html
     *
     * @experimental
     */
    toGetMetricStatistics(): this;
    /**
     * (experimental) Grants permission to retrieve snapshots of metric widgets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricWidgetImage.html
     *
     * @experimental
     */
    toGetMetricWidgetImage(): this;
    /**
     * (experimental) Grants permission to return a list of all CloudWatch dashboards in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListDashboards.html
     *
     * @experimental
     */
    toListDashboards(): this;
    /**
     * (experimental) Grants permission to retrieve a list of valid metrics stored for the AWS account owner.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html
     *
     * @experimental
     */
    toListMetrics(): this;
    /**
     * (experimental) Grants permission to list tags for an Amazon CloudWatch resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to create or update an anomaly detection model for a CloudWatch metric.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutAnomalyDetector.html
     *
     * @experimental
     */
    toPutAnomalyDetector(): this;
    /**
     * (experimental) Grants permission to create or update a composite alarm.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html
     *
     * @experimental
     */
    toPutCompositeAlarm(): this;
    /**
     * (experimental) Grants permission to create a CloudWatch dashboard, or update an existing dashboard if it already exists.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutDashboard.html
     *
     * @experimental
     */
    toPutDashboard(): this;
    /**
     * (experimental) Grants permission to create a new insight rule or replace an existing insight rule.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutInsightRule.html
     *
     * @experimental
     */
    toPutInsightRule(): this;
    /**
     * (experimental) Grants permission to create or update an alarm and associates it with the specified Amazon CloudWatch metric.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html
     *
     * @experimental
     */
    toPutMetricAlarm(): this;
    /**
     * (experimental) Grants permission to publish metric data points to Amazon CloudWatch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifNamespace()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricData.html
     *
     * @experimental
     */
    toPutMetricData(): this;
    /**
     * (experimental) Grants permission to temporarily set the state of an alarm for testing purposes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_SetAlarmState.html
     *
     * @experimental
     */
    toSetAlarmState(): this;
    /**
     * (experimental) Grants permission to add tags to an Amazon CloudWatch resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove a tag from an Amazon CloudWatch resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type alarm to the statement.
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html
     *
     * @param alarmName - Identifier for the alarmName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAlarm(alarmName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dashboard to the statement.
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html
     *
     * @param dashboardName - Identifier for the dashboardName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDashboard(dashboardName: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type insight-rule to the statement.
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html
     *
     * @param insightRuleName - Identifier for the insightRuleName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onInsightRule(insightRuleName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters actions based on the presence of optional namespace values.
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/iam-cw-condition-keys-namespace.html
     *
     * Applies to actions:
     * - .toPutMetricData()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifNamespace(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [cloudwatch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
