"""Dictionaries of key translations, used by `getch` and friends."""

POSIX_KEY_NAMES = {  # pylint: disable=cyclic-import
    "\x1b": ("esc", "escape"),
    "\x1b[A": ("up", "arrow-up"),
    "\x1b[B": ("down", "arrow-down"),
    "\x1b[C": ("right", "arrow-right"),
    "\x1b[D": ("left", "arrow-left"),
    "\x1b[1;2A": ("shift-up", "shift-arrow-up"),
    "\x1b[1;2B": ("shift-down", "shift-arrow-down"),
    "\x1b[1;2C": ("shift-right", "shift-arrow-right"),
    "\x1b[1;2D": ("shift-left", "shift-arrow-left"),
    "\x1b[1;3A": ("alt-up", "alt-arrow-up"),
    "\x1b[1;3B": ("alt-down", "alt-arrow-down"),
    "\x1b[1;3C": ("alt-right", "alt-arrow-right"),
    "\x1b[1;3D": ("alt-left", "alt-arrow-left"),
    "\x1b[1;4A": ("alt-shift-up", "alt-shift-arrow-up"),
    "\x1b[1;4B": ("alt-shift-down", "alt-shift-arrow-down"),
    "\x1b[1;4C": ("alt-shift-right", "alt-shift-arrow-right"),
    "\x1b[1;4D": ("alt-shift-left", "alt-shift-arrow-left"),
    "\x1b[1;6A": ("ctrl-shift-up", "ctrl-shift-arrow-up"),
    "\x1b[1;6B": ("ctrl-shift-down", "ctrl-shift-arrow-down"),
    "\x7f": ("backspace",),
    "\x1b\x7f": ("alt-backspace",),
    "\x01": ("ctrl-a",),
    "\x02": ("ctrl-b",),
    "\x03": ("ctrl-c",),
    "\x04": ("ctrl-d",),
    "\x05": ("ctrl-e",),
    "\x06": ("ctrl-f",),
    "\x07": ("ctrl-g",),
    "\x08": (
        "ctrl-backspace",
        "ctrl-h",
    ),
    "\t": (
        "tab",
        "ctrl-i",
    ),
    "\n": (
        "return",
        "ctrl-j",
    ),
    "\x0b": ("ctrl-k",),
    "\x0c": ("ctrl-l",),
    "\r": ("ctrl-m",),
    "\x0e": ("ctrl-n",),
    "\x0f": ("ctrl-o",),
    "\x10": ("ctrl-p",),
    "\x11": ("ctrl-q",),
    "\x12": ("ctrl-r",),
    "\x13": ("ctrl-s",),
    "\x14": ("ctrl-t",),
    "\x15": ("ctrl-u",),
    "\x16": ("ctrl-v",),
    "\x17": ("ctrl-w",),
    "\x18": ("ctrl-x",),
    "\x19": ("ctrl-y",),
    "\x1a": ("ctrl-z",),
    "\x1b[1;5A": ("ctrl-up",),
    "\x1b[1;5B": ("ctrl-down",),
    "\x1b[1;5C": ("ctrl-right",),
    "\x1b[1;5D": ("ctrl-left",),
    "\x1b[H": ("end",),
    "\x1b[F": ("home",),
    "\x1b[2~": ("insert",),
    "\x1b[3~": ("delete",),
    "\x1b[Z": ("shift-tab",),
    "\x1b[11~": ("F1",),
    "\x1bOP": ("F1",),
    "\x1b[12~": ("F2",),
    "\x1bOQ": ("F2",),
    "\x1b[13~": ("F3",),
    "\x1bOR": ("F3",),
    "\x1b[14~": ("F4",),
    "\x1bOS": ("F4",),
    "\x1b[15~": ("F5",),
    "\x1b[17~": ("F6",),
    "\x1b[18~": ("F7",),
    "\x1b[19~": ("F8",),
    "\x1b[20~": ("F9",),
    "\x1b[21~": ("F10",),
    "\x1b[23~": ("F11",),
    "\x1b[24~": ("F12",),
}

NT_KEY_NAMES = {
    "\x1b": ("esc",),
    "\x1bK": ("left",),
    "\x1bM": ("right",),
    "\x1bH": ("up",),
    "\x1bP": ("down",),
    "\r": ("return",),
    "\x08": ("backspace",),
    "\x00;": ("f1",),
    "\x00<": ("f2",),
    "\x00=": ("f3",),
    "\x00>": ("f4",),
    "\x00?": ("f5",),
    "\x00@": ("f6",),
    "\x00A": ("f7",),
    "\x00B": ("f8",),
    "\x00C": ("f9",),
    "\x00D": ("f10",),
    "\xe0\x85": ("f11",),
    "\xe0\x86": ("f12",),
}
