# -*- coding: utf-8 -*-
# (c) Copyright 2021 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.8.1
# Product:      SFA3x
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class Sfa3xCmdDeviceInformationBase(ShdlcCommand):
    """
    SHDLC command 0xD0: "Device Information".
    """

    def __init__(self, *args, **kwargs):
        """
        Constructor.
        """
        super(Sfa3xCmdDeviceInformationBase, self).__init__(
            0xD0, *args, **kwargs)


class Sfa3xCmdGetDeviceMarking(Sfa3xCmdDeviceInformationBase):
    """
    Get Device Marking Command

    Gets the device marking from the device.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Sfa3xCmdGetDeviceMarking, self).__init__(
            data=b"".join([bytes(bytearray([0x06]))]),
            max_response_time=0.01,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: String containing the device marking.
        :rtype: str
        """
        device_marking = str(data[0:].decode('utf-8').rstrip('\0'))  # string
        return device_marking
