'''
# `azurerm_site_recovery_replication_recovery_plan`

Refer to the Terraform Registory for docs: [`azurerm_site_recovery_replication_recovery_plan`](https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf as _cdktf_9a9027ec
import constructs as _constructs_77d1e7e8


class SiteRecoveryReplicationRecoveryPlan(
    _cdktf_9a9027ec.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlan",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan azurerm_site_recovery_replication_recovery_plan}.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id_: builtins.str,
        *,
        name: builtins.str,
        recovery_vault_id: builtins.str,
        source_recovery_fabric_id: builtins.str,
        target_recovery_fabric_id: builtins.str,
        id: typing.Optional[builtins.str] = None,
        recovery_group: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["SiteRecoveryReplicationRecoveryPlanRecoveryGroup", typing.Dict[builtins.str, typing.Any]]]]] = None,
        timeouts: typing.Optional[typing.Union["SiteRecoveryReplicationRecoveryPlanTimeouts", typing.Dict[builtins.str, typing.Any]]] = None,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan azurerm_site_recovery_replication_recovery_plan} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}.
        :param recovery_vault_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#recovery_vault_id SiteRecoveryReplicationRecoveryPlan#recovery_vault_id}.
        :param source_recovery_fabric_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#source_recovery_fabric_id SiteRecoveryReplicationRecoveryPlan#source_recovery_fabric_id}.
        :param target_recovery_fabric_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#target_recovery_fabric_id SiteRecoveryReplicationRecoveryPlan#target_recovery_fabric_id}.
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#id SiteRecoveryReplicationRecoveryPlan#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param recovery_group: recovery_group block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#recovery_group SiteRecoveryReplicationRecoveryPlan#recovery_group}
        :param timeouts: timeouts block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#timeouts SiteRecoveryReplicationRecoveryPlan#timeouts}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aedea51b38ad30e9028c148d4a78f46e5eb52a8b076de0aa694b0ae87dfd112a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = SiteRecoveryReplicationRecoveryPlanConfig(
            name=name,
            recovery_vault_id=recovery_vault_id,
            source_recovery_fabric_id=source_recovery_fabric_id,
            target_recovery_fabric_id=target_recovery_fabric_id,
            id=id,
            recovery_group=recovery_group,
            timeouts=timeouts,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="putRecoveryGroup")
    def put_recovery_group(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["SiteRecoveryReplicationRecoveryPlanRecoveryGroup", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ec83b76f1c9aea7ab2b1f01ee6a73f77b17b7ae3fa716a371101e977e19e015)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putRecoveryGroup", [value]))

    @jsii.member(jsii_name="putTimeouts")
    def put_timeouts(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param create: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#create SiteRecoveryReplicationRecoveryPlan#create}.
        :param delete: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#delete SiteRecoveryReplicationRecoveryPlan#delete}.
        :param read: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#read SiteRecoveryReplicationRecoveryPlan#read}.
        :param update: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#update SiteRecoveryReplicationRecoveryPlan#update}.
        '''
        value = SiteRecoveryReplicationRecoveryPlanTimeouts(
            create=create, delete=delete, read=read, update=update
        )

        return typing.cast(None, jsii.invoke(self, "putTimeouts", [value]))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetRecoveryGroup")
    def reset_recovery_group(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRecoveryGroup", []))

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimeouts", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="recoveryGroup")
    def recovery_group(self) -> "SiteRecoveryReplicationRecoveryPlanRecoveryGroupList":
        return typing.cast("SiteRecoveryReplicationRecoveryPlanRecoveryGroupList", jsii.get(self, "recoveryGroup"))

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "SiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference":
        return typing.cast("SiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference", jsii.get(self, "timeouts"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="recoveryGroupInput")
    def recovery_group_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroup"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroup"]]], jsii.get(self, "recoveryGroupInput"))

    @builtins.property
    @jsii.member(jsii_name="recoveryVaultIdInput")
    def recovery_vault_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "recoveryVaultIdInput"))

    @builtins.property
    @jsii.member(jsii_name="sourceRecoveryFabricIdInput")
    def source_recovery_fabric_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "sourceRecoveryFabricIdInput"))

    @builtins.property
    @jsii.member(jsii_name="targetRecoveryFabricIdInput")
    def target_recovery_fabric_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "targetRecoveryFabricIdInput"))

    @builtins.property
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional[typing.Union["SiteRecoveryReplicationRecoveryPlanTimeouts", _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union["SiteRecoveryReplicationRecoveryPlanTimeouts", _cdktf_9a9027ec.IResolvable]], jsii.get(self, "timeoutsInput"))

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee355680b8e194ef0876852c8dea1e27bc12d65a467f28ab108366411c7f183b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b3399611c4c5e49977e9de0cb86ddc8d51699822c5cf5754825f54ea41fba37)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="recoveryVaultId")
    def recovery_vault_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "recoveryVaultId"))

    @recovery_vault_id.setter
    def recovery_vault_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df87245229d2aac4c67cabbdfa5a394fd81b35a33765e47ab1190765d4be122e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "recoveryVaultId", value)

    @builtins.property
    @jsii.member(jsii_name="sourceRecoveryFabricId")
    def source_recovery_fabric_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "sourceRecoveryFabricId"))

    @source_recovery_fabric_id.setter
    def source_recovery_fabric_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cbb2a5e3579d6168a5020c8ace78b19cb633865cb4ca99a424d8a191496a6126)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "sourceRecoveryFabricId", value)

    @builtins.property
    @jsii.member(jsii_name="targetRecoveryFabricId")
    def target_recovery_fabric_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "targetRecoveryFabricId"))

    @target_recovery_fabric_id.setter
    def target_recovery_fabric_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4457f570effbf69c634f881a3d03a864d9ad62ec0ebf1f62317a8a3a39de28d3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "targetRecoveryFabricId", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanConfig",
    jsii_struct_bases=[_cdktf_9a9027ec.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "name": "name",
        "recovery_vault_id": "recoveryVaultId",
        "source_recovery_fabric_id": "sourceRecoveryFabricId",
        "target_recovery_fabric_id": "targetRecoveryFabricId",
        "id": "id",
        "recovery_group": "recoveryGroup",
        "timeouts": "timeouts",
    },
)
class SiteRecoveryReplicationRecoveryPlanConfig(_cdktf_9a9027ec.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
        name: builtins.str,
        recovery_vault_id: builtins.str,
        source_recovery_fabric_id: builtins.str,
        target_recovery_fabric_id: builtins.str,
        id: typing.Optional[builtins.str] = None,
        recovery_group: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["SiteRecoveryReplicationRecoveryPlanRecoveryGroup", typing.Dict[builtins.str, typing.Any]]]]] = None,
        timeouts: typing.Optional[typing.Union["SiteRecoveryReplicationRecoveryPlanTimeouts", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}.
        :param recovery_vault_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#recovery_vault_id SiteRecoveryReplicationRecoveryPlan#recovery_vault_id}.
        :param source_recovery_fabric_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#source_recovery_fabric_id SiteRecoveryReplicationRecoveryPlan#source_recovery_fabric_id}.
        :param target_recovery_fabric_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#target_recovery_fabric_id SiteRecoveryReplicationRecoveryPlan#target_recovery_fabric_id}.
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#id SiteRecoveryReplicationRecoveryPlan#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param recovery_group: recovery_group block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#recovery_group SiteRecoveryReplicationRecoveryPlan#recovery_group}
        :param timeouts: timeouts block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#timeouts SiteRecoveryReplicationRecoveryPlan#timeouts}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = _cdktf_9a9027ec.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = SiteRecoveryReplicationRecoveryPlanTimeouts(**timeouts)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df27bcf614e7715749244a844445eab7b01373b56a2b4f8848018c1be15c8b0f)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument recovery_vault_id", value=recovery_vault_id, expected_type=type_hints["recovery_vault_id"])
            check_type(argname="argument source_recovery_fabric_id", value=source_recovery_fabric_id, expected_type=type_hints["source_recovery_fabric_id"])
            check_type(argname="argument target_recovery_fabric_id", value=target_recovery_fabric_id, expected_type=type_hints["target_recovery_fabric_id"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument recovery_group", value=recovery_group, expected_type=type_hints["recovery_group"])
            check_type(argname="argument timeouts", value=timeouts, expected_type=type_hints["timeouts"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "recovery_vault_id": recovery_vault_id,
            "source_recovery_fabric_id": source_recovery_fabric_id,
            "target_recovery_fabric_id": target_recovery_fabric_id,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if id is not None:
            self._values["id"] = id
        if recovery_group is not None:
            self._values["recovery_group"] = recovery_group
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(
        self,
    ) -> typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[_cdktf_9a9027ec.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[_cdktf_9a9027ec.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def recovery_vault_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#recovery_vault_id SiteRecoveryReplicationRecoveryPlan#recovery_vault_id}.'''
        result = self._values.get("recovery_vault_id")
        assert result is not None, "Required property 'recovery_vault_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def source_recovery_fabric_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#source_recovery_fabric_id SiteRecoveryReplicationRecoveryPlan#source_recovery_fabric_id}.'''
        result = self._values.get("source_recovery_fabric_id")
        assert result is not None, "Required property 'source_recovery_fabric_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target_recovery_fabric_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#target_recovery_fabric_id SiteRecoveryReplicationRecoveryPlan#target_recovery_fabric_id}.'''
        result = self._values.get("target_recovery_fabric_id")
        assert result is not None, "Required property 'target_recovery_fabric_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#id SiteRecoveryReplicationRecoveryPlan#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def recovery_group(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroup"]]]:
        '''recovery_group block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#recovery_group SiteRecoveryReplicationRecoveryPlan#recovery_group}
        '''
        result = self._values.get("recovery_group")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroup"]]], result)

    @builtins.property
    def timeouts(
        self,
    ) -> typing.Optional["SiteRecoveryReplicationRecoveryPlanTimeouts"]:
        '''timeouts block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#timeouts SiteRecoveryReplicationRecoveryPlan#timeouts}
        '''
        result = self._values.get("timeouts")
        return typing.cast(typing.Optional["SiteRecoveryReplicationRecoveryPlanTimeouts"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SiteRecoveryReplicationRecoveryPlanConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroup",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "post_action": "postAction",
        "pre_action": "preAction",
        "replicated_protected_items": "replicatedProtectedItems",
    },
)
class SiteRecoveryReplicationRecoveryPlanRecoveryGroup:
    def __init__(
        self,
        *,
        type: builtins.str,
        post_action: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction", typing.Dict[builtins.str, typing.Any]]]]] = None,
        pre_action: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction", typing.Dict[builtins.str, typing.Any]]]]] = None,
        replicated_protected_items: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}.
        :param post_action: post_action block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#post_action SiteRecoveryReplicationRecoveryPlan#post_action}
        :param pre_action: pre_action block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#pre_action SiteRecoveryReplicationRecoveryPlan#pre_action}
        :param replicated_protected_items: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#replicated_protected_items SiteRecoveryReplicationRecoveryPlan#replicated_protected_items}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__714f57a81eba502192c9794d7afa2ba92d9070576f7cc733620ef1c512e20ab1)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument post_action", value=post_action, expected_type=type_hints["post_action"])
            check_type(argname="argument pre_action", value=pre_action, expected_type=type_hints["pre_action"])
            check_type(argname="argument replicated_protected_items", value=replicated_protected_items, expected_type=type_hints["replicated_protected_items"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "type": type,
        }
        if post_action is not None:
            self._values["post_action"] = post_action
        if pre_action is not None:
            self._values["pre_action"] = pre_action
        if replicated_protected_items is not None:
            self._values["replicated_protected_items"] = replicated_protected_items

    @builtins.property
    def type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}.'''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def post_action(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction"]]]:
        '''post_action block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#post_action SiteRecoveryReplicationRecoveryPlan#post_action}
        '''
        result = self._values.get("post_action")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction"]]], result)

    @builtins.property
    def pre_action(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction"]]]:
        '''pre_action block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#pre_action SiteRecoveryReplicationRecoveryPlan#pre_action}
        '''
        result = self._values.get("pre_action")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction"]]], result)

    @builtins.property
    def replicated_protected_items(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#replicated_protected_items SiteRecoveryReplicationRecoveryPlan#replicated_protected_items}.'''
        result = self._values.get("replicated_protected_items")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SiteRecoveryReplicationRecoveryPlanRecoveryGroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class SiteRecoveryReplicationRecoveryPlanRecoveryGroupList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroupList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__914c9acc5994f96f1a441c1c6b7e9e0773c68162650ff3a1fc325aafc72dbb69)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "SiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__69e9af8d6f31dd99cf03449eba4bb53adf063ef6c1c57e7bc8d06389c879f996)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("SiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__94a5513ef5e12bba7bfcaac64ca5a627abb2dd5995088b2a830f18e10093ce06)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce4c6109aef0c1cc47ed4192f2d2e1abad51a120f0d6b6e3859cfa166a9734d6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8b0f8642356df1d225b586f488195ec8c232fb7e5e39084dea95b7c6276eb9b1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroup]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroup]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroup]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b614907d051bb4e52b2b8c9824fac66e4fdfc7155cd626baefdab44348d4aa8d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class SiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c8c6b2c080c31a9c95b35a49453eb3dd18b39cb2377323e344d7728e8e8e03b)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="putPostAction")
    def put_post_action(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ee17be9c70b75ce9f8324e715de0045739c07cb2baa51d0457c032ffdbe2db0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putPostAction", [value]))

    @jsii.member(jsii_name="putPreAction")
    def put_pre_action(
        self,
        value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction", typing.Dict[builtins.str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b545a1976d34de1c279f4f62eb6c58c53cc7fa431fce680f01f945c36158e008)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putPreAction", [value]))

    @jsii.member(jsii_name="resetPostAction")
    def reset_post_action(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPostAction", []))

    @jsii.member(jsii_name="resetPreAction")
    def reset_pre_action(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPreAction", []))

    @jsii.member(jsii_name="resetReplicatedProtectedItems")
    def reset_replicated_protected_items(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetReplicatedProtectedItems", []))

    @builtins.property
    @jsii.member(jsii_name="postAction")
    def post_action(
        self,
    ) -> "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList":
        return typing.cast("SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList", jsii.get(self, "postAction"))

    @builtins.property
    @jsii.member(jsii_name="preAction")
    def pre_action(
        self,
    ) -> "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList":
        return typing.cast("SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList", jsii.get(self, "preAction"))

    @builtins.property
    @jsii.member(jsii_name="postActionInput")
    def post_action_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction"]]], jsii.get(self, "postActionInput"))

    @builtins.property
    @jsii.member(jsii_name="preActionInput")
    def pre_action_input(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction"]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List["SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction"]]], jsii.get(self, "preActionInput"))

    @builtins.property
    @jsii.member(jsii_name="replicatedProtectedItemsInput")
    def replicated_protected_items_input(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "replicatedProtectedItemsInput"))

    @builtins.property
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property
    @jsii.member(jsii_name="replicatedProtectedItems")
    def replicated_protected_items(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "replicatedProtectedItems"))

    @replicated_protected_items.setter
    def replicated_protected_items(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__919f7d468e330fffc5b45492293c2e6a852483466c9e5dce1e089f53c20616d9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "replicatedProtectedItems", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf2aed9c3b9f43ceeb9ca0e1986e6339467424fd3ed28ce8f35337ce1e62540a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroup, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroup, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroup, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1277a4f380349eb91a4bd402d50a5091d539f377d7ccd21e52c7c5c35464881f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction",
    jsii_struct_bases=[],
    name_mapping={
        "fail_over_directions": "failOverDirections",
        "fail_over_types": "failOverTypes",
        "name": "name",
        "type": "type",
        "fabric_location": "fabricLocation",
        "manual_action_instruction": "manualActionInstruction",
        "runbook_id": "runbookId",
        "script_path": "scriptPath",
    },
)
class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction:
    def __init__(
        self,
        *,
        fail_over_directions: typing.Sequence[builtins.str],
        fail_over_types: typing.Sequence[builtins.str],
        name: builtins.str,
        type: builtins.str,
        fabric_location: typing.Optional[builtins.str] = None,
        manual_action_instruction: typing.Optional[builtins.str] = None,
        runbook_id: typing.Optional[builtins.str] = None,
        script_path: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param fail_over_directions: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fail_over_directions SiteRecoveryReplicationRecoveryPlan#fail_over_directions}.
        :param fail_over_types: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fail_over_types SiteRecoveryReplicationRecoveryPlan#fail_over_types}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}.
        :param type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}.
        :param fabric_location: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fabric_location SiteRecoveryReplicationRecoveryPlan#fabric_location}.
        :param manual_action_instruction: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#manual_action_instruction SiteRecoveryReplicationRecoveryPlan#manual_action_instruction}.
        :param runbook_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#runbook_id SiteRecoveryReplicationRecoveryPlan#runbook_id}.
        :param script_path: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#script_path SiteRecoveryReplicationRecoveryPlan#script_path}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64e7a024aa27c6c0e1921fdc1f953440492f320073df9fc70d551c71d875ff1b)
            check_type(argname="argument fail_over_directions", value=fail_over_directions, expected_type=type_hints["fail_over_directions"])
            check_type(argname="argument fail_over_types", value=fail_over_types, expected_type=type_hints["fail_over_types"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument fabric_location", value=fabric_location, expected_type=type_hints["fabric_location"])
            check_type(argname="argument manual_action_instruction", value=manual_action_instruction, expected_type=type_hints["manual_action_instruction"])
            check_type(argname="argument runbook_id", value=runbook_id, expected_type=type_hints["runbook_id"])
            check_type(argname="argument script_path", value=script_path, expected_type=type_hints["script_path"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "fail_over_directions": fail_over_directions,
            "fail_over_types": fail_over_types,
            "name": name,
            "type": type,
        }
        if fabric_location is not None:
            self._values["fabric_location"] = fabric_location
        if manual_action_instruction is not None:
            self._values["manual_action_instruction"] = manual_action_instruction
        if runbook_id is not None:
            self._values["runbook_id"] = runbook_id
        if script_path is not None:
            self._values["script_path"] = script_path

    @builtins.property
    def fail_over_directions(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fail_over_directions SiteRecoveryReplicationRecoveryPlan#fail_over_directions}.'''
        result = self._values.get("fail_over_directions")
        assert result is not None, "Required property 'fail_over_directions' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def fail_over_types(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fail_over_types SiteRecoveryReplicationRecoveryPlan#fail_over_types}.'''
        result = self._values.get("fail_over_types")
        assert result is not None, "Required property 'fail_over_types' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}.'''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fabric_location(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fabric_location SiteRecoveryReplicationRecoveryPlan#fabric_location}.'''
        result = self._values.get("fabric_location")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def manual_action_instruction(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#manual_action_instruction SiteRecoveryReplicationRecoveryPlan#manual_action_instruction}.'''
        result = self._values.get("manual_action_instruction")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def runbook_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#runbook_id SiteRecoveryReplicationRecoveryPlan#runbook_id}.'''
        result = self._values.get("runbook_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def script_path(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#script_path SiteRecoveryReplicationRecoveryPlan#script_path}.'''
        result = self._values.get("script_path")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0f44386760b148faf8f9304862080499c53da45a292ba67a63257c93028d6d8)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ccf839816b288b0ad8d0f9174fdd7cc58de7ac772dc1888926fe1564a6a6fe69)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee3ba3003dddc50baf3692231350eaa901d2c8c27c803e0c8ed57d76f8f9d7b7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f87ba9046ca4fd2a0eb2662c989b76b945561a41cefc4c645e10c8abcd877ed8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8dc00cbf3bcfc8c092fb80510862e16747caf75e9cae102e5743f969d7c1a49)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e7a078caad20dab244fd820286bad6d2e8e0ba221e538bbab04ca0089899592)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80412fb28dcad81960d4c6771c466dccc36c644d4c7d28e25369cc3380287999)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFabricLocation")
    def reset_fabric_location(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFabricLocation", []))

    @jsii.member(jsii_name="resetManualActionInstruction")
    def reset_manual_action_instruction(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetManualActionInstruction", []))

    @jsii.member(jsii_name="resetRunbookId")
    def reset_runbook_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRunbookId", []))

    @jsii.member(jsii_name="resetScriptPath")
    def reset_script_path(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScriptPath", []))

    @builtins.property
    @jsii.member(jsii_name="fabricLocationInput")
    def fabric_location_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "fabricLocationInput"))

    @builtins.property
    @jsii.member(jsii_name="failOverDirectionsInput")
    def fail_over_directions_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "failOverDirectionsInput"))

    @builtins.property
    @jsii.member(jsii_name="failOverTypesInput")
    def fail_over_types_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "failOverTypesInput"))

    @builtins.property
    @jsii.member(jsii_name="manualActionInstructionInput")
    def manual_action_instruction_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "manualActionInstructionInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="runbookIdInput")
    def runbook_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "runbookIdInput"))

    @builtins.property
    @jsii.member(jsii_name="scriptPathInput")
    def script_path_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "scriptPathInput"))

    @builtins.property
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property
    @jsii.member(jsii_name="fabricLocation")
    def fabric_location(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "fabricLocation"))

    @fabric_location.setter
    def fabric_location(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a919dbd372ff7779f0a8da56996f49ddaceabe41b9156f3f2796963b61591eea)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "fabricLocation", value)

    @builtins.property
    @jsii.member(jsii_name="failOverDirections")
    def fail_over_directions(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "failOverDirections"))

    @fail_over_directions.setter
    def fail_over_directions(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d9bb793f83e750e532f1193c6437255e8e8b72568831132137ea2fe9cbc803b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "failOverDirections", value)

    @builtins.property
    @jsii.member(jsii_name="failOverTypes")
    def fail_over_types(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "failOverTypes"))

    @fail_over_types.setter
    def fail_over_types(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2b7885980b93032e44f6f2ba3ebe99be452a602d0e052ac67ea177ae798decbb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "failOverTypes", value)

    @builtins.property
    @jsii.member(jsii_name="manualActionInstruction")
    def manual_action_instruction(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "manualActionInstruction"))

    @manual_action_instruction.setter
    def manual_action_instruction(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__981ce0ae72bd6ace50040ad50b31eb4c29050bd2ef27ba344c27fa3f9a18523e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "manualActionInstruction", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26730d84af16a37f6f2a66dd23831ca6420de393b5173d31ea5ed14f3af5f562)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="runbookId")
    def runbook_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "runbookId"))

    @runbook_id.setter
    def runbook_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__836ebc71c3ebb8b2026f87b429e2addf0c3315c2ed1d60bdf86de3c6ee0d11c2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "runbookId", value)

    @builtins.property
    @jsii.member(jsii_name="scriptPath")
    def script_path(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "scriptPath"))

    @script_path.setter
    def script_path(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dcf776bb7734a1984db884b28e92c9ed59af68d017c31a528b44dbccc6e7b59c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scriptPath", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f5b17adc61fa5c0febe69c1b0f755c80fe24b20af1e74a2ff2b14187dd299f1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__515184eb6c5140b41a7b99e9c24a45c846ee21f95bd1df0e33b0d7fded874331)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction",
    jsii_struct_bases=[],
    name_mapping={
        "fail_over_directions": "failOverDirections",
        "fail_over_types": "failOverTypes",
        "name": "name",
        "type": "type",
        "fabric_location": "fabricLocation",
        "manual_action_instruction": "manualActionInstruction",
        "runbook_id": "runbookId",
        "script_path": "scriptPath",
    },
)
class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction:
    def __init__(
        self,
        *,
        fail_over_directions: typing.Sequence[builtins.str],
        fail_over_types: typing.Sequence[builtins.str],
        name: builtins.str,
        type: builtins.str,
        fabric_location: typing.Optional[builtins.str] = None,
        manual_action_instruction: typing.Optional[builtins.str] = None,
        runbook_id: typing.Optional[builtins.str] = None,
        script_path: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param fail_over_directions: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fail_over_directions SiteRecoveryReplicationRecoveryPlan#fail_over_directions}.
        :param fail_over_types: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fail_over_types SiteRecoveryReplicationRecoveryPlan#fail_over_types}.
        :param name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}.
        :param type: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}.
        :param fabric_location: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fabric_location SiteRecoveryReplicationRecoveryPlan#fabric_location}.
        :param manual_action_instruction: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#manual_action_instruction SiteRecoveryReplicationRecoveryPlan#manual_action_instruction}.
        :param runbook_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#runbook_id SiteRecoveryReplicationRecoveryPlan#runbook_id}.
        :param script_path: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#script_path SiteRecoveryReplicationRecoveryPlan#script_path}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__44ecd884e7baf46eff9bc66d144e07a8c9226b540d5dfead28321c2db7824cd1)
            check_type(argname="argument fail_over_directions", value=fail_over_directions, expected_type=type_hints["fail_over_directions"])
            check_type(argname="argument fail_over_types", value=fail_over_types, expected_type=type_hints["fail_over_types"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument fabric_location", value=fabric_location, expected_type=type_hints["fabric_location"])
            check_type(argname="argument manual_action_instruction", value=manual_action_instruction, expected_type=type_hints["manual_action_instruction"])
            check_type(argname="argument runbook_id", value=runbook_id, expected_type=type_hints["runbook_id"])
            check_type(argname="argument script_path", value=script_path, expected_type=type_hints["script_path"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "fail_over_directions": fail_over_directions,
            "fail_over_types": fail_over_types,
            "name": name,
            "type": type,
        }
        if fabric_location is not None:
            self._values["fabric_location"] = fabric_location
        if manual_action_instruction is not None:
            self._values["manual_action_instruction"] = manual_action_instruction
        if runbook_id is not None:
            self._values["runbook_id"] = runbook_id
        if script_path is not None:
            self._values["script_path"] = script_path

    @builtins.property
    def fail_over_directions(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fail_over_directions SiteRecoveryReplicationRecoveryPlan#fail_over_directions}.'''
        result = self._values.get("fail_over_directions")
        assert result is not None, "Required property 'fail_over_directions' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def fail_over_types(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fail_over_types SiteRecoveryReplicationRecoveryPlan#fail_over_types}.'''
        result = self._values.get("fail_over_types")
        assert result is not None, "Required property 'fail_over_types' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}.'''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fabric_location(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#fabric_location SiteRecoveryReplicationRecoveryPlan#fabric_location}.'''
        result = self._values.get("fabric_location")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def manual_action_instruction(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#manual_action_instruction SiteRecoveryReplicationRecoveryPlan#manual_action_instruction}.'''
        result = self._values.get("manual_action_instruction")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def runbook_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#runbook_id SiteRecoveryReplicationRecoveryPlan#runbook_id}.'''
        result = self._values.get("runbook_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def script_path(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#script_path SiteRecoveryReplicationRecoveryPlan#script_path}.'''
        result = self._values.get("script_path")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList(
    _cdktf_9a9027ec.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b48858eaf390addc67ed9ca7c1b1a99072f2cda8c7c2a9169de6b8eff163d11)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f11c3d7459b0c0e761a0a44a3eb2839bb37ce0d49e0ce7c4ebe4a9cd2dc43bb6)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__492046c07d584b6383424e3ba0d871a7fa16346e282d81f720ab92772d4f8573)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> _cdktf_9a9027ec.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(_cdktf_9a9027ec.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: _cdktf_9a9027ec.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d857a5d70eaeadb211980ad3e9fa7fe9fea0dc3f4277af805ce24d3ef478ed4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d2758e6c5c5099954c83ecc98e4d39d062955f90b32786223189331b1b7f05e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction]]]:
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__211e9d506c90eaea7106a043bf990e80b8800b081c11b0c878f0ef75429a89f4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7227d7491bd1e7248b9854ab30cf8cca7cf715f59dde365b8e677be9edaa8de)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @jsii.member(jsii_name="resetFabricLocation")
    def reset_fabric_location(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetFabricLocation", []))

    @jsii.member(jsii_name="resetManualActionInstruction")
    def reset_manual_action_instruction(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetManualActionInstruction", []))

    @jsii.member(jsii_name="resetRunbookId")
    def reset_runbook_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRunbookId", []))

    @jsii.member(jsii_name="resetScriptPath")
    def reset_script_path(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetScriptPath", []))

    @builtins.property
    @jsii.member(jsii_name="fabricLocationInput")
    def fabric_location_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "fabricLocationInput"))

    @builtins.property
    @jsii.member(jsii_name="failOverDirectionsInput")
    def fail_over_directions_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "failOverDirectionsInput"))

    @builtins.property
    @jsii.member(jsii_name="failOverTypesInput")
    def fail_over_types_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "failOverTypesInput"))

    @builtins.property
    @jsii.member(jsii_name="manualActionInstructionInput")
    def manual_action_instruction_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "manualActionInstructionInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="runbookIdInput")
    def runbook_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "runbookIdInput"))

    @builtins.property
    @jsii.member(jsii_name="scriptPathInput")
    def script_path_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "scriptPathInput"))

    @builtins.property
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property
    @jsii.member(jsii_name="fabricLocation")
    def fabric_location(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "fabricLocation"))

    @fabric_location.setter
    def fabric_location(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9be29c0874c53db0f999b9ff5ec50627767bc58faf6afbdb56f5554c8d204105)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "fabricLocation", value)

    @builtins.property
    @jsii.member(jsii_name="failOverDirections")
    def fail_over_directions(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "failOverDirections"))

    @fail_over_directions.setter
    def fail_over_directions(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f579f514fcf223baf2ad283f64f2fb970a179754b99f2a306e722566f709b4fe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "failOverDirections", value)

    @builtins.property
    @jsii.member(jsii_name="failOverTypes")
    def fail_over_types(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "failOverTypes"))

    @fail_over_types.setter
    def fail_over_types(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1331a1c4a0f78ead4b6f3774193c5fd0396ba3a1708f7aa5257e43ee47e210f1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "failOverTypes", value)

    @builtins.property
    @jsii.member(jsii_name="manualActionInstruction")
    def manual_action_instruction(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "manualActionInstruction"))

    @manual_action_instruction.setter
    def manual_action_instruction(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ecb639a73cb6c20b26a2342cc0230044dade3ec26423a3e982bda893fae97aca)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "manualActionInstruction", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a2da6313aab42e1ea5f89f9add1a9815a978593f1b752e30cc5065d314daf27)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="runbookId")
    def runbook_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "runbookId"))

    @runbook_id.setter
    def runbook_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5a17a3dd0cfb0e5a776ff8cbb5be4ea04cd5cf0a4a2b89280ac1af927be153d9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "runbookId", value)

    @builtins.property
    @jsii.member(jsii_name="scriptPath")
    def script_path(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "scriptPath"))

    @script_path.setter
    def script_path(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__42cb86d1748da57732a0af951f7534a34a64f3e12e2705412c899a5c8e371e2a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scriptPath", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e3d62e604ab3a9752849fd8e6d9a190f9fca7f846c8073c420654ebe5d140ffe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8d0fead44718aa8f3f7b8bca91e8e78ce5989210e0c9a23bc44fd766c294faa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class SiteRecoveryReplicationRecoveryPlanTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param create: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#create SiteRecoveryReplicationRecoveryPlan#create}.
        :param delete: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#delete SiteRecoveryReplicationRecoveryPlan#delete}.
        :param read: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#read SiteRecoveryReplicationRecoveryPlan#read}.
        :param update: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#update SiteRecoveryReplicationRecoveryPlan#update}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d58c92f3e49fca0fc57aea5c5fddcaab3ebfca0a3bf47820ea88dae027e17aff)
            check_type(argname="argument create", value=create, expected_type=type_hints["create"])
            check_type(argname="argument delete", value=delete, expected_type=type_hints["delete"])
            check_type(argname="argument read", value=read, expected_type=type_hints["read"])
            check_type(argname="argument update", value=update, expected_type=type_hints["update"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#create SiteRecoveryReplicationRecoveryPlan#create}.'''
        result = self._values.get("create")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#delete SiteRecoveryReplicationRecoveryPlan#delete}.'''
        result = self._values.get("delete")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#read SiteRecoveryReplicationRecoveryPlan#read}.'''
        result = self._values.get("read")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replication_recovery_plan#update SiteRecoveryReplicationRecoveryPlan#update}.'''
        result = self._values.get("update")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SiteRecoveryReplicationRecoveryPlanTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class SiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.siteRecoveryReplicationRecoveryPlan.SiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0e2b9a3e264550d284bf37c7d1f4f92e72d058f8efdcab71846db6ea7e6e8b4)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetCreate")
    def reset_create(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCreate", []))

    @jsii.member(jsii_name="resetDelete")
    def reset_delete(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDelete", []))

    @jsii.member(jsii_name="resetRead")
    def reset_read(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRead", []))

    @jsii.member(jsii_name="resetUpdate")
    def reset_update(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUpdate", []))

    @builtins.property
    @jsii.member(jsii_name="createInput")
    def create_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "createInput"))

    @builtins.property
    @jsii.member(jsii_name="deleteInput")
    def delete_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "deleteInput"))

    @builtins.property
    @jsii.member(jsii_name="readInput")
    def read_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "readInput"))

    @builtins.property
    @jsii.member(jsii_name="updateInput")
    def update_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "updateInput"))

    @builtins.property
    @jsii.member(jsii_name="create")
    def create(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "create"))

    @create.setter
    def create(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__908963d13a5a1fb00edb6b584aa07c1669f6bc8091c57b07168a2f90f2828e75)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "create", value)

    @builtins.property
    @jsii.member(jsii_name="delete")
    def delete(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "delete"))

    @delete.setter
    def delete(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__973a8e3388b3332d4144b899051d1a3a9b6195d3c33fb66f2b9e80c0702c7d69)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "delete", value)

    @builtins.property
    @jsii.member(jsii_name="read")
    def read(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "read"))

    @read.setter
    def read(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b2a8b8888e2cc3ea24e7ec3c7af0482db75a8e52280ee92df6a2c60c97d361b8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "read", value)

    @builtins.property
    @jsii.member(jsii_name="update")
    def update(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "update"))

    @update.setter
    def update(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d63d33082c458119de0b67f6cea4dfb247e7b48448d269afb214a2ebfc5fba6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "update", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanTimeouts, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanTimeouts, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanTimeouts, _cdktf_9a9027ec.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cb913c8bb96af6173c654591aeb1db1fb3611d948b590a98c092813f26aa8f0b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


__all__ = [
    "SiteRecoveryReplicationRecoveryPlan",
    "SiteRecoveryReplicationRecoveryPlanConfig",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroup",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroupList",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList",
    "SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference",
    "SiteRecoveryReplicationRecoveryPlanTimeouts",
    "SiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference",
]

publication.publish()

def _typecheckingstub__aedea51b38ad30e9028c148d4a78f46e5eb52a8b076de0aa694b0ae87dfd112a(
    scope: _constructs_77d1e7e8.Construct,
    id_: builtins.str,
    *,
    name: builtins.str,
    recovery_vault_id: builtins.str,
    source_recovery_fabric_id: builtins.str,
    target_recovery_fabric_id: builtins.str,
    id: typing.Optional[builtins.str] = None,
    recovery_group: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroup, typing.Dict[builtins.str, typing.Any]]]]] = None,
    timeouts: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanTimeouts, typing.Dict[builtins.str, typing.Any]]] = None,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[jsii.Number] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8ec83b76f1c9aea7ab2b1f01ee6a73f77b17b7ae3fa716a371101e977e19e015(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroup, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ee355680b8e194ef0876852c8dea1e27bc12d65a467f28ab108366411c7f183b(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2b3399611c4c5e49977e9de0cb86ddc8d51699822c5cf5754825f54ea41fba37(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__df87245229d2aac4c67cabbdfa5a394fd81b35a33765e47ab1190765d4be122e(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__cbb2a5e3579d6168a5020c8ace78b19cb633865cb4ca99a424d8a191496a6126(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4457f570effbf69c634f881a3d03a864d9ad62ec0ebf1f62317a8a3a39de28d3(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__df27bcf614e7715749244a844445eab7b01373b56a2b4f8848018c1be15c8b0f(
    *,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[jsii.Number] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    name: builtins.str,
    recovery_vault_id: builtins.str,
    source_recovery_fabric_id: builtins.str,
    target_recovery_fabric_id: builtins.str,
    id: typing.Optional[builtins.str] = None,
    recovery_group: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroup, typing.Dict[builtins.str, typing.Any]]]]] = None,
    timeouts: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanTimeouts, typing.Dict[builtins.str, typing.Any]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__714f57a81eba502192c9794d7afa2ba92d9070576f7cc733620ef1c512e20ab1(
    *,
    type: builtins.str,
    post_action: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction, typing.Dict[builtins.str, typing.Any]]]]] = None,
    pre_action: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction, typing.Dict[builtins.str, typing.Any]]]]] = None,
    replicated_protected_items: typing.Optional[typing.Sequence[builtins.str]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__914c9acc5994f96f1a441c1c6b7e9e0773c68162650ff3a1fc325aafc72dbb69(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__69e9af8d6f31dd99cf03449eba4bb53adf063ef6c1c57e7bc8d06389c879f996(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__94a5513ef5e12bba7bfcaac64ca5a627abb2dd5995088b2a830f18e10093ce06(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ce4c6109aef0c1cc47ed4192f2d2e1abad51a120f0d6b6e3859cfa166a9734d6(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8b0f8642356df1d225b586f488195ec8c232fb7e5e39084dea95b7c6276eb9b1(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b614907d051bb4e52b2b8c9824fac66e4fdfc7155cd626baefdab44348d4aa8d(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroup]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1c8c6b2c080c31a9c95b35a49453eb3dd18b39cb2377323e344d7728e8e8e03b(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8ee17be9c70b75ce9f8324e715de0045739c07cb2baa51d0457c032ffdbe2db0(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b545a1976d34de1c279f4f62eb6c58c53cc7fa431fce680f01f945c36158e008(
    value: typing.Union[_cdktf_9a9027ec.IResolvable, typing.Sequence[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction, typing.Dict[builtins.str, typing.Any]]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__919f7d468e330fffc5b45492293c2e6a852483466c9e5dce1e089f53c20616d9(
    value: typing.List[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__bf2aed9c3b9f43ceeb9ca0e1986e6339467424fd3ed28ce8f35337ce1e62540a(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1277a4f380349eb91a4bd402d50a5091d539f377d7ccd21e52c7c5c35464881f(
    value: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroup, _cdktf_9a9027ec.IResolvable]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__64e7a024aa27c6c0e1921fdc1f953440492f320073df9fc70d551c71d875ff1b(
    *,
    fail_over_directions: typing.Sequence[builtins.str],
    fail_over_types: typing.Sequence[builtins.str],
    name: builtins.str,
    type: builtins.str,
    fabric_location: typing.Optional[builtins.str] = None,
    manual_action_instruction: typing.Optional[builtins.str] = None,
    runbook_id: typing.Optional[builtins.str] = None,
    script_path: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d0f44386760b148faf8f9304862080499c53da45a292ba67a63257c93028d6d8(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ccf839816b288b0ad8d0f9174fdd7cc58de7ac772dc1888926fe1564a6a6fe69(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ee3ba3003dddc50baf3692231350eaa901d2c8c27c803e0c8ed57d76f8f9d7b7(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f87ba9046ca4fd2a0eb2662c989b76b945561a41cefc4c645e10c8abcd877ed8(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a8dc00cbf3bcfc8c092fb80510862e16747caf75e9cae102e5743f969d7c1a49(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0e7a078caad20dab244fd820286bad6d2e8e0ba221e538bbab04ca0089899592(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__80412fb28dcad81960d4c6771c466dccc36c644d4c7d28e25369cc3380287999(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a919dbd372ff7779f0a8da56996f49ddaceabe41b9156f3f2796963b61591eea(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3d9bb793f83e750e532f1193c6437255e8e8b72568831132137ea2fe9cbc803b(
    value: typing.List[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2b7885980b93032e44f6f2ba3ebe99be452a602d0e052ac67ea177ae798decbb(
    value: typing.List[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__981ce0ae72bd6ace50040ad50b31eb4c29050bd2ef27ba344c27fa3f9a18523e(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__26730d84af16a37f6f2a66dd23831ca6420de393b5173d31ea5ed14f3af5f562(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__836ebc71c3ebb8b2026f87b429e2addf0c3315c2ed1d60bdf86de3c6ee0d11c2(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__dcf776bb7734a1984db884b28e92c9ed59af68d017c31a528b44dbccc6e7b59c(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4f5b17adc61fa5c0febe69c1b0f755c80fe24b20af1e74a2ff2b14187dd299f1(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__515184eb6c5140b41a7b99e9c24a45c846ee21f95bd1df0e33b0d7fded874331(
    value: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction, _cdktf_9a9027ec.IResolvable]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__44ecd884e7baf46eff9bc66d144e07a8c9226b540d5dfead28321c2db7824cd1(
    *,
    fail_over_directions: typing.Sequence[builtins.str],
    fail_over_types: typing.Sequence[builtins.str],
    name: builtins.str,
    type: builtins.str,
    fabric_location: typing.Optional[builtins.str] = None,
    manual_action_instruction: typing.Optional[builtins.str] = None,
    runbook_id: typing.Optional[builtins.str] = None,
    script_path: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0b48858eaf390addc67ed9ca7c1b1a99072f2cda8c7c2a9169de6b8eff163d11(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    wraps_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f11c3d7459b0c0e761a0a44a3eb2839bb37ce0d49e0ce7c4ebe4a9cd2dc43bb6(
    index: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__492046c07d584b6383424e3ba0d871a7fa16346e282d81f720ab92772d4f8573(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__6d857a5d70eaeadb211980ad3e9fa7fe9fea0dc3f4277af805ce24d3ef478ed4(
    value: _cdktf_9a9027ec.IInterpolatingParent,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2d2758e6c5c5099954c83ecc98e4d39d062955f90b32786223189331b1b7f05e(
    value: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__211e9d506c90eaea7106a043bf990e80b8800b081c11b0c878f0ef75429a89f4(
    value: typing.Optional[typing.Union[_cdktf_9a9027ec.IResolvable, typing.List[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d7227d7491bd1e7248b9854ab30cf8cca7cf715f59dde365b8e677be9edaa8de(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
    complex_object_index: jsii.Number,
    complex_object_is_from_set: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9be29c0874c53db0f999b9ff5ec50627767bc58faf6afbdb56f5554c8d204105(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f579f514fcf223baf2ad283f64f2fb970a179754b99f2a306e722566f709b4fe(
    value: typing.List[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1331a1c4a0f78ead4b6f3774193c5fd0396ba3a1708f7aa5257e43ee47e210f1(
    value: typing.List[builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ecb639a73cb6c20b26a2342cc0230044dade3ec26423a3e982bda893fae97aca(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4a2da6313aab42e1ea5f89f9add1a9815a978593f1b752e30cc5065d314daf27(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5a17a3dd0cfb0e5a776ff8cbb5be4ea04cd5cf0a4a2b89280ac1af927be153d9(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__42cb86d1748da57732a0af951f7534a34a64f3e12e2705412c899a5c8e371e2a(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e3d62e604ab3a9752849fd8e6d9a190f9fca7f846c8073c420654ebe5d140ffe(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e8d0fead44718aa8f3f7b8bca91e8e78ce5989210e0c9a23bc44fd766c294faa(
    value: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction, _cdktf_9a9027ec.IResolvable]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d58c92f3e49fca0fc57aea5c5fddcaab3ebfca0a3bf47820ea88dae027e17aff(
    *,
    create: typing.Optional[builtins.str] = None,
    delete: typing.Optional[builtins.str] = None,
    read: typing.Optional[builtins.str] = None,
    update: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e0e2b9a3e264550d284bf37c7d1f4f92e72d058f8efdcab71846db6ea7e6e8b4(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__908963d13a5a1fb00edb6b584aa07c1669f6bc8091c57b07168a2f90f2828e75(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__973a8e3388b3332d4144b899051d1a3a9b6195d3c33fb66f2b9e80c0702c7d69(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b2a8b8888e2cc3ea24e7ec3c7af0482db75a8e52280ee92df6a2c60c97d361b8(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__6d63d33082c458119de0b67f6cea4dfb247e7b48448d269afb214a2ebfc5fba6(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__cb913c8bb96af6173c654591aeb1db1fb3611d948b590a98c092813f26aa8f0b(
    value: typing.Optional[typing.Union[SiteRecoveryReplicationRecoveryPlanTimeouts, _cdktf_9a9027ec.IResolvable]],
) -> None:
    """Type checking stubs"""
    pass
