import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultCertificatesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificates#id DataAzurermKeyVaultCertificates#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificates#include_pending DataAzurermKeyVaultCertificates#include_pending}
    */
    readonly includePending?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificates#key_vault_id DataAzurermKeyVaultCertificates#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificates#timeouts DataAzurermKeyVaultCertificates#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultCertificatesTimeouts;
}
export interface DataAzurermKeyVaultCertificatesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificates#read DataAzurermKeyVaultCertificates#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultCertificatesTimeoutsToTerraform(struct?: DataAzurermKeyVaultCertificatesTimeoutsOutputReference | DataAzurermKeyVaultCertificatesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultCertificatesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultCertificatesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificatesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificates azurerm_key_vault_certificates}
*/
export declare class DataAzurermKeyVaultCertificates extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_certificates";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificates azurerm_key_vault_certificates} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultCertificatesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultCertificatesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includePending?;
    get includePending(): boolean | cdktf.IResolvable;
    set includePending(value: boolean | cdktf.IResolvable);
    resetIncludePending(): void;
    get includePendingInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    get names(): string[];
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultCertificatesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultCertificatesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKeyVaultCertificatesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
