import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IpGroupCidrConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr#cidr IpGroupCidr#cidr}
    */
    readonly cidr: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr#id IpGroupCidr#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr#ip_group_id IpGroupCidr#ip_group_id}
    */
    readonly ipGroupId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr#timeouts IpGroupCidr#timeouts}
    */
    readonly timeouts?: IpGroupCidrTimeouts;
}
export interface IpGroupCidrTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr#create IpGroupCidr#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr#delete IpGroupCidr#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr#read IpGroupCidr#read}
    */
    readonly read?: string;
}
export declare function ipGroupCidrTimeoutsToTerraform(struct?: IpGroupCidrTimeoutsOutputReference | IpGroupCidrTimeouts | cdktf.IResolvable): any;
export declare class IpGroupCidrTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IpGroupCidrTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IpGroupCidrTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr azurerm_ip_group_cidr}
*/
export declare class IpGroupCidr extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_ip_group_cidr";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/ip_group_cidr azurerm_ip_group_cidr} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IpGroupCidrConfig
    */
    constructor(scope: Construct, id: string, config: IpGroupCidrConfig);
    private _cidr?;
    get cidr(): string;
    set cidr(value: string);
    get cidrInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipGroupId?;
    get ipGroupId(): string;
    set ipGroupId(value: string);
    get ipGroupIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): IpGroupCidrTimeoutsOutputReference;
    putTimeouts(value: IpGroupCidrTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IpGroupCidrTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
