import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamAnalyticsStreamInputEventhubV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#authentication_mode StreamAnalyticsStreamInputEventhubV2#authentication_mode}
    */
    readonly authenticationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#eventhub_consumer_group_name StreamAnalyticsStreamInputEventhubV2#eventhub_consumer_group_name}
    */
    readonly eventhubConsumerGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#eventhub_name StreamAnalyticsStreamInputEventhubV2#eventhub_name}
    */
    readonly eventhubName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#id StreamAnalyticsStreamInputEventhubV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#name StreamAnalyticsStreamInputEventhubV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#partition_key StreamAnalyticsStreamInputEventhubV2#partition_key}
    */
    readonly partitionKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#servicebus_namespace StreamAnalyticsStreamInputEventhubV2#servicebus_namespace}
    */
    readonly servicebusNamespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#shared_access_policy_key StreamAnalyticsStreamInputEventhubV2#shared_access_policy_key}
    */
    readonly sharedAccessPolicyKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#shared_access_policy_name StreamAnalyticsStreamInputEventhubV2#shared_access_policy_name}
    */
    readonly sharedAccessPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#stream_analytics_job_id StreamAnalyticsStreamInputEventhubV2#stream_analytics_job_id}
    */
    readonly streamAnalyticsJobId: string;
    /**
    * serialization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#serialization StreamAnalyticsStreamInputEventhubV2#serialization}
    */
    readonly serialization: StreamAnalyticsStreamInputEventhubV2Serialization;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#timeouts StreamAnalyticsStreamInputEventhubV2#timeouts}
    */
    readonly timeouts?: StreamAnalyticsStreamInputEventhubV2Timeouts;
}
export interface StreamAnalyticsStreamInputEventhubV2Serialization {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#encoding StreamAnalyticsStreamInputEventhubV2#encoding}
    */
    readonly encoding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#field_delimiter StreamAnalyticsStreamInputEventhubV2#field_delimiter}
    */
    readonly fieldDelimiter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#type StreamAnalyticsStreamInputEventhubV2#type}
    */
    readonly type: string;
}
export declare function streamAnalyticsStreamInputEventhubV2SerializationToTerraform(struct?: StreamAnalyticsStreamInputEventhubV2SerializationOutputReference | StreamAnalyticsStreamInputEventhubV2Serialization): any;
export declare class StreamAnalyticsStreamInputEventhubV2SerializationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsStreamInputEventhubV2Serialization | undefined;
    set internalValue(value: StreamAnalyticsStreamInputEventhubV2Serialization | undefined);
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string;
    set fieldDelimiter(value: string);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StreamAnalyticsStreamInputEventhubV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#create StreamAnalyticsStreamInputEventhubV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#delete StreamAnalyticsStreamInputEventhubV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#read StreamAnalyticsStreamInputEventhubV2#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2#update StreamAnalyticsStreamInputEventhubV2#update}
    */
    readonly update?: string;
}
export declare function streamAnalyticsStreamInputEventhubV2TimeoutsToTerraform(struct?: StreamAnalyticsStreamInputEventhubV2TimeoutsOutputReference | StreamAnalyticsStreamInputEventhubV2Timeouts | cdktf.IResolvable): any;
export declare class StreamAnalyticsStreamInputEventhubV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsStreamInputEventhubV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StreamAnalyticsStreamInputEventhubV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2 azurerm_stream_analytics_stream_input_eventhub_v2}
*/
export declare class StreamAnalyticsStreamInputEventhubV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stream_analytics_stream_input_eventhub_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub_v2 azurerm_stream_analytics_stream_input_eventhub_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamAnalyticsStreamInputEventhubV2Config
    */
    constructor(scope: Construct, id: string, config: StreamAnalyticsStreamInputEventhubV2Config);
    private _authenticationMode?;
    get authenticationMode(): string;
    set authenticationMode(value: string);
    resetAuthenticationMode(): void;
    get authenticationModeInput(): string | undefined;
    private _eventhubConsumerGroupName?;
    get eventhubConsumerGroupName(): string;
    set eventhubConsumerGroupName(value: string);
    resetEventhubConsumerGroupName(): void;
    get eventhubConsumerGroupNameInput(): string | undefined;
    private _eventhubName?;
    get eventhubName(): string;
    set eventhubName(value: string);
    get eventhubNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _partitionKey?;
    get partitionKey(): string;
    set partitionKey(value: string);
    resetPartitionKey(): void;
    get partitionKeyInput(): string | undefined;
    private _servicebusNamespace?;
    get servicebusNamespace(): string;
    set servicebusNamespace(value: string);
    get servicebusNamespaceInput(): string | undefined;
    private _sharedAccessPolicyKey?;
    get sharedAccessPolicyKey(): string;
    set sharedAccessPolicyKey(value: string);
    resetSharedAccessPolicyKey(): void;
    get sharedAccessPolicyKeyInput(): string | undefined;
    private _sharedAccessPolicyName?;
    get sharedAccessPolicyName(): string;
    set sharedAccessPolicyName(value: string);
    resetSharedAccessPolicyName(): void;
    get sharedAccessPolicyNameInput(): string | undefined;
    private _streamAnalyticsJobId?;
    get streamAnalyticsJobId(): string;
    set streamAnalyticsJobId(value: string);
    get streamAnalyticsJobIdInput(): string | undefined;
    private _serialization;
    get serialization(): StreamAnalyticsStreamInputEventhubV2SerializationOutputReference;
    putSerialization(value: StreamAnalyticsStreamInputEventhubV2Serialization): void;
    get serializationInput(): StreamAnalyticsStreamInputEventhubV2Serialization | undefined;
    private _timeouts;
    get timeouts(): StreamAnalyticsStreamInputEventhubV2TimeoutsOutputReference;
    putTimeouts(value: StreamAnalyticsStreamInputEventhubV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StreamAnalyticsStreamInputEventhubV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
