# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/search.ipynb.

# %% auto 0
__all__ = ['get_owners']

# %% ../nbs/search.ipynb 5
import requests, time
from . import core, config
from .query import _process_query
from tqdm.autonotebook import tqdm

# %% ../nbs/search.ipynb 6
def _search_loop(search_query, # Instance of Query object
                 url, # Copper API url,
                 max_retries:int = 5, # Maximum retry attempts
                 retry_delay:float = 2.0 # Delay in seconds between retries
                ):
    """Standard search loop used across all Copper record types
    """
    
    Sess = core.get_session()

    Native_Params, CF_Parms, Outputs  = _process_query(search_query)
    #print(f"Native_Params: {Native_Params}")
    #print(f"CF_Params: {CF_Parms}")

    total_pages = page = 1
    combined_results = []
    
    while page <= total_pages:
        page_params = {
            "page_size": 100,
            "page_number": page,
            }
        
        if Native_Params: page_params.update(Native_Params)

        if CF_Parms:     page_params.update({"custom_fields":CF_Parms}) 

        retries = 0
        while retries < max_retries:
            result = Sess.post(url,json=page_params)
    
            if result.status_code == 200:
                total_pages = (int(result.headers['X-PW-TOTAL'])//100)+1
                
                # Creatig Progress Bar:
                if page == 1: progress_bar = tqdm(total=total_pages,desc='Searching Copper')
                progress_bar.update(1)  # Update the progress bar
                
                result_json = result.json()
                combined_results.extend(result_json)
                page +=1
                break
            elif result.status_code == 429:
                retries += 1
                #print(f"Rate limit encountered. Retry {retries}/{max_retries} in {retry_delay} seconds.")
                time.sleep(retry_delay)
            else:
                print(f"Issue with page {page}")
                raise Exception(f"Error {result.status_code} retrieved from API")
    
    progress_bar.close()  # Close the progress bar when done
    
    return combined_results, Outputs


# %% ../nbs/search.ipynb 7
def get_owners(assignee_ids:list)-> dict:
    Sess = core.get_session()
    assignee_dict = {}

    for userid in assignee_ids:
        results = Sess.get(f"https://api.copper.com/developer_api/v1/users/{int(userid)}")
        assignee_dict[userid] = results.json().get('name', None)

    return assignee_dict
