from .crc64_combine import mkCombineFun

try:
  from crcmod.crcmod import *
  import crcmod.predefined
except ImportError:
  # Make this backward compatible
  from crcmod import *
  import predefined
__doc__ = crcmod.__doc__


class Crc64(object):
  _POLY = 0x142F0E1EBA9EA3693
  _XOROUT = 0XFFFFFFFFFFFFFFFF

  def __init__(self, init_crc=0):
    self.crc64 = crcmod.Crc(self._POLY, initCrc=init_crc, rev=True, xorOut=self._XOROUT)

    self.crc64_combineFun = mkCombineFun(self._POLY, initCrc=init_crc, rev=True, xorOut=self._XOROUT)

  def __call__(self, data):
    self.update(data)

  def update(self, data):
    self.crc64.update(data)

  def combine(self, crc1, crc2, len2):
    return self.crc64_combineFun(crc1, crc2, len2)

  @property
  def crc(self):
    return self.crc64.crcValue
