# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

import types

__config__ = pulumi.Config('auth0')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def api_token(self) -> Optional[str]:
        """
        Your Auth0 [management api access token](https://auth0.com/docs/security/tokens/access-tokens/management-api-access-tokens). It can also be sourced from the `AUTH0_API_TOKEN` environment variable. It can be used instead of `client_id` + `client_secret`. If both are specified, `api_token` will be used over `client_id` + `client_secret` fields.
        """
        return __config__.get('apiToken')

    @_builtins.property
    def audience(self) -> Optional[str]:
        """
        Your Auth0 audience when using a custom domain. It can also be sourced from the `AUTH0_AUDIENCE` environment variable.
        """
        return __config__.get('audience')

    @_builtins.property
    def cli_login(self) -> Optional[bool]:
        """
        While toggled on, the API token gets fetched from the keyring for the given domain
        """
        return __config__.get_bool('cliLogin')

    @_builtins.property
    def client_assertion_private_key(self) -> Optional[str]:
        """
        The private key used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_PRIVATE_KEY` environment variable.
        """
        return __config__.get('clientAssertionPrivateKey')

    @_builtins.property
    def client_assertion_signing_alg(self) -> Optional[str]:
        """
        The algorithm used to sign the client assertion JWT. It can also be sourced from the `AUTH0_CLIENT_ASSERTION_SIGNING_ALG` environment variable.
        """
        return __config__.get('clientAssertionSigningAlg')

    @_builtins.property
    def client_id(self) -> Optional[str]:
        """
        Your Auth0 client ID. It can also be sourced from the `AUTH0_CLIENT_ID` environment variable.
        """
        return __config__.get('clientId')

    @_builtins.property
    def client_secret(self) -> Optional[str]:
        """
        Your Auth0 client secret. It can also be sourced from the `AUTH0_CLIENT_SECRET` environment variable.
        """
        return __config__.get('clientSecret')

    @_builtins.property
    def custom_domain_header(self) -> Optional[str]:
        """
        When specified, this header is added to requests targeting a set of pre-defined whitelisted URLs Global setting overrides all resource specific `custom_domain_header` value
        """
        return __config__.get('customDomainHeader')

    @_builtins.property
    def debug(self) -> Optional[bool]:
        """
        Enables HTTP request and response logging when TF_LOG=DEBUG is set. It can also be sourced from the `AUTH0_DEBUG` environment variable.
        """
        return __config__.get_bool('debug') or _utilities.get_env_bool('AUTH0_DEBUG')

    @_builtins.property
    def domain(self) -> Optional[str]:
        """
        Your Auth0 domain name. It can also be sourced from the `AUTH0_DOMAIN` environment variable.
        """
        return __config__.get('domain')

    @_builtins.property
    def dynamic_credentials(self) -> Optional[bool]:
        return __config__.get_bool('dynamicCredentials')

