# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomDomainArgs', 'CustomDomain']

@pulumi.input_type
class CustomDomainArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 custom_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomDomain resource.
        :param pulumi.Input[_builtins.str] domain: Name of the custom domain.
        :param pulumi.Input[_builtins.str] type: Provisioning type for the custom domain. Options include `auth0_managed_certs` and `self_managed_certs`.
        :param pulumi.Input[_builtins.str] custom_client_ip_header: The HTTP header to fetch the client's IP address. Cannot be set on auth0_managed domains.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] domain_metadata: Metadata associated with the Custom Domain. Maximum of 10 metadata properties allowed.
        :param pulumi.Input[_builtins.str] tls_policy: TLS policy for the custom domain. Available options are: `compatible` or `recommended`. Compatible includes TLS 1.0, 1.1, 1.2, and recommended only includes TLS 1.2. Cannot be set on self_managed domains.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "type", type)
        if custom_client_ip_header is not None:
            pulumi.set(__self__, "custom_client_ip_header", custom_client_ip_header)
        if domain_metadata is not None:
            pulumi.set(__self__, "domain_metadata", domain_metadata)
        if tls_policy is not None:
            pulumi.set(__self__, "tls_policy", tls_policy)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the custom domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Provisioning type for the custom domain. Options include `auth0_managed_certs` and `self_managed_certs`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="customClientIpHeader")
    def custom_client_ip_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP header to fetch the client's IP address. Cannot be set on auth0_managed domains.
        """
        return pulumi.get(self, "custom_client_ip_header")

    @custom_client_ip_header.setter
    def custom_client_ip_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_client_ip_header", value)

    @_builtins.property
    @pulumi.getter(name="domainMetadata")
    def domain_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata associated with the Custom Domain. Maximum of 10 metadata properties allowed.
        """
        return pulumi.get(self, "domain_metadata")

    @domain_metadata.setter
    def domain_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_metadata", value)

    @_builtins.property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TLS policy for the custom domain. Available options are: `compatible` or `recommended`. Compatible includes TLS 1.0, 1.1, 1.2, and recommended only includes TLS 1.2. Cannot be set on self_managed domains.
        """
        return pulumi.get(self, "tls_policy")

    @tls_policy.setter
    def tls_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_policy", value)


@pulumi.input_type
class _CustomDomainState:
    def __init__(__self__, *,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainCertificateArgs']]]] = None,
                 custom_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 origin_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 verifications: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainVerificationArgs']]]] = None):
        """
        Input properties used for looking up and filtering CustomDomain resources.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainCertificateArgs']]] certificates: The Custom Domain certificate.
        :param pulumi.Input[_builtins.str] custom_client_ip_header: The HTTP header to fetch the client's IP address. Cannot be set on auth0_managed domains.
        :param pulumi.Input[_builtins.str] domain: Name of the custom domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] domain_metadata: Metadata associated with the Custom Domain. Maximum of 10 metadata properties allowed.
        :param pulumi.Input[_builtins.str] origin_domain_name: Once the configuration status is `ready`, the DNS name of the Auth0 origin server that handles traffic for the custom domain.
        :param pulumi.Input[_builtins.bool] primary: Indicates whether this is a primary domain.
        :param pulumi.Input[_builtins.str] status: Configuration status for the custom domain. Options include `disabled`, `pending`, `pending_verification`, and `ready`.
        :param pulumi.Input[_builtins.str] tls_policy: TLS policy for the custom domain. Available options are: `compatible` or `recommended`. Compatible includes TLS 1.0, 1.1, 1.2, and recommended only includes TLS 1.2. Cannot be set on self_managed domains.
        :param pulumi.Input[_builtins.str] type: Provisioning type for the custom domain. Options include `auth0_managed_certs` and `self_managed_certs`.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainVerificationArgs']]] verifications: Configuration settings for verification.
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if custom_client_ip_header is not None:
            pulumi.set(__self__, "custom_client_ip_header", custom_client_ip_header)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_metadata is not None:
            pulumi.set(__self__, "domain_metadata", domain_metadata)
        if origin_domain_name is not None:
            pulumi.set(__self__, "origin_domain_name", origin_domain_name)
        if primary is not None:
            warnings.warn("""Primary field is no longer used and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""primary is deprecated: Primary field is no longer used and will be removed in a future release.""")
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tls_policy is not None:
            pulumi.set(__self__, "tls_policy", tls_policy)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if verifications is not None:
            pulumi.set(__self__, "verifications", verifications)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainCertificateArgs']]]]:
        """
        The Custom Domain certificate.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="customClientIpHeader")
    def custom_client_ip_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP header to fetch the client's IP address. Cannot be set on auth0_managed domains.
        """
        return pulumi.get(self, "custom_client_ip_header")

    @custom_client_ip_header.setter
    def custom_client_ip_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_client_ip_header", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the custom domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="domainMetadata")
    def domain_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata associated with the Custom Domain. Maximum of 10 metadata properties allowed.
        """
        return pulumi.get(self, "domain_metadata")

    @domain_metadata.setter
    def domain_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_metadata", value)

    @_builtins.property
    @pulumi.getter(name="originDomainName")
    def origin_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Once the configuration status is `ready`, the DNS name of the Auth0 origin server that handles traffic for the custom domain.
        """
        return pulumi.get(self, "origin_domain_name")

    @origin_domain_name.setter
    def origin_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_domain_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Primary field is no longer used and will be removed in a future release.""")
    def primary(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether this is a primary domain.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "primary", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration status for the custom domain. Options include `disabled`, `pending`, `pending_verification`, and `ready`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TLS policy for the custom domain. Available options are: `compatible` or `recommended`. Compatible includes TLS 1.0, 1.1, 1.2, and recommended only includes TLS 1.2. Cannot be set on self_managed domains.
        """
        return pulumi.get(self, "tls_policy")

    @tls_policy.setter
    def tls_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_policy", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning type for the custom domain. Options include `auth0_managed_certs` and `self_managed_certs`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def verifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainVerificationArgs']]]]:
        """
        Configuration settings for verification.
        """
        return pulumi.get(self, "verifications")

    @verifications.setter
    def verifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainVerificationArgs']]]]):
        pulumi.set(self, "verifications", value)


@pulumi.type_token("auth0:index/customDomain:CustomDomain")
class CustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        With Auth0, you can use a custom domain to maintain a consistent user experience. This resource allows you to create and manage a custom domain within your Auth0 tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_custom_domain = auth0.CustomDomain("my_custom_domain",
            domain="auth.example.com",
            type="auth0_managed_certs",
            tls_policy="recommended",
            domain_metadata={
                "key1": "value1",
                "key2": "value2",
            })
        ```

        ## Import

        Custom domains can be imported using their ID.

        You can find existing custom domain IDs using the Auth0 Management API.

        https://auth0.com/docs/api/management/v2#!/Custom_Domains/get_custom_domains

        Example:

        ```sh
        $ pulumi import auth0:index/customDomain:CustomDomain my_custom_domain "cd_XXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_client_ip_header: The HTTP header to fetch the client's IP address. Cannot be set on auth0_managed domains.
        :param pulumi.Input[_builtins.str] domain: Name of the custom domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] domain_metadata: Metadata associated with the Custom Domain. Maximum of 10 metadata properties allowed.
        :param pulumi.Input[_builtins.str] tls_policy: TLS policy for the custom domain. Available options are: `compatible` or `recommended`. Compatible includes TLS 1.0, 1.1, 1.2, and recommended only includes TLS 1.2. Cannot be set on self_managed domains.
        :param pulumi.Input[_builtins.str] type: Provisioning type for the custom domain. Options include `auth0_managed_certs` and `self_managed_certs`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With Auth0, you can use a custom domain to maintain a consistent user experience. This resource allows you to create and manage a custom domain within your Auth0 tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_custom_domain = auth0.CustomDomain("my_custom_domain",
            domain="auth.example.com",
            type="auth0_managed_certs",
            tls_policy="recommended",
            domain_metadata={
                "key1": "value1",
                "key2": "value2",
            })
        ```

        ## Import

        Custom domains can be imported using their ID.

        You can find existing custom domain IDs using the Auth0 Management API.

        https://auth0.com/docs/api/management/v2#!/Custom_Domains/get_custom_domains

        Example:

        ```sh
        $ pulumi import auth0:index/customDomain:CustomDomain my_custom_domain "cd_XXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param CustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDomainArgs.__new__(CustomDomainArgs)

            __props__.__dict__["custom_client_ip_header"] = custom_client_ip_header
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["domain_metadata"] = domain_metadata
            __props__.__dict__["tls_policy"] = tls_policy
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["certificates"] = None
            __props__.__dict__["origin_domain_name"] = None
            __props__.__dict__["primary"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["verifications"] = None
        super(CustomDomain, __self__).__init__(
            'auth0:index/customDomain:CustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainCertificateArgs', 'CustomDomainCertificateArgsDict']]]]] = None,
            custom_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            domain_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            origin_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            primary: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tls_policy: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            verifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainVerificationArgs', 'CustomDomainVerificationArgsDict']]]]] = None) -> 'CustomDomain':
        """
        Get an existing CustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainCertificateArgs', 'CustomDomainCertificateArgsDict']]]] certificates: The Custom Domain certificate.
        :param pulumi.Input[_builtins.str] custom_client_ip_header: The HTTP header to fetch the client's IP address. Cannot be set on auth0_managed domains.
        :param pulumi.Input[_builtins.str] domain: Name of the custom domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] domain_metadata: Metadata associated with the Custom Domain. Maximum of 10 metadata properties allowed.
        :param pulumi.Input[_builtins.str] origin_domain_name: Once the configuration status is `ready`, the DNS name of the Auth0 origin server that handles traffic for the custom domain.
        :param pulumi.Input[_builtins.bool] primary: Indicates whether this is a primary domain.
        :param pulumi.Input[_builtins.str] status: Configuration status for the custom domain. Options include `disabled`, `pending`, `pending_verification`, and `ready`.
        :param pulumi.Input[_builtins.str] tls_policy: TLS policy for the custom domain. Available options are: `compatible` or `recommended`. Compatible includes TLS 1.0, 1.1, 1.2, and recommended only includes TLS 1.2. Cannot be set on self_managed domains.
        :param pulumi.Input[_builtins.str] type: Provisioning type for the custom domain. Options include `auth0_managed_certs` and `self_managed_certs`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainVerificationArgs', 'CustomDomainVerificationArgsDict']]]] verifications: Configuration settings for verification.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDomainState.__new__(_CustomDomainState)

        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["custom_client_ip_header"] = custom_client_ip_header
        __props__.__dict__["domain"] = domain
        __props__.__dict__["domain_metadata"] = domain_metadata
        __props__.__dict__["origin_domain_name"] = origin_domain_name
        __props__.__dict__["primary"] = primary
        __props__.__dict__["status"] = status
        __props__.__dict__["tls_policy"] = tls_policy
        __props__.__dict__["type"] = type
        __props__.__dict__["verifications"] = verifications
        return CustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Sequence['outputs.CustomDomainCertificate']]:
        """
        The Custom Domain certificate.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="customClientIpHeader")
    def custom_client_ip_header(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The HTTP header to fetch the client's IP address. Cannot be set on auth0_managed domains.
        """
        return pulumi.get(self, "custom_client_ip_header")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the custom domain.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="domainMetadata")
    def domain_metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Metadata associated with the Custom Domain. Maximum of 10 metadata properties allowed.
        """
        return pulumi.get(self, "domain_metadata")

    @_builtins.property
    @pulumi.getter(name="originDomainName")
    def origin_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Once the configuration status is `ready`, the DNS name of the Auth0 origin server that handles traffic for the custom domain.
        """
        return pulumi.get(self, "origin_domain_name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Primary field is no longer used and will be removed in a future release.""")
    def primary(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether this is a primary domain.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Configuration status for the custom domain. Options include `disabled`, `pending`, `pending_verification`, and `ready`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> pulumi.Output[_builtins.str]:
        """
        TLS policy for the custom domain. Available options are: `compatible` or `recommended`. Compatible includes TLS 1.0, 1.1, 1.2, and recommended only includes TLS 1.2. Cannot be set on self_managed domains.
        """
        return pulumi.get(self, "tls_policy")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Provisioning type for the custom domain. Options include `auth0_managed_certs` and `self_managed_certs`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def verifications(self) -> pulumi.Output[Sequence['outputs.CustomDomainVerification']]:
        """
        Configuration settings for verification.
        """
        return pulumi.get(self, "verifications")

