/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AlertConfig extends cdktf.TerraformMetaArguments {
    /**
    * The SQL statement that should be executed if the condition returns one or more rows.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#action Alert#action}
    */
    readonly action: string;
    /**
    * Specifies a comment for the alert.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#comment Alert#comment}
    */
    readonly comment?: string;
    /**
    * The SQL statement that represents the condition for the alert. (SELECT, SHOW, CALL)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#condition Alert#condition}
    */
    readonly condition: string;
    /**
    * The database in which to create the alert.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#database Alert#database}
    */
    readonly database: string;
    /**
    * Specifies if an alert should be 'started' (enabled) after creation or should remain 'suspended' (default).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#enabled Alert#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#id Alert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the alert; must be unique for the database and schema in which the alert is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#name Alert#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the alert.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#schema Alert#schema}
    */
    readonly schema: string;
    /**
    * The warehouse the alert will use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#warehouse Alert#warehouse}
    */
    readonly warehouse: string;
    /**
    * alert_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#alert_schedule Alert#alert_schedule}
    */
    readonly alertSchedule?: AlertAlertSchedule;
}
export interface AlertAlertScheduleCron {
    /**
    * Specifies the cron expression for the alert. The cron expression must be in the following format: "minute hour day-of-month month day-of-week". The following values are supported: minute: 0-59 hour: 0-23 day-of-month: 1-31 month: 1-12 day-of-week: 0-6 (0 is Sunday)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#expression Alert#expression}
    */
    readonly expression: string;
    /**
    * Specifies the time zone for alert refresh.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#time_zone Alert#time_zone}
    */
    readonly timeZone: string;
}
export declare function alertAlertScheduleCronToTerraform(struct?: AlertAlertScheduleCronOutputReference | AlertAlertScheduleCron): any;
export declare class AlertAlertScheduleCronOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlertAlertScheduleCron | undefined;
    set internalValue(value: AlertAlertScheduleCron | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
}
export interface AlertAlertSchedule {
    /**
    * Specifies the interval in minutes for the alert schedule. The interval must be greater than 0 and less than 1440 (24 hours).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#interval Alert#interval}
    */
    readonly interval?: number;
    /**
    * cron block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert#cron Alert#cron}
    */
    readonly cron?: AlertAlertScheduleCron;
}
export declare function alertAlertScheduleToTerraform(struct?: AlertAlertScheduleOutputReference | AlertAlertSchedule): any;
export declare class AlertAlertScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlertAlertSchedule | undefined;
    set internalValue(value: AlertAlertSchedule | undefined);
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _cron;
    get cron(): AlertAlertScheduleCronOutputReference;
    putCron(value: AlertAlertScheduleCron): void;
    resetCron(): void;
    get cronInput(): AlertAlertScheduleCron | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert snowflake_alert}
*/
export declare class Alert extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_alert";
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/alert snowflake_alert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AlertConfig
    */
    constructor(scope: Construct, id: string, config: AlertConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _condition?;
    get condition(): string;
    set condition(value: string);
    get conditionInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _warehouse?;
    get warehouse(): string;
    set warehouse(value: string);
    get warehouseInput(): string | undefined;
    private _alertSchedule;
    get alertSchedule(): AlertAlertScheduleOutputReference;
    putAlertSchedule(value: AlertAlertSchedule): void;
    resetAlertSchedule(): void;
    get alertScheduleInput(): AlertAlertSchedule | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
