/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeResourceMonitorsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/data-sources/resource_monitors#id DataSnowflakeResourceMonitors#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataSnowflakeResourceMonitorsResourceMonitors {
}
export declare function dataSnowflakeResourceMonitorsResourceMonitorsToTerraform(struct?: DataSnowflakeResourceMonitorsResourceMonitors): any;
export declare class DataSnowflakeResourceMonitorsResourceMonitorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeResourceMonitorsResourceMonitors | undefined;
    set internalValue(value: DataSnowflakeResourceMonitorsResourceMonitors | undefined);
    get comment(): string;
    get creditQuota(): string;
    get frequency(): string;
    get name(): string;
}
export declare class DataSnowflakeResourceMonitorsResourceMonitorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeResourceMonitorsResourceMonitorsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/data-sources/resource_monitors snowflake_resource_monitors}
*/
export declare class DataSnowflakeResourceMonitors extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_resource_monitors";
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/data-sources/resource_monitors snowflake_resource_monitors} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeResourceMonitorsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeResourceMonitorsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceMonitors;
    get resourceMonitors(): DataSnowflakeResourceMonitorsResourceMonitorsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
