/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#comment FunctionResource#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the function. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#database FunctionResource#database}
    */
    readonly database: string;
    /**
    * The handler method for Java / Python function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#handler FunctionResource#handler}
    */
    readonly handler?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#id FunctionResource#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Imports for Java / Python functions. For Java this a list of jar files, for Python this is a list of Python files.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#imports FunctionResource#imports}
    */
    readonly imports?: string[];
    /**
    * Specifies that the function is secure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#is_secure FunctionResource#is_secure}
    */
    readonly isSecure?: boolean | cdktf.IResolvable;
    /**
    * The language of the statement
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#language FunctionResource#language}
    */
    readonly language?: string;
    /**
    * Specifies the identifier for the function; does not have to be unique for the schema in which the function is created. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#name FunctionResource#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the function when called with null inputs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#null_input_behavior FunctionResource#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * List of package imports to use for Java / Python functions. For Java, package imports should be of the form: package_name:version_number, where package_name is snowflake_domain:package. For Python use it should be: ('numpy','pandas','xgboost==1.5.0').
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#packages FunctionResource#packages}
    */
    readonly packages?: string[];
    /**
    * Specifies the behavior of the function when returning results
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#return_behavior FunctionResource#return_behavior}
    */
    readonly returnBehavior?: string;
    /**
    * The return type of the function
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#return_type FunctionResource#return_type}
    */
    readonly returnType: string;
    /**
    * Required for Python functions. Specifies Python runtime version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#runtime_version FunctionResource#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The schema in which to create the function. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#schema FunctionResource#schema}
    */
    readonly schema: string;
    /**
    * Specifies the javascript / java / sql / python code used to create the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#statement FunctionResource#statement}
    */
    readonly statement: string;
    /**
    * The target path for the Java / Python functions. For Java, it is the path of compiled jar files and for the Python it is the path of the Python files.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#target_path FunctionResource#target_path}
    */
    readonly targetPath?: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#arguments FunctionResource#arguments}
    */
    readonly arguments?: FunctionResourceArguments[] | cdktf.IResolvable;
}
export interface FunctionResourceArguments {
    /**
    * The argument name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#name FunctionResource#name}
    */
    readonly name: string;
    /**
    * The argument type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function#type FunctionResource#type}
    */
    readonly type: string;
}
export declare function functionResourceArgumentsToTerraform(struct?: FunctionResourceArguments | cdktf.IResolvable): any;
export declare class FunctionResourceArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionResourceArguments | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionResourceArguments | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class FunctionResourceArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionResourceArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionResourceArgumentsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function snowflake_function}
*/
export declare class FunctionResource extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_function";
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/function snowflake_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionResourceConfig
    */
    constructor(scope: Construct, id: string, config: FunctionResourceConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _handler?;
    get handler(): string;
    set handler(value: string);
    resetHandler(): void;
    get handlerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imports?;
    get imports(): string[];
    set imports(value: string[]);
    resetImports(): void;
    get importsInput(): string[] | undefined;
    private _isSecure?;
    get isSecure(): boolean | cdktf.IResolvable;
    set isSecure(value: boolean | cdktf.IResolvable);
    resetIsSecure(): void;
    get isSecureInput(): boolean | cdktf.IResolvable | undefined;
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _packages?;
    get packages(): string[];
    set packages(value: string[]);
    resetPackages(): void;
    get packagesInput(): string[] | undefined;
    private _returnBehavior?;
    get returnBehavior(): string;
    set returnBehavior(value: string);
    resetReturnBehavior(): void;
    get returnBehaviorInput(): string | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _statement?;
    get statement(): string;
    set statement(value: string);
    get statementInput(): string | undefined;
    private _targetPath?;
    get targetPath(): string;
    set targetPath(value: string);
    resetTargetPath(): void;
    get targetPathInput(): string | undefined;
    private _arguments;
    get arguments(): FunctionResourceArgumentsList;
    putArguments(value: FunctionResourceArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | FunctionResourceArguments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
