/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/network_policy#allowed_ip_list NetworkPolicy#allowed_ip_list}
    */
    readonly allowedIpList: string[];
    /**
    * Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account<br><br>**Do not** add `0.0.0.0/0` to `blocked_ip_list`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/network_policy#blocked_ip_list NetworkPolicy#blocked_ip_list}
    */
    readonly blockedIpList?: string[];
    /**
    * Specifies a comment for the network policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/network_policy#comment NetworkPolicy#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/network_policy#id NetworkPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the network policy; must be unique for the account in which the network policy is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/network_policy#name NetworkPolicy#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/network_policy snowflake_network_policy}
*/
export declare class NetworkPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_network_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/network_policy snowflake_network_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkPolicyConfig
    */
    constructor(scope: Construct, id: string, config: NetworkPolicyConfig);
    private _allowedIpList?;
    get allowedIpList(): string[];
    set allowedIpList(value: string[]);
    get allowedIpListInput(): string[] | undefined;
    private _blockedIpList?;
    get blockedIpList(): string[];
    set blockedIpList(value: string[]);
    resetBlockedIpList(): void;
    get blockedIpListInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
