/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PasswordPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Adds a comment or overwrites an existing comment for the password policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#comment PasswordPolicy#comment}
    */
    readonly comment?: string;
    /**
    * The database this password policy belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#database PasswordPolicy#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#id PasswordPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Prevent overwriting a previous password policy with the same name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#if_not_exists PasswordPolicy#if_not_exists}
    */
    readonly ifNotExists?: boolean | cdktf.IResolvable;
    /**
    * Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD_MAX_RETRIES). Supported range: 1 to 999, inclusive. Default: 15
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#lockout_time_mins PasswordPolicy#lockout_time_mins}
    */
    readonly lockoutTimeMins?: number;
    /**
    * Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#max_age_days PasswordPolicy#max_age_days}
    */
    readonly maxAgeDays?: number;
    /**
    * Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD_MIN_LENGTH, PASSWORD_MIN_UPPER_CASE_CHARS, and PASSWORD_MIN_LOWER_CASE_CHARS. Supported range: 8 to 256, inclusive. Default: 256
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#max_length PasswordPolicy#max_length}
    */
    readonly maxLength?: number;
    /**
    * Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#max_retries PasswordPolicy#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#min_length PasswordPolicy#min_length}
    */
    readonly minLength?: number;
    /**
    * Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#min_lower_case_chars PasswordPolicy#min_lower_case_chars}
    */
    readonly minLowerCaseChars?: number;
    /**
    * Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#min_numeric_chars PasswordPolicy#min_numeric_chars}
    */
    readonly minNumericChars?: number;
    /**
    * Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#min_special_chars PasswordPolicy#min_special_chars}
    */
    readonly minSpecialChars?: number;
    /**
    * Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#min_upper_case_chars PasswordPolicy#min_upper_case_chars}
    */
    readonly minUpperCaseChars?: number;
    /**
    * Identifier for the password policy; must be unique for your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#name PasswordPolicy#name}
    */
    readonly name: string;
    /**
    * Whether to override a previous password policy with the same name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#or_replace PasswordPolicy#or_replace}
    */
    readonly orReplace?: boolean | cdktf.IResolvable;
    /**
    * The schema this password policy belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy#schema PasswordPolicy#schema}
    */
    readonly schema: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy snowflake_password_policy}
*/
export declare class PasswordPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_password_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/password_policy snowflake_password_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PasswordPolicyConfig
    */
    constructor(scope: Construct, id: string, config: PasswordPolicyConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ifNotExists?;
    get ifNotExists(): boolean | cdktf.IResolvable;
    set ifNotExists(value: boolean | cdktf.IResolvable);
    resetIfNotExists(): void;
    get ifNotExistsInput(): boolean | cdktf.IResolvable | undefined;
    private _lockoutTimeMins?;
    get lockoutTimeMins(): number;
    set lockoutTimeMins(value: number);
    resetLockoutTimeMins(): void;
    get lockoutTimeMinsInput(): number | undefined;
    private _maxAgeDays?;
    get maxAgeDays(): number;
    set maxAgeDays(value: number);
    resetMaxAgeDays(): void;
    get maxAgeDaysInput(): number | undefined;
    private _maxLength?;
    get maxLength(): number;
    set maxLength(value: number);
    resetMaxLength(): void;
    get maxLengthInput(): number | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _minLength?;
    get minLength(): number;
    set minLength(value: number);
    resetMinLength(): void;
    get minLengthInput(): number | undefined;
    private _minLowerCaseChars?;
    get minLowerCaseChars(): number;
    set minLowerCaseChars(value: number);
    resetMinLowerCaseChars(): void;
    get minLowerCaseCharsInput(): number | undefined;
    private _minNumericChars?;
    get minNumericChars(): number;
    set minNumericChars(value: number);
    resetMinNumericChars(): void;
    get minNumericCharsInput(): number | undefined;
    private _minSpecialChars?;
    get minSpecialChars(): number;
    set minSpecialChars(value: number);
    resetMinSpecialChars(): void;
    get minSpecialCharsInput(): number | undefined;
    private _minUpperCaseChars?;
    get minUpperCaseChars(): number;
    set minUpperCaseChars(value: number);
    resetMinUpperCaseChars(): void;
    get minUpperCaseCharsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orReplace?;
    get orReplace(): boolean | cdktf.IResolvable;
    set orReplace(value: boolean | cdktf.IResolvable);
    resetOrReplace(): void;
    get orReplaceInput(): boolean | cdktf.IResolvable | undefined;
    get qualifiedName(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
