"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs snowflake}
*/
class SnowflakeProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'snowflake',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.68.2',
                providerVersionConstraint: ' ~> 0.40'
            },
            terraformProviderSource: 'Snowflake-Labs/snowflake'
        });
        this._account = config.account;
        this._browserAuth = config.browserAuth;
        this._host = config.host;
        this._insecureMode = config.insecureMode;
        this._oauthAccessToken = config.oauthAccessToken;
        this._oauthClientId = config.oauthClientId;
        this._oauthClientSecret = config.oauthClientSecret;
        this._oauthEndpoint = config.oauthEndpoint;
        this._oauthRedirectUrl = config.oauthRedirectUrl;
        this._oauthRefreshToken = config.oauthRefreshToken;
        this._password = config.password;
        this._port = config.port;
        this._privateKey = config.privateKey;
        this._privateKeyPassphrase = config.privateKeyPassphrase;
        this._privateKeyPath = config.privateKeyPath;
        this._profile = config.profile;
        this._protocol = config.protocol;
        this._region = config.region;
        this._role = config.role;
        this._sessionParams = config.sessionParams;
        this._username = config.username;
        this._warehouse = config.warehouse;
        this._alias = config.alias;
    }
    get account() {
        return this._account;
    }
    set account(value) {
        this._account = value;
    }
    resetAccount() {
        this._account = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountInput() {
        return this._account;
    }
    get browserAuth() {
        return this._browserAuth;
    }
    set browserAuth(value) {
        this._browserAuth = value;
    }
    resetBrowserAuth() {
        this._browserAuth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get browserAuthInput() {
        return this._browserAuth;
    }
    get host() {
        return this._host;
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get insecureMode() {
        return this._insecureMode;
    }
    set insecureMode(value) {
        this._insecureMode = value;
    }
    resetInsecureMode() {
        this._insecureMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureModeInput() {
        return this._insecureMode;
    }
    get oauthAccessToken() {
        return this._oauthAccessToken;
    }
    set oauthAccessToken(value) {
        this._oauthAccessToken = value;
    }
    resetOauthAccessToken() {
        this._oauthAccessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthAccessTokenInput() {
        return this._oauthAccessToken;
    }
    get oauthClientId() {
        return this._oauthClientId;
    }
    set oauthClientId(value) {
        this._oauthClientId = value;
    }
    resetOauthClientId() {
        this._oauthClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientIdInput() {
        return this._oauthClientId;
    }
    get oauthClientSecret() {
        return this._oauthClientSecret;
    }
    set oauthClientSecret(value) {
        this._oauthClientSecret = value;
    }
    resetOauthClientSecret() {
        this._oauthClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientSecretInput() {
        return this._oauthClientSecret;
    }
    get oauthEndpoint() {
        return this._oauthEndpoint;
    }
    set oauthEndpoint(value) {
        this._oauthEndpoint = value;
    }
    resetOauthEndpoint() {
        this._oauthEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthEndpointInput() {
        return this._oauthEndpoint;
    }
    get oauthRedirectUrl() {
        return this._oauthRedirectUrl;
    }
    set oauthRedirectUrl(value) {
        this._oauthRedirectUrl = value;
    }
    resetOauthRedirectUrl() {
        this._oauthRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRedirectUrlInput() {
        return this._oauthRedirectUrl;
    }
    get oauthRefreshToken() {
        return this._oauthRefreshToken;
    }
    set oauthRefreshToken(value) {
        this._oauthRefreshToken = value;
    }
    resetOauthRefreshToken() {
        this._oauthRefreshToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRefreshTokenInput() {
        return this._oauthRefreshToken;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get port() {
        return this._port;
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get privateKey() {
        return this._privateKey;
    }
    set privateKey(value) {
        this._privateKey = value;
    }
    resetPrivateKey() {
        this._privateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyInput() {
        return this._privateKey;
    }
    get privateKeyPassphrase() {
        return this._privateKeyPassphrase;
    }
    set privateKeyPassphrase(value) {
        this._privateKeyPassphrase = value;
    }
    resetPrivateKeyPassphrase() {
        this._privateKeyPassphrase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPassphraseInput() {
        return this._privateKeyPassphrase;
    }
    get privateKeyPath() {
        return this._privateKeyPath;
    }
    set privateKeyPath(value) {
        this._privateKeyPath = value;
    }
    resetPrivateKeyPath() {
        this._privateKeyPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPathInput() {
        return this._privateKeyPath;
    }
    get profile() {
        return this._profile;
    }
    set profile(value) {
        this._profile = value;
    }
    resetProfile() {
        this._profile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get profileInput() {
        return this._profile;
    }
    get protocol() {
        return this._protocol;
    }
    set protocol(value) {
        this._protocol = value;
    }
    resetProtocol() {
        this._protocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protocolInput() {
        return this._protocol;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get role() {
        return this._role;
    }
    set role(value) {
        this._role = value;
    }
    resetRole() {
        this._role = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get sessionParams() {
        return this._sessionParams;
    }
    set sessionParams(value) {
        this._sessionParams = value;
    }
    resetSessionParams() {
        this._sessionParams = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sessionParamsInput() {
        return this._sessionParams;
    }
    get username() {
        return this._username;
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get warehouse() {
        return this._warehouse;
    }
    set warehouse(value) {
        this._warehouse = value;
    }
    resetWarehouse() {
        this._warehouse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warehouseInput() {
        return this._warehouse;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account: cdktf.stringToTerraform(this._account),
            browser_auth: cdktf.booleanToTerraform(this._browserAuth),
            host: cdktf.stringToTerraform(this._host),
            insecure_mode: cdktf.booleanToTerraform(this._insecureMode),
            oauth_access_token: cdktf.stringToTerraform(this._oauthAccessToken),
            oauth_client_id: cdktf.stringToTerraform(this._oauthClientId),
            oauth_client_secret: cdktf.stringToTerraform(this._oauthClientSecret),
            oauth_endpoint: cdktf.stringToTerraform(this._oauthEndpoint),
            oauth_redirect_url: cdktf.stringToTerraform(this._oauthRedirectUrl),
            oauth_refresh_token: cdktf.stringToTerraform(this._oauthRefreshToken),
            password: cdktf.stringToTerraform(this._password),
            port: cdktf.numberToTerraform(this._port),
            private_key: cdktf.stringToTerraform(this._privateKey),
            private_key_passphrase: cdktf.stringToTerraform(this._privateKeyPassphrase),
            private_key_path: cdktf.stringToTerraform(this._privateKeyPath),
            profile: cdktf.stringToTerraform(this._profile),
            protocol: cdktf.stringToTerraform(this._protocol),
            region: cdktf.stringToTerraform(this._region),
            role: cdktf.stringToTerraform(this._role),
            session_params: cdktf.hashMapper(cdktf.stringToTerraform)(this._sessionParams),
            username: cdktf.stringToTerraform(this._username),
            warehouse: cdktf.stringToTerraform(this._warehouse),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.SnowflakeProvider = SnowflakeProvider;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeProvider[_a] = { fqn: "@cdktf/provider-snowflake.provider.SnowflakeProvider", version: "8.0.1" };
// =================
// STATIC PROPERTIES
// =================
SnowflakeProvider.tfResourceType = "snowflake";
//# sourceMappingURL=data:application/json;base64,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