"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceMonitor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/resource_monitor snowflake_resource_monitor}
*/
class ResourceMonitor extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/resource_monitor snowflake_resource_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceMonitorConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_resource_monitor',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.68.2',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._creditQuota = config.creditQuota;
        this._endTimestamp = config.endTimestamp;
        this._frequency = config.frequency;
        this._id = config.id;
        this._name = config.name;
        this._notifyTriggers = config.notifyTriggers;
        this._notifyUsers = config.notifyUsers;
        this._setForAccount = config.setForAccount;
        this._startTimestamp = config.startTimestamp;
        this._suspendImmediateTrigger = config.suspendImmediateTrigger;
        this._suspendImmediateTriggers = config.suspendImmediateTriggers;
        this._suspendTrigger = config.suspendTrigger;
        this._suspendTriggers = config.suspendTriggers;
        this._warehouses = config.warehouses;
    }
    get creditQuota() {
        return this.getNumberAttribute('credit_quota');
    }
    set creditQuota(value) {
        this._creditQuota = value;
    }
    resetCreditQuota() {
        this._creditQuota = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get creditQuotaInput() {
        return this._creditQuota;
    }
    get endTimestamp() {
        return this.getStringAttribute('end_timestamp');
    }
    set endTimestamp(value) {
        this._endTimestamp = value;
    }
    resetEndTimestamp() {
        this._endTimestamp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get endTimestampInput() {
        return this._endTimestamp;
    }
    get frequency() {
        return this.getStringAttribute('frequency');
    }
    set frequency(value) {
        this._frequency = value;
    }
    resetFrequency() {
        this._frequency = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get frequencyInput() {
        return this._frequency;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get notifyTriggers() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('notify_triggers')));
    }
    set notifyTriggers(value) {
        this._notifyTriggers = value;
    }
    resetNotifyTriggers() {
        this._notifyTriggers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyTriggersInput() {
        return this._notifyTriggers;
    }
    get notifyUsers() {
        return cdktf.Fn.tolist(this.getListAttribute('notify_users'));
    }
    set notifyUsers(value) {
        this._notifyUsers = value;
    }
    resetNotifyUsers() {
        this._notifyUsers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyUsersInput() {
        return this._notifyUsers;
    }
    get setForAccount() {
        return this.getBooleanAttribute('set_for_account');
    }
    set setForAccount(value) {
        this._setForAccount = value;
    }
    resetSetForAccount() {
        this._setForAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get setForAccountInput() {
        return this._setForAccount;
    }
    get startTimestamp() {
        return this.getStringAttribute('start_timestamp');
    }
    set startTimestamp(value) {
        this._startTimestamp = value;
    }
    resetStartTimestamp() {
        this._startTimestamp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get startTimestampInput() {
        return this._startTimestamp;
    }
    get suspendImmediateTrigger() {
        return this.getNumberAttribute('suspend_immediate_trigger');
    }
    set suspendImmediateTrigger(value) {
        this._suspendImmediateTrigger = value;
    }
    resetSuspendImmediateTrigger() {
        this._suspendImmediateTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendImmediateTriggerInput() {
        return this._suspendImmediateTrigger;
    }
    get suspendImmediateTriggers() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('suspend_immediate_triggers')));
    }
    set suspendImmediateTriggers(value) {
        this._suspendImmediateTriggers = value;
    }
    resetSuspendImmediateTriggers() {
        this._suspendImmediateTriggers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendImmediateTriggersInput() {
        return this._suspendImmediateTriggers;
    }
    get suspendTrigger() {
        return this.getNumberAttribute('suspend_trigger');
    }
    set suspendTrigger(value) {
        this._suspendTrigger = value;
    }
    resetSuspendTrigger() {
        this._suspendTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendTriggerInput() {
        return this._suspendTrigger;
    }
    get suspendTriggers() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('suspend_triggers')));
    }
    set suspendTriggers(value) {
        this._suspendTriggers = value;
    }
    resetSuspendTriggers() {
        this._suspendTriggers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendTriggersInput() {
        return this._suspendTriggers;
    }
    get warehouses() {
        return cdktf.Fn.tolist(this.getListAttribute('warehouses'));
    }
    set warehouses(value) {
        this._warehouses = value;
    }
    resetWarehouses() {
        this._warehouses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warehousesInput() {
        return this._warehouses;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            credit_quota: cdktf.numberToTerraform(this._creditQuota),
            end_timestamp: cdktf.stringToTerraform(this._endTimestamp),
            frequency: cdktf.stringToTerraform(this._frequency),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            notify_triggers: cdktf.listMapper(cdktf.numberToTerraform, false)(this._notifyTriggers),
            notify_users: cdktf.listMapper(cdktf.stringToTerraform, false)(this._notifyUsers),
            set_for_account: cdktf.booleanToTerraform(this._setForAccount),
            start_timestamp: cdktf.stringToTerraform(this._startTimestamp),
            suspend_immediate_trigger: cdktf.numberToTerraform(this._suspendImmediateTrigger),
            suspend_immediate_triggers: cdktf.listMapper(cdktf.numberToTerraform, false)(this._suspendImmediateTriggers),
            suspend_trigger: cdktf.numberToTerraform(this._suspendTrigger),
            suspend_triggers: cdktf.listMapper(cdktf.numberToTerraform, false)(this._suspendTriggers),
            warehouses: cdktf.listMapper(cdktf.stringToTerraform, false)(this._warehouses),
        };
    }
}
exports.ResourceMonitor = ResourceMonitor;
_a = JSII_RTTI_SYMBOL_1;
ResourceMonitor[_a] = { fqn: "@cdktf/provider-snowflake.resourceMonitor.ResourceMonitor", version: "8.0.1" };
// =================
// STATIC PROPERTIES
// =================
ResourceMonitor.tfResourceType = "snowflake_resource_monitor";
//# sourceMappingURL=data:application/json;base64,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