"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/saml_integration snowflake_saml_integration}
*/
class SamlIntegration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/saml_integration snowflake_saml_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlIntegrationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_saml_integration',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.68.2',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._enabled = config.enabled;
        this._id = config.id;
        this._name = config.name;
        this._saml2EnableSpInitiated = config.saml2EnableSpInitiated;
        this._saml2ForceAuthn = config.saml2ForceAuthn;
        this._saml2Issuer = config.saml2Issuer;
        this._saml2PostLogoutRedirectUrl = config.saml2PostLogoutRedirectUrl;
        this._saml2Provider = config.saml2Provider;
        this._saml2RequestedNameidFormat = config.saml2RequestedNameidFormat;
        this._saml2SignRequest = config.saml2SignRequest;
        this._saml2SnowflakeAcsUrl = config.saml2SnowflakeAcsUrl;
        this._saml2SnowflakeIssuerUrl = config.saml2SnowflakeIssuerUrl;
        this._saml2SnowflakeX509Cert = config.saml2SnowflakeX509Cert;
        this._saml2SpInitiatedLoginPageLabel = config.saml2SpInitiatedLoginPageLabel;
        this._saml2SsoUrl = config.saml2SsoUrl;
        this._saml2X509Cert = config.saml2X509Cert;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // created_on - computed: true, optional: false, required: false
    get createdOn() {
        return this.getStringAttribute('created_on');
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // saml2_digest_methods_used - computed: true, optional: false, required: false
    get saml2DigestMethodsUsed() {
        return this.getStringAttribute('saml2_digest_methods_used');
    }
    get saml2EnableSpInitiated() {
        return this.getBooleanAttribute('saml2_enable_sp_initiated');
    }
    set saml2EnableSpInitiated(value) {
        this._saml2EnableSpInitiated = value;
    }
    resetSaml2EnableSpInitiated() {
        this._saml2EnableSpInitiated = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2EnableSpInitiatedInput() {
        return this._saml2EnableSpInitiated;
    }
    get saml2ForceAuthn() {
        return this.getBooleanAttribute('saml2_force_authn');
    }
    set saml2ForceAuthn(value) {
        this._saml2ForceAuthn = value;
    }
    resetSaml2ForceAuthn() {
        this._saml2ForceAuthn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ForceAuthnInput() {
        return this._saml2ForceAuthn;
    }
    get saml2Issuer() {
        return this.getStringAttribute('saml2_issuer');
    }
    set saml2Issuer(value) {
        this._saml2Issuer = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2IssuerInput() {
        return this._saml2Issuer;
    }
    get saml2PostLogoutRedirectUrl() {
        return this.getStringAttribute('saml2_post_logout_redirect_url');
    }
    set saml2PostLogoutRedirectUrl(value) {
        this._saml2PostLogoutRedirectUrl = value;
    }
    resetSaml2PostLogoutRedirectUrl() {
        this._saml2PostLogoutRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2PostLogoutRedirectUrlInput() {
        return this._saml2PostLogoutRedirectUrl;
    }
    get saml2Provider() {
        return this.getStringAttribute('saml2_provider');
    }
    set saml2Provider(value) {
        this._saml2Provider = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ProviderInput() {
        return this._saml2Provider;
    }
    get saml2RequestedNameidFormat() {
        return this.getStringAttribute('saml2_requested_nameid_format');
    }
    set saml2RequestedNameidFormat(value) {
        this._saml2RequestedNameidFormat = value;
    }
    resetSaml2RequestedNameidFormat() {
        this._saml2RequestedNameidFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2RequestedNameidFormatInput() {
        return this._saml2RequestedNameidFormat;
    }
    get saml2SignRequest() {
        return this.getBooleanAttribute('saml2_sign_request');
    }
    set saml2SignRequest(value) {
        this._saml2SignRequest = value;
    }
    resetSaml2SignRequest() {
        this._saml2SignRequest = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SignRequestInput() {
        return this._saml2SignRequest;
    }
    // saml2_signature_methods_used - computed: true, optional: false, required: false
    get saml2SignatureMethodsUsed() {
        return this.getStringAttribute('saml2_signature_methods_used');
    }
    get saml2SnowflakeAcsUrl() {
        return this.getStringAttribute('saml2_snowflake_acs_url');
    }
    set saml2SnowflakeAcsUrl(value) {
        this._saml2SnowflakeAcsUrl = value;
    }
    resetSaml2SnowflakeAcsUrl() {
        this._saml2SnowflakeAcsUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeAcsUrlInput() {
        return this._saml2SnowflakeAcsUrl;
    }
    get saml2SnowflakeIssuerUrl() {
        return this.getStringAttribute('saml2_snowflake_issuer_url');
    }
    set saml2SnowflakeIssuerUrl(value) {
        this._saml2SnowflakeIssuerUrl = value;
    }
    resetSaml2SnowflakeIssuerUrl() {
        this._saml2SnowflakeIssuerUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeIssuerUrlInput() {
        return this._saml2SnowflakeIssuerUrl;
    }
    // saml2_snowflake_metadata - computed: true, optional: false, required: false
    get saml2SnowflakeMetadata() {
        return this.getStringAttribute('saml2_snowflake_metadata');
    }
    get saml2SnowflakeX509Cert() {
        return this.getStringAttribute('saml2_snowflake_x509_cert');
    }
    set saml2SnowflakeX509Cert(value) {
        this._saml2SnowflakeX509Cert = value;
    }
    resetSaml2SnowflakeX509Cert() {
        this._saml2SnowflakeX509Cert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeX509CertInput() {
        return this._saml2SnowflakeX509Cert;
    }
    get saml2SpInitiatedLoginPageLabel() {
        return this.getStringAttribute('saml2_sp_initiated_login_page_label');
    }
    set saml2SpInitiatedLoginPageLabel(value) {
        this._saml2SpInitiatedLoginPageLabel = value;
    }
    resetSaml2SpInitiatedLoginPageLabel() {
        this._saml2SpInitiatedLoginPageLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SpInitiatedLoginPageLabelInput() {
        return this._saml2SpInitiatedLoginPageLabel;
    }
    get saml2SsoUrl() {
        return this.getStringAttribute('saml2_sso_url');
    }
    set saml2SsoUrl(value) {
        this._saml2SsoUrl = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SsoUrlInput() {
        return this._saml2SsoUrl;
    }
    get saml2X509Cert() {
        return this.getStringAttribute('saml2_x509_cert');
    }
    set saml2X509Cert(value) {
        this._saml2X509Cert = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2X509CertInput() {
        return this._saml2X509Cert;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enabled: cdktf.booleanToTerraform(this._enabled),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            saml2_enable_sp_initiated: cdktf.booleanToTerraform(this._saml2EnableSpInitiated),
            saml2_force_authn: cdktf.booleanToTerraform(this._saml2ForceAuthn),
            saml2_issuer: cdktf.stringToTerraform(this._saml2Issuer),
            saml2_post_logout_redirect_url: cdktf.stringToTerraform(this._saml2PostLogoutRedirectUrl),
            saml2_provider: cdktf.stringToTerraform(this._saml2Provider),
            saml2_requested_nameid_format: cdktf.stringToTerraform(this._saml2RequestedNameidFormat),
            saml2_sign_request: cdktf.booleanToTerraform(this._saml2SignRequest),
            saml2_snowflake_acs_url: cdktf.stringToTerraform(this._saml2SnowflakeAcsUrl),
            saml2_snowflake_issuer_url: cdktf.stringToTerraform(this._saml2SnowflakeIssuerUrl),
            saml2_snowflake_x509_cert: cdktf.stringToTerraform(this._saml2SnowflakeX509Cert),
            saml2_sp_initiated_login_page_label: cdktf.stringToTerraform(this._saml2SpInitiatedLoginPageLabel),
            saml2_sso_url: cdktf.stringToTerraform(this._saml2SsoUrl),
            saml2_x509_cert: cdktf.stringToTerraform(this._saml2X509Cert),
        };
    }
}
exports.SamlIntegration = SamlIntegration;
_a = JSII_RTTI_SYMBOL_1;
SamlIntegration[_a] = { fqn: "@cdktf/provider-snowflake.samlIntegration.SamlIntegration", version: "8.0.1" };
// =================
// STATIC PROPERTIES
// =================
SamlIntegration.tfResourceType = "snowflake_saml_integration";
//# sourceMappingURL=data:application/json;base64,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