"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamGrant = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/stream_grant snowflake_stream_grant}
*/
class StreamGrant extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/stream_grant snowflake_stream_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamGrantConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_stream_grant',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.68.2',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._databaseName = config.databaseName;
        this._enableMultipleGrants = config.enableMultipleGrants;
        this._id = config.id;
        this._onAll = config.onAll;
        this._onFuture = config.onFuture;
        this._privilege = config.privilege;
        this._revertOwnershipToRoleName = config.revertOwnershipToRoleName;
        this._roles = config.roles;
        this._schemaName = config.schemaName;
        this._streamName = config.streamName;
        this._withGrantOption = config.withGrantOption;
    }
    get databaseName() {
        return this.getStringAttribute('database_name');
    }
    set databaseName(value) {
        this._databaseName = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseNameInput() {
        return this._databaseName;
    }
    get enableMultipleGrants() {
        return this.getBooleanAttribute('enable_multiple_grants');
    }
    set enableMultipleGrants(value) {
        this._enableMultipleGrants = value;
    }
    resetEnableMultipleGrants() {
        this._enableMultipleGrants = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableMultipleGrantsInput() {
        return this._enableMultipleGrants;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get onAll() {
        return this.getBooleanAttribute('on_all');
    }
    set onAll(value) {
        this._onAll = value;
    }
    resetOnAll() {
        this._onAll = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onAllInput() {
        return this._onAll;
    }
    get onFuture() {
        return this.getBooleanAttribute('on_future');
    }
    set onFuture(value) {
        this._onFuture = value;
    }
    resetOnFuture() {
        this._onFuture = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onFutureInput() {
        return this._onFuture;
    }
    get privilege() {
        return this.getStringAttribute('privilege');
    }
    set privilege(value) {
        this._privilege = value;
    }
    resetPrivilege() {
        this._privilege = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privilegeInput() {
        return this._privilege;
    }
    get revertOwnershipToRoleName() {
        return this.getStringAttribute('revert_ownership_to_role_name');
    }
    set revertOwnershipToRoleName(value) {
        this._revertOwnershipToRoleName = value;
    }
    resetRevertOwnershipToRoleName() {
        this._revertOwnershipToRoleName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get revertOwnershipToRoleNameInput() {
        return this._revertOwnershipToRoleName;
    }
    get roles() {
        return cdktf.Fn.tolist(this.getListAttribute('roles'));
    }
    set roles(value) {
        this._roles = value;
    }
    // Temporarily expose input value. Use with caution.
    get rolesInput() {
        return this._roles;
    }
    get schemaName() {
        return this.getStringAttribute('schema_name');
    }
    set schemaName(value) {
        this._schemaName = value;
    }
    resetSchemaName() {
        this._schemaName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schemaNameInput() {
        return this._schemaName;
    }
    get streamName() {
        return this.getStringAttribute('stream_name');
    }
    set streamName(value) {
        this._streamName = value;
    }
    resetStreamName() {
        this._streamName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get streamNameInput() {
        return this._streamName;
    }
    get withGrantOption() {
        return this.getBooleanAttribute('with_grant_option');
    }
    set withGrantOption(value) {
        this._withGrantOption = value;
    }
    resetWithGrantOption() {
        this._withGrantOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get withGrantOptionInput() {
        return this._withGrantOption;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            database_name: cdktf.stringToTerraform(this._databaseName),
            enable_multiple_grants: cdktf.booleanToTerraform(this._enableMultipleGrants),
            id: cdktf.stringToTerraform(this._id),
            on_all: cdktf.booleanToTerraform(this._onAll),
            on_future: cdktf.booleanToTerraform(this._onFuture),
            privilege: cdktf.stringToTerraform(this._privilege),
            revert_ownership_to_role_name: cdktf.stringToTerraform(this._revertOwnershipToRoleName),
            roles: cdktf.listMapper(cdktf.stringToTerraform, false)(this._roles),
            schema_name: cdktf.stringToTerraform(this._schemaName),
            stream_name: cdktf.stringToTerraform(this._streamName),
            with_grant_option: cdktf.booleanToTerraform(this._withGrantOption),
        };
    }
}
exports.StreamGrant = StreamGrant;
_a = JSII_RTTI_SYMBOL_1;
StreamGrant[_a] = { fqn: "@cdktf/provider-snowflake.streamGrant.StreamGrant", version: "8.0.1" };
// =================
// STATIC PROPERTIES
// =================
StreamGrant.tfResourceType = "snowflake_stream_grant";
//# sourceMappingURL=data:application/json;base64,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