"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WarehouseGrant = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/warehouse_grant snowflake_warehouse_grant}
*/
class WarehouseGrant extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.68.2/docs/resources/warehouse_grant snowflake_warehouse_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WarehouseGrantConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_warehouse_grant',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.68.2',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._enableMultipleGrants = config.enableMultipleGrants;
        this._id = config.id;
        this._privilege = config.privilege;
        this._revertOwnershipToRoleName = config.revertOwnershipToRoleName;
        this._roles = config.roles;
        this._warehouseName = config.warehouseName;
        this._withGrantOption = config.withGrantOption;
    }
    get enableMultipleGrants() {
        return this.getBooleanAttribute('enable_multiple_grants');
    }
    set enableMultipleGrants(value) {
        this._enableMultipleGrants = value;
    }
    resetEnableMultipleGrants() {
        this._enableMultipleGrants = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableMultipleGrantsInput() {
        return this._enableMultipleGrants;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get privilege() {
        return this.getStringAttribute('privilege');
    }
    set privilege(value) {
        this._privilege = value;
    }
    resetPrivilege() {
        this._privilege = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privilegeInput() {
        return this._privilege;
    }
    get revertOwnershipToRoleName() {
        return this.getStringAttribute('revert_ownership_to_role_name');
    }
    set revertOwnershipToRoleName(value) {
        this._revertOwnershipToRoleName = value;
    }
    resetRevertOwnershipToRoleName() {
        this._revertOwnershipToRoleName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get revertOwnershipToRoleNameInput() {
        return this._revertOwnershipToRoleName;
    }
    get roles() {
        return cdktf.Fn.tolist(this.getListAttribute('roles'));
    }
    set roles(value) {
        this._roles = value;
    }
    resetRoles() {
        this._roles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rolesInput() {
        return this._roles;
    }
    get warehouseName() {
        return this.getStringAttribute('warehouse_name');
    }
    set warehouseName(value) {
        this._warehouseName = value;
    }
    // Temporarily expose input value. Use with caution.
    get warehouseNameInput() {
        return this._warehouseName;
    }
    get withGrantOption() {
        return this.getBooleanAttribute('with_grant_option');
    }
    set withGrantOption(value) {
        this._withGrantOption = value;
    }
    resetWithGrantOption() {
        this._withGrantOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get withGrantOptionInput() {
        return this._withGrantOption;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enable_multiple_grants: cdktf.booleanToTerraform(this._enableMultipleGrants),
            id: cdktf.stringToTerraform(this._id),
            privilege: cdktf.stringToTerraform(this._privilege),
            revert_ownership_to_role_name: cdktf.stringToTerraform(this._revertOwnershipToRoleName),
            roles: cdktf.listMapper(cdktf.stringToTerraform, false)(this._roles),
            warehouse_name: cdktf.stringToTerraform(this._warehouseName),
            with_grant_option: cdktf.booleanToTerraform(this._withGrantOption),
        };
    }
}
exports.WarehouseGrant = WarehouseGrant;
_a = JSII_RTTI_SYMBOL_1;
WarehouseGrant[_a] = { fqn: "@cdktf/provider-snowflake.warehouseGrant.WarehouseGrant", version: "8.0.1" };
// =================
// STATIC PROPERTIES
// =================
WarehouseGrant.tfResourceType = "snowflake_warehouse_grant";
//# sourceMappingURL=data:application/json;base64,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