# Generated by Django 2.1.5 on 2019-02-08 21:29

from django.db import migrations


def migrate_inquiries_forward(apps, schema_editor):
    ContentType = apps.get_model("contenttypes", "ContentType")
    USCreditApp = apps.get_model("wellsfargo", "USCreditApp")
    USJointCreditApp = apps.get_model("wellsfargo", "USJointCreditApp")
    CACreditApp = apps.get_model("wellsfargo", "CACreditApp")
    CAJointCreditApp = apps.get_model("wellsfargo", "CAJointCreditApp")
    for CreditApp in (USCreditApp, USJointCreditApp, CACreditApp, CAJointCreditApp):
        for credit_app in CreditApp.objects.all():
            for inquiry in credit_app.inquiries.all():
                content_type = ContentType.objects.get_for_model(CreditApp)
                inquiry.credit_app_type = content_type
                inquiry.credit_app_id = credit_app.pk
                inquiry.credit_app_source = credit_app
                inquiry.save()


def migrate_inquiries_reverse(apps, schema_editor):
    AccountInquiryResult = apps.get_model("wellsfargo", "AccountInquiryResult")
    for inquiry in AccountInquiryResult.objects.all():
        credit_app = inquiry.credit_app_source
        credit_app.inquiries.add(inquiry)


class Migration(migrations.Migration):

    dependencies = [
        ("wellsfargo", "0025_auto_20190208_1431"),
    ]

    operations = [
        migrations.RunPython(migrate_inquiries_forward, migrate_inquiries_reverse),
    ]
