# Generated by Django 2.2.11 on 2020-03-26 18:12
from django.db import migrations
from django.db.models.functions import Concat, Substr
from django.db.models import F, Value, CharField


def trunc(NewCls, field_name, value):
    if type(value) is str:
        max_length = NewCls._meta.get_field(field_name).max_length
        return value[:max_length]
    return value


def migrate_credit_app_data(apps, schema_editor):
    ContentType = apps.get_model("contenttypes", "ContentType")
    AccountInquiryResult = apps.get_model("wellsfargo", "AccountInquiryResult")

    # Old Cedit Apps
    USCreditApp = apps.get_model("wellsfargo", "USCreditApp")
    USJointCreditApp = apps.get_model("wellsfargo", "USJointCreditApp")

    uscreditapp_type = ContentType.objects.get_for_model(USCreditApp)
    usjointcreditapp_type = ContentType.objects.get_for_model(USJointCreditApp)

    # New unified Credit App model
    CreditApplicationAddress = apps.get_model("wellsfargo", "CreditApplicationAddress")
    CreditApplicationApplicant = apps.get_model(
        "wellsfargo", "CreditApplicationApplicant"
    )
    CreditApplication = apps.get_model("wellsfargo", "CreditApplication")

    # Migrate USCreditApp
    for old_app in USCreditApp.objects.select_related(
        "credentials", "user", "submitting_user"
    ).all():
        main_applicant_addr = CreditApplicationAddress.objects.create(
            address_line_1=trunc(
                CreditApplicationAddress, "address_line_1", old_app.main_address_line1
            ),
            address_line_2=trunc(
                CreditApplicationAddress, "address_line_2", old_app.main_address_line2
            ),
            city=trunc(CreditApplicationAddress, "city", old_app.main_address_city),
            state_code=trunc(
                CreditApplicationAddress, "state_code", old_app.main_address_state
            ),
            postal_code=trunc(
                CreditApplicationAddress, "postal_code", old_app.main_address_postcode
            ),
        )
        main_applicant = CreditApplicationApplicant.objects.create(
            first_name=trunc(
                CreditApplicationApplicant, "first_name", old_app.main_first_name
            ),
            last_name=trunc(
                CreditApplicationApplicant, "last_name", old_app.main_last_name
            ),
            middle_initial=trunc(
                CreditApplicationApplicant,
                "middle_initial",
                old_app.main_middle_initial,
            ),
            date_of_birth=trunc(
                CreditApplicationApplicant, "date_of_birth", old_app.main_date_of_birth
            ),
            ssn=trunc(CreditApplicationApplicant, "ssn", old_app.main_ssn),
            annual_income=trunc(
                CreditApplicationApplicant, "annual_income", old_app.main_annual_income
            ),
            email_address=trunc(
                CreditApplicationApplicant, "email_address", old_app.email
            ),
            home_phone=trunc(
                CreditApplicationApplicant, "home_phone", old_app.main_home_phone
            ),
            mobile_phone=trunc(
                CreditApplicationApplicant, "mobile_phone", old_app.main_cell_phone
            ),
            work_phone=trunc(
                CreditApplicationApplicant, "work_phone", old_app.main_employer_phone
            ),
            employer_name=trunc(
                CreditApplicationApplicant, "employer_name", old_app.main_employer_name
            ),
            housing_status=trunc(
                CreditApplicationApplicant,
                "housing_status",
                old_app.main_housing_status,
            ),
            address=trunc(CreditApplicationApplicant, "address", main_applicant_addr),
        )
        new_app = CreditApplication.objects.create(
            requested_credit_limit=trunc(
                CreditApplication, "requested_credit_limit", old_app.purchase_price
            ),
            language_preference=trunc(
                CreditApplication, "language_preference", old_app.language
            ),
            salesperson=trunc(
                CreditApplication, "salesperson", old_app.new_sales_person
            ),
            main_applicant=trunc(CreditApplication, "main_applicant", main_applicant),
            joint_applicant=trunc(CreditApplication, "joint_applicant", None),
            status=trunc(CreditApplication, "status", old_app.status),
            credentials=trunc(CreditApplication, "credentials", old_app.credentials),
            application_source=trunc(
                CreditApplication, "application_source", old_app.application_source
            ),
            user=trunc(CreditApplication, "user", old_app.user),
            ip_address=trunc(CreditApplication, "ip_address", old_app.ip_address),
            submitting_user=trunc(
                CreditApplication, "submitting_user", old_app.submitting_user
            ),
            encrypted_account_number=trunc(
                CreditApplication, "encrypted_account_number", None
            ),
            last4_account_number=trunc(
                CreditApplication, "last4_account_number", old_app.last4_account_number
            ),
            created_datetime=trunc(
                CreditApplication, "created_datetime", old_app.created_datetime
            ),
            modified_datetime=trunc(
                CreditApplication, "modified_datetime", old_app.modified_datetime
            ),
        )
        AccountInquiryResult.objects.filter(
            credit_app_type__pk=uscreditapp_type.id, credit_app_id=old_app.pk
        ).update(new_credit_app=new_app)

    # Migrate USJointCreditApp
    for old_app in USJointCreditApp.objects.select_related(
        "credentials", "user", "submitting_user"
    ).all():
        main_applicant_addr = CreditApplicationAddress.objects.create(
            address_line_1=trunc(
                CreditApplicationAddress, "address_line_1", old_app.main_address_line1
            ),
            address_line_2=trunc(
                CreditApplicationAddress, "address_line_2", old_app.main_address_line2
            ),
            city=trunc(CreditApplicationAddress, "city", old_app.main_address_city),
            state_code=trunc(
                CreditApplicationAddress, "state_code", old_app.main_address_state
            ),
            postal_code=trunc(
                CreditApplicationAddress, "postal_code", old_app.main_address_postcode
            ),
        )
        main_applicant = CreditApplicationApplicant.objects.create(
            first_name=trunc(
                CreditApplicationApplicant, "first_name", old_app.main_first_name
            ),
            last_name=trunc(
                CreditApplicationApplicant, "last_name", old_app.main_last_name
            ),
            middle_initial=trunc(
                CreditApplicationApplicant,
                "middle_initial",
                old_app.main_middle_initial,
            ),
            date_of_birth=trunc(
                CreditApplicationApplicant, "date_of_birth", old_app.main_date_of_birth
            ),
            ssn=trunc(CreditApplicationApplicant, "ssn", old_app.main_ssn),
            annual_income=trunc(
                CreditApplicationApplicant, "annual_income", old_app.main_annual_income
            ),
            email_address=trunc(
                CreditApplicationApplicant, "email_address", old_app.email
            ),
            home_phone=trunc(
                CreditApplicationApplicant, "home_phone", old_app.main_home_phone
            ),
            mobile_phone=trunc(
                CreditApplicationApplicant, "mobile_phone", old_app.main_cell_phone
            ),
            work_phone=trunc(
                CreditApplicationApplicant, "work_phone", old_app.main_employer_phone
            ),
            employer_name=trunc(
                CreditApplicationApplicant, "employer_name", old_app.main_employer_name
            ),
            housing_status=trunc(
                CreditApplicationApplicant,
                "housing_status",
                old_app.main_housing_status,
            ),
            address=trunc(CreditApplicationApplicant, "address", main_applicant_addr),
        )
        joint_applicant_addr = CreditApplicationAddress.objects.create(
            address_line_1=trunc(
                CreditApplicationAddress, "address_line_1", old_app.joint_address_line1
            ),
            address_line_2=trunc(
                CreditApplicationAddress, "address_line_2", old_app.joint_address_line2
            ),
            city=trunc(CreditApplicationAddress, "city", old_app.joint_address_city),
            state_code=trunc(
                CreditApplicationAddress, "state_code", old_app.joint_address_state
            ),
            postal_code=trunc(
                CreditApplicationAddress, "postal_code", old_app.joint_address_postcode
            ),
        )
        joint_applicant = CreditApplicationApplicant.objects.create(
            first_name=trunc(
                CreditApplicationApplicant, "first_name", old_app.joint_first_name
            ),
            last_name=trunc(
                CreditApplicationApplicant, "last_name", old_app.joint_last_name
            ),
            middle_initial=trunc(
                CreditApplicationApplicant,
                "middle_initial",
                old_app.joint_middle_initial,
            ),
            date_of_birth=trunc(
                CreditApplicationApplicant, "date_of_birth", old_app.joint_date_of_birth
            ),
            ssn=trunc(CreditApplicationApplicant, "ssn", old_app.joint_ssn),
            annual_income=trunc(
                CreditApplicationApplicant, "annual_income", old_app.joint_annual_income
            ),
            email_address=trunc(CreditApplicationApplicant, "email_address", None),
            home_phone="",
            mobile_phone=trunc(
                CreditApplicationApplicant, "mobile_phone", old_app.joint_cell_phone
            ),
            work_phone=trunc(
                CreditApplicationApplicant, "work_phone", old_app.joint_employer_phone
            ),
            employer_name=trunc(
                CreditApplicationApplicant, "employer_name", old_app.joint_employer_name
            ),
            housing_status=trunc(CreditApplicationApplicant, "housing_status", None),
            address=trunc(CreditApplicationApplicant, "address", joint_applicant_addr),
        )
        new_app = CreditApplication.objects.create(
            requested_credit_limit=trunc(
                CreditApplication, "requested_credit_limit", old_app.purchase_price
            ),
            language_preference=trunc(
                CreditApplication, "language_preference", old_app.language
            ),
            salesperson=trunc(
                CreditApplication, "salesperson", old_app.new_sales_person
            ),
            main_applicant=trunc(CreditApplication, "main_applicant", main_applicant),
            joint_applicant=trunc(
                CreditApplication, "joint_applicant", joint_applicant
            ),
            status=trunc(CreditApplication, "status", old_app.status),
            credentials=trunc(CreditApplication, "credentials", old_app.credentials),
            application_source=trunc(
                CreditApplication, "application_source", old_app.application_source
            ),
            user=trunc(CreditApplication, "user", old_app.user),
            ip_address=trunc(CreditApplication, "ip_address", old_app.ip_address),
            submitting_user=trunc(
                CreditApplication, "submitting_user", old_app.submitting_user
            ),
            encrypted_account_number=trunc(
                CreditApplication, "encrypted_account_number", None
            ),
            last4_account_number=trunc(
                CreditApplication, "last4_account_number", old_app.last4_account_number
            ),
            created_datetime=trunc(
                CreditApplication, "created_datetime", old_app.created_datetime
            ),
            modified_datetime=trunc(
                CreditApplication, "modified_datetime", old_app.modified_datetime
            ),
        )
        AccountInquiryResult.objects.filter(
            credit_app_type__pk=usjointcreditapp_type.id, credit_app_id=old_app.pk
        ).update(new_credit_app=new_app)


def migrate_account_inquiries(apps, schema_editor):
    AccountInquiryResult = apps.get_model("wellsfargo", "AccountInquiryResult")
    AccountInquiryResult.objects.all().update(
        main_applicant_full_name=Substr(
            Concat(
                F("last_name"), Value(", "), F("first_name"), output_field=CharField()
            ),
            1,
            50,
        ),
    )


class Migration(migrations.Migration):

    dependencies = [
        ("wellsfargo", "0034_auto_20200326_1411"),
    ]

    operations = [
        migrations.RunPython(migrate_account_inquiries),
        migrations.RunPython(migrate_credit_app_data),
    ]
