# Generated by Django 2.2.12 on 2020-04-02 15:08
from django.db.models import Subquery, OuterRef
from django.db import migrations, models
import oscar.models.fields


def update_merchant_fields(apps, schema_editor):
    APICredentials = apps.get_model("wellsfargo", "APICredentials")

    CreditApplication = apps.get_model("wellsfargo", "CreditApplication")
    TransferMetadata = apps.get_model("wellsfargo", "TransferMetadata")
    PreQualificationRequest = apps.get_model("wellsfargo", "PreQualificationRequest")

    for Model in [CreditApplication, TransferMetadata, PreQualificationRequest]:
        Model.objects.filter(credentials__isnull=False).all().update(
            merchant_name=Subquery(
                APICredentials.objects.filter(id=OuterRef("credentials")).values(
                    "name"
                )[:1]
            ),
            merchant_num=Subquery(
                APICredentials.objects.filter(id=OuterRef("credentials")).values(
                    "merchant_num"
                )[:1]
            ),
        )


class Migration(migrations.Migration):

    dependencies = [
        ("wellsfargo", "0036_auto_20200326_1430"),
    ]

    operations = [
        migrations.AddField(
            model_name="creditapplication",
            name="merchant_name",
            field=oscar.models.fields.NullCharField(
                max_length=200, verbose_name="Merchant Name"
            ),
        ),
        migrations.AddField(
            model_name="creditapplication",
            name="merchant_num",
            field=oscar.models.fields.NullCharField(
                max_length=200, verbose_name="Merchant Number"
            ),
        ),
        migrations.AddField(
            model_name="transfermetadata",
            name="merchant_name",
            field=oscar.models.fields.NullCharField(
                max_length=200, verbose_name="Merchant Name"
            ),
        ),
        migrations.AddField(
            model_name="transfermetadata",
            name="merchant_num",
            field=oscar.models.fields.NullCharField(
                max_length=200, verbose_name="Merchant Number"
            ),
        ),
        migrations.RunPython(update_merchant_fields),
        migrations.RemoveField(
            model_name="creditapplication",
            name="credentials",
        ),
        migrations.RemoveField(
            model_name="prequalificationrequest",
            name="credentials",
        ),
        migrations.RemoveField(
            model_name="transfermetadata",
            name="credentials",
        ),
        migrations.RenameModel(
            old_name="APICredentials",
            new_name="APIMerchantNum",
        ),
        migrations.RemoveField(
            model_name="apimerchantnum",
            name="username",
        ),
        migrations.RemoveField(
            model_name="apimerchantnum",
            name="password",
        ),
        migrations.AlterModelOptions(
            name="apimerchantnum",
            options={
                "ordering": ("-priority", "-id"),
                "verbose_name": "API Merchant Number",
                "verbose_name_plural": "API Merchant Numbers",
            },
        ),
        migrations.AlterField(
            model_name="apimerchantnum",
            name="merchant_num",
            field=models.CharField(max_length=200, verbose_name="Merchant Number"),
        ),
        migrations.AlterField(
            model_name="sdkmerchantnum",
            name="merchant_num",
            field=models.CharField(max_length=200, verbose_name="Merchant Number"),
        ),
        migrations.AlterField(
            model_name="sdkmerchantnum",
            name="name",
            field=models.CharField(
                default="Default", max_length=200, verbose_name="Merchant Name"
            ),
        ),
    ]
