/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_MATHAPPROXIMATIONPASS
#define GEN_PASS_DECL_MATHLEGALIZATIONPASS
#define GEN_PASS_DECL_MATHOPTIMIZATIONPASS
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// MathApproximationPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_MATHAPPROXIMATIONPASS
struct MathApproximationPassOptions {
  ::llvm::ArrayRef<std::string> oplist;
};
#undef GEN_PASS_DECL_MATHAPPROXIMATIONPASS
#endif // GEN_PASS_DECL_MATHAPPROXIMATIONPASS
#ifdef GEN_PASS_DEF_MATHAPPROXIMATIONPASS
namespace impl {

template <typename DerivedT>
class MathApproximationPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = MathApproximationPassBase;

  MathApproximationPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  MathApproximationPassBase(const MathApproximationPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("xla-math-approximation");
  }
  ::llvm::StringRef getArgument() const override { return "xla-math-approximation"; }

  ::llvm::StringRef getDescription() const override { return "Approximate math operations for accuracy and speed."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MathApproximationPass");
  }
  ::llvm::StringRef getName() const override { return "MathApproximationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MathApproximationPassBase<DerivedT>)

  MathApproximationPassBase(const MathApproximationPassOptions &options) : MathApproximationPassBase() {
    oplist = options.oplist;
  }
protected:
  ::mlir::Pass::ListOption<std::string> oplist{*this, "oplist", ::llvm::cl::desc("List of math operations to be approximated. Use 'all' to select all supported math operations.")};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_MATHAPPROXIMATIONPASS
#endif // GEN_PASS_DEF_MATHAPPROXIMATIONPASS

//===----------------------------------------------------------------------===//
// MathLegalizationPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_MATHLEGALIZATIONPASS
struct MathLegalizationPassOptions {
  bool enable_approximations_ = true;
};
#undef GEN_PASS_DECL_MATHLEGALIZATIONPASS
#endif // GEN_PASS_DECL_MATHLEGALIZATIONPASS
#ifdef GEN_PASS_DEF_MATHLEGALIZATIONPASS
namespace impl {

template <typename DerivedT>
class MathLegalizationPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = MathLegalizationPassBase;

  MathLegalizationPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  MathLegalizationPassBase(const MathLegalizationPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("xla-math-legalization");
  }
  ::llvm::StringRef getArgument() const override { return "xla-math-legalization"; }

  ::llvm::StringRef getDescription() const override { return "Legalize operations from the `math` dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MathLegalizationPass");
  }
  ::llvm::StringRef getName() const override { return "MathLegalizationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mlir::arith::ArithDialect>();

  registry.insert<mlir::func::FuncDialect>();

  registry.insert<mlir::vector::VectorDialect>();

  registry.insert<LLVM::LLVMDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MathLegalizationPassBase<DerivedT>)

  MathLegalizationPassBase(const MathLegalizationPassOptions &options) : MathLegalizationPassBase() {
    enable_approximations_ = options.enable_approximations_;
  }
protected:
  ::mlir::Pass::Option<bool> enable_approximations_{*this, "enable-approximations", ::llvm::cl::desc("Enable math approximations."), ::llvm::cl::init(true)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_MATHLEGALIZATIONPASS
#endif // GEN_PASS_DEF_MATHLEGALIZATIONPASS

//===----------------------------------------------------------------------===//
// MathOptimizationPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_MATHOPTIMIZATIONPASS
struct MathOptimizationPassOptions {
  bool enable_avx2_ = false;
};
#undef GEN_PASS_DECL_MATHOPTIMIZATIONPASS
#endif // GEN_PASS_DECL_MATHOPTIMIZATIONPASS
#ifdef GEN_PASS_DEF_MATHOPTIMIZATIONPASS
namespace impl {

template <typename DerivedT>
class MathOptimizationPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = MathOptimizationPassBase;

  MathOptimizationPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  MathOptimizationPassBase(const MathOptimizationPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("xla-math-optimization");
  }
  ::llvm::StringRef getArgument() const override { return "xla-math-optimization"; }

  ::llvm::StringRef getDescription() const override { return "Optimize operations from the `math` dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MathOptimizationPass");
  }
  ::llvm::StringRef getName() const override { return "MathOptimizationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mlir::vector::VectorDialect>();

  registry.insert<mlir::x86vector::X86VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MathOptimizationPassBase<DerivedT>)

  MathOptimizationPassBase(const MathOptimizationPassOptions &options) : MathOptimizationPassBase() {
    enable_avx2_ = options.enable_avx2_;
  }
protected:
  ::mlir::Pass::Option<bool> enable_avx2_{*this, "enable-avx2", ::llvm::cl::desc("Enable math approximations that emit AVX2 intrinsics."), ::llvm::cl::init(false)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_MATHOPTIMIZATIONPASS
#endif // GEN_PASS_DEF_MATHOPTIMIZATIONPASS
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// MathApproximationPass Registration
//===----------------------------------------------------------------------===//

inline void registerMathApproximationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::xla::CreateMathApproximationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerMathApproximationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::xla::CreateMathApproximationPass();
  });
}

//===----------------------------------------------------------------------===//
// MathLegalizationPass Registration
//===----------------------------------------------------------------------===//

inline void registerMathLegalizationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::xla::CreateMathLegalizationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerMathLegalizationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::xla::CreateMathLegalizationPass();
  });
}

//===----------------------------------------------------------------------===//
// MathOptimizationPass Registration
//===----------------------------------------------------------------------===//

inline void registerMathOptimizationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::xla::CreateMathOptimizationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerMathOptimizationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::xla::CreateMathOptimizationPass();
  });
}

//===----------------------------------------------------------------------===//
// MathTransforms Registration
//===----------------------------------------------------------------------===//

inline void registerMathTransformsPasses() {
  registerMathApproximationPass();
  registerMathLegalizationPass();
  registerMathOptimizationPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class MathApproximationPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = MathApproximationPassBase;

  MathApproximationPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  MathApproximationPassBase(const MathApproximationPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("xla-math-approximation");
  }
  ::llvm::StringRef getArgument() const override { return "xla-math-approximation"; }

  ::llvm::StringRef getDescription() const override { return "Approximate math operations for accuracy and speed."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MathApproximationPass");
  }
  ::llvm::StringRef getName() const override { return "MathApproximationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MathApproximationPassBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<std::string> oplist{*this, "oplist", ::llvm::cl::desc("List of math operations to be approximated. Use 'all' to select all supported math operations.")};
};

template <typename DerivedT>
class MathLegalizationPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = MathLegalizationPassBase;

  MathLegalizationPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  MathLegalizationPassBase(const MathLegalizationPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("xla-math-legalization");
  }
  ::llvm::StringRef getArgument() const override { return "xla-math-legalization"; }

  ::llvm::StringRef getDescription() const override { return "Legalize operations from the `math` dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MathLegalizationPass");
  }
  ::llvm::StringRef getName() const override { return "MathLegalizationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mlir::arith::ArithDialect>();

  registry.insert<mlir::func::FuncDialect>();

  registry.insert<mlir::vector::VectorDialect>();

  registry.insert<LLVM::LLVMDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MathLegalizationPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> enable_approximations_{*this, "enable-approximations", ::llvm::cl::desc("Enable math approximations."), ::llvm::cl::init(true)};
};

template <typename DerivedT>
class MathOptimizationPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = MathOptimizationPassBase;

  MathOptimizationPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  MathOptimizationPassBase(const MathOptimizationPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("xla-math-optimization");
  }
  ::llvm::StringRef getArgument() const override { return "xla-math-optimization"; }

  ::llvm::StringRef getDescription() const override { return "Optimize operations from the `math` dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MathOptimizationPass");
  }
  ::llvm::StringRef getName() const override { return "MathOptimizationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mlir::vector::VectorDialect>();

  registry.insert<mlir::x86vector::X86VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MathOptimizationPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> enable_avx2_{*this, "enable-avx2", ::llvm::cl::desc("Enable math approximations that emit AVX2 intrinsics."), ::llvm::cl::init(false)};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
