/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import junit.framework.TestCase;
import org.mortbay.http.HttpRequest;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public abstract class HTMLRunnerTestBase
extends TestCase
implements HTMLResultsListener {
    SeleniumServer server;
    HTMLLauncher launcher;
    HTMLTestResults results = null;
    protected boolean multiWindow = true;
    protected String suiteName = "TestSuite.html";
    protected String browserURL;
    File output;

    public HTMLRunnerTestBase() {
    }

    public HTMLRunnerTestBase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.output = new File(this.getName() + "-results.html");
        System.out.println("Will print results to " + this.output.getAbsolutePath());
        HttpRequest.__maxFormContentSize = 400000;
    }

    protected void runHTMLSuite(String browser, boolean slowResources) throws Exception {
        this.server = new SeleniumServer(slowResources);
        this.launcher = new HTMLLauncher(this.server);
        this.server.start();
        this.browserURL = "http://localhost:" + this.server.getPort();
        String testURL = this.browserURL + "/selenium-server/tests/" + this.suiteName;
        int timeout = 900;
        String result = this.launcher.runHTMLSuite(browser, this.browserURL, testURL, this.output, timeout, this.multiWindow);
        HTMLRunnerTestBase.assertTrue((String)("Results file doesn't exist: " + this.output.getAbsolutePath()), (boolean)this.output.exists());
        HTMLRunnerTestBase.assertEquals((String)("Tests didn't pass, check HTML output for details: " + this.output.getAbsolutePath()), (String)"PASSED", (String)result);
    }

    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void processResults(HTMLTestResults r) {
        this.results = r;
    }
}

