/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;

public class FirefoxChromeLauncherUnitTest
extends TestCase {
    public void testInvalidBrowserStringCausesChromeLauncherToThrowException() {
        try {
            new FirefoxChromeLauncher(null, null, "invalid");
            FirefoxChromeLauncherUnitTest.fail((String)"No exception thrown");
        }
        catch (InvalidBrowserExecutableException ibee) {
            FirefoxChromeLauncherUnitTest.assertEquals((String)"The specified path to the browser executable is invalid.", (String)ibee.getMessage());
        }
    }

    public void testNullBrowserInstallationDoesntCauseChromeLauncherToThrowException() {
        BrowserInstallation bi = null;
        FirefoxChromeLauncher fcl = new FirefoxChromeLauncher(null, null, bi);
        FirefoxChromeLauncherUnitTest.assertNotNull((Object)fcl);
    }

    public void testShouldAbleToCreateChromeUrlWithNormalUrl() throws Exception {
        String httpUrl = "http://www.my.com/folder/endname.html?a=aaa&b=bbb";
        String chromeUrl = new FirefoxChromeLauncher.ChromeUrlConvert().convert(httpUrl);
        FirefoxChromeLauncherUnitTest.assertEquals((String)"chrome://src/content/endname.html?a=aaa&b=bbb", (String)chromeUrl);
    }

    public void testProfileRemovedWhenProcessNull() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.close();
        FirefoxChromeLauncherUnitTest.assertFalse((boolean)launcher.wasKillFirefoxProcessCalled());
        FirefoxChromeLauncherUnitTest.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public void testProfileRemovedWhenProcessKillFails() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.haveProcessKillThrowException(false);
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.setProcess(new TestProcess());
        launcher.close();
        FirefoxChromeLauncherUnitTest.assertTrue((boolean)launcher.wasKillFirefoxProcessCalled());
        FirefoxChromeLauncherUnitTest.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public void testProfileRemovedWhenProcessNotNull() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.setProcess(new TestProcess());
        launcher.close();
        FirefoxChromeLauncherUnitTest.assertTrue((boolean)launcher.wasKillFirefoxProcessCalled());
        FirefoxChromeLauncherUnitTest.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public void testNothingRemovedIfAlreadyNull() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.close();
        FirefoxChromeLauncherUnitTest.assertFalse((boolean)launcher.wasKillFirefoxProcessCalled());
        FirefoxChromeLauncherUnitTest.assertFalse((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public void testSecondCloseIsNoOp() {
        FirefoxChromeLauncherStubbedForShutdown launcher = new FirefoxChromeLauncherStubbedForShutdown();
        launcher.setCustomProfileDir(new File("testdir"));
        launcher.close();
        FirefoxChromeLauncherUnitTest.assertTrue((boolean)launcher.wasRemoveCustomProfileCalled());
        launcher.reset();
        launcher.close();
        FirefoxChromeLauncherUnitTest.assertFalse((boolean)launcher.wasRemoveCustomProfileCalled());
    }

    public static class TestProcess
    extends Process {
        public void destroy() {
        }

        public int exitValue() {
            return 0;
        }

        public InputStream getErrorStream() {
            return null;
        }

        public InputStream getInputStream() {
            return null;
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public int waitFor() throws InterruptedException {
            return 0;
        }
    }

    public static class FirefoxChromeLauncherStubbedForShutdown
    extends FirefoxChromeLauncher {
        private boolean killFirefoxProcessCalled = false;
        private boolean removeCustomProfileDirCalled = false;
        private boolean throwProcessKillException = true;

        public FirefoxChromeLauncherStubbedForShutdown() {
            super(new RemoteControlConfiguration(), "testsession");
        }

        public void haveProcessKillThrowException(boolean doThrow) {
            this.throwProcessKillException = doThrow;
        }

        public void reset() {
            this.killFirefoxProcessCalled = false;
            this.removeCustomProfileDirCalled = false;
            this.throwProcessKillException = true;
        }

        public boolean wasKillFirefoxProcessCalled() {
            return this.killFirefoxProcessCalled;
        }

        public boolean wasRemoveCustomProfileCalled() {
            return this.removeCustomProfileDirCalled;
        }

        protected void killFirefoxProcess() throws FirefoxChromeLauncher.FileLockRemainedException {
            this.killFirefoxProcessCalled = true;
            if (!this.throwProcessKillException) {
                throw new FirefoxChromeLauncher.FileLockRemainedException((FirefoxChromeLauncher)this, "test exception");
            }
        }

        protected void removeCustomProfileDir() throws RuntimeException {
            this.removeCustomProfileDirCalled = true;
        }
    }
}

