/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;

public class CachedContentTestHandler
implements HttpHandler {
    private static final long serialVersionUID = -4765843647662493876L;
    HttpContext context;
    boolean started;

    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse res) throws HttpException, IOException {
        if (!"/cachedContentTest".equals(pathInContext)) {
            return;
        }
        res.setField("Content-Type", "text/html");
        this.setAlwaysCacheHeaders(res);
        OutputStreamWriter writer = new OutputStreamWriter(res.getOutputStream());
        writer.write("<html><body>");
        writer.write(Long.toString(System.currentTimeMillis()));
        writer.write("</body></html>");
        writer.flush();
        writer.close();
        httpRequest.setHandled(true);
    }

    private void setAlwaysCacheHeaders(HttpResponse res) {
        res.setField("Cache-Control", "max-age=29723626");
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 1);
        res.setField("Expires", HttpFields.formatDate((Calendar)calendar, (boolean)false));
        res.setField("Last-Modified", HttpFields.__01Jan1970);
        res.removeField("Pragma");
        res.setField("ETag", "foo");
    }

    public String getName() {
        return CachedContentTestHandler.class.getName();
    }

    public HttpContext getHttpContext() {
        return this.context;
    }

    public void initialize(HttpContext c) {
        this.context = c;
    }

    public void start() throws Exception {
        this.started = true;
    }

    public void stop() throws InterruptedException {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }
}

