### WEOM Python interface

version: 1.6.151

WEOMPy is a comprehensive Python library designed to control [WEOM cameras](https://workswell.eu/weom-thermal-core-high-performance-thermal-camera/) using the Python language. 

The library can access the following key WEOM thermal core features

* read device information such as serial number, firmware version, etc...
* change display parameters (display palette, contrast, brightness, frame rate, gain, etc..)
* view and capture images
* update thermal core firmware
* manage sensor dead pixels

We provide documentation, howtos and tutorials in a form Jupyter notebooks. The notebooks and example can be found in directory where the library is installed using `pip`. We strongly recommend the use of Python virtual environments to avoid any possible conflicts. To create and activate a clean WEOMPy Python environment run

`python -m venv <venv_directories>/weompy`

`. <venv_directories>/weompy/bin/activate`

now we have a clean Python environment and we can proceed by installing the library

`pip install weompy`

After these steps you can find the documentation and example in

`<venv_directories>/weompy/lib/python<version>/site-packages/weompy/example.py`

`<venv_directories>/weompy/lib/python<version>/site-packages/weompy/user_documentation.ipynb`

Also we provide stubs for IDE code completion in

`<venv_directories>/weompy/lib/python<version>/site-packages/weompy/weompy.pyi`

Prerequisites:

- Python 3.8 - 3.12
- Jupyter extension by Microsoft installed on VSCode, if you want to open user_documentation.ipynb in VSCode
