"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .entity_invoice import EntityInvoice, EntityInvoiceTypedDict
from .list_links import ListLinks, ListLinksTypedDict
from .sorting import Sorting
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListInvoicesRequestTypedDict(TypedDict):
    reference: NotRequired[Nullable[str]]
    r"""Filter for an invoice with a specific invoice reference, for example
    `2024.10000`.
    """
    year: NotRequired[Nullable[str]]
    r"""Filter for invoices of a specific year, for example `2024`."""
    month: NotRequired[Nullable[str]]
    r"""Filter for invoices of a specific month, for example `01`."""
    from_: NotRequired[Nullable[str]]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    sort: NotRequired[Sorting]
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class ListInvoicesRequest(BaseModel):
    reference: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for an invoice with a specific invoice reference, for example
    `2024.10000`.
    """

    year: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for invoices of a specific year, for example `2024`."""

    month: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for invoices of a specific month, for example `01`."""

    from_: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    sort: Annotated[
        Optional[Sorting],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "reference",
            "year",
            "month",
            "from",
            "limit",
            "sort",
            "idempotency-key",
        ]
        nullable_fields = ["reference", "year", "month", "from", "limit"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListInvoicesEmbeddedTypedDict(TypedDict):
    invoices: List[EntityInvoiceTypedDict]
    r"""An array of invoice objects. For a complete reference of
    the invoice object, refer to the [Get invoice endpoint](get-invoice) documentation.
    """


class ListInvoicesEmbedded(BaseModel):
    invoices: List[EntityInvoice]
    r"""An array of invoice objects. For a complete reference of
    the invoice object, refer to the [Get invoice endpoint](get-invoice) documentation.
    """


class ListInvoicesResponseTypedDict(TypedDict):
    r"""A list of invoice objects. For a complete reference of the invoice
    object, refer to the [Get invoice endpoint](get-invoice) documentation.
    """

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: ListInvoicesEmbeddedTypedDict
    links: ListLinksTypedDict
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListInvoicesResponse(BaseModel):
    r"""A list of invoice objects. For a complete reference of the invoice
    object, refer to the [Get invoice endpoint](get-invoice) documentation.
    """

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[ListInvoicesEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListLinks, pydantic.Field(alias="_links")]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
