
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "handshake"

@_ods_cext.register_operation(_Dialect)
class BranchOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.br"

  _ODS_REGIONS = (0, True)

  def __init__(self, dataOperand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(dataOperand)
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def dataOperand(self):
    return self.operation.operands[0]

  @builtins.property
  def dataResult(self):
    return self.operation.results[0]

def br(data_operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return BranchOp(dataOperand=data_operand, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BufferOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.buffer"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, slots, bufferType, *, initValues=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["slots"] = (slots if (
    isinstance(slots, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(slots, context=_ods_context))
    attributes["bufferType"] = (bufferType if (
    isinstance(bufferType, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BufferTypeEnumAttr')) else
      _ods_ir.AttrBuilder.get('BufferTypeEnumAttr')(bufferType, context=_ods_context))
    if initValues is not None: attributes["initValues"] = (initValues if (
        isinstance(initValues, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('I64ArrayAttr')(initValues, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def slots(self):
    return self.operation.attributes["slots"]

  @slots.setter
  def slots(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["slots"] = value

  @builtins.property
  def bufferType(self):
    return self.operation.attributes["bufferType"]

  @bufferType.setter
  def bufferType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["bufferType"] = value

  @builtins.property
  def initValues(self):
    if "initValues" not in self.operation.attributes:
      return None
    return self.operation.attributes["initValues"]

  @initValues.setter
  def initValues(self, value):
    if value is not None:
      self.operation.attributes["initValues"] = value
    elif "initValues" in self.operation.attributes:
      del self.operation.attributes["initValues"]

  @initValues.deleter
  def initValues(self):
    del self.operation.attributes["initValues"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def buffer(operand, slots, buffer_type, *, init_values=None, loc=None, ip=None) -> _ods_ir.Value:
  return BufferOp(operand=operand, slots=slots, bufferType=buffer_type, initValues=init_values, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConditionalBranchOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.cond_br"

  _ODS_REGIONS = (0, True)

  def __init__(self, conditionOperand, dataOperand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(conditionOperand)
    operands.append(dataOperand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def conditionOperand(self):
    return self.operation.operands[0]

  @builtins.property
  def dataOperand(self):
    return self.operation.operands[1]

  @builtins.property
  def trueResult(self):
    return self.operation.results[0]

  @builtins.property
  def falseResult(self):
    return self.operation.results[1]

def cond_br(condition_operand, data_operand, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return ConditionalBranchOp(conditionOperand=condition_operand, dataOperand=data_operand, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class ConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, value, ctrl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(ctrl)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypedAttrInterface')) else
      _ods_ir.AttrBuilder.get('TypedAttrInterface')(value, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def ctrl(self):
    return self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def constant(result, value, ctrl, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstantOp(result=result, value=value, ctrl=ctrl, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ControlMergeOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.control_merge"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, index, dataOperands, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(dataOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    results.append(index)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def dataOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

  @builtins.property
  def index(self):
    return self.operation.results[1]

def control_merge(result, index, data_operands, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return ControlMergeOp(result=result, index=index, dataOperands=data_operands, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class ESIInstanceOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.esi_instance"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, module, instName, clk, rst, opOperands, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(clk)
    operands.append(rst)
    operands.extend(_get_op_results_or_values(opOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["module"] = (module if (
    isinstance(module, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(module, context=_ods_context))
    attributes["instName"] = (instName if (
    isinstance(instName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(instName, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def clk(self):
    return self.operation.operands[0]

  @builtins.property
  def rst(self):
    return self.operation.operands[1]

  @builtins.property
  def opOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def module(self):
    return self.operation.attributes["module"]

  @module.setter
  def module(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["module"] = value

  @builtins.property
  def instName(self):
    return self.operation.attributes["instName"]

  @instName.setter
  def instName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["instName"] = value

def esi_instance(result, module, inst_name, clk, rst, op_operands, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ESIInstanceOp(result=result, module=module, instName=inst_name, clk=clk, rst=rst, opOperands=op_operands, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExternalMemoryOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.extmemory"

  _ODS_REGIONS = (0, True)

  def __init__(self, outputs, memref, inputs, ldCount, stCount, id, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(memref)
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["ldCount"] = (ldCount if (
    isinstance(ldCount, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(ldCount, context=_ods_context))
    attributes["stCount"] = (stCount if (
    isinstance(stCount, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(stCount, context=_ods_context))
    attributes["id"] = (id if (
    isinstance(id, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(id, context=_ods_context))
    results.extend(outputs)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def ldCount(self):
    return self.operation.attributes["ldCount"]

  @ldCount.setter
  def ldCount(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ldCount"] = value

  @builtins.property
  def stCount(self):
    return self.operation.attributes["stCount"]

  @stCount.setter
  def stCount(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stCount"] = value

  @builtins.property
  def id(self):
    return self.operation.attributes["id"]

  @id.setter
  def id(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["id"] = value

  @builtins.property
  def outputs(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def extmemory(outputs, memref, inputs, ld_count, st_count, id, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExternalMemoryOp(outputs=outputs, memref=memref, inputs=inputs, ldCount=ld_count, stCount=st_count, id=id, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ForkOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.fork"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def fork(result, operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ForkOp(result=result, operand=operand, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FuncOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.func"

  _ODS_REGIONS = (1, True)

  def __init__(self, function_type, *, arg_attrs=None, res_attrs=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["function_type"] = (function_type if (
    isinstance(function_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_482')) else
      _ods_ir.AttrBuilder.get('anonymous_482')(function_type, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        isinstance(arg_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        isinstance(res_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def function_type(self):
    return self.operation.attributes["function_type"]

  @function_type.setter
  def function_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["function_type"] = value

  @builtins.property
  def arg_attrs(self):
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self):
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

  @builtins.property
  def body(self):
    return self.regions[0]

def func(function_type, *, arg_attrs=None, res_attrs=None, loc=None, ip=None) -> _ods_ir.Operation:
  return FuncOp(function_type=function_type, arg_attrs=arg_attrs, res_attrs=res_attrs, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class InstanceOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.instance"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, module, opOperands, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(opOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["module"] = (module if (
    isinstance(module, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(module, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def opOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def module(self):
    return self.operation.attributes["module"]

  @module.setter
  def module(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["module"] = value

def instance(result, module, op_operands, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InstanceOp(result=result, module=module, opOperands=op_operands, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class JoinOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.join"

  _ODS_REGIONS = (0, True)

  def __init__(self, data, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(data))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def data(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def join(data, *, loc=None, ip=None) -> _ods_ir.Value:
  return JoinOp(data=data, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LazyForkOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.lazy_fork"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def lazy_fork(result, operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LazyForkOp(result=result, operand=operand, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, dataResult, addressResults, addresses, data, ctrl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(addresses))
    operands.append(data)
    operands.append(ctrl)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dataResult)
    results.extend(addressResults)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def addresses(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def data(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def ctrl(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def dataResult(self):
    return self.operation.results[0]

  @builtins.property
  def addressResults(self):
    _ods_variadic_group_length = len(self.operation.results) - 2 + 1
    return self.operation.results[1:1 + _ods_variadic_group_length]

def load(data_result, address_results, addresses, data, ctrl, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(LoadOp(dataResult=data_result, addressResults=address_results, addresses=addresses, data=data, ctrl=ctrl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MemoryOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.memory"

  _ODS_REGIONS = (0, True)

  def __init__(self, outputs, inputs, ldCount, stCount, id, memRefType, lsq, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["ldCount"] = (ldCount if (
    isinstance(ldCount, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(ldCount, context=_ods_context))
    attributes["stCount"] = (stCount if (
    isinstance(stCount, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(stCount, context=_ods_context))
    attributes["id"] = (id if (
    isinstance(id, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(id, context=_ods_context))
    attributes["memRefType"] = (memRefType if (
    isinstance(memRefType, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('MemRefTypeAttr')) else
      _ods_ir.AttrBuilder.get('MemRefTypeAttr')(memRefType, context=_ods_context))
    attributes["lsq"] = (lsq if (
    isinstance(lsq, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(lsq, context=_ods_context))
    results.extend(outputs)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def ldCount(self):
    return self.operation.attributes["ldCount"]

  @ldCount.setter
  def ldCount(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ldCount"] = value

  @builtins.property
  def stCount(self):
    return self.operation.attributes["stCount"]

  @stCount.setter
  def stCount(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stCount"] = value

  @builtins.property
  def id(self):
    return self.operation.attributes["id"]

  @id.setter
  def id(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["id"] = value

  @builtins.property
  def memRefType(self):
    return self.operation.attributes["memRefType"]

  @memRefType.setter
  def memRefType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["memRefType"] = value

  @builtins.property
  def lsq(self):
    return self.operation.attributes["lsq"]

  @lsq.setter
  def lsq(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lsq"] = value

  @builtins.property
  def outputs(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def memory(outputs, inputs, ld_count, st_count, id, mem_ref_type, lsq, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MemoryOp(outputs=outputs, inputs=inputs, ldCount=ld_count, stCount=st_count, id=id, memRefType=mem_ref_type, lsq=lsq, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MergeOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.merge"

  _ODS_REGIONS = (0, True)

  def __init__(self, dataOperands, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(dataOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def dataOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def merge(data_operands, *, loc=None, ip=None) -> _ods_ir.Value:
  return MergeOp(dataOperands=data_operands, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MuxOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.mux"

  _ODS_REGIONS = (0, True)

  def __init__(self, selectOperand, dataOperands, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(selectOperand)
    operands.extend(_get_op_results_or_values(dataOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def selectOperand(self):
    return self.operation.operands[0]

  @builtins.property
  def dataOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def mux(select_operand, data_operands, *, loc=None, ip=None) -> _ods_ir.Value:
  return MuxOp(selectOperand=select_operand, dataOperands=data_operands, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class NeverOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.never"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self):
    return self.operation.results[0]

def never(result, *, loc=None, ip=None) -> _ods_ir.Value:
  return NeverOp(result=result, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PackOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.pack"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def pack(result, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return PackOp(result=result, inputs=inputs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, opOperands, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(opOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def opOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def return_(op_operands, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ReturnOp(opOperands=op_operands, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SinkOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.sink"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

def sink(operand, *, loc=None, ip=None) -> _ods_ir.Operation:
  return SinkOp(operand=operand, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SourceOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.source"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self):
    return self.operation.results[0]

def source(result, *, loc=None, ip=None) -> _ods_ir.Value:
  return SourceOp(result=result, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, dataResult, addressResult, addresses, data, ctrl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(addresses))
    operands.append(data)
    operands.append(ctrl)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dataResult)
    results.extend(addressResult)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def addresses(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def data(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def ctrl(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def dataResult(self):
    return self.operation.results[0]

  @builtins.property
  def addressResult(self):
    _ods_variadic_group_length = len(self.operation.results) - 2 + 1
    return self.operation.results[1:1 + _ods_variadic_group_length]

def store(data_result, address_result, addresses, data, ctrl, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(StoreOp(dataResult=data_result, addressResult=address_result, addresses=addresses, data=data, ctrl=ctrl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SyncOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.sync"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def sync(results_, operands_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SyncOp(results_=results_, operands_=operands_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnpackOp(_ods_ir.OpView):
  OPERATION_NAME = "handshake.unpack"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def unpack(results_, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnpackOp(results_=results_, input=input, loc=loc, ip=ip))
