# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCertificateVersionsResult',
    'AwaitableGetCertificateVersionsResult',
    'get_certificate_versions',
    'get_certificate_versions_output',
]

@pulumi.output_type
class GetCertificateVersionsResult:
    """
    A collection of values returned by getCertificateVersions.
    """
    def __init__(__self__, certificate_id=None, certificate_version_collections=None, filters=None, id=None, version_number=None):
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_version_collections and not isinstance(certificate_version_collections, list):
            raise TypeError("Expected argument 'certificate_version_collections' to be a list")
        pulumi.set(__self__, "certificate_version_collections", certificate_version_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if version_number and not isinstance(version_number, str):
            raise TypeError("Expected argument 'version_number' to be a str")
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        """
        The OCID of the certificate.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateVersionCollections")
    def certificate_version_collections(self) -> Sequence['outputs.GetCertificateVersionsCertificateVersionCollectionResult']:
        """
        The list of certificate_version_collection.
        """
        return pulumi.get(self, "certificate_version_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCertificateVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[str]:
        """
        The version number of the certificate.
        """
        return pulumi.get(self, "version_number")


class AwaitableGetCertificateVersionsResult(GetCertificateVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateVersionsResult(
            certificate_id=self.certificate_id,
            certificate_version_collections=self.certificate_version_collections,
            filters=self.filters,
            id=self.id,
            version_number=self.version_number)


def get_certificate_versions(certificate_id: Optional[str] = None,
                             filters: Optional[Sequence[pulumi.InputType['GetCertificateVersionsFilterArgs']]] = None,
                             version_number: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateVersionsResult:
    """
    This data source provides the list of Certificate Versions in Oracle Cloud Infrastructure Certificates Management service.

    Lists all certificate versions for the specified certificate.
    Optionally, you can use the parameter `FilterByVersionNumberQueryParam` to limit the result set to a single item that matches the specified version number.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate_versions = oci.CertificatesManagement.get_certificate_versions(certificate_id=oci_certificates_management_certificate["test_certificate"]["id"],
        version_number=var["certificate_version_version_number"])
    ```
    <!--End PulumiCodeChooser -->


    :param str certificate_id: The OCID of the certificate.
    :param str version_number: A filter that returns only resources that match the specified version number. The default value is 0, which means that this filter is not applied.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['filters'] = filters
    __args__['versionNumber'] = version_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CertificatesManagement/getCertificateVersions:getCertificateVersions', __args__, opts=opts, typ=GetCertificateVersionsResult).value

    return AwaitableGetCertificateVersionsResult(
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        certificate_version_collections=pulumi.get(__ret__, 'certificate_version_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        version_number=pulumi.get(__ret__, 'version_number'))


@_utilities.lift_output_func(get_certificate_versions)
def get_certificate_versions_output(certificate_id: Optional[pulumi.Input[str]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetCertificateVersionsFilterArgs']]]]] = None,
                                    version_number: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateVersionsResult]:
    """
    This data source provides the list of Certificate Versions in Oracle Cloud Infrastructure Certificates Management service.

    Lists all certificate versions for the specified certificate.
    Optionally, you can use the parameter `FilterByVersionNumberQueryParam` to limit the result set to a single item that matches the specified version number.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate_versions = oci.CertificatesManagement.get_certificate_versions(certificate_id=oci_certificates_management_certificate["test_certificate"]["id"],
        version_number=var["certificate_version_version_number"])
    ```
    <!--End PulumiCodeChooser -->


    :param str certificate_id: The OCID of the certificate.
    :param str version_number: A filter that returns only resources that match the specified version number. The default value is 0, which means that this filter is not applied.
    """
    ...
