# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetConfigurationResult',
    'AwaitableGetConfigurationResult',
    'get_configuration',
    'get_configuration_output',
]

@pulumi.output_type
class GetConfigurationResult:
    """
    A collection of values returned by getConfiguration.
    """
    def __init__(__self__, compartment_id=None, http_submit_endpoint=None, id=None, smtp_submit_endpoint=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if http_submit_endpoint and not isinstance(http_submit_endpoint, str):
            raise TypeError("Expected argument 'http_submit_endpoint' to be a str")
        pulumi.set(__self__, "http_submit_endpoint", http_submit_endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if smtp_submit_endpoint and not isinstance(smtp_submit_endpoint, str):
            raise TypeError("Expected argument 'smtp_submit_endpoint' to be a str")
        pulumi.set(__self__, "smtp_submit_endpoint", smtp_submit_endpoint)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The root compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) (same as the tenancy OCID)
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="httpSubmitEndpoint")
    def http_submit_endpoint(self) -> str:
        """
        Endpoint used to submit emails via the HTTP email submission API
        """
        return pulumi.get(self, "http_submit_endpoint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="smtpSubmitEndpoint")
    def smtp_submit_endpoint(self) -> str:
        """
        Endpoint used to submit emails via the standard SMTP submission protocol. Note that TLS 1.2 and standard SMTP authentication is required for submission.
        """
        return pulumi.get(self, "smtp_submit_endpoint")


class AwaitableGetConfigurationResult(GetConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationResult(
            compartment_id=self.compartment_id,
            http_submit_endpoint=self.http_submit_endpoint,
            id=self.id,
            smtp_submit_endpoint=self.smtp_submit_endpoint)


def get_configuration(compartment_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationResult:
    """
    This data source provides details about a specific Configuration resource in Oracle Cloud Infrastructure Email service.

    Returns  email configuration associated with the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_configuration = oci.Email.get_configuration(compartment_id=var["compartment_id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID for the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Email/getConfiguration:getConfiguration', __args__, opts=opts, typ=GetConfigurationResult).value

    return AwaitableGetConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        http_submit_endpoint=pulumi.get(__ret__, 'http_submit_endpoint'),
        id=pulumi.get(__ret__, 'id'),
        smtp_submit_endpoint=pulumi.get(__ret__, 'smtp_submit_endpoint'))


@_utilities.lift_output_func(get_configuration)
def get_configuration_output(compartment_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConfigurationResult]:
    """
    This data source provides details about a specific Configuration resource in Oracle Cloud Infrastructure Email service.

    Returns  email configuration associated with the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_configuration = oci.Email.get_configuration(compartment_id=var["compartment_id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID for the compartment.
    """
    ...
