# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDeploymentVersionsResult',
    'AwaitableGetDeploymentVersionsResult',
    'get_deployment_versions',
    'get_deployment_versions_output',
]

@pulumi.output_type
class GetDeploymentVersionsResult:
    """
    A collection of values returned by getDeploymentVersions.
    """
    def __init__(__self__, compartment_id=None, deployment_id=None, deployment_type=None, deployment_version_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if deployment_version_collections and not isinstance(deployment_version_collections, list):
            raise TypeError("Expected argument 'deployment_version_collections' to be a list")
        pulumi.set(__self__, "deployment_version_collections", deployment_version_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[str]:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[str]:
        """
        The type of deployment, the value determines the exact 'type' of service executed in the Deployment. NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of the equivalent 'DATABASE_ORACLE' value.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="deploymentVersionCollections")
    def deployment_version_collections(self) -> Sequence['outputs.GetDeploymentVersionsDeploymentVersionCollectionResult']:
        """
        The list of deployment_version_collection.
        """
        return pulumi.get(self, "deployment_version_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDeploymentVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDeploymentVersionsResult(GetDeploymentVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentVersionsResult(
            compartment_id=self.compartment_id,
            deployment_id=self.deployment_id,
            deployment_type=self.deployment_type,
            deployment_version_collections=self.deployment_version_collections,
            filters=self.filters,
            id=self.id)


def get_deployment_versions(compartment_id: Optional[str] = None,
                            deployment_id: Optional[str] = None,
                            deployment_type: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetDeploymentVersionsFilterArgs']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentVersionsResult:
    """
    This data source provides the list of Deployment Versions in Oracle Cloud Infrastructure Golden Gate service.

    Returns the list of available deployment versions.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_versions = oci.GoldenGate.get_deployment_versions(compartment_id=var["compartment_id"],
        deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
        deployment_type=var["deployment_version_deployment_type"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
    :param str deployment_type: The type of deployment, the value determines the exact 'type' of the service executed in the deployment. Default value is DATABASE_ORACLE.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['deploymentId'] = deployment_id
    __args__['deploymentType'] = deployment_type
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDeploymentVersions:getDeploymentVersions', __args__, opts=opts, typ=GetDeploymentVersionsResult).value

    return AwaitableGetDeploymentVersionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        deployment_version_collections=pulumi.get(__ret__, 'deployment_version_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_deployment_versions)
def get_deployment_versions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   deployment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   deployment_type: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDeploymentVersionsFilterArgs']]]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDeploymentVersionsResult]:
    """
    This data source provides the list of Deployment Versions in Oracle Cloud Infrastructure Golden Gate service.

    Returns the list of available deployment versions.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_versions = oci.GoldenGate.get_deployment_versions(compartment_id=var["compartment_id"],
        deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
        deployment_type=var["deployment_version_deployment_type"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
    :param str deployment_type: The type of deployment, the value determines the exact 'type' of the service executed in the deployment. Default value is DATABASE_ORACLE.
    """
    ...
