# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsIdentityPropagationTrustArgs', 'DomainsIdentityPropagationTrust']

@pulumi.input_type
class DomainsIdentityPropagationTrustArgs:
    def __init__(__self__, *,
                 idcs_endpoint: pulumi.Input[str],
                 issuer: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 allow_impersonation: Optional[pulumi.Input[bool]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 client_claim_name: Optional[pulumi.Input[str]] = None,
                 client_claim_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 clock_skew_seconds: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 impersonation_service_users: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]] = None,
                 keytab: Optional[pulumi.Input['DomainsIdentityPropagationTrustKeytabArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 public_certificate: Optional[pulumi.Input[str]] = None,
                 public_key_endpoint: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 subject_claim_name: Optional[pulumi.Input[str]] = None,
                 subject_mapping_attribute: Optional[pulumi.Input[str]] = None,
                 subject_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustTagArgs']]]] = None):
        """
        The set of arguments for constructing a DomainsIdentityPropagationTrust resource.
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[str] issuer: (Updatable) The issuer claim of the Identity provider.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: true
               * mutability: readWrite
               * returned: always
               * caseExact: true
               * idcsSearchable: true
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] type: (Updatable) The type of the inbound token from the Identity cloud provider.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * required: true
               * mutability: readWrite
               * returned: default
               * type: string
               * multiValued: false
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] account_id: (Updatable) The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * caseExact: true
               * idcsSearchable: true
               * uniqueness: none
        :param pulumi.Input[bool] active: (Updatable) If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.
               
               **SCIM++ Properties:**
               * type: boolean
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[bool] allow_impersonation: (Updatable) Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.
               
               **SCIM++ Properties:**
               * type: boolean
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] client_claim_name: (Updatable) The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\"aud\\" or \\"client_id\\". If Azure, then \\"appid\\". If GCP, then \\"aud\\".
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_claim_values: (Updatable) The value that corresponds to the client claim name used to identify to whom the token is issued.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: true
               * idcsSearchable: false
        :param pulumi.Input[int] clock_skew_seconds: (Updatable) The clock skew (in secs) that's allowed for the token issue and expiry time.
               
               **Added In:** 2308181911
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) The description of the Identity Propagation Trust.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]] impersonation_service_users: (Updatable) The Impersonating Principal.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [rule, value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsIdentityPropagationTrustKeytabArgs'] keytab: (Updatable) The keytab stored in the tenancy's Vault. This is required if the identity propagation type is 'SPNEGO'.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [secretOcid]
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] name: The name of the the Identity Propagation Trust.
               
               **SCIM++ Properties:**
               * type: string
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * required: true
               * mutability: immutable
               * returned: default
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_clients: (Updatable) The value of all the authorized OAuth Clients.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] public_certificate: (Updatable) Store the public key if public key cert.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[str] public_key_endpoint: (Updatable) The cloud provider's public key API of SAML and OIDC providers for signature validation.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
               * idcsSearchable: false
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[str] subject_claim_name: (Updatable) Used for locating the subject claim from the incoming token.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: true
               * idcsSearchable: false
        :param pulumi.Input[str] subject_mapping_attribute: (Updatable) Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * idcsSearchable: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[str] subject_type: (Updatable) The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "type", type)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if allow_impersonation is not None:
            pulumi.set(__self__, "allow_impersonation", allow_impersonation)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if client_claim_name is not None:
            pulumi.set(__self__, "client_claim_name", client_claim_name)
        if client_claim_values is not None:
            pulumi.set(__self__, "client_claim_values", client_claim_values)
        if clock_skew_seconds is not None:
            pulumi.set(__self__, "clock_skew_seconds", clock_skew_seconds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if impersonation_service_users is not None:
            pulumi.set(__self__, "impersonation_service_users", impersonation_service_users)
        if keytab is not None:
            pulumi.set(__self__, "keytab", keytab)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_clients is not None:
            pulumi.set(__self__, "oauth_clients", oauth_clients)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)
        if public_key_endpoint is not None:
            pulumi.set(__self__, "public_key_endpoint", public_key_endpoint)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if subject_claim_name is not None:
            pulumi.set(__self__, "subject_claim_name", subject_claim_name)
        if subject_mapping_attribute is not None:
            pulumi.set(__self__, "subject_mapping_attribute", subject_mapping_attribute)
        if subject_type is not None:
            pulumi.set(__self__, "subject_type", subject_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        (Updatable) The issuer claim of the Identity provider.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: true
        * mutability: readWrite
        * returned: always
        * caseExact: true
        * idcsSearchable: true
        * uniqueness: server
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the inbound token from the Identity cloud provider.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * required: true
        * mutability: readWrite
        * returned: default
        * type: string
        * multiValued: false
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * caseExact: true
        * idcsSearchable: true
        * uniqueness: none
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.

        **SCIM++ Properties:**
        * type: boolean
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="allowImpersonation")
    def allow_impersonation(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.

        **SCIM++ Properties:**
        * type: boolean
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "allow_impersonation")

    @allow_impersonation.setter
    def allow_impersonation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_impersonation", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="clientClaimName")
    def client_claim_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\"aud\\" or \\"client_id\\". If Azure, then \\"appid\\". If GCP, then \\"aud\\".

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "client_claim_name")

    @client_claim_name.setter
    def client_claim_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_claim_name", value)

    @property
    @pulumi.getter(name="clientClaimValues")
    def client_claim_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The value that corresponds to the client claim name used to identify to whom the token is issued.

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: true
        * idcsSearchable: false
        """
        return pulumi.get(self, "client_claim_values")

    @client_claim_values.setter
    def client_claim_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_claim_values", value)

    @property
    @pulumi.getter(name="clockSkewSeconds")
    def clock_skew_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The clock skew (in secs) that's allowed for the token issue and expiry time.

        **Added In:** 2308181911

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "clock_skew_seconds")

    @clock_skew_seconds.setter
    def clock_skew_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "clock_skew_seconds", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the Identity Propagation Trust.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        * idcsSearchable: false
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="impersonationServiceUsers")
    def impersonation_service_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]]:
        """
        (Updatable) The Impersonating Principal.

        **SCIM++ Properties:**
        * idcsCompositeKey: [rule, value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "impersonation_service_users")

    @impersonation_service_users.setter
    def impersonation_service_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]]):
        pulumi.set(self, "impersonation_service_users", value)

    @property
    @pulumi.getter
    def keytab(self) -> Optional[pulumi.Input['DomainsIdentityPropagationTrustKeytabArgs']]:
        """
        (Updatable) The keytab stored in the tenancy's Vault. This is required if the identity propagation type is 'SPNEGO'.

        **SCIM++ Properties:**
        * idcsCompositeKey: [secretOcid]
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "keytab")

    @keytab.setter
    def keytab(self, value: Optional[pulumi.Input['DomainsIdentityPropagationTrustKeytabArgs']]):
        pulumi.set(self, "keytab", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the the Identity Propagation Trust.

        **SCIM++ Properties:**
        * type: string
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * required: true
        * mutability: immutable
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthClients")
    def oauth_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The value of all the authorized OAuth Clients.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "oauth_clients")

    @oauth_clients.setter
    def oauth_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_clients", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Store the public key if public key cert.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_certificate", value)

    @property
    @pulumi.getter(name="publicKeyEndpoint")
    def public_key_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The cloud provider's public key API of SAML and OIDC providers for signature validation.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        * idcsSearchable: false
        """
        return pulumi.get(self, "public_key_endpoint")

    @public_key_endpoint.setter
    def public_key_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_endpoint", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter(name="subjectClaimName")
    def subject_claim_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used for locating the subject claim from the incoming token.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: true
        * idcsSearchable: false
        """
        return pulumi.get(self, "subject_claim_name")

    @subject_claim_name.setter
    def subject_claim_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_claim_name", value)

    @property
    @pulumi.getter(name="subjectMappingAttribute")
    def subject_mapping_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * idcsSearchable: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "subject_mapping_attribute")

    @subject_mapping_attribute.setter
    def subject_mapping_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_mapping_attribute", value)

    @property
    @pulumi.getter(name="subjectType")
    def subject_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "subject_type")

    @subject_type.setter
    def subject_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainsIdentityPropagationTrustState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 allow_impersonation: Optional[pulumi.Input[bool]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 client_claim_name: Optional[pulumi.Input[str]] = None,
                 client_claim_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 clock_skew_seconds: Optional[pulumi.Input[int]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 impersonation_service_users: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 keytab: Optional[pulumi.Input['DomainsIdentityPropagationTrustKeytabArgs']] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustMetaArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 public_certificate: Optional[pulumi.Input[str]] = None,
                 public_key_endpoint: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subject_claim_name: Optional[pulumi.Input[str]] = None,
                 subject_mapping_attribute: Optional[pulumi.Input[str]] = None,
                 subject_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DomainsIdentityPropagationTrust resources.
        :param pulumi.Input[str] account_id: (Updatable) The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * caseExact: true
               * idcsSearchable: true
               * uniqueness: none
        :param pulumi.Input[bool] active: (Updatable) If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.
               
               **SCIM++ Properties:**
               * type: boolean
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[bool] allow_impersonation: (Updatable) Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.
               
               **SCIM++ Properties:**
               * type: boolean
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] client_claim_name: (Updatable) The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\"aud\\" or \\"client_id\\". If Azure, then \\"appid\\". If GCP, then \\"aud\\".
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_claim_values: (Updatable) The value that corresponds to the client claim name used to identify to whom the token is issued.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: true
               * idcsSearchable: false
        :param pulumi.Input[int] clock_skew_seconds: (Updatable) The clock skew (in secs) that's allowed for the token issue and expiry time.
               
               **Added In:** 2308181911
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) The description of the Identity Propagation Trust.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
               * idcsSearchable: false
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]] impersonation_service_users: (Updatable) The Impersonating Principal.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [rule, value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] issuer: (Updatable) The issuer claim of the Identity provider.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: true
               * mutability: readWrite
               * returned: always
               * caseExact: true
               * idcsSearchable: true
               * uniqueness: server
        :param pulumi.Input['DomainsIdentityPropagationTrustKeytabArgs'] keytab: (Updatable) The keytab stored in the tenancy's Vault. This is required if the identity propagation type is 'SPNEGO'.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [secretOcid]
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] name: The name of the the Identity Propagation Trust.
               
               **SCIM++ Properties:**
               * type: string
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * required: true
               * mutability: immutable
               * returned: default
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_clients: (Updatable) The value of all the authorized OAuth Clients.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] public_certificate: (Updatable) Store the public key if public key cert.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[str] public_key_endpoint: (Updatable) The cloud provider's public key API of SAML and OIDC providers for signature validation.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
               * idcsSearchable: false
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] subject_claim_name: (Updatable) Used for locating the subject claim from the incoming token.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: true
               * idcsSearchable: false
        :param pulumi.Input[str] subject_mapping_attribute: (Updatable) Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * idcsSearchable: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[str] subject_type: (Updatable) The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] type: (Updatable) The type of the inbound token from the Identity cloud provider.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * required: true
               * mutability: readWrite
               * returned: default
               * type: string
               * multiValued: false
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if allow_impersonation is not None:
            pulumi.set(__self__, "allow_impersonation", allow_impersonation)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if client_claim_name is not None:
            pulumi.set(__self__, "client_claim_name", client_claim_name)
        if client_claim_values is not None:
            pulumi.set(__self__, "client_claim_values", client_claim_values)
        if clock_skew_seconds is not None:
            pulumi.set(__self__, "clock_skew_seconds", clock_skew_seconds)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if impersonation_service_users is not None:
            pulumi.set(__self__, "impersonation_service_users", impersonation_service_users)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if keytab is not None:
            pulumi.set(__self__, "keytab", keytab)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_clients is not None:
            pulumi.set(__self__, "oauth_clients", oauth_clients)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)
        if public_key_endpoint is not None:
            pulumi.set(__self__, "public_key_endpoint", public_key_endpoint)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if subject_claim_name is not None:
            pulumi.set(__self__, "subject_claim_name", subject_claim_name)
        if subject_mapping_attribute is not None:
            pulumi.set(__self__, "subject_mapping_attribute", subject_mapping_attribute)
        if subject_type is not None:
            pulumi.set(__self__, "subject_type", subject_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * caseExact: true
        * idcsSearchable: true
        * uniqueness: none
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.

        **SCIM++ Properties:**
        * type: boolean
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="allowImpersonation")
    def allow_impersonation(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.

        **SCIM++ Properties:**
        * type: boolean
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "allow_impersonation")

    @allow_impersonation.setter
    def allow_impersonation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_impersonation", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="clientClaimName")
    def client_claim_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\"aud\\" or \\"client_id\\". If Azure, then \\"appid\\". If GCP, then \\"aud\\".

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "client_claim_name")

    @client_claim_name.setter
    def client_claim_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_claim_name", value)

    @property
    @pulumi.getter(name="clientClaimValues")
    def client_claim_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The value that corresponds to the client claim name used to identify to whom the token is issued.

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: true
        * idcsSearchable: false
        """
        return pulumi.get(self, "client_claim_values")

    @client_claim_values.setter
    def client_claim_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_claim_values", value)

    @property
    @pulumi.getter(name="clockSkewSeconds")
    def clock_skew_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The clock skew (in secs) that's allowed for the token issue and expiry time.

        **Added In:** 2308181911

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "clock_skew_seconds")

    @clock_skew_seconds.setter
    def clock_skew_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "clock_skew_seconds", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the Identity Propagation Trust.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        * idcsSearchable: false
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="impersonationServiceUsers")
    def impersonation_service_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]]:
        """
        (Updatable) The Impersonating Principal.

        **SCIM++ Properties:**
        * idcsCompositeKey: [rule, value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "impersonation_service_users")

    @impersonation_service_users.setter
    def impersonation_service_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]]):
        pulumi.set(self, "impersonation_service_users", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The issuer claim of the Identity provider.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: true
        * mutability: readWrite
        * returned: always
        * caseExact: true
        * idcsSearchable: true
        * uniqueness: server
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter
    def keytab(self) -> Optional[pulumi.Input['DomainsIdentityPropagationTrustKeytabArgs']]:
        """
        (Updatable) The keytab stored in the tenancy's Vault. This is required if the identity propagation type is 'SPNEGO'.

        **SCIM++ Properties:**
        * idcsCompositeKey: [secretOcid]
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "keytab")

    @keytab.setter
    def keytab(self, value: Optional[pulumi.Input['DomainsIdentityPropagationTrustKeytabArgs']]):
        pulumi.set(self, "keytab", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the the Identity Propagation Trust.

        **SCIM++ Properties:**
        * type: string
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * required: true
        * mutability: immutable
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthClients")
    def oauth_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The value of all the authorized OAuth Clients.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "oauth_clients")

    @oauth_clients.setter
    def oauth_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_clients", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Store the public key if public key cert.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_certificate", value)

    @property
    @pulumi.getter(name="publicKeyEndpoint")
    def public_key_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The cloud provider's public key API of SAML and OIDC providers for signature validation.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        * idcsSearchable: false
        """
        return pulumi.get(self, "public_key_endpoint")

    @public_key_endpoint.setter
    def public_key_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_endpoint", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="subjectClaimName")
    def subject_claim_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used for locating the subject claim from the incoming token.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: true
        * idcsSearchable: false
        """
        return pulumi.get(self, "subject_claim_name")

    @subject_claim_name.setter
    def subject_claim_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_claim_name", value)

    @property
    @pulumi.getter(name="subjectMappingAttribute")
    def subject_mapping_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * idcsSearchable: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "subject_mapping_attribute")

    @subject_mapping_attribute.setter
    def subject_mapping_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_mapping_attribute", value)

    @property
    @pulumi.getter(name="subjectType")
    def subject_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "subject_type")

    @subject_type.setter
    def subject_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityPropagationTrustTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the inbound token from the Identity cloud provider.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * required: true
        * mutability: readWrite
        * returned: default
        * type: string
        * multiValued: false
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class DomainsIdentityPropagationTrust(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 allow_impersonation: Optional[pulumi.Input[bool]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 client_claim_name: Optional[pulumi.Input[str]] = None,
                 client_claim_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 clock_skew_seconds: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 impersonation_service_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 keytab: Optional[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustKeytabArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 public_certificate: Optional[pulumi.Input[str]] = None,
                 public_key_endpoint: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subject_claim_name: Optional[pulumi.Input[str]] = None,
                 subject_mapping_attribute: Optional[pulumi.Input[str]] = None,
                 subject_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Identity Propagation Trust resource in Oracle Cloud Infrastructure Identity Domains service.

        Register a new Identity Propagation Trust configuration.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_identity_propagation_trust = oci.identity.DomainsIdentityPropagationTrust("testIdentityPropagationTrust",
            idcs_endpoint=data["oci_identity_domain"]["test_domain"]["url"],
            issuer=var["identity_propagation_trust_issuer"],
            schemas=["urn:ietf:params:scim:schemas:oracle:idcs:IdentityPropagationTrust"],
            type=var["identity_propagation_trust_type"],
            account_id="accountId",
            active=var["identity_propagation_trust_active"],
            allow_impersonation=var["identity_propagation_trust_allow_impersonation"],
            attribute_sets=["all"],
            attributes="",
            authorization=var["identity_propagation_trust_authorization"],
            client_claim_name=var["identity_propagation_trust_client_claim_name"],
            client_claim_values=["clientClaimValues"],
            clock_skew_seconds=var["identity_propagation_trust_clock_skew_seconds"],
            description=var["identity_propagation_trust_description"],
            impersonation_service_users=[oci.identity.DomainsIdentityPropagationTrustImpersonationServiceUserArgs(
                rule=var["identity_propagation_trust_impersonation_service_users_rule"],
                value=oci_identity_domains_user["test_identity_propagation_trust_user"]["id"],
                ocid=var["identity_propagation_trust_impersonation_service_users_ocid"],
            )],
            keytab=oci.identity.DomainsIdentityPropagationTrustKeytabArgs(
                secret_ocid=var["identity_propagation_trust_keytab_secret_ocid"],
                secret_version=var["identity_propagation_trust_keytab_secret_version"],
            ),
            oauth_clients=["oauthClients"],
            ocid=var["identity_propagation_trust_ocid"],
            public_certificate=var["identity_propagation_trust_public_certificate"],
            public_key_endpoint=var["identity_propagation_trust_public_key_endpoint"],
            resource_type_schema_version=var["identity_propagation_trust_resource_type_schema_version"],
            subject_claim_name=var["identity_propagation_trust_subject_claim_name"],
            subject_mapping_attribute=var["identity_propagation_trust_subject_mapping_attribute"],
            subject_type=var["identity_propagation_trust_subject_type"],
            tags=[oci.identity.DomainsIdentityPropagationTrustTagArgs(
                key=var["identity_propagation_trust_tags_key"],
                value=var["identity_propagation_trust_tags_value"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        IdentityPropagationTrusts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsIdentityPropagationTrust:DomainsIdentityPropagationTrust test_identity_propagation_trust "idcsEndpoint/{idcsEndpoint}/identityPropagationTrusts/{identityPropagationTrustId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: (Updatable) The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * caseExact: true
               * idcsSearchable: true
               * uniqueness: none
        :param pulumi.Input[bool] active: (Updatable) If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.
               
               **SCIM++ Properties:**
               * type: boolean
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[bool] allow_impersonation: (Updatable) Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.
               
               **SCIM++ Properties:**
               * type: boolean
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] client_claim_name: (Updatable) The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\"aud\\" or \\"client_id\\". If Azure, then \\"appid\\". If GCP, then \\"aud\\".
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_claim_values: (Updatable) The value that corresponds to the client claim name used to identify to whom the token is issued.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: true
               * idcsSearchable: false
        :param pulumi.Input[int] clock_skew_seconds: (Updatable) The clock skew (in secs) that's allowed for the token issue and expiry time.
               
               **Added In:** 2308181911
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) The description of the Identity Propagation Trust.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
               * idcsSearchable: false
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]] impersonation_service_users: (Updatable) The Impersonating Principal.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [rule, value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] issuer: (Updatable) The issuer claim of the Identity provider.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: true
               * mutability: readWrite
               * returned: always
               * caseExact: true
               * idcsSearchable: true
               * uniqueness: server
        :param pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustKeytabArgs']] keytab: (Updatable) The keytab stored in the tenancy's Vault. This is required if the identity propagation type is 'SPNEGO'.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [secretOcid]
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] name: The name of the the Identity Propagation Trust.
               
               **SCIM++ Properties:**
               * type: string
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * required: true
               * mutability: immutable
               * returned: default
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_clients: (Updatable) The value of all the authorized OAuth Clients.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] public_certificate: (Updatable) Store the public key if public key cert.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[str] public_key_endpoint: (Updatable) The cloud provider's public key API of SAML and OIDC providers for signature validation.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
               * idcsSearchable: false
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] subject_claim_name: (Updatable) Used for locating the subject claim from the incoming token.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: true
               * idcsSearchable: false
        :param pulumi.Input[str] subject_mapping_attribute: (Updatable) Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * idcsSearchable: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[str] subject_type: (Updatable) The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] type: (Updatable) The type of the inbound token from the Identity cloud provider.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * required: true
               * mutability: readWrite
               * returned: default
               * type: string
               * multiValued: false
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsIdentityPropagationTrustArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Identity Propagation Trust resource in Oracle Cloud Infrastructure Identity Domains service.

        Register a new Identity Propagation Trust configuration.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_identity_propagation_trust = oci.identity.DomainsIdentityPropagationTrust("testIdentityPropagationTrust",
            idcs_endpoint=data["oci_identity_domain"]["test_domain"]["url"],
            issuer=var["identity_propagation_trust_issuer"],
            schemas=["urn:ietf:params:scim:schemas:oracle:idcs:IdentityPropagationTrust"],
            type=var["identity_propagation_trust_type"],
            account_id="accountId",
            active=var["identity_propagation_trust_active"],
            allow_impersonation=var["identity_propagation_trust_allow_impersonation"],
            attribute_sets=["all"],
            attributes="",
            authorization=var["identity_propagation_trust_authorization"],
            client_claim_name=var["identity_propagation_trust_client_claim_name"],
            client_claim_values=["clientClaimValues"],
            clock_skew_seconds=var["identity_propagation_trust_clock_skew_seconds"],
            description=var["identity_propagation_trust_description"],
            impersonation_service_users=[oci.identity.DomainsIdentityPropagationTrustImpersonationServiceUserArgs(
                rule=var["identity_propagation_trust_impersonation_service_users_rule"],
                value=oci_identity_domains_user["test_identity_propagation_trust_user"]["id"],
                ocid=var["identity_propagation_trust_impersonation_service_users_ocid"],
            )],
            keytab=oci.identity.DomainsIdentityPropagationTrustKeytabArgs(
                secret_ocid=var["identity_propagation_trust_keytab_secret_ocid"],
                secret_version=var["identity_propagation_trust_keytab_secret_version"],
            ),
            oauth_clients=["oauthClients"],
            ocid=var["identity_propagation_trust_ocid"],
            public_certificate=var["identity_propagation_trust_public_certificate"],
            public_key_endpoint=var["identity_propagation_trust_public_key_endpoint"],
            resource_type_schema_version=var["identity_propagation_trust_resource_type_schema_version"],
            subject_claim_name=var["identity_propagation_trust_subject_claim_name"],
            subject_mapping_attribute=var["identity_propagation_trust_subject_mapping_attribute"],
            subject_type=var["identity_propagation_trust_subject_type"],
            tags=[oci.identity.DomainsIdentityPropagationTrustTagArgs(
                key=var["identity_propagation_trust_tags_key"],
                value=var["identity_propagation_trust_tags_value"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        IdentityPropagationTrusts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsIdentityPropagationTrust:DomainsIdentityPropagationTrust test_identity_propagation_trust "idcsEndpoint/{idcsEndpoint}/identityPropagationTrusts/{identityPropagationTrustId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsIdentityPropagationTrustArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsIdentityPropagationTrustArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 allow_impersonation: Optional[pulumi.Input[bool]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 client_claim_name: Optional[pulumi.Input[str]] = None,
                 client_claim_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 clock_skew_seconds: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 impersonation_service_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 keytab: Optional[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustKeytabArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 public_certificate: Optional[pulumi.Input[str]] = None,
                 public_key_endpoint: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subject_claim_name: Optional[pulumi.Input[str]] = None,
                 subject_mapping_attribute: Optional[pulumi.Input[str]] = None,
                 subject_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsIdentityPropagationTrustArgs.__new__(DomainsIdentityPropagationTrustArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["active"] = active
            __props__.__dict__["allow_impersonation"] = allow_impersonation
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["client_claim_name"] = client_claim_name
            __props__.__dict__["client_claim_values"] = client_claim_values
            __props__.__dict__["clock_skew_seconds"] = clock_skew_seconds
            __props__.__dict__["description"] = description
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["impersonation_service_users"] = impersonation_service_users
            if issuer is None and not opts.urn:
                raise TypeError("Missing required property 'issuer'")
            __props__.__dict__["issuer"] = issuer
            __props__.__dict__["keytab"] = keytab
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth_clients"] = oauth_clients
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["public_certificate"] = public_certificate
            __props__.__dict__["public_key_endpoint"] = public_key_endpoint
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["subject_claim_name"] = subject_claim_name
            __props__.__dict__["subject_mapping_attribute"] = subject_mapping_attribute
            __props__.__dict__["subject_type"] = subject_type
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsIdentityPropagationTrust, __self__).__init__(
            'oci:Identity/domainsIdentityPropagationTrust:DomainsIdentityPropagationTrust',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            active: Optional[pulumi.Input[bool]] = None,
            allow_impersonation: Optional[pulumi.Input[bool]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            client_claim_name: Optional[pulumi.Input[str]] = None,
            client_claim_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            clock_skew_seconds: Optional[pulumi.Input[int]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustIdcsCreatedByArgs']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustIdcsLastModifiedByArgs']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            impersonation_service_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]]] = None,
            issuer: Optional[pulumi.Input[str]] = None,
            keytab: Optional[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustKeytabArgs']]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustMetaArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oauth_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            public_certificate: Optional[pulumi.Input[str]] = None,
            public_key_endpoint: Optional[pulumi.Input[str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            subject_claim_name: Optional[pulumi.Input[str]] = None,
            subject_mapping_attribute: Optional[pulumi.Input[str]] = None,
            subject_type: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustTagArgs']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'DomainsIdentityPropagationTrust':
        """
        Get an existing DomainsIdentityPropagationTrust resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: (Updatable) The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * caseExact: true
               * idcsSearchable: true
               * uniqueness: none
        :param pulumi.Input[bool] active: (Updatable) If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.
               
               **SCIM++ Properties:**
               * type: boolean
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[bool] allow_impersonation: (Updatable) Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.
               
               **SCIM++ Properties:**
               * type: boolean
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] client_claim_name: (Updatable) The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\"aud\\" or \\"client_id\\". If Azure, then \\"appid\\". If GCP, then \\"aud\\".
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_claim_values: (Updatable) The value that corresponds to the client claim name used to identify to whom the token is issued.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: true
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: true
               * idcsSearchable: false
        :param pulumi.Input[int] clock_skew_seconds: (Updatable) The clock skew (in secs) that's allowed for the token issue and expiry time.
               
               **Added In:** 2308181911
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) The description of the Identity Propagation Trust.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
               * idcsSearchable: false
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustIdcsCreatedByArgs']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustIdcsLastModifiedByArgs']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustImpersonationServiceUserArgs']]]] impersonation_service_users: (Updatable) The Impersonating Principal.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [rule, value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] issuer: (Updatable) The issuer claim of the Identity provider.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: true
               * mutability: readWrite
               * returned: always
               * caseExact: true
               * idcsSearchable: true
               * uniqueness: server
        :param pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustKeytabArgs']] keytab: (Updatable) The keytab stored in the tenancy's Vault. This is required if the identity propagation type is 'SPNEGO'.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [secretOcid]
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustMetaArgs']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] name: The name of the the Identity Propagation Trust.
               
               **SCIM++ Properties:**
               * type: string
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * required: true
               * mutability: immutable
               * returned: default
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_clients: (Updatable) The value of all the authorized OAuth Clients.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] public_certificate: (Updatable) Store the public key if public key cert.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsSearchable: false
        :param pulumi.Input[str] public_key_endpoint: (Updatable) The cloud provider's public key API of SAML and OIDC providers for signature validation.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: false
               * idcsSearchable: false
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] subject_claim_name: (Updatable) Used for locating the subject claim from the incoming token.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * caseExact: true
               * idcsSearchable: false
        :param pulumi.Input[str] subject_mapping_attribute: (Updatable) Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * idcsSearchable: false
               * required: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[str] subject_type: (Updatable) The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentityPropagationTrustTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] type: (Updatable) The type of the inbound token from the Identity cloud provider.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * required: true
               * mutability: readWrite
               * returned: default
               * type: string
               * multiValued: false
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsIdentityPropagationTrustState.__new__(_DomainsIdentityPropagationTrustState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["active"] = active
        __props__.__dict__["allow_impersonation"] = allow_impersonation
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["client_claim_name"] = client_claim_name
        __props__.__dict__["client_claim_values"] = client_claim_values
        __props__.__dict__["clock_skew_seconds"] = clock_skew_seconds
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["impersonation_service_users"] = impersonation_service_users
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["keytab"] = keytab
        __props__.__dict__["metas"] = metas
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_clients"] = oauth_clients
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["public_certificate"] = public_certificate
        __props__.__dict__["public_key_endpoint"] = public_key_endpoint
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["subject_claim_name"] = subject_claim_name
        __props__.__dict__["subject_mapping_attribute"] = subject_mapping_attribute
        __props__.__dict__["subject_type"] = subject_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["type"] = type
        return DomainsIdentityPropagationTrust(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * caseExact: true
        * idcsSearchable: true
        * uniqueness: none
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.

        **SCIM++ Properties:**
        * type: boolean
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="allowImpersonation")
    def allow_impersonation(self) -> pulumi.Output[bool]:
        """
        (Updatable) Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.

        **SCIM++ Properties:**
        * type: boolean
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "allow_impersonation")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="clientClaimName")
    def client_claim_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\"aud\\" or \\"client_id\\". If Azure, then \\"appid\\". If GCP, then \\"aud\\".

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "client_claim_name")

    @property
    @pulumi.getter(name="clientClaimValues")
    def client_claim_values(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The value that corresponds to the client claim name used to identify to whom the token is issued.

        **SCIM++ Properties:**
        * type: string
        * multiValued: true
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: true
        * idcsSearchable: false
        """
        return pulumi.get(self, "client_claim_values")

    @property
    @pulumi.getter(name="clockSkewSeconds")
    def clock_skew_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) The clock skew (in secs) that's allowed for the token issue and expiry time.

        **Added In:** 2308181911

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "clock_skew_seconds")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the Identity Propagation Trust.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        * idcsSearchable: false
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityPropagationTrustIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityPropagationTrustIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="impersonationServiceUsers")
    def impersonation_service_users(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityPropagationTrustImpersonationServiceUser']]:
        """
        (Updatable) The Impersonating Principal.

        **SCIM++ Properties:**
        * idcsCompositeKey: [rule, value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "impersonation_service_users")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[str]:
        """
        (Updatable) The issuer claim of the Identity provider.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: true
        * mutability: readWrite
        * returned: always
        * caseExact: true
        * idcsSearchable: true
        * uniqueness: server
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def keytab(self) -> pulumi.Output['outputs.DomainsIdentityPropagationTrustKeytab']:
        """
        (Updatable) The keytab stored in the tenancy's Vault. This is required if the identity propagation type is 'SPNEGO'.

        **SCIM++ Properties:**
        * idcsCompositeKey: [secretOcid]
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "keytab")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityPropagationTrustMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the the Identity Propagation Trust.

        **SCIM++ Properties:**
        * type: string
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * required: true
        * mutability: immutable
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthClients")
    def oauth_clients(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The value of all the authorized OAuth Clients.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "oauth_clients")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> pulumi.Output[str]:
        """
        (Updatable) Store the public key if public key cert.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsSearchable: false
        """
        return pulumi.get(self, "public_certificate")

    @property
    @pulumi.getter(name="publicKeyEndpoint")
    def public_key_endpoint(self) -> pulumi.Output[str]:
        """
        (Updatable) The cloud provider's public key API of SAML and OIDC providers for signature validation.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: false
        * idcsSearchable: false
        """
        return pulumi.get(self, "public_key_endpoint")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="subjectClaimName")
    def subject_claim_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Used for locating the subject claim from the incoming token.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * caseExact: true
        * idcsSearchable: false
        """
        return pulumi.get(self, "subject_claim_name")

    @property
    @pulumi.getter(name="subjectMappingAttribute")
    def subject_mapping_attribute(self) -> pulumi.Output[str]:
        """
        (Updatable) Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * idcsSearchable: false
        * required: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "subject_mapping_attribute")

    @property
    @pulumi.getter(name="subjectType")
    def subject_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "subject_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityPropagationTrustTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of the inbound token from the Identity cloud provider.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * required: true
        * mutability: readWrite
        * returned: default
        * type: string
        * multiValued: false
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

