# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPublishersResult',
    'AwaitableGetPublishersResult',
    'get_publishers',
    'get_publishers_output',
]

@pulumi.output_type
class GetPublishersResult:
    """
    A collection of values returned by getPublishers.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, publisher_id=None, publishers=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if publisher_id and not isinstance(publisher_id, str):
            raise TypeError("Expected argument 'publisher_id' to be a str")
        pulumi.set(__self__, "publisher_id", publisher_id)
        if publishers and not isinstance(publishers, list):
            raise TypeError("Expected argument 'publishers' to be a list")
        pulumi.set(__self__, "publishers", publishers)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPublishersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> Optional[str]:
        return pulumi.get(self, "publisher_id")

    @property
    @pulumi.getter
    def publishers(self) -> Sequence['outputs.GetPublishersPublisherResult']:
        """
        The list of publishers.
        """
        return pulumi.get(self, "publishers")


class AwaitableGetPublishersResult(GetPublishersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublishersResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            publisher_id=self.publisher_id,
            publishers=self.publishers)


def get_publishers(compartment_id: Optional[str] = None,
                   filters: Optional[Sequence[pulumi.InputType['GetPublishersFilterArgs']]] = None,
                   publisher_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublishersResult:
    """
    This data source provides the list of Publishers in Oracle Cloud Infrastructure Marketplace service.

    Gets the list of all the publishers of listings available in Oracle Cloud Infrastructure Marketplace.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_publishers = oci.Marketplace.get_publishers(compartment_id=var["compartment_id"],
        publisher_id=oci_marketplace_publisher["test_publisher"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The unique identifier for the compartment.
    :param str publisher_id: Limit results to just this publisher.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['publisherId'] = publisher_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getPublishers:getPublishers', __args__, opts=opts, typ=GetPublishersResult).value

    return AwaitableGetPublishersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        publisher_id=pulumi.get(__ret__, 'publisher_id'),
        publishers=pulumi.get(__ret__, 'publishers'))


@_utilities.lift_output_func(get_publishers)
def get_publishers_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetPublishersFilterArgs']]]]] = None,
                          publisher_id: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublishersResult]:
    """
    This data source provides the list of Publishers in Oracle Cloud Infrastructure Marketplace service.

    Gets the list of all the publishers of listings available in Oracle Cloud Infrastructure Marketplace.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_publishers = oci.Marketplace.get_publishers(compartment_id=var["compartment_id"],
        publisher_id=oci_marketplace_publisher["test_publisher"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The unique identifier for the compartment.
    :param str publisher_id: Limit results to just this publisher.
    """
    ...
