# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetHostScanRecipeResult',
    'AwaitableGetHostScanRecipeResult',
    'get_host_scan_recipe',
    'get_host_scan_recipe_output',
]

@pulumi.output_type
class GetHostScanRecipeResult:
    """
    A collection of values returned by getHostScanRecipe.
    """
    def __init__(__self__, agent_settings=None, application_settings=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, host_scan_recipe_id=None, id=None, port_settings=None, schedules=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if agent_settings and not isinstance(agent_settings, list):
            raise TypeError("Expected argument 'agent_settings' to be a list")
        pulumi.set(__self__, "agent_settings", agent_settings)
        if application_settings and not isinstance(application_settings, list):
            raise TypeError("Expected argument 'application_settings' to be a list")
        pulumi.set(__self__, "application_settings", application_settings)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_scan_recipe_id and not isinstance(host_scan_recipe_id, str):
            raise TypeError("Expected argument 'host_scan_recipe_id' to be a str")
        pulumi.set(__self__, "host_scan_recipe_id", host_scan_recipe_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if port_settings and not isinstance(port_settings, list):
            raise TypeError("Expected argument 'port_settings' to be a list")
        pulumi.set(__self__, "port_settings", port_settings)
        if schedules and not isinstance(schedules, list):
            raise TypeError("Expected argument 'schedules' to be a list")
        pulumi.set(__self__, "schedules", schedules)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="agentSettings")
    def agent_settings(self) -> Sequence['outputs.GetHostScanRecipeAgentSettingResult']:
        """
        Agent scan settings for a host scan
        """
        return pulumi.get(self, "agent_settings")

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Sequence['outputs.GetHostScanRecipeApplicationSettingResult']:
        """
        Agent scan settings for an application scan (as a part of a host scan)
        """
        return pulumi.get(self, "application_settings")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment ID of the scan recipe
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Recipe identifier, which can be renamed
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostScanRecipeId")
    def host_scan_recipe_id(self) -> str:
        return pulumi.get(self, "host_scan_recipe_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier of the config that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="portSettings")
    def port_settings(self) -> Sequence['outputs.GetHostScanRecipePortSettingResult']:
        """
        Port scan settings for a host scan
        """
        return pulumi.get(self, "port_settings")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetHostScanRecipeScheduleResult']:
        """
        A scanning schedule
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetHostScanRecipeResult(GetHostScanRecipeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostScanRecipeResult(
            agent_settings=self.agent_settings,
            application_settings=self.application_settings,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            host_scan_recipe_id=self.host_scan_recipe_id,
            id=self.id,
            port_settings=self.port_settings,
            schedules=self.schedules,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_host_scan_recipe(host_scan_recipe_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostScanRecipeResult:
    """
    This data source provides details about a specific Host Scan Recipe resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a HostScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned, and how often to scan.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_scan_recipe = oci.VulnerabilityScanning.get_host_scan_recipe(host_scan_recipe_id=oci_vulnerability_scanning_host_scan_recipe["test_host_scan_recipe"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str host_scan_recipe_id: unique HostScanRecipe identifier
    """
    __args__ = dict()
    __args__['hostScanRecipeId'] = host_scan_recipe_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VulnerabilityScanning/getHostScanRecipe:getHostScanRecipe', __args__, opts=opts, typ=GetHostScanRecipeResult).value

    return AwaitableGetHostScanRecipeResult(
        agent_settings=pulumi.get(__ret__, 'agent_settings'),
        application_settings=pulumi.get(__ret__, 'application_settings'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        host_scan_recipe_id=pulumi.get(__ret__, 'host_scan_recipe_id'),
        id=pulumi.get(__ret__, 'id'),
        port_settings=pulumi.get(__ret__, 'port_settings'),
        schedules=pulumi.get(__ret__, 'schedules'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_host_scan_recipe)
def get_host_scan_recipe_output(host_scan_recipe_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHostScanRecipeResult]:
    """
    This data source provides details about a specific Host Scan Recipe resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a HostScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned, and how often to scan.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_scan_recipe = oci.VulnerabilityScanning.get_host_scan_recipe(host_scan_recipe_id=oci_vulnerability_scanning_host_scan_recipe["test_host_scan_recipe"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str host_scan_recipe_id: unique HostScanRecipe identifier
    """
    ...
