"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return cdk.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return cdk.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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