# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CellularProfileFeatureTemplateArgs', 'CellularProfileFeatureTemplate']

@pulumi.input_type
class CellularProfileFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 access_point_name: Optional[pulumi.Input[builtins.str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 if_name: Optional[pulumi.Input[builtins.str]] = None,
                 if_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[builtins.str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[builtins.int]] = None,
                 profile_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_password: Optional[pulumi.Input[builtins.str]] = None,
                 profile_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_username: Optional[pulumi.Input[builtins.str]] = None,
                 profile_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CellularProfileFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] access_point_name: Set access point name
        :param pulumi.Input[builtins.str] access_point_name_variable: Variable name
        :param pulumi.Input[builtins.str] authentication_type: Set authentication type - Choices: `None`, `PAP`, `CHAP`, `PAP/CHAP` - Default value: `None`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] if_name: Set interface name
        :param pulumi.Input[builtins.str] if_name_variable: Variable name
        :param pulumi.Input[builtins.str] ip_address: Set IP address
        :param pulumi.Input[builtins.str] ip_address_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] packet_data_network_type: Set packet data network type - Choices: `ipv4`, `ipv6`, `ipv46`
        :param pulumi.Input[builtins.str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[builtins.str] primary_dns_address: Set the address of the primary DNS server
        :param pulumi.Input[builtins.str] primary_dns_address_variable: Variable name
        :param pulumi.Input[builtins.int] profile_id: Set Profile ID - Range: `1`-`16`
        :param pulumi.Input[builtins.str] profile_id_variable: Variable name
        :param pulumi.Input[builtins.str] profile_name: Set profile name
        :param pulumi.Input[builtins.str] profile_name_variable: Variable name
        :param pulumi.Input[builtins.str] profile_password: Set the profile password
        :param pulumi.Input[builtins.str] profile_password_variable: Variable name
        :param pulumi.Input[builtins.str] profile_username: Set the profile username
        :param pulumi.Input[builtins.str] profile_username_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address: Set the address of the secondary DNS server
        :param pulumi.Input[builtins.str] secondary_dns_address_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if access_point_name is not None:
            pulumi.set(__self__, "access_point_name", access_point_name)
        if access_point_name_variable is not None:
            pulumi.set(__self__, "access_point_name_variable", access_point_name_variable)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if if_name is not None:
            pulumi.set(__self__, "if_name", if_name)
        if if_name_variable is not None:
            pulumi.set(__self__, "if_name_variable", if_name_variable)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_variable is not None:
            pulumi.set(__self__, "ip_address_variable", ip_address_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if packet_data_network_type is not None:
            pulumi.set(__self__, "packet_data_network_type", packet_data_network_type)
        if packet_data_network_type_variable is not None:
            pulumi.set(__self__, "packet_data_network_type_variable", packet_data_network_type_variable)
        if primary_dns_address is not None:
            pulumi.set(__self__, "primary_dns_address", primary_dns_address)
        if primary_dns_address_variable is not None:
            pulumi.set(__self__, "primary_dns_address_variable", primary_dns_address_variable)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if profile_id_variable is not None:
            pulumi.set(__self__, "profile_id_variable", profile_id_variable)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if profile_name_variable is not None:
            pulumi.set(__self__, "profile_name_variable", profile_name_variable)
        if profile_password is not None:
            pulumi.set(__self__, "profile_password", profile_password)
        if profile_password_variable is not None:
            pulumi.set(__self__, "profile_password_variable", profile_password_variable)
        if profile_username is not None:
            pulumi.set(__self__, "profile_username", profile_username)
        if profile_username_variable is not None:
            pulumi.set(__self__, "profile_username_variable", profile_username_variable)
        if secondary_dns_address is not None:
            pulumi.set(__self__, "secondary_dns_address", secondary_dns_address)
        if secondary_dns_address_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_variable", secondary_dns_address_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @access_point_name.setter
    def access_point_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_point_name", value)

    @property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @access_point_name_variable.setter
    def access_point_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_point_name_variable", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set authentication type - Choices: `None`, `PAP`, `CHAP`, `PAP/CHAP` - Default value: `None`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @property
    @pulumi.getter(name="ifName")
    def if_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set interface name
        """
        return pulumi.get(self, "if_name")

    @if_name.setter
    def if_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "if_name", value)

    @property
    @pulumi.getter(name="ifNameVariable")
    def if_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "if_name_variable")

    @if_name_variable.setter
    def if_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "if_name_variable", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set IP address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @ip_address_variable.setter
    def ip_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set packet data network type - Choices: `ipv4`, `ipv6`, `ipv46`
        """
        return pulumi.get(self, "packet_data_network_type")

    @packet_data_network_type.setter
    def packet_data_network_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "packet_data_network_type", value)

    @property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @packet_data_network_type_variable.setter
    def packet_data_network_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "packet_data_network_type_variable", value)

    @property
    @pulumi.getter(name="primaryDnsAddress")
    def primary_dns_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the address of the primary DNS server
        """
        return pulumi.get(self, "primary_dns_address")

    @primary_dns_address.setter
    def primary_dns_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address", value)

    @property
    @pulumi.getter(name="primaryDnsAddressVariable")
    def primary_dns_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_variable")

    @primary_dns_address_variable.setter
    def primary_dns_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_variable", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set Profile ID - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @profile_id_variable.setter
    def profile_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_id_variable", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set profile name
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="profileNameVariable")
    def profile_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_name_variable")

    @profile_name_variable.setter
    def profile_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name_variable", value)

    @property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the profile password
        """
        return pulumi.get(self, "profile_password")

    @profile_password.setter
    def profile_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_password", value)

    @property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_password_variable")

    @profile_password_variable.setter
    def profile_password_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_password_variable", value)

    @property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the profile username
        """
        return pulumi.get(self, "profile_username")

    @profile_username.setter
    def profile_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_username", value)

    @property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_username_variable")

    @profile_username_variable.setter
    def profile_username_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_username_variable", value)

    @property
    @pulumi.getter(name="secondaryDnsAddress")
    def secondary_dns_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the address of the secondary DNS server
        """
        return pulumi.get(self, "secondary_dns_address")

    @secondary_dns_address.setter
    def secondary_dns_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressVariable")
    def secondary_dns_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_variable")

    @secondary_dns_address_variable.setter
    def secondary_dns_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_variable", value)


@pulumi.input_type
class _CellularProfileFeatureTemplateState:
    def __init__(__self__, *,
                 access_point_name: Optional[pulumi.Input[builtins.str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 if_name: Optional[pulumi.Input[builtins.str]] = None,
                 if_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[builtins.str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[builtins.int]] = None,
                 profile_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_password: Optional[pulumi.Input[builtins.str]] = None,
                 profile_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_username: Optional[pulumi.Input[builtins.str]] = None,
                 profile_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CellularProfileFeatureTemplate resources.
        :param pulumi.Input[builtins.str] access_point_name: Set access point name
        :param pulumi.Input[builtins.str] access_point_name_variable: Variable name
        :param pulumi.Input[builtins.str] authentication_type: Set authentication type - Choices: `None`, `PAP`, `CHAP`, `PAP/CHAP` - Default value: `None`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] if_name: Set interface name
        :param pulumi.Input[builtins.str] if_name_variable: Variable name
        :param pulumi.Input[builtins.str] ip_address: Set IP address
        :param pulumi.Input[builtins.str] ip_address_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] packet_data_network_type: Set packet data network type - Choices: `ipv4`, `ipv6`, `ipv46`
        :param pulumi.Input[builtins.str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[builtins.str] primary_dns_address: Set the address of the primary DNS server
        :param pulumi.Input[builtins.str] primary_dns_address_variable: Variable name
        :param pulumi.Input[builtins.int] profile_id: Set Profile ID - Range: `1`-`16`
        :param pulumi.Input[builtins.str] profile_id_variable: Variable name
        :param pulumi.Input[builtins.str] profile_name: Set profile name
        :param pulumi.Input[builtins.str] profile_name_variable: Variable name
        :param pulumi.Input[builtins.str] profile_password: Set the profile password
        :param pulumi.Input[builtins.str] profile_password_variable: Variable name
        :param pulumi.Input[builtins.str] profile_username: Set the profile username
        :param pulumi.Input[builtins.str] profile_username_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address: Set the address of the secondary DNS server
        :param pulumi.Input[builtins.str] secondary_dns_address_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if access_point_name is not None:
            pulumi.set(__self__, "access_point_name", access_point_name)
        if access_point_name_variable is not None:
            pulumi.set(__self__, "access_point_name_variable", access_point_name_variable)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if if_name is not None:
            pulumi.set(__self__, "if_name", if_name)
        if if_name_variable is not None:
            pulumi.set(__self__, "if_name_variable", if_name_variable)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_variable is not None:
            pulumi.set(__self__, "ip_address_variable", ip_address_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if packet_data_network_type is not None:
            pulumi.set(__self__, "packet_data_network_type", packet_data_network_type)
        if packet_data_network_type_variable is not None:
            pulumi.set(__self__, "packet_data_network_type_variable", packet_data_network_type_variable)
        if primary_dns_address is not None:
            pulumi.set(__self__, "primary_dns_address", primary_dns_address)
        if primary_dns_address_variable is not None:
            pulumi.set(__self__, "primary_dns_address_variable", primary_dns_address_variable)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if profile_id_variable is not None:
            pulumi.set(__self__, "profile_id_variable", profile_id_variable)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if profile_name_variable is not None:
            pulumi.set(__self__, "profile_name_variable", profile_name_variable)
        if profile_password is not None:
            pulumi.set(__self__, "profile_password", profile_password)
        if profile_password_variable is not None:
            pulumi.set(__self__, "profile_password_variable", profile_password_variable)
        if profile_username is not None:
            pulumi.set(__self__, "profile_username", profile_username)
        if profile_username_variable is not None:
            pulumi.set(__self__, "profile_username_variable", profile_username_variable)
        if secondary_dns_address is not None:
            pulumi.set(__self__, "secondary_dns_address", secondary_dns_address)
        if secondary_dns_address_variable is not None:
            pulumi.set(__self__, "secondary_dns_address_variable", secondary_dns_address_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @access_point_name.setter
    def access_point_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_point_name", value)

    @property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @access_point_name_variable.setter
    def access_point_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_point_name_variable", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set authentication type - Choices: `None`, `PAP`, `CHAP`, `PAP/CHAP` - Default value: `None`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="ifName")
    def if_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set interface name
        """
        return pulumi.get(self, "if_name")

    @if_name.setter
    def if_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "if_name", value)

    @property
    @pulumi.getter(name="ifNameVariable")
    def if_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "if_name_variable")

    @if_name_variable.setter
    def if_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "if_name_variable", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set IP address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @ip_address_variable.setter
    def ip_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set packet data network type - Choices: `ipv4`, `ipv6`, `ipv46`
        """
        return pulumi.get(self, "packet_data_network_type")

    @packet_data_network_type.setter
    def packet_data_network_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "packet_data_network_type", value)

    @property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @packet_data_network_type_variable.setter
    def packet_data_network_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "packet_data_network_type_variable", value)

    @property
    @pulumi.getter(name="primaryDnsAddress")
    def primary_dns_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the address of the primary DNS server
        """
        return pulumi.get(self, "primary_dns_address")

    @primary_dns_address.setter
    def primary_dns_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address", value)

    @property
    @pulumi.getter(name="primaryDnsAddressVariable")
    def primary_dns_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_variable")

    @primary_dns_address_variable.setter
    def primary_dns_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dns_address_variable", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set Profile ID - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @profile_id_variable.setter
    def profile_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_id_variable", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set profile name
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="profileNameVariable")
    def profile_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_name_variable")

    @profile_name_variable.setter
    def profile_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name_variable", value)

    @property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the profile password
        """
        return pulumi.get(self, "profile_password")

    @profile_password.setter
    def profile_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_password", value)

    @property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_password_variable")

    @profile_password_variable.setter
    def profile_password_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_password_variable", value)

    @property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the profile username
        """
        return pulumi.get(self, "profile_username")

    @profile_username.setter
    def profile_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_username", value)

    @property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_username_variable")

    @profile_username_variable.setter
    def profile_username_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_username_variable", value)

    @property
    @pulumi.getter(name="secondaryDnsAddress")
    def secondary_dns_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the address of the secondary DNS server
        """
        return pulumi.get(self, "secondary_dns_address")

    @secondary_dns_address.setter
    def secondary_dns_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address", value)

    @property
    @pulumi.getter(name="secondaryDnsAddressVariable")
    def secondary_dns_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_variable")

    @secondary_dns_address_variable.setter
    def secondary_dns_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dns_address_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/cellularProfileFeatureTemplate:CellularProfileFeatureTemplate")
class CellularProfileFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_name: Optional[pulumi.Input[builtins.str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 if_name: Optional[pulumi.Input[builtins.str]] = None,
                 if_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[builtins.str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[builtins.int]] = None,
                 profile_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_password: Optional[pulumi.Input[builtins.str]] = None,
                 profile_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_username: Optional[pulumi.Input[builtins.str]] = None,
                 profile_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cellular Profile feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CellularProfileFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            if_name="Ethernet1",
            profile_id=1,
            access_point_name="APN1",
            authentication_type="CHAP",
            ip_address="1.2.3.4",
            profile_name="PROFILE1",
            packet_data_network_type="ipv4",
            profile_username="MyUsername",
            profile_password="MyPassword",
            primary_dns_address="1.2.3.4",
            secondary_dns_address="1.2.3.5")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/cellularProfileFeatureTemplate:CellularProfileFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_point_name: Set access point name
        :param pulumi.Input[builtins.str] access_point_name_variable: Variable name
        :param pulumi.Input[builtins.str] authentication_type: Set authentication type - Choices: `None`, `PAP`, `CHAP`, `PAP/CHAP` - Default value: `None`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] if_name: Set interface name
        :param pulumi.Input[builtins.str] if_name_variable: Variable name
        :param pulumi.Input[builtins.str] ip_address: Set IP address
        :param pulumi.Input[builtins.str] ip_address_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] packet_data_network_type: Set packet data network type - Choices: `ipv4`, `ipv6`, `ipv46`
        :param pulumi.Input[builtins.str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[builtins.str] primary_dns_address: Set the address of the primary DNS server
        :param pulumi.Input[builtins.str] primary_dns_address_variable: Variable name
        :param pulumi.Input[builtins.int] profile_id: Set Profile ID - Range: `1`-`16`
        :param pulumi.Input[builtins.str] profile_id_variable: Variable name
        :param pulumi.Input[builtins.str] profile_name: Set profile name
        :param pulumi.Input[builtins.str] profile_name_variable: Variable name
        :param pulumi.Input[builtins.str] profile_password: Set the profile password
        :param pulumi.Input[builtins.str] profile_password_variable: Variable name
        :param pulumi.Input[builtins.str] profile_username: Set the profile username
        :param pulumi.Input[builtins.str] profile_username_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address: Set the address of the secondary DNS server
        :param pulumi.Input[builtins.str] secondary_dns_address_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CellularProfileFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cellular Profile feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CellularProfileFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            if_name="Ethernet1",
            profile_id=1,
            access_point_name="APN1",
            authentication_type="CHAP",
            ip_address="1.2.3.4",
            profile_name="PROFILE1",
            packet_data_network_type="ipv4",
            profile_username="MyUsername",
            profile_password="MyPassword",
            primary_dns_address="1.2.3.4",
            secondary_dns_address="1.2.3.5")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/cellularProfileFeatureTemplate:CellularProfileFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CellularProfileFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CellularProfileFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_name: Optional[pulumi.Input[builtins.str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 if_name: Optional[pulumi.Input[builtins.str]] = None,
                 if_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[builtins.str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[builtins.int]] = None,
                 profile_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_password: Optional[pulumi.Input[builtins.str]] = None,
                 profile_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 profile_username: Optional[pulumi.Input[builtins.str]] = None,
                 profile_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CellularProfileFeatureTemplateArgs.__new__(CellularProfileFeatureTemplateArgs)

            __props__.__dict__["access_point_name"] = access_point_name
            __props__.__dict__["access_point_name_variable"] = access_point_name_variable
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["authentication_type_variable"] = authentication_type_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["if_name"] = if_name
            __props__.__dict__["if_name_variable"] = if_name_variable
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ip_address_variable"] = ip_address_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["packet_data_network_type"] = packet_data_network_type
            __props__.__dict__["packet_data_network_type_variable"] = packet_data_network_type_variable
            __props__.__dict__["primary_dns_address"] = primary_dns_address
            __props__.__dict__["primary_dns_address_variable"] = primary_dns_address_variable
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["profile_id_variable"] = profile_id_variable
            __props__.__dict__["profile_name"] = profile_name
            __props__.__dict__["profile_name_variable"] = profile_name_variable
            __props__.__dict__["profile_password"] = profile_password
            __props__.__dict__["profile_password_variable"] = profile_password_variable
            __props__.__dict__["profile_username"] = profile_username
            __props__.__dict__["profile_username_variable"] = profile_username_variable
            __props__.__dict__["secondary_dns_address"] = secondary_dns_address
            __props__.__dict__["secondary_dns_address_variable"] = secondary_dns_address_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CellularProfileFeatureTemplate, __self__).__init__(
            'sdwan:index/cellularProfileFeatureTemplate:CellularProfileFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_name: Optional[pulumi.Input[builtins.str]] = None,
            access_point_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            authentication_type: Optional[pulumi.Input[builtins.str]] = None,
            authentication_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            if_name: Optional[pulumi.Input[builtins.str]] = None,
            if_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            ip_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            packet_data_network_type: Optional[pulumi.Input[builtins.str]] = None,
            packet_data_network_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            primary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
            primary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            profile_id: Optional[pulumi.Input[builtins.int]] = None,
            profile_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            profile_name: Optional[pulumi.Input[builtins.str]] = None,
            profile_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            profile_password: Optional[pulumi.Input[builtins.str]] = None,
            profile_password_variable: Optional[pulumi.Input[builtins.str]] = None,
            profile_username: Optional[pulumi.Input[builtins.str]] = None,
            profile_username_variable: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dns_address: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dns_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CellularProfileFeatureTemplate':
        """
        Get an existing CellularProfileFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_point_name: Set access point name
        :param pulumi.Input[builtins.str] access_point_name_variable: Variable name
        :param pulumi.Input[builtins.str] authentication_type: Set authentication type - Choices: `None`, `PAP`, `CHAP`, `PAP/CHAP` - Default value: `None`
        :param pulumi.Input[builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] if_name: Set interface name
        :param pulumi.Input[builtins.str] if_name_variable: Variable name
        :param pulumi.Input[builtins.str] ip_address: Set IP address
        :param pulumi.Input[builtins.str] ip_address_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] packet_data_network_type: Set packet data network type - Choices: `ipv4`, `ipv6`, `ipv46`
        :param pulumi.Input[builtins.str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[builtins.str] primary_dns_address: Set the address of the primary DNS server
        :param pulumi.Input[builtins.str] primary_dns_address_variable: Variable name
        :param pulumi.Input[builtins.int] profile_id: Set Profile ID - Range: `1`-`16`
        :param pulumi.Input[builtins.str] profile_id_variable: Variable name
        :param pulumi.Input[builtins.str] profile_name: Set profile name
        :param pulumi.Input[builtins.str] profile_name_variable: Variable name
        :param pulumi.Input[builtins.str] profile_password: Set the profile password
        :param pulumi.Input[builtins.str] profile_password_variable: Variable name
        :param pulumi.Input[builtins.str] profile_username: Set the profile username
        :param pulumi.Input[builtins.str] profile_username_variable: Variable name
        :param pulumi.Input[builtins.str] secondary_dns_address: Set the address of the secondary DNS server
        :param pulumi.Input[builtins.str] secondary_dns_address_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CellularProfileFeatureTemplateState.__new__(_CellularProfileFeatureTemplateState)

        __props__.__dict__["access_point_name"] = access_point_name
        __props__.__dict__["access_point_name_variable"] = access_point_name_variable
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["authentication_type_variable"] = authentication_type_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["if_name"] = if_name
        __props__.__dict__["if_name_variable"] = if_name_variable
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_address_variable"] = ip_address_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["packet_data_network_type"] = packet_data_network_type
        __props__.__dict__["packet_data_network_type_variable"] = packet_data_network_type_variable
        __props__.__dict__["primary_dns_address"] = primary_dns_address
        __props__.__dict__["primary_dns_address_variable"] = primary_dns_address_variable
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["profile_id_variable"] = profile_id_variable
        __props__.__dict__["profile_name"] = profile_name
        __props__.__dict__["profile_name_variable"] = profile_name_variable
        __props__.__dict__["profile_password"] = profile_password
        __props__.__dict__["profile_password_variable"] = profile_password_variable
        __props__.__dict__["profile_username"] = profile_username
        __props__.__dict__["profile_username_variable"] = profile_username_variable
        __props__.__dict__["secondary_dns_address"] = secondary_dns_address
        __props__.__dict__["secondary_dns_address_variable"] = secondary_dns_address_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CellularProfileFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set authentication type - Choices: `None`, `PAP`, `CHAP`, `PAP/CHAP` - Default value: `None`
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="ifName")
    def if_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set interface name
        """
        return pulumi.get(self, "if_name")

    @property
    @pulumi.getter(name="ifNameVariable")
    def if_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "if_name_variable")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set IP address
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipAddressVariable")
    def ip_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_address_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set packet data network type - Choices: `ipv4`, `ipv6`, `ipv46`
        """
        return pulumi.get(self, "packet_data_network_type")

    @property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @property
    @pulumi.getter(name="primaryDnsAddress")
    def primary_dns_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the address of the primary DNS server
        """
        return pulumi.get(self, "primary_dns_address")

    @property
    @pulumi.getter(name="primaryDnsAddressVariable")
    def primary_dns_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_dns_address_variable")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set Profile ID - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set profile name
        """
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="profileNameVariable")
    def profile_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_name_variable")

    @property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the profile password
        """
        return pulumi.get(self, "profile_password")

    @property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_password_variable")

    @property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the profile username
        """
        return pulumi.get(self, "profile_username")

    @property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_username_variable")

    @property
    @pulumi.getter(name="secondaryDnsAddress")
    def secondary_dns_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the address of the secondary DNS server
        """
        return pulumi.get(self, "secondary_dns_address")

    @property
    @pulumi.getter(name="secondaryDnsAddressVariable")
    def secondary_dns_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_dns_address_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

