# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoNtpFeatureTemplateArgs', 'CiscoNtpFeatureTemplate']

@pulumi.input_type
class CiscoNtpFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateAuthenticationKeyArgs']]]] = None,
                 master: Optional[pulumi.Input[builtins.bool]] = None,
                 master_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 master_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 master_stratum: Optional[pulumi.Input[builtins.int]] = None,
                 master_stratum_variable: Optional[pulumi.Input[builtins.str]] = None,
                 master_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateServerArgs']]]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CiscoNtpFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateAuthenticationKeyArgs']]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[builtins.bool] master: Configure device as NTP master - Default value: `false`
        :param pulumi.Input[builtins.str] master_source_interface: Set interface for NTP Master
        :param pulumi.Input[builtins.str] master_source_interface_variable: Variable name
        :param pulumi.Input[builtins.int] master_stratum: Master Stratum <1..15> - Range: `1`-`15`
        :param pulumi.Input[builtins.str] master_stratum_variable: Variable name
        :param pulumi.Input[builtins.str] master_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateServerArgs']]] servers: Configure NTP servers
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[builtins.str] trusted_keys_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if authentication_keys is not None:
            pulumi.set(__self__, "authentication_keys", authentication_keys)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if master_source_interface is not None:
            pulumi.set(__self__, "master_source_interface", master_source_interface)
        if master_source_interface_variable is not None:
            pulumi.set(__self__, "master_source_interface_variable", master_source_interface_variable)
        if master_stratum is not None:
            pulumi.set(__self__, "master_stratum", master_stratum)
        if master_stratum_variable is not None:
            pulumi.set(__self__, "master_stratum_variable", master_stratum_variable)
        if master_variable is not None:
            pulumi.set(__self__, "master_variable", master_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if trusted_keys is not None:
            pulumi.set(__self__, "trusted_keys", trusted_keys)
        if trusted_keys_variable is not None:
            pulumi.set(__self__, "trusted_keys_variable", trusted_keys_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateAuthenticationKeyArgs']]]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @authentication_keys.setter
    def authentication_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateAuthenticationKeyArgs']]]]):
        pulumi.set(self, "authentication_keys", value)

    @property
    @pulumi.getter
    def master(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Configure device as NTP master - Default value: `false`
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "master", value)

    @property
    @pulumi.getter(name="masterSourceInterface")
    def master_source_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set interface for NTP Master
        """
        return pulumi.get(self, "master_source_interface")

    @master_source_interface.setter
    def master_source_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_source_interface", value)

    @property
    @pulumi.getter(name="masterSourceInterfaceVariable")
    def master_source_interface_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_source_interface_variable")

    @master_source_interface_variable.setter
    def master_source_interface_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_source_interface_variable", value)

    @property
    @pulumi.getter(name="masterStratum")
    def master_stratum(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Master Stratum <1..15> - Range: `1`-`15`
        """
        return pulumi.get(self, "master_stratum")

    @master_stratum.setter
    def master_stratum(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "master_stratum", value)

    @property
    @pulumi.getter(name="masterStratumVariable")
    def master_stratum_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_stratum_variable")

    @master_stratum_variable.setter
    def master_stratum_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_stratum_variable", value)

    @property
    @pulumi.getter(name="masterVariable")
    def master_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_variable")

    @master_variable.setter
    def master_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateServerArgs']]]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @trusted_keys.setter
    def trusted_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "trusted_keys", value)

    @property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @trusted_keys_variable.setter
    def trusted_keys_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trusted_keys_variable", value)


@pulumi.input_type
class _CiscoNtpFeatureTemplateState:
    def __init__(__self__, *,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateAuthenticationKeyArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 master: Optional[pulumi.Input[builtins.bool]] = None,
                 master_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 master_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 master_stratum: Optional[pulumi.Input[builtins.int]] = None,
                 master_stratum_variable: Optional[pulumi.Input[builtins.str]] = None,
                 master_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateServerArgs']]]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CiscoNtpFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateAuthenticationKeyArgs']]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] master: Configure device as NTP master - Default value: `false`
        :param pulumi.Input[builtins.str] master_source_interface: Set interface for NTP Master
        :param pulumi.Input[builtins.str] master_source_interface_variable: Variable name
        :param pulumi.Input[builtins.int] master_stratum: Master Stratum <1..15> - Range: `1`-`15`
        :param pulumi.Input[builtins.str] master_stratum_variable: Variable name
        :param pulumi.Input[builtins.str] master_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateServerArgs']]] servers: Configure NTP servers
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[builtins.str] trusted_keys_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if authentication_keys is not None:
            pulumi.set(__self__, "authentication_keys", authentication_keys)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if master_source_interface is not None:
            pulumi.set(__self__, "master_source_interface", master_source_interface)
        if master_source_interface_variable is not None:
            pulumi.set(__self__, "master_source_interface_variable", master_source_interface_variable)
        if master_stratum is not None:
            pulumi.set(__self__, "master_stratum", master_stratum)
        if master_stratum_variable is not None:
            pulumi.set(__self__, "master_stratum_variable", master_stratum_variable)
        if master_variable is not None:
            pulumi.set(__self__, "master_variable", master_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if trusted_keys is not None:
            pulumi.set(__self__, "trusted_keys", trusted_keys)
        if trusted_keys_variable is not None:
            pulumi.set(__self__, "trusted_keys_variable", trusted_keys_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateAuthenticationKeyArgs']]]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @authentication_keys.setter
    def authentication_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateAuthenticationKeyArgs']]]]):
        pulumi.set(self, "authentication_keys", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def master(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Configure device as NTP master - Default value: `false`
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "master", value)

    @property
    @pulumi.getter(name="masterSourceInterface")
    def master_source_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set interface for NTP Master
        """
        return pulumi.get(self, "master_source_interface")

    @master_source_interface.setter
    def master_source_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_source_interface", value)

    @property
    @pulumi.getter(name="masterSourceInterfaceVariable")
    def master_source_interface_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_source_interface_variable")

    @master_source_interface_variable.setter
    def master_source_interface_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_source_interface_variable", value)

    @property
    @pulumi.getter(name="masterStratum")
    def master_stratum(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Master Stratum <1..15> - Range: `1`-`15`
        """
        return pulumi.get(self, "master_stratum")

    @master_stratum.setter
    def master_stratum(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "master_stratum", value)

    @property
    @pulumi.getter(name="masterStratumVariable")
    def master_stratum_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_stratum_variable")

    @master_stratum_variable.setter
    def master_stratum_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_stratum_variable", value)

    @property
    @pulumi.getter(name="masterVariable")
    def master_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_variable")

    @master_variable.setter
    def master_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateServerArgs']]]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoNtpFeatureTemplateServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @trusted_keys.setter
    def trusted_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "trusted_keys", value)

    @property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @trusted_keys_variable.setter
    def trusted_keys_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trusted_keys_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/ciscoNtpFeatureTemplate:CiscoNtpFeatureTemplate")
class CiscoNtpFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateAuthenticationKeyArgs', 'CiscoNtpFeatureTemplateAuthenticationKeyArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 master: Optional[pulumi.Input[builtins.bool]] = None,
                 master_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 master_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 master_stratum: Optional[pulumi.Input[builtins.int]] = None,
                 master_stratum_variable: Optional[pulumi.Input[builtins.str]] = None,
                 master_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateServerArgs', 'CiscoNtpFeatureTemplateServerArgsDict']]]]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco NTP feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoNtpFeatureTemplate:CiscoNtpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateAuthenticationKeyArgs', 'CiscoNtpFeatureTemplateAuthenticationKeyArgsDict']]]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] master: Configure device as NTP master - Default value: `false`
        :param pulumi.Input[builtins.str] master_source_interface: Set interface for NTP Master
        :param pulumi.Input[builtins.str] master_source_interface_variable: Variable name
        :param pulumi.Input[builtins.int] master_stratum: Master Stratum <1..15> - Range: `1`-`15`
        :param pulumi.Input[builtins.str] master_stratum_variable: Variable name
        :param pulumi.Input[builtins.str] master_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateServerArgs', 'CiscoNtpFeatureTemplateServerArgsDict']]]] servers: Configure NTP servers
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[builtins.str] trusted_keys_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoNtpFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco NTP feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoNtpFeatureTemplate:CiscoNtpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoNtpFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoNtpFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateAuthenticationKeyArgs', 'CiscoNtpFeatureTemplateAuthenticationKeyArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 master: Optional[pulumi.Input[builtins.bool]] = None,
                 master_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 master_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 master_stratum: Optional[pulumi.Input[builtins.int]] = None,
                 master_stratum_variable: Optional[pulumi.Input[builtins.str]] = None,
                 master_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateServerArgs', 'CiscoNtpFeatureTemplateServerArgsDict']]]]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoNtpFeatureTemplateArgs.__new__(CiscoNtpFeatureTemplateArgs)

            __props__.__dict__["authentication_keys"] = authentication_keys
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["master"] = master
            __props__.__dict__["master_source_interface"] = master_source_interface
            __props__.__dict__["master_source_interface_variable"] = master_source_interface_variable
            __props__.__dict__["master_stratum"] = master_stratum
            __props__.__dict__["master_stratum_variable"] = master_stratum_variable
            __props__.__dict__["master_variable"] = master_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["servers"] = servers
            __props__.__dict__["trusted_keys"] = trusted_keys
            __props__.__dict__["trusted_keys_variable"] = trusted_keys_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoNtpFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoNtpFeatureTemplate:CiscoNtpFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateAuthenticationKeyArgs', 'CiscoNtpFeatureTemplateAuthenticationKeyArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            master: Optional[pulumi.Input[builtins.bool]] = None,
            master_source_interface: Optional[pulumi.Input[builtins.str]] = None,
            master_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
            master_stratum: Optional[pulumi.Input[builtins.int]] = None,
            master_stratum_variable: Optional[pulumi.Input[builtins.str]] = None,
            master_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateServerArgs', 'CiscoNtpFeatureTemplateServerArgsDict']]]]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            trusted_keys_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CiscoNtpFeatureTemplate':
        """
        Get an existing CiscoNtpFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateAuthenticationKeyArgs', 'CiscoNtpFeatureTemplateAuthenticationKeyArgsDict']]]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] master: Configure device as NTP master - Default value: `false`
        :param pulumi.Input[builtins.str] master_source_interface: Set interface for NTP Master
        :param pulumi.Input[builtins.str] master_source_interface_variable: Variable name
        :param pulumi.Input[builtins.int] master_stratum: Master Stratum <1..15> - Range: `1`-`15`
        :param pulumi.Input[builtins.str] master_stratum_variable: Variable name
        :param pulumi.Input[builtins.str] master_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoNtpFeatureTemplateServerArgs', 'CiscoNtpFeatureTemplateServerArgsDict']]]] servers: Configure NTP servers
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[builtins.str] trusted_keys_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoNtpFeatureTemplateState.__new__(_CiscoNtpFeatureTemplateState)

        __props__.__dict__["authentication_keys"] = authentication_keys
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["master"] = master
        __props__.__dict__["master_source_interface"] = master_source_interface
        __props__.__dict__["master_source_interface_variable"] = master_source_interface_variable
        __props__.__dict__["master_stratum"] = master_stratum
        __props__.__dict__["master_stratum_variable"] = master_stratum_variable
        __props__.__dict__["master_variable"] = master_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["servers"] = servers
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["trusted_keys"] = trusted_keys
        __props__.__dict__["trusted_keys_variable"] = trusted_keys_variable
        __props__.__dict__["version"] = version
        return CiscoNtpFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoNtpFeatureTemplateAuthenticationKey']]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def master(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Configure device as NTP master - Default value: `false`
        """
        return pulumi.get(self, "master")

    @property
    @pulumi.getter(name="masterSourceInterface")
    def master_source_interface(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set interface for NTP Master
        """
        return pulumi.get(self, "master_source_interface")

    @property
    @pulumi.getter(name="masterSourceInterfaceVariable")
    def master_source_interface_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_source_interface_variable")

    @property
    @pulumi.getter(name="masterStratum")
    def master_stratum(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Master Stratum <1..15> - Range: `1`-`15`
        """
        return pulumi.get(self, "master_stratum")

    @property
    @pulumi.getter(name="masterStratumVariable")
    def master_stratum_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_stratum_variable")

    @property
    @pulumi.getter(name="masterVariable")
    def master_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "master_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoNtpFeatureTemplateServer']]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

