# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CiscoSigCredentialsFeatureTemplateArgs', 'CiscoSigCredentialsFeatureTemplate']

@pulumi.input_type
class CiscoSigCredentialsFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_secret: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_secret_variable: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_organization_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_cloud_name: Optional[pulumi.Input[builtins.int]] = None,
                 zscaler_cloud_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_organization: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_organization_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_base_uri: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_base_uri_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_password: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_username: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_password: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_username: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_username_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CiscoSigCredentialsFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] umbrella_api_key: API Key
        :param pulumi.Input[builtins.str] umbrella_api_key_variable: Variable name
        :param pulumi.Input[builtins.str] umbrella_api_secret: API Secret
        :param pulumi.Input[builtins.str] umbrella_api_secret_variable: Variable name
        :param pulumi.Input[builtins.str] umbrella_organization_id: Ord ID
        :param pulumi.Input[builtins.str] umbrella_organization_id_variable: Variable name
        :param pulumi.Input[builtins.int] zscaler_cloud_name: Third Party Cloud Name - Range: `0`-`255`
        :param pulumi.Input[builtins.str] zscaler_cloud_name_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_organization: Organization Name
        :param pulumi.Input[builtins.str] zscaler_organization_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_api_key: Partner API Key
        :param pulumi.Input[builtins.str] zscaler_partner_api_key_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_base_uri: Partner Base URI to be used in REST calls
        :param pulumi.Input[builtins.str] zscaler_partner_base_uri_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_password: Partner Password
        :param pulumi.Input[builtins.str] zscaler_partner_password_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_username: Partner User Name
        :param pulumi.Input[builtins.str] zscaler_partner_username_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_password: Password of Zscaler partner account
        :param pulumi.Input[builtins.str] zscaler_password_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_username: Username of Zscaler partner account
        :param pulumi.Input[builtins.str] zscaler_username_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if umbrella_api_key is not None:
            pulumi.set(__self__, "umbrella_api_key", umbrella_api_key)
        if umbrella_api_key_variable is not None:
            pulumi.set(__self__, "umbrella_api_key_variable", umbrella_api_key_variable)
        if umbrella_api_secret is not None:
            pulumi.set(__self__, "umbrella_api_secret", umbrella_api_secret)
        if umbrella_api_secret_variable is not None:
            pulumi.set(__self__, "umbrella_api_secret_variable", umbrella_api_secret_variable)
        if umbrella_organization_id is not None:
            pulumi.set(__self__, "umbrella_organization_id", umbrella_organization_id)
        if umbrella_organization_id_variable is not None:
            pulumi.set(__self__, "umbrella_organization_id_variable", umbrella_organization_id_variable)
        if zscaler_cloud_name is not None:
            pulumi.set(__self__, "zscaler_cloud_name", zscaler_cloud_name)
        if zscaler_cloud_name_variable is not None:
            pulumi.set(__self__, "zscaler_cloud_name_variable", zscaler_cloud_name_variable)
        if zscaler_organization is not None:
            pulumi.set(__self__, "zscaler_organization", zscaler_organization)
        if zscaler_organization_variable is not None:
            pulumi.set(__self__, "zscaler_organization_variable", zscaler_organization_variable)
        if zscaler_partner_api_key is not None:
            pulumi.set(__self__, "zscaler_partner_api_key", zscaler_partner_api_key)
        if zscaler_partner_api_key_variable is not None:
            pulumi.set(__self__, "zscaler_partner_api_key_variable", zscaler_partner_api_key_variable)
        if zscaler_partner_base_uri is not None:
            pulumi.set(__self__, "zscaler_partner_base_uri", zscaler_partner_base_uri)
        if zscaler_partner_base_uri_variable is not None:
            pulumi.set(__self__, "zscaler_partner_base_uri_variable", zscaler_partner_base_uri_variable)
        if zscaler_partner_password is not None:
            pulumi.set(__self__, "zscaler_partner_password", zscaler_partner_password)
        if zscaler_partner_password_variable is not None:
            pulumi.set(__self__, "zscaler_partner_password_variable", zscaler_partner_password_variable)
        if zscaler_partner_username is not None:
            pulumi.set(__self__, "zscaler_partner_username", zscaler_partner_username)
        if zscaler_partner_username_variable is not None:
            pulumi.set(__self__, "zscaler_partner_username_variable", zscaler_partner_username_variable)
        if zscaler_password is not None:
            pulumi.set(__self__, "zscaler_password", zscaler_password)
        if zscaler_password_variable is not None:
            pulumi.set(__self__, "zscaler_password_variable", zscaler_password_variable)
        if zscaler_username is not None:
            pulumi.set(__self__, "zscaler_username", zscaler_username)
        if zscaler_username_variable is not None:
            pulumi.set(__self__, "zscaler_username_variable", zscaler_username_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="umbrellaApiKey")
    def umbrella_api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API Key
        """
        return pulumi.get(self, "umbrella_api_key")

    @umbrella_api_key.setter
    def umbrella_api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_api_key", value)

    @property
    @pulumi.getter(name="umbrellaApiKeyVariable")
    def umbrella_api_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_api_key_variable")

    @umbrella_api_key_variable.setter
    def umbrella_api_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_api_key_variable", value)

    @property
    @pulumi.getter(name="umbrellaApiSecret")
    def umbrella_api_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API Secret
        """
        return pulumi.get(self, "umbrella_api_secret")

    @umbrella_api_secret.setter
    def umbrella_api_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_api_secret", value)

    @property
    @pulumi.getter(name="umbrellaApiSecretVariable")
    def umbrella_api_secret_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_api_secret_variable")

    @umbrella_api_secret_variable.setter
    def umbrella_api_secret_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_api_secret_variable", value)

    @property
    @pulumi.getter(name="umbrellaOrganizationId")
    def umbrella_organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Ord ID
        """
        return pulumi.get(self, "umbrella_organization_id")

    @umbrella_organization_id.setter
    def umbrella_organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_organization_id", value)

    @property
    @pulumi.getter(name="umbrellaOrganizationIdVariable")
    def umbrella_organization_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_organization_id_variable")

    @umbrella_organization_id_variable.setter
    def umbrella_organization_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_organization_id_variable", value)

    @property
    @pulumi.getter(name="zscalerCloudName")
    def zscaler_cloud_name(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Third Party Cloud Name - Range: `0`-`255`
        """
        return pulumi.get(self, "zscaler_cloud_name")

    @zscaler_cloud_name.setter
    def zscaler_cloud_name(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zscaler_cloud_name", value)

    @property
    @pulumi.getter(name="zscalerCloudNameVariable")
    def zscaler_cloud_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_cloud_name_variable")

    @zscaler_cloud_name_variable.setter
    def zscaler_cloud_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_cloud_name_variable", value)

    @property
    @pulumi.getter(name="zscalerOrganization")
    def zscaler_organization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization Name
        """
        return pulumi.get(self, "zscaler_organization")

    @zscaler_organization.setter
    def zscaler_organization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_organization", value)

    @property
    @pulumi.getter(name="zscalerOrganizationVariable")
    def zscaler_organization_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_organization_variable")

    @zscaler_organization_variable.setter
    def zscaler_organization_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_organization_variable", value)

    @property
    @pulumi.getter(name="zscalerPartnerApiKey")
    def zscaler_partner_api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partner API Key
        """
        return pulumi.get(self, "zscaler_partner_api_key")

    @zscaler_partner_api_key.setter
    def zscaler_partner_api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_api_key", value)

    @property
    @pulumi.getter(name="zscalerPartnerApiKeyVariable")
    def zscaler_partner_api_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_api_key_variable")

    @zscaler_partner_api_key_variable.setter
    def zscaler_partner_api_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_api_key_variable", value)

    @property
    @pulumi.getter(name="zscalerPartnerBaseUri")
    def zscaler_partner_base_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partner Base URI to be used in REST calls
        """
        return pulumi.get(self, "zscaler_partner_base_uri")

    @zscaler_partner_base_uri.setter
    def zscaler_partner_base_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_base_uri", value)

    @property
    @pulumi.getter(name="zscalerPartnerBaseUriVariable")
    def zscaler_partner_base_uri_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_base_uri_variable")

    @zscaler_partner_base_uri_variable.setter
    def zscaler_partner_base_uri_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_base_uri_variable", value)

    @property
    @pulumi.getter(name="zscalerPartnerPassword")
    def zscaler_partner_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partner Password
        """
        return pulumi.get(self, "zscaler_partner_password")

    @zscaler_partner_password.setter
    def zscaler_partner_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_password", value)

    @property
    @pulumi.getter(name="zscalerPartnerPasswordVariable")
    def zscaler_partner_password_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_password_variable")

    @zscaler_partner_password_variable.setter
    def zscaler_partner_password_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_password_variable", value)

    @property
    @pulumi.getter(name="zscalerPartnerUsername")
    def zscaler_partner_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partner User Name
        """
        return pulumi.get(self, "zscaler_partner_username")

    @zscaler_partner_username.setter
    def zscaler_partner_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_username", value)

    @property
    @pulumi.getter(name="zscalerPartnerUsernameVariable")
    def zscaler_partner_username_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_username_variable")

    @zscaler_partner_username_variable.setter
    def zscaler_partner_username_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_username_variable", value)

    @property
    @pulumi.getter(name="zscalerPassword")
    def zscaler_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password of Zscaler partner account
        """
        return pulumi.get(self, "zscaler_password")

    @zscaler_password.setter
    def zscaler_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_password", value)

    @property
    @pulumi.getter(name="zscalerPasswordVariable")
    def zscaler_password_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_password_variable")

    @zscaler_password_variable.setter
    def zscaler_password_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_password_variable", value)

    @property
    @pulumi.getter(name="zscalerUsername")
    def zscaler_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username of Zscaler partner account
        """
        return pulumi.get(self, "zscaler_username")

    @zscaler_username.setter
    def zscaler_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_username", value)

    @property
    @pulumi.getter(name="zscalerUsernameVariable")
    def zscaler_username_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_username_variable")

    @zscaler_username_variable.setter
    def zscaler_username_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_username_variable", value)


@pulumi.input_type
class _CiscoSigCredentialsFeatureTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_secret: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_secret_variable: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_organization_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None,
                 zscaler_cloud_name: Optional[pulumi.Input[builtins.int]] = None,
                 zscaler_cloud_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_organization: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_organization_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_base_uri: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_base_uri_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_password: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_username: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_password: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_username: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_username_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CiscoSigCredentialsFeatureTemplate resources.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.str] umbrella_api_key: API Key
        :param pulumi.Input[builtins.str] umbrella_api_key_variable: Variable name
        :param pulumi.Input[builtins.str] umbrella_api_secret: API Secret
        :param pulumi.Input[builtins.str] umbrella_api_secret_variable: Variable name
        :param pulumi.Input[builtins.str] umbrella_organization_id: Ord ID
        :param pulumi.Input[builtins.str] umbrella_organization_id_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the feature template
        :param pulumi.Input[builtins.int] zscaler_cloud_name: Third Party Cloud Name - Range: `0`-`255`
        :param pulumi.Input[builtins.str] zscaler_cloud_name_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_organization: Organization Name
        :param pulumi.Input[builtins.str] zscaler_organization_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_api_key: Partner API Key
        :param pulumi.Input[builtins.str] zscaler_partner_api_key_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_base_uri: Partner Base URI to be used in REST calls
        :param pulumi.Input[builtins.str] zscaler_partner_base_uri_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_password: Partner Password
        :param pulumi.Input[builtins.str] zscaler_partner_password_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_username: Partner User Name
        :param pulumi.Input[builtins.str] zscaler_partner_username_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_password: Password of Zscaler partner account
        :param pulumi.Input[builtins.str] zscaler_password_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_username: Username of Zscaler partner account
        :param pulumi.Input[builtins.str] zscaler_username_variable: Variable name
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if umbrella_api_key is not None:
            pulumi.set(__self__, "umbrella_api_key", umbrella_api_key)
        if umbrella_api_key_variable is not None:
            pulumi.set(__self__, "umbrella_api_key_variable", umbrella_api_key_variable)
        if umbrella_api_secret is not None:
            pulumi.set(__self__, "umbrella_api_secret", umbrella_api_secret)
        if umbrella_api_secret_variable is not None:
            pulumi.set(__self__, "umbrella_api_secret_variable", umbrella_api_secret_variable)
        if umbrella_organization_id is not None:
            pulumi.set(__self__, "umbrella_organization_id", umbrella_organization_id)
        if umbrella_organization_id_variable is not None:
            pulumi.set(__self__, "umbrella_organization_id_variable", umbrella_organization_id_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zscaler_cloud_name is not None:
            pulumi.set(__self__, "zscaler_cloud_name", zscaler_cloud_name)
        if zscaler_cloud_name_variable is not None:
            pulumi.set(__self__, "zscaler_cloud_name_variable", zscaler_cloud_name_variable)
        if zscaler_organization is not None:
            pulumi.set(__self__, "zscaler_organization", zscaler_organization)
        if zscaler_organization_variable is not None:
            pulumi.set(__self__, "zscaler_organization_variable", zscaler_organization_variable)
        if zscaler_partner_api_key is not None:
            pulumi.set(__self__, "zscaler_partner_api_key", zscaler_partner_api_key)
        if zscaler_partner_api_key_variable is not None:
            pulumi.set(__self__, "zscaler_partner_api_key_variable", zscaler_partner_api_key_variable)
        if zscaler_partner_base_uri is not None:
            pulumi.set(__self__, "zscaler_partner_base_uri", zscaler_partner_base_uri)
        if zscaler_partner_base_uri_variable is not None:
            pulumi.set(__self__, "zscaler_partner_base_uri_variable", zscaler_partner_base_uri_variable)
        if zscaler_partner_password is not None:
            pulumi.set(__self__, "zscaler_partner_password", zscaler_partner_password)
        if zscaler_partner_password_variable is not None:
            pulumi.set(__self__, "zscaler_partner_password_variable", zscaler_partner_password_variable)
        if zscaler_partner_username is not None:
            pulumi.set(__self__, "zscaler_partner_username", zscaler_partner_username)
        if zscaler_partner_username_variable is not None:
            pulumi.set(__self__, "zscaler_partner_username_variable", zscaler_partner_username_variable)
        if zscaler_password is not None:
            pulumi.set(__self__, "zscaler_password", zscaler_password)
        if zscaler_password_variable is not None:
            pulumi.set(__self__, "zscaler_password_variable", zscaler_password_variable)
        if zscaler_username is not None:
            pulumi.set(__self__, "zscaler_username", zscaler_username)
        if zscaler_username_variable is not None:
            pulumi.set(__self__, "zscaler_username_variable", zscaler_username_variable)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="umbrellaApiKey")
    def umbrella_api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API Key
        """
        return pulumi.get(self, "umbrella_api_key")

    @umbrella_api_key.setter
    def umbrella_api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_api_key", value)

    @property
    @pulumi.getter(name="umbrellaApiKeyVariable")
    def umbrella_api_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_api_key_variable")

    @umbrella_api_key_variable.setter
    def umbrella_api_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_api_key_variable", value)

    @property
    @pulumi.getter(name="umbrellaApiSecret")
    def umbrella_api_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API Secret
        """
        return pulumi.get(self, "umbrella_api_secret")

    @umbrella_api_secret.setter
    def umbrella_api_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_api_secret", value)

    @property
    @pulumi.getter(name="umbrellaApiSecretVariable")
    def umbrella_api_secret_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_api_secret_variable")

    @umbrella_api_secret_variable.setter
    def umbrella_api_secret_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_api_secret_variable", value)

    @property
    @pulumi.getter(name="umbrellaOrganizationId")
    def umbrella_organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Ord ID
        """
        return pulumi.get(self, "umbrella_organization_id")

    @umbrella_organization_id.setter
    def umbrella_organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_organization_id", value)

    @property
    @pulumi.getter(name="umbrellaOrganizationIdVariable")
    def umbrella_organization_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_organization_id_variable")

    @umbrella_organization_id_variable.setter
    def umbrella_organization_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "umbrella_organization_id_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="zscalerCloudName")
    def zscaler_cloud_name(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Third Party Cloud Name - Range: `0`-`255`
        """
        return pulumi.get(self, "zscaler_cloud_name")

    @zscaler_cloud_name.setter
    def zscaler_cloud_name(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zscaler_cloud_name", value)

    @property
    @pulumi.getter(name="zscalerCloudNameVariable")
    def zscaler_cloud_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_cloud_name_variable")

    @zscaler_cloud_name_variable.setter
    def zscaler_cloud_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_cloud_name_variable", value)

    @property
    @pulumi.getter(name="zscalerOrganization")
    def zscaler_organization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Organization Name
        """
        return pulumi.get(self, "zscaler_organization")

    @zscaler_organization.setter
    def zscaler_organization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_organization", value)

    @property
    @pulumi.getter(name="zscalerOrganizationVariable")
    def zscaler_organization_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_organization_variable")

    @zscaler_organization_variable.setter
    def zscaler_organization_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_organization_variable", value)

    @property
    @pulumi.getter(name="zscalerPartnerApiKey")
    def zscaler_partner_api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partner API Key
        """
        return pulumi.get(self, "zscaler_partner_api_key")

    @zscaler_partner_api_key.setter
    def zscaler_partner_api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_api_key", value)

    @property
    @pulumi.getter(name="zscalerPartnerApiKeyVariable")
    def zscaler_partner_api_key_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_api_key_variable")

    @zscaler_partner_api_key_variable.setter
    def zscaler_partner_api_key_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_api_key_variable", value)

    @property
    @pulumi.getter(name="zscalerPartnerBaseUri")
    def zscaler_partner_base_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partner Base URI to be used in REST calls
        """
        return pulumi.get(self, "zscaler_partner_base_uri")

    @zscaler_partner_base_uri.setter
    def zscaler_partner_base_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_base_uri", value)

    @property
    @pulumi.getter(name="zscalerPartnerBaseUriVariable")
    def zscaler_partner_base_uri_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_base_uri_variable")

    @zscaler_partner_base_uri_variable.setter
    def zscaler_partner_base_uri_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_base_uri_variable", value)

    @property
    @pulumi.getter(name="zscalerPartnerPassword")
    def zscaler_partner_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partner Password
        """
        return pulumi.get(self, "zscaler_partner_password")

    @zscaler_partner_password.setter
    def zscaler_partner_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_password", value)

    @property
    @pulumi.getter(name="zscalerPartnerPasswordVariable")
    def zscaler_partner_password_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_password_variable")

    @zscaler_partner_password_variable.setter
    def zscaler_partner_password_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_password_variable", value)

    @property
    @pulumi.getter(name="zscalerPartnerUsername")
    def zscaler_partner_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partner User Name
        """
        return pulumi.get(self, "zscaler_partner_username")

    @zscaler_partner_username.setter
    def zscaler_partner_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_username", value)

    @property
    @pulumi.getter(name="zscalerPartnerUsernameVariable")
    def zscaler_partner_username_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_username_variable")

    @zscaler_partner_username_variable.setter
    def zscaler_partner_username_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_partner_username_variable", value)

    @property
    @pulumi.getter(name="zscalerPassword")
    def zscaler_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password of Zscaler partner account
        """
        return pulumi.get(self, "zscaler_password")

    @zscaler_password.setter
    def zscaler_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_password", value)

    @property
    @pulumi.getter(name="zscalerPasswordVariable")
    def zscaler_password_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_password_variable")

    @zscaler_password_variable.setter
    def zscaler_password_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_password_variable", value)

    @property
    @pulumi.getter(name="zscalerUsername")
    def zscaler_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username of Zscaler partner account
        """
        return pulumi.get(self, "zscaler_username")

    @zscaler_username.setter
    def zscaler_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_username", value)

    @property
    @pulumi.getter(name="zscalerUsernameVariable")
    def zscaler_username_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_username_variable")

    @zscaler_username_variable.setter
    def zscaler_username_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zscaler_username_variable", value)


@pulumi.type_token("sdwan:index/ciscoSigCredentialsFeatureTemplate:CiscoSigCredentialsFeatureTemplate")
class CiscoSigCredentialsFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_secret: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_secret_variable: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_organization_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_cloud_name: Optional[pulumi.Input[builtins.int]] = None,
                 zscaler_cloud_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_organization: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_organization_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_base_uri: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_base_uri_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_password: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_username: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_password: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_username: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco SIG Credentials feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CiscoSigCredentialsFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            zscaler_organization="org1",
            zscaler_partner_base_uri="abc",
            zscaler_username="user1",
            zscaler_password="password123",
            zscaler_cloud_name=1,
            zscaler_partner_username="partner1",
            zscaler_partner_password="password123",
            zscaler_partner_api_key="key123",
            umbrella_api_key="key123",
            umbrella_api_secret="secret123",
            umbrella_organization_id="org1")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoSigCredentialsFeatureTemplate:CiscoSigCredentialsFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] umbrella_api_key: API Key
        :param pulumi.Input[builtins.str] umbrella_api_key_variable: Variable name
        :param pulumi.Input[builtins.str] umbrella_api_secret: API Secret
        :param pulumi.Input[builtins.str] umbrella_api_secret_variable: Variable name
        :param pulumi.Input[builtins.str] umbrella_organization_id: Ord ID
        :param pulumi.Input[builtins.str] umbrella_organization_id_variable: Variable name
        :param pulumi.Input[builtins.int] zscaler_cloud_name: Third Party Cloud Name - Range: `0`-`255`
        :param pulumi.Input[builtins.str] zscaler_cloud_name_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_organization: Organization Name
        :param pulumi.Input[builtins.str] zscaler_organization_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_api_key: Partner API Key
        :param pulumi.Input[builtins.str] zscaler_partner_api_key_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_base_uri: Partner Base URI to be used in REST calls
        :param pulumi.Input[builtins.str] zscaler_partner_base_uri_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_password: Partner Password
        :param pulumi.Input[builtins.str] zscaler_partner_password_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_username: Partner User Name
        :param pulumi.Input[builtins.str] zscaler_partner_username_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_password: Password of Zscaler partner account
        :param pulumi.Input[builtins.str] zscaler_password_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_username: Username of Zscaler partner account
        :param pulumi.Input[builtins.str] zscaler_username_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoSigCredentialsFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco SIG Credentials feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CiscoSigCredentialsFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            zscaler_organization="org1",
            zscaler_partner_base_uri="abc",
            zscaler_username="user1",
            zscaler_password="password123",
            zscaler_cloud_name=1,
            zscaler_partner_username="partner1",
            zscaler_partner_password="password123",
            zscaler_partner_api_key="key123",
            umbrella_api_key="key123",
            umbrella_api_secret="secret123",
            umbrella_organization_id="org1")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoSigCredentialsFeatureTemplate:CiscoSigCredentialsFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoSigCredentialsFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoSigCredentialsFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_secret: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_api_secret_variable: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 umbrella_organization_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_cloud_name: Optional[pulumi.Input[builtins.int]] = None,
                 zscaler_cloud_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_organization: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_organization_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_base_uri: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_base_uri_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_password: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_username: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_partner_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_password: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_username: Optional[pulumi.Input[builtins.str]] = None,
                 zscaler_username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoSigCredentialsFeatureTemplateArgs.__new__(CiscoSigCredentialsFeatureTemplateArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["name"] = name
            __props__.__dict__["umbrella_api_key"] = umbrella_api_key
            __props__.__dict__["umbrella_api_key_variable"] = umbrella_api_key_variable
            __props__.__dict__["umbrella_api_secret"] = umbrella_api_secret
            __props__.__dict__["umbrella_api_secret_variable"] = umbrella_api_secret_variable
            __props__.__dict__["umbrella_organization_id"] = umbrella_organization_id
            __props__.__dict__["umbrella_organization_id_variable"] = umbrella_organization_id_variable
            __props__.__dict__["zscaler_cloud_name"] = zscaler_cloud_name
            __props__.__dict__["zscaler_cloud_name_variable"] = zscaler_cloud_name_variable
            __props__.__dict__["zscaler_organization"] = zscaler_organization
            __props__.__dict__["zscaler_organization_variable"] = zscaler_organization_variable
            __props__.__dict__["zscaler_partner_api_key"] = zscaler_partner_api_key
            __props__.__dict__["zscaler_partner_api_key_variable"] = zscaler_partner_api_key_variable
            __props__.__dict__["zscaler_partner_base_uri"] = zscaler_partner_base_uri
            __props__.__dict__["zscaler_partner_base_uri_variable"] = zscaler_partner_base_uri_variable
            __props__.__dict__["zscaler_partner_password"] = zscaler_partner_password
            __props__.__dict__["zscaler_partner_password_variable"] = zscaler_partner_password_variable
            __props__.__dict__["zscaler_partner_username"] = zscaler_partner_username
            __props__.__dict__["zscaler_partner_username_variable"] = zscaler_partner_username_variable
            __props__.__dict__["zscaler_password"] = zscaler_password
            __props__.__dict__["zscaler_password_variable"] = zscaler_password_variable
            __props__.__dict__["zscaler_username"] = zscaler_username
            __props__.__dict__["zscaler_username_variable"] = zscaler_username_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoSigCredentialsFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoSigCredentialsFeatureTemplate:CiscoSigCredentialsFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            umbrella_api_key: Optional[pulumi.Input[builtins.str]] = None,
            umbrella_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
            umbrella_api_secret: Optional[pulumi.Input[builtins.str]] = None,
            umbrella_api_secret_variable: Optional[pulumi.Input[builtins.str]] = None,
            umbrella_organization_id: Optional[pulumi.Input[builtins.str]] = None,
            umbrella_organization_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None,
            zscaler_cloud_name: Optional[pulumi.Input[builtins.int]] = None,
            zscaler_cloud_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_organization: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_organization_variable: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_partner_api_key: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_partner_api_key_variable: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_partner_base_uri: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_partner_base_uri_variable: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_partner_password: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_partner_password_variable: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_partner_username: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_partner_username_variable: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_password: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_password_variable: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_username: Optional[pulumi.Input[builtins.str]] = None,
            zscaler_username_variable: Optional[pulumi.Input[builtins.str]] = None) -> 'CiscoSigCredentialsFeatureTemplate':
        """
        Get an existing CiscoSigCredentialsFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.str] umbrella_api_key: API Key
        :param pulumi.Input[builtins.str] umbrella_api_key_variable: Variable name
        :param pulumi.Input[builtins.str] umbrella_api_secret: API Secret
        :param pulumi.Input[builtins.str] umbrella_api_secret_variable: Variable name
        :param pulumi.Input[builtins.str] umbrella_organization_id: Ord ID
        :param pulumi.Input[builtins.str] umbrella_organization_id_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the feature template
        :param pulumi.Input[builtins.int] zscaler_cloud_name: Third Party Cloud Name - Range: `0`-`255`
        :param pulumi.Input[builtins.str] zscaler_cloud_name_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_organization: Organization Name
        :param pulumi.Input[builtins.str] zscaler_organization_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_api_key: Partner API Key
        :param pulumi.Input[builtins.str] zscaler_partner_api_key_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_base_uri: Partner Base URI to be used in REST calls
        :param pulumi.Input[builtins.str] zscaler_partner_base_uri_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_password: Partner Password
        :param pulumi.Input[builtins.str] zscaler_partner_password_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_partner_username: Partner User Name
        :param pulumi.Input[builtins.str] zscaler_partner_username_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_password: Password of Zscaler partner account
        :param pulumi.Input[builtins.str] zscaler_password_variable: Variable name
        :param pulumi.Input[builtins.str] zscaler_username: Username of Zscaler partner account
        :param pulumi.Input[builtins.str] zscaler_username_variable: Variable name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoSigCredentialsFeatureTemplateState.__new__(_CiscoSigCredentialsFeatureTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["name"] = name
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["umbrella_api_key"] = umbrella_api_key
        __props__.__dict__["umbrella_api_key_variable"] = umbrella_api_key_variable
        __props__.__dict__["umbrella_api_secret"] = umbrella_api_secret
        __props__.__dict__["umbrella_api_secret_variable"] = umbrella_api_secret_variable
        __props__.__dict__["umbrella_organization_id"] = umbrella_organization_id
        __props__.__dict__["umbrella_organization_id_variable"] = umbrella_organization_id_variable
        __props__.__dict__["version"] = version
        __props__.__dict__["zscaler_cloud_name"] = zscaler_cloud_name
        __props__.__dict__["zscaler_cloud_name_variable"] = zscaler_cloud_name_variable
        __props__.__dict__["zscaler_organization"] = zscaler_organization
        __props__.__dict__["zscaler_organization_variable"] = zscaler_organization_variable
        __props__.__dict__["zscaler_partner_api_key"] = zscaler_partner_api_key
        __props__.__dict__["zscaler_partner_api_key_variable"] = zscaler_partner_api_key_variable
        __props__.__dict__["zscaler_partner_base_uri"] = zscaler_partner_base_uri
        __props__.__dict__["zscaler_partner_base_uri_variable"] = zscaler_partner_base_uri_variable
        __props__.__dict__["zscaler_partner_password"] = zscaler_partner_password
        __props__.__dict__["zscaler_partner_password_variable"] = zscaler_partner_password_variable
        __props__.__dict__["zscaler_partner_username"] = zscaler_partner_username
        __props__.__dict__["zscaler_partner_username_variable"] = zscaler_partner_username_variable
        __props__.__dict__["zscaler_password"] = zscaler_password
        __props__.__dict__["zscaler_password_variable"] = zscaler_password_variable
        __props__.__dict__["zscaler_username"] = zscaler_username
        __props__.__dict__["zscaler_username_variable"] = zscaler_username_variable
        return CiscoSigCredentialsFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="umbrellaApiKey")
    def umbrella_api_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        API Key
        """
        return pulumi.get(self, "umbrella_api_key")

    @property
    @pulumi.getter(name="umbrellaApiKeyVariable")
    def umbrella_api_key_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_api_key_variable")

    @property
    @pulumi.getter(name="umbrellaApiSecret")
    def umbrella_api_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        API Secret
        """
        return pulumi.get(self, "umbrella_api_secret")

    @property
    @pulumi.getter(name="umbrellaApiSecretVariable")
    def umbrella_api_secret_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_api_secret_variable")

    @property
    @pulumi.getter(name="umbrellaOrganizationId")
    def umbrella_organization_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Ord ID
        """
        return pulumi.get(self, "umbrella_organization_id")

    @property
    @pulumi.getter(name="umbrellaOrganizationIdVariable")
    def umbrella_organization_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "umbrella_organization_id_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="zscalerCloudName")
    def zscaler_cloud_name(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Third Party Cloud Name - Range: `0`-`255`
        """
        return pulumi.get(self, "zscaler_cloud_name")

    @property
    @pulumi.getter(name="zscalerCloudNameVariable")
    def zscaler_cloud_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_cloud_name_variable")

    @property
    @pulumi.getter(name="zscalerOrganization")
    def zscaler_organization(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Organization Name
        """
        return pulumi.get(self, "zscaler_organization")

    @property
    @pulumi.getter(name="zscalerOrganizationVariable")
    def zscaler_organization_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_organization_variable")

    @property
    @pulumi.getter(name="zscalerPartnerApiKey")
    def zscaler_partner_api_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Partner API Key
        """
        return pulumi.get(self, "zscaler_partner_api_key")

    @property
    @pulumi.getter(name="zscalerPartnerApiKeyVariable")
    def zscaler_partner_api_key_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_api_key_variable")

    @property
    @pulumi.getter(name="zscalerPartnerBaseUri")
    def zscaler_partner_base_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Partner Base URI to be used in REST calls
        """
        return pulumi.get(self, "zscaler_partner_base_uri")

    @property
    @pulumi.getter(name="zscalerPartnerBaseUriVariable")
    def zscaler_partner_base_uri_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_base_uri_variable")

    @property
    @pulumi.getter(name="zscalerPartnerPassword")
    def zscaler_partner_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Partner Password
        """
        return pulumi.get(self, "zscaler_partner_password")

    @property
    @pulumi.getter(name="zscalerPartnerPasswordVariable")
    def zscaler_partner_password_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_password_variable")

    @property
    @pulumi.getter(name="zscalerPartnerUsername")
    def zscaler_partner_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Partner User Name
        """
        return pulumi.get(self, "zscaler_partner_username")

    @property
    @pulumi.getter(name="zscalerPartnerUsernameVariable")
    def zscaler_partner_username_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_partner_username_variable")

    @property
    @pulumi.getter(name="zscalerPassword")
    def zscaler_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password of Zscaler partner account
        """
        return pulumi.get(self, "zscaler_password")

    @property
    @pulumi.getter(name="zscalerPasswordVariable")
    def zscaler_password_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_password_variable")

    @property
    @pulumi.getter(name="zscalerUsername")
    def zscaler_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Username of Zscaler partner account
        """
        return pulumi.get(self, "zscaler_username")

    @property
    @pulumi.getter(name="zscalerUsernameVariable")
    def zscaler_username_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "zscaler_username_variable")

