# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPolicyObjectSecurityIdentityListResult',
    'AwaitableGetPolicyObjectSecurityIdentityListResult',
    'get_policy_object_security_identity_list',
    'get_policy_object_security_identity_list_output',
]

@pulumi.output_type
class GetPolicyObjectSecurityIdentityListResult:
    """
    A collection of values returned by getPolicyObjectSecurityIdentityList.
    """
    def __init__(__self__, description=None, entries=None, feature_profile_id=None, id=None, name=None, version=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Policy_object
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetPolicyObjectSecurityIdentityListEntryResult']:
        """
        Array of Users and User Groups
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> builtins.str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the Policy_object
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Policy_object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the Policy_object
        """
        return pulumi.get(self, "version")


class AwaitableGetPolicyObjectSecurityIdentityListResult(GetPolicyObjectSecurityIdentityListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyObjectSecurityIdentityListResult(
            description=self.description,
            entries=self.entries,
            feature_profile_id=self.feature_profile_id,
            id=self.id,
            name=self.name,
            version=self.version)


def get_policy_object_security_identity_list(feature_profile_id: Optional[builtins.str] = None,
                                             id: Optional[builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyObjectSecurityIdentityListResult:
    """
    This data source can read the Policy Object Security Identity List Policy_object.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_policy_object_security_identity_list(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Policy_object
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getPolicyObjectSecurityIdentityList:getPolicyObjectSecurityIdentityList', __args__, opts=opts, typ=GetPolicyObjectSecurityIdentityListResult).value

    return AwaitableGetPolicyObjectSecurityIdentityListResult(
        description=pulumi.get(__ret__, 'description'),
        entries=pulumi.get(__ret__, 'entries'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        version=pulumi.get(__ret__, 'version'))
def get_policy_object_security_identity_list_output(feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                                                    id: Optional[pulumi.Input[builtins.str]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicyObjectSecurityIdentityListResult]:
    """
    This data source can read the Policy Object Security Identity List Policy_object.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_policy_object_security_identity_list(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param builtins.str feature_profile_id: Feature Profile ID
    :param builtins.str id: The id of the Policy_object
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getPolicyObjectSecurityIdentityList:getPolicyObjectSecurityIdentityList', __args__, opts=opts, typ=GetPolicyObjectSecurityIdentityListResult)
    return __ret__.apply(lambda __response__: GetPolicyObjectSecurityIdentityListResult(
        description=pulumi.get(__response__, 'description'),
        entries=pulumi.get(__response__, 'entries'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        version=pulumi.get(__response__, 'version')))
