# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityPolicyArgs', 'SecurityPolicy']

@pulumi.input_type
class SecurityPolicyArgs:
    def __init__(__self__, *,
                 definitions: pulumi.Input[Sequence[pulumi.Input['SecurityPolicyDefinitionArgs']]],
                 description: pulumi.Input[builtins.str],
                 audit_trail: Optional[pulumi.Input[builtins.str]] = None,
                 direct_internet_applications: Optional[pulumi.Input[builtins.str]] = None,
                 failure_mode: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_port: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_vpn: Optional[pulumi.Input[builtins.str]] = None,
                 imcp_unreachable_allow: Optional[pulumi.Input[builtins.bool]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyLoggingArgs']]]] = None,
                 match_statistics_per_filter: Optional[pulumi.Input[builtins.str]] = None,
                 max_incomplete_icmp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_incomplete_tcp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_incomplete_udp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 session_reclassify_allow: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_syn_flood_limit: Optional[pulumi.Input[builtins.str]] = None,
                 unified_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 use_case: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityPolicyDefinitionArgs']]] definitions: List of policy definitions
        :param pulumi.Input[builtins.str] description: The description of the security policy
        :param pulumi.Input[builtins.str] audit_trail: Audit trail - Choices: `on`, `off`
        :param pulumi.Input[builtins.str] direct_internet_applications: Bypass firewall policy and allow all Internet traffic to/from VPN 0 - Choices: `allow`, `deny`
        :param pulumi.Input[builtins.str] failure_mode: Failure mode - Choices: `open`, `close`
        :param pulumi.Input[builtins.str] high_speed_logging_server_ip: High Speed Logging Server IP
        :param pulumi.Input[builtins.str] high_speed_logging_server_port: High Speed Logging Port
        :param pulumi.Input[builtins.str] high_speed_logging_server_source_interface: High Speed Logging Source Interface
        :param pulumi.Input[builtins.str] high_speed_logging_vpn: High Speed Logging VPN
        :param pulumi.Input[builtins.bool] imcp_unreachable_allow: ICMP Unreachable Allow
        :param pulumi.Input[builtins.str] match_statistics_per_filter: Match Statistics per-filter - Choices: `on`, `off`
        :param pulumi.Input[builtins.int] max_incomplete_icmp_limit: Max Incomplete ICMP Limit
        :param pulumi.Input[builtins.int] max_incomplete_tcp_limit: Max Incomplete TCP Limit
        :param pulumi.Input[builtins.int] max_incomplete_udp_limit: Max Incomplete UDP Limit
        :param pulumi.Input[builtins.str] mode: The policy mode - Choices: `security`, `unified` - Default value: `security`
        :param pulumi.Input[builtins.str] name: The name of the security policy
        :param pulumi.Input[builtins.bool] session_reclassify_allow: Session Reclassify Allow
        :param pulumi.Input[builtins.str] tcp_syn_flood_limit: TCP SYN Flood Limit, value from 1 to 4294967295
        :param pulumi.Input[builtins.bool] unified_logging: Unified Logging
        :param pulumi.Input[builtins.str] use_case: The use case of the security policy - Choices: `custom`, `compliance`, `guestAccess`, `directCloudAccess`,
               `directInternetAccess`, `directCloudAccess` - Default value: `custom`
        """
        pulumi.set(__self__, "definitions", definitions)
        pulumi.set(__self__, "description", description)
        if audit_trail is not None:
            pulumi.set(__self__, "audit_trail", audit_trail)
        if direct_internet_applications is not None:
            pulumi.set(__self__, "direct_internet_applications", direct_internet_applications)
        if failure_mode is not None:
            pulumi.set(__self__, "failure_mode", failure_mode)
        if high_speed_logging_server_ip is not None:
            pulumi.set(__self__, "high_speed_logging_server_ip", high_speed_logging_server_ip)
        if high_speed_logging_server_port is not None:
            pulumi.set(__self__, "high_speed_logging_server_port", high_speed_logging_server_port)
        if high_speed_logging_server_source_interface is not None:
            pulumi.set(__self__, "high_speed_logging_server_source_interface", high_speed_logging_server_source_interface)
        if high_speed_logging_vpn is not None:
            pulumi.set(__self__, "high_speed_logging_vpn", high_speed_logging_vpn)
        if imcp_unreachable_allow is not None:
            pulumi.set(__self__, "imcp_unreachable_allow", imcp_unreachable_allow)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if match_statistics_per_filter is not None:
            pulumi.set(__self__, "match_statistics_per_filter", match_statistics_per_filter)
        if max_incomplete_icmp_limit is not None:
            pulumi.set(__self__, "max_incomplete_icmp_limit", max_incomplete_icmp_limit)
        if max_incomplete_tcp_limit is not None:
            pulumi.set(__self__, "max_incomplete_tcp_limit", max_incomplete_tcp_limit)
        if max_incomplete_udp_limit is not None:
            pulumi.set(__self__, "max_incomplete_udp_limit", max_incomplete_udp_limit)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_reclassify_allow is not None:
            pulumi.set(__self__, "session_reclassify_allow", session_reclassify_allow)
        if tcp_syn_flood_limit is not None:
            pulumi.set(__self__, "tcp_syn_flood_limit", tcp_syn_flood_limit)
        if unified_logging is not None:
            pulumi.set(__self__, "unified_logging", unified_logging)
        if use_case is not None:
            pulumi.set(__self__, "use_case", use_case)

    @property
    @pulumi.getter
    def definitions(self) -> pulumi.Input[Sequence[pulumi.Input['SecurityPolicyDefinitionArgs']]]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @definitions.setter
    def definitions(self, value: pulumi.Input[Sequence[pulumi.Input['SecurityPolicyDefinitionArgs']]]):
        pulumi.set(self, "definitions", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the security policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="auditTrail")
    def audit_trail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Audit trail - Choices: `on`, `off`
        """
        return pulumi.get(self, "audit_trail")

    @audit_trail.setter
    def audit_trail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audit_trail", value)

    @property
    @pulumi.getter(name="directInternetApplications")
    def direct_internet_applications(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Bypass firewall policy and allow all Internet traffic to/from VPN 0 - Choices: `allow`, `deny`
        """
        return pulumi.get(self, "direct_internet_applications")

    @direct_internet_applications.setter
    def direct_internet_applications(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direct_internet_applications", value)

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Failure mode - Choices: `open`, `close`
        """
        return pulumi.get(self, "failure_mode")

    @failure_mode.setter
    def failure_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "failure_mode", value)

    @property
    @pulumi.getter(name="highSpeedLoggingServerIp")
    def high_speed_logging_server_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High Speed Logging Server IP
        """
        return pulumi.get(self, "high_speed_logging_server_ip")

    @high_speed_logging_server_ip.setter
    def high_speed_logging_server_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "high_speed_logging_server_ip", value)

    @property
    @pulumi.getter(name="highSpeedLoggingServerPort")
    def high_speed_logging_server_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High Speed Logging Port
        """
        return pulumi.get(self, "high_speed_logging_server_port")

    @high_speed_logging_server_port.setter
    def high_speed_logging_server_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "high_speed_logging_server_port", value)

    @property
    @pulumi.getter(name="highSpeedLoggingServerSourceInterface")
    def high_speed_logging_server_source_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High Speed Logging Source Interface
        """
        return pulumi.get(self, "high_speed_logging_server_source_interface")

    @high_speed_logging_server_source_interface.setter
    def high_speed_logging_server_source_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "high_speed_logging_server_source_interface", value)

    @property
    @pulumi.getter(name="highSpeedLoggingVpn")
    def high_speed_logging_vpn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High Speed Logging VPN
        """
        return pulumi.get(self, "high_speed_logging_vpn")

    @high_speed_logging_vpn.setter
    def high_speed_logging_vpn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "high_speed_logging_vpn", value)

    @property
    @pulumi.getter(name="imcpUnreachableAllow")
    def imcp_unreachable_allow(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ICMP Unreachable Allow
        """
        return pulumi.get(self, "imcp_unreachable_allow")

    @imcp_unreachable_allow.setter
    def imcp_unreachable_allow(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "imcp_unreachable_allow", value)

    @property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyLoggingArgs']]]]:
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @property
    @pulumi.getter(name="matchStatisticsPerFilter")
    def match_statistics_per_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Match Statistics per-filter - Choices: `on`, `off`
        """
        return pulumi.get(self, "match_statistics_per_filter")

    @match_statistics_per_filter.setter
    def match_statistics_per_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match_statistics_per_filter", value)

    @property
    @pulumi.getter(name="maxIncompleteIcmpLimit")
    def max_incomplete_icmp_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max Incomplete ICMP Limit
        """
        return pulumi.get(self, "max_incomplete_icmp_limit")

    @max_incomplete_icmp_limit.setter
    def max_incomplete_icmp_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_incomplete_icmp_limit", value)

    @property
    @pulumi.getter(name="maxIncompleteTcpLimit")
    def max_incomplete_tcp_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max Incomplete TCP Limit
        """
        return pulumi.get(self, "max_incomplete_tcp_limit")

    @max_incomplete_tcp_limit.setter
    def max_incomplete_tcp_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_incomplete_tcp_limit", value)

    @property
    @pulumi.getter(name="maxIncompleteUdpLimit")
    def max_incomplete_udp_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max Incomplete UDP Limit
        """
        return pulumi.get(self, "max_incomplete_udp_limit")

    @max_incomplete_udp_limit.setter
    def max_incomplete_udp_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_incomplete_udp_limit", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy mode - Choices: `security`, `unified` - Default value: `security`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the security policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionReclassifyAllow")
    def session_reclassify_allow(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Session Reclassify Allow
        """
        return pulumi.get(self, "session_reclassify_allow")

    @session_reclassify_allow.setter
    def session_reclassify_allow(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "session_reclassify_allow", value)

    @property
    @pulumi.getter(name="tcpSynFloodLimit")
    def tcp_syn_flood_limit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TCP SYN Flood Limit, value from 1 to 4294967295
        """
        return pulumi.get(self, "tcp_syn_flood_limit")

    @tcp_syn_flood_limit.setter
    def tcp_syn_flood_limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_syn_flood_limit", value)

    @property
    @pulumi.getter(name="unifiedLogging")
    def unified_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Unified Logging
        """
        return pulumi.get(self, "unified_logging")

    @unified_logging.setter
    def unified_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unified_logging", value)

    @property
    @pulumi.getter(name="useCase")
    def use_case(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The use case of the security policy - Choices: `custom`, `compliance`, `guestAccess`, `directCloudAccess`,
        `directInternetAccess`, `directCloudAccess` - Default value: `custom`
        """
        return pulumi.get(self, "use_case")

    @use_case.setter
    def use_case(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "use_case", value)


@pulumi.input_type
class _SecurityPolicyState:
    def __init__(__self__, *,
                 audit_trail: Optional[pulumi.Input[builtins.str]] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyDefinitionArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direct_internet_applications: Optional[pulumi.Input[builtins.str]] = None,
                 failure_mode: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_port: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_vpn: Optional[pulumi.Input[builtins.str]] = None,
                 imcp_unreachable_allow: Optional[pulumi.Input[builtins.bool]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyLoggingArgs']]]] = None,
                 match_statistics_per_filter: Optional[pulumi.Input[builtins.str]] = None,
                 max_incomplete_icmp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_incomplete_tcp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_incomplete_udp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 session_reclassify_allow: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_syn_flood_limit: Optional[pulumi.Input[builtins.str]] = None,
                 unified_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 use_case: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SecurityPolicy resources.
        :param pulumi.Input[builtins.str] audit_trail: Audit trail - Choices: `on`, `off`
        :param pulumi.Input[Sequence[pulumi.Input['SecurityPolicyDefinitionArgs']]] definitions: List of policy definitions
        :param pulumi.Input[builtins.str] description: The description of the security policy
        :param pulumi.Input[builtins.str] direct_internet_applications: Bypass firewall policy and allow all Internet traffic to/from VPN 0 - Choices: `allow`, `deny`
        :param pulumi.Input[builtins.str] failure_mode: Failure mode - Choices: `open`, `close`
        :param pulumi.Input[builtins.str] high_speed_logging_server_ip: High Speed Logging Server IP
        :param pulumi.Input[builtins.str] high_speed_logging_server_port: High Speed Logging Port
        :param pulumi.Input[builtins.str] high_speed_logging_server_source_interface: High Speed Logging Source Interface
        :param pulumi.Input[builtins.str] high_speed_logging_vpn: High Speed Logging VPN
        :param pulumi.Input[builtins.bool] imcp_unreachable_allow: ICMP Unreachable Allow
        :param pulumi.Input[builtins.str] match_statistics_per_filter: Match Statistics per-filter - Choices: `on`, `off`
        :param pulumi.Input[builtins.int] max_incomplete_icmp_limit: Max Incomplete ICMP Limit
        :param pulumi.Input[builtins.int] max_incomplete_tcp_limit: Max Incomplete TCP Limit
        :param pulumi.Input[builtins.int] max_incomplete_udp_limit: Max Incomplete UDP Limit
        :param pulumi.Input[builtins.str] mode: The policy mode - Choices: `security`, `unified` - Default value: `security`
        :param pulumi.Input[builtins.str] name: The name of the security policy
        :param pulumi.Input[builtins.bool] session_reclassify_allow: Session Reclassify Allow
        :param pulumi.Input[builtins.str] tcp_syn_flood_limit: TCP SYN Flood Limit, value from 1 to 4294967295
        :param pulumi.Input[builtins.bool] unified_logging: Unified Logging
        :param pulumi.Input[builtins.str] use_case: The use case of the security policy - Choices: `custom`, `compliance`, `guestAccess`, `directCloudAccess`,
               `directInternetAccess`, `directCloudAccess` - Default value: `custom`
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        if audit_trail is not None:
            pulumi.set(__self__, "audit_trail", audit_trail)
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direct_internet_applications is not None:
            pulumi.set(__self__, "direct_internet_applications", direct_internet_applications)
        if failure_mode is not None:
            pulumi.set(__self__, "failure_mode", failure_mode)
        if high_speed_logging_server_ip is not None:
            pulumi.set(__self__, "high_speed_logging_server_ip", high_speed_logging_server_ip)
        if high_speed_logging_server_port is not None:
            pulumi.set(__self__, "high_speed_logging_server_port", high_speed_logging_server_port)
        if high_speed_logging_server_source_interface is not None:
            pulumi.set(__self__, "high_speed_logging_server_source_interface", high_speed_logging_server_source_interface)
        if high_speed_logging_vpn is not None:
            pulumi.set(__self__, "high_speed_logging_vpn", high_speed_logging_vpn)
        if imcp_unreachable_allow is not None:
            pulumi.set(__self__, "imcp_unreachable_allow", imcp_unreachable_allow)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if match_statistics_per_filter is not None:
            pulumi.set(__self__, "match_statistics_per_filter", match_statistics_per_filter)
        if max_incomplete_icmp_limit is not None:
            pulumi.set(__self__, "max_incomplete_icmp_limit", max_incomplete_icmp_limit)
        if max_incomplete_tcp_limit is not None:
            pulumi.set(__self__, "max_incomplete_tcp_limit", max_incomplete_tcp_limit)
        if max_incomplete_udp_limit is not None:
            pulumi.set(__self__, "max_incomplete_udp_limit", max_incomplete_udp_limit)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_reclassify_allow is not None:
            pulumi.set(__self__, "session_reclassify_allow", session_reclassify_allow)
        if tcp_syn_flood_limit is not None:
            pulumi.set(__self__, "tcp_syn_flood_limit", tcp_syn_flood_limit)
        if unified_logging is not None:
            pulumi.set(__self__, "unified_logging", unified_logging)
        if use_case is not None:
            pulumi.set(__self__, "use_case", use_case)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="auditTrail")
    def audit_trail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Audit trail - Choices: `on`, `off`
        """
        return pulumi.get(self, "audit_trail")

    @audit_trail.setter
    def audit_trail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audit_trail", value)

    @property
    @pulumi.getter
    def definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyDefinitionArgs']]]]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @definitions.setter
    def definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyDefinitionArgs']]]]):
        pulumi.set(self, "definitions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the security policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directInternetApplications")
    def direct_internet_applications(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Bypass firewall policy and allow all Internet traffic to/from VPN 0 - Choices: `allow`, `deny`
        """
        return pulumi.get(self, "direct_internet_applications")

    @direct_internet_applications.setter
    def direct_internet_applications(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direct_internet_applications", value)

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Failure mode - Choices: `open`, `close`
        """
        return pulumi.get(self, "failure_mode")

    @failure_mode.setter
    def failure_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "failure_mode", value)

    @property
    @pulumi.getter(name="highSpeedLoggingServerIp")
    def high_speed_logging_server_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High Speed Logging Server IP
        """
        return pulumi.get(self, "high_speed_logging_server_ip")

    @high_speed_logging_server_ip.setter
    def high_speed_logging_server_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "high_speed_logging_server_ip", value)

    @property
    @pulumi.getter(name="highSpeedLoggingServerPort")
    def high_speed_logging_server_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High Speed Logging Port
        """
        return pulumi.get(self, "high_speed_logging_server_port")

    @high_speed_logging_server_port.setter
    def high_speed_logging_server_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "high_speed_logging_server_port", value)

    @property
    @pulumi.getter(name="highSpeedLoggingServerSourceInterface")
    def high_speed_logging_server_source_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High Speed Logging Source Interface
        """
        return pulumi.get(self, "high_speed_logging_server_source_interface")

    @high_speed_logging_server_source_interface.setter
    def high_speed_logging_server_source_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "high_speed_logging_server_source_interface", value)

    @property
    @pulumi.getter(name="highSpeedLoggingVpn")
    def high_speed_logging_vpn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High Speed Logging VPN
        """
        return pulumi.get(self, "high_speed_logging_vpn")

    @high_speed_logging_vpn.setter
    def high_speed_logging_vpn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "high_speed_logging_vpn", value)

    @property
    @pulumi.getter(name="imcpUnreachableAllow")
    def imcp_unreachable_allow(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ICMP Unreachable Allow
        """
        return pulumi.get(self, "imcp_unreachable_allow")

    @imcp_unreachable_allow.setter
    def imcp_unreachable_allow(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "imcp_unreachable_allow", value)

    @property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyLoggingArgs']]]]:
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @property
    @pulumi.getter(name="matchStatisticsPerFilter")
    def match_statistics_per_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Match Statistics per-filter - Choices: `on`, `off`
        """
        return pulumi.get(self, "match_statistics_per_filter")

    @match_statistics_per_filter.setter
    def match_statistics_per_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match_statistics_per_filter", value)

    @property
    @pulumi.getter(name="maxIncompleteIcmpLimit")
    def max_incomplete_icmp_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max Incomplete ICMP Limit
        """
        return pulumi.get(self, "max_incomplete_icmp_limit")

    @max_incomplete_icmp_limit.setter
    def max_incomplete_icmp_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_incomplete_icmp_limit", value)

    @property
    @pulumi.getter(name="maxIncompleteTcpLimit")
    def max_incomplete_tcp_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max Incomplete TCP Limit
        """
        return pulumi.get(self, "max_incomplete_tcp_limit")

    @max_incomplete_tcp_limit.setter
    def max_incomplete_tcp_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_incomplete_tcp_limit", value)

    @property
    @pulumi.getter(name="maxIncompleteUdpLimit")
    def max_incomplete_udp_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Max Incomplete UDP Limit
        """
        return pulumi.get(self, "max_incomplete_udp_limit")

    @max_incomplete_udp_limit.setter
    def max_incomplete_udp_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_incomplete_udp_limit", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy mode - Choices: `security`, `unified` - Default value: `security`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the security policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionReclassifyAllow")
    def session_reclassify_allow(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Session Reclassify Allow
        """
        return pulumi.get(self, "session_reclassify_allow")

    @session_reclassify_allow.setter
    def session_reclassify_allow(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "session_reclassify_allow", value)

    @property
    @pulumi.getter(name="tcpSynFloodLimit")
    def tcp_syn_flood_limit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TCP SYN Flood Limit, value from 1 to 4294967295
        """
        return pulumi.get(self, "tcp_syn_flood_limit")

    @tcp_syn_flood_limit.setter
    def tcp_syn_flood_limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_syn_flood_limit", value)

    @property
    @pulumi.getter(name="unifiedLogging")
    def unified_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Unified Logging
        """
        return pulumi.get(self, "unified_logging")

    @unified_logging.setter
    def unified_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unified_logging", value)

    @property
    @pulumi.getter(name="useCase")
    def use_case(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The use case of the security policy - Choices: `custom`, `compliance`, `guestAccess`, `directCloudAccess`,
        `directInternetAccess`, `directCloudAccess` - Default value: `custom`
        """
        return pulumi.get(self, "use_case")

    @use_case.setter
    def use_case(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "use_case", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/securityPolicy:SecurityPolicy")
class SecurityPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_trail: Optional[pulumi.Input[builtins.str]] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyDefinitionArgs', 'SecurityPolicyDefinitionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direct_internet_applications: Optional[pulumi.Input[builtins.str]] = None,
                 failure_mode: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_port: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_vpn: Optional[pulumi.Input[builtins.str]] = None,
                 imcp_unreachable_allow: Optional[pulumi.Input[builtins.bool]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyLoggingArgs', 'SecurityPolicyLoggingArgsDict']]]]] = None,
                 match_statistics_per_filter: Optional[pulumi.Input[builtins.str]] = None,
                 max_incomplete_icmp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_incomplete_tcp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_incomplete_udp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 session_reclassify_allow: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_syn_flood_limit: Optional[pulumi.Input[builtins.str]] = None,
                 unified_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 use_case: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Security Policy .

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/securityPolicy:SecurityPolicy example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] audit_trail: Audit trail - Choices: `on`, `off`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyDefinitionArgs', 'SecurityPolicyDefinitionArgsDict']]]] definitions: List of policy definitions
        :param pulumi.Input[builtins.str] description: The description of the security policy
        :param pulumi.Input[builtins.str] direct_internet_applications: Bypass firewall policy and allow all Internet traffic to/from VPN 0 - Choices: `allow`, `deny`
        :param pulumi.Input[builtins.str] failure_mode: Failure mode - Choices: `open`, `close`
        :param pulumi.Input[builtins.str] high_speed_logging_server_ip: High Speed Logging Server IP
        :param pulumi.Input[builtins.str] high_speed_logging_server_port: High Speed Logging Port
        :param pulumi.Input[builtins.str] high_speed_logging_server_source_interface: High Speed Logging Source Interface
        :param pulumi.Input[builtins.str] high_speed_logging_vpn: High Speed Logging VPN
        :param pulumi.Input[builtins.bool] imcp_unreachable_allow: ICMP Unreachable Allow
        :param pulumi.Input[builtins.str] match_statistics_per_filter: Match Statistics per-filter - Choices: `on`, `off`
        :param pulumi.Input[builtins.int] max_incomplete_icmp_limit: Max Incomplete ICMP Limit
        :param pulumi.Input[builtins.int] max_incomplete_tcp_limit: Max Incomplete TCP Limit
        :param pulumi.Input[builtins.int] max_incomplete_udp_limit: Max Incomplete UDP Limit
        :param pulumi.Input[builtins.str] mode: The policy mode - Choices: `security`, `unified` - Default value: `security`
        :param pulumi.Input[builtins.str] name: The name of the security policy
        :param pulumi.Input[builtins.bool] session_reclassify_allow: Session Reclassify Allow
        :param pulumi.Input[builtins.str] tcp_syn_flood_limit: TCP SYN Flood Limit, value from 1 to 4294967295
        :param pulumi.Input[builtins.bool] unified_logging: Unified Logging
        :param pulumi.Input[builtins.str] use_case: The use case of the security policy - Choices: `custom`, `compliance`, `guestAccess`, `directCloudAccess`,
               `directInternetAccess`, `directCloudAccess` - Default value: `custom`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Security Policy .

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/securityPolicy:SecurityPolicy example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param SecurityPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_trail: Optional[pulumi.Input[builtins.str]] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyDefinitionArgs', 'SecurityPolicyDefinitionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direct_internet_applications: Optional[pulumi.Input[builtins.str]] = None,
                 failure_mode: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_port: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_server_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 high_speed_logging_vpn: Optional[pulumi.Input[builtins.str]] = None,
                 imcp_unreachable_allow: Optional[pulumi.Input[builtins.bool]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyLoggingArgs', 'SecurityPolicyLoggingArgsDict']]]]] = None,
                 match_statistics_per_filter: Optional[pulumi.Input[builtins.str]] = None,
                 max_incomplete_icmp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_incomplete_tcp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 max_incomplete_udp_limit: Optional[pulumi.Input[builtins.int]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 session_reclassify_allow: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_syn_flood_limit: Optional[pulumi.Input[builtins.str]] = None,
                 unified_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 use_case: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityPolicyArgs.__new__(SecurityPolicyArgs)

            __props__.__dict__["audit_trail"] = audit_trail
            if definitions is None and not opts.urn:
                raise TypeError("Missing required property 'definitions'")
            __props__.__dict__["definitions"] = definitions
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["direct_internet_applications"] = direct_internet_applications
            __props__.__dict__["failure_mode"] = failure_mode
            __props__.__dict__["high_speed_logging_server_ip"] = high_speed_logging_server_ip
            __props__.__dict__["high_speed_logging_server_port"] = high_speed_logging_server_port
            __props__.__dict__["high_speed_logging_server_source_interface"] = high_speed_logging_server_source_interface
            __props__.__dict__["high_speed_logging_vpn"] = high_speed_logging_vpn
            __props__.__dict__["imcp_unreachable_allow"] = imcp_unreachable_allow
            __props__.__dict__["loggings"] = loggings
            __props__.__dict__["match_statistics_per_filter"] = match_statistics_per_filter
            __props__.__dict__["max_incomplete_icmp_limit"] = max_incomplete_icmp_limit
            __props__.__dict__["max_incomplete_tcp_limit"] = max_incomplete_tcp_limit
            __props__.__dict__["max_incomplete_udp_limit"] = max_incomplete_udp_limit
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["session_reclassify_allow"] = session_reclassify_allow
            __props__.__dict__["tcp_syn_flood_limit"] = tcp_syn_flood_limit
            __props__.__dict__["unified_logging"] = unified_logging
            __props__.__dict__["use_case"] = use_case
            __props__.__dict__["version"] = None
        super(SecurityPolicy, __self__).__init__(
            'sdwan:index/securityPolicy:SecurityPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_trail: Optional[pulumi.Input[builtins.str]] = None,
            definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyDefinitionArgs', 'SecurityPolicyDefinitionArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            direct_internet_applications: Optional[pulumi.Input[builtins.str]] = None,
            failure_mode: Optional[pulumi.Input[builtins.str]] = None,
            high_speed_logging_server_ip: Optional[pulumi.Input[builtins.str]] = None,
            high_speed_logging_server_port: Optional[pulumi.Input[builtins.str]] = None,
            high_speed_logging_server_source_interface: Optional[pulumi.Input[builtins.str]] = None,
            high_speed_logging_vpn: Optional[pulumi.Input[builtins.str]] = None,
            imcp_unreachable_allow: Optional[pulumi.Input[builtins.bool]] = None,
            loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyLoggingArgs', 'SecurityPolicyLoggingArgsDict']]]]] = None,
            match_statistics_per_filter: Optional[pulumi.Input[builtins.str]] = None,
            max_incomplete_icmp_limit: Optional[pulumi.Input[builtins.int]] = None,
            max_incomplete_tcp_limit: Optional[pulumi.Input[builtins.int]] = None,
            max_incomplete_udp_limit: Optional[pulumi.Input[builtins.int]] = None,
            mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            session_reclassify_allow: Optional[pulumi.Input[builtins.bool]] = None,
            tcp_syn_flood_limit: Optional[pulumi.Input[builtins.str]] = None,
            unified_logging: Optional[pulumi.Input[builtins.bool]] = None,
            use_case: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'SecurityPolicy':
        """
        Get an existing SecurityPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] audit_trail: Audit trail - Choices: `on`, `off`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityPolicyDefinitionArgs', 'SecurityPolicyDefinitionArgsDict']]]] definitions: List of policy definitions
        :param pulumi.Input[builtins.str] description: The description of the security policy
        :param pulumi.Input[builtins.str] direct_internet_applications: Bypass firewall policy and allow all Internet traffic to/from VPN 0 - Choices: `allow`, `deny`
        :param pulumi.Input[builtins.str] failure_mode: Failure mode - Choices: `open`, `close`
        :param pulumi.Input[builtins.str] high_speed_logging_server_ip: High Speed Logging Server IP
        :param pulumi.Input[builtins.str] high_speed_logging_server_port: High Speed Logging Port
        :param pulumi.Input[builtins.str] high_speed_logging_server_source_interface: High Speed Logging Source Interface
        :param pulumi.Input[builtins.str] high_speed_logging_vpn: High Speed Logging VPN
        :param pulumi.Input[builtins.bool] imcp_unreachable_allow: ICMP Unreachable Allow
        :param pulumi.Input[builtins.str] match_statistics_per_filter: Match Statistics per-filter - Choices: `on`, `off`
        :param pulumi.Input[builtins.int] max_incomplete_icmp_limit: Max Incomplete ICMP Limit
        :param pulumi.Input[builtins.int] max_incomplete_tcp_limit: Max Incomplete TCP Limit
        :param pulumi.Input[builtins.int] max_incomplete_udp_limit: Max Incomplete UDP Limit
        :param pulumi.Input[builtins.str] mode: The policy mode - Choices: `security`, `unified` - Default value: `security`
        :param pulumi.Input[builtins.str] name: The name of the security policy
        :param pulumi.Input[builtins.bool] session_reclassify_allow: Session Reclassify Allow
        :param pulumi.Input[builtins.str] tcp_syn_flood_limit: TCP SYN Flood Limit, value from 1 to 4294967295
        :param pulumi.Input[builtins.bool] unified_logging: Unified Logging
        :param pulumi.Input[builtins.str] use_case: The use case of the security policy - Choices: `custom`, `compliance`, `guestAccess`, `directCloudAccess`,
               `directInternetAccess`, `directCloudAccess` - Default value: `custom`
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityPolicyState.__new__(_SecurityPolicyState)

        __props__.__dict__["audit_trail"] = audit_trail
        __props__.__dict__["definitions"] = definitions
        __props__.__dict__["description"] = description
        __props__.__dict__["direct_internet_applications"] = direct_internet_applications
        __props__.__dict__["failure_mode"] = failure_mode
        __props__.__dict__["high_speed_logging_server_ip"] = high_speed_logging_server_ip
        __props__.__dict__["high_speed_logging_server_port"] = high_speed_logging_server_port
        __props__.__dict__["high_speed_logging_server_source_interface"] = high_speed_logging_server_source_interface
        __props__.__dict__["high_speed_logging_vpn"] = high_speed_logging_vpn
        __props__.__dict__["imcp_unreachable_allow"] = imcp_unreachable_allow
        __props__.__dict__["loggings"] = loggings
        __props__.__dict__["match_statistics_per_filter"] = match_statistics_per_filter
        __props__.__dict__["max_incomplete_icmp_limit"] = max_incomplete_icmp_limit
        __props__.__dict__["max_incomplete_tcp_limit"] = max_incomplete_tcp_limit
        __props__.__dict__["max_incomplete_udp_limit"] = max_incomplete_udp_limit
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["session_reclassify_allow"] = session_reclassify_allow
        __props__.__dict__["tcp_syn_flood_limit"] = tcp_syn_flood_limit
        __props__.__dict__["unified_logging"] = unified_logging
        __props__.__dict__["use_case"] = use_case
        __props__.__dict__["version"] = version
        return SecurityPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditTrail")
    def audit_trail(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Audit trail - Choices: `on`, `off`
        """
        return pulumi.get(self, "audit_trail")

    @property
    @pulumi.getter
    def definitions(self) -> pulumi.Output[Sequence['outputs.SecurityPolicyDefinition']]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the security policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directInternetApplications")
    def direct_internet_applications(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Bypass firewall policy and allow all Internet traffic to/from VPN 0 - Choices: `allow`, `deny`
        """
        return pulumi.get(self, "direct_internet_applications")

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Failure mode - Choices: `open`, `close`
        """
        return pulumi.get(self, "failure_mode")

    @property
    @pulumi.getter(name="highSpeedLoggingServerIp")
    def high_speed_logging_server_ip(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        High Speed Logging Server IP
        """
        return pulumi.get(self, "high_speed_logging_server_ip")

    @property
    @pulumi.getter(name="highSpeedLoggingServerPort")
    def high_speed_logging_server_port(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        High Speed Logging Port
        """
        return pulumi.get(self, "high_speed_logging_server_port")

    @property
    @pulumi.getter(name="highSpeedLoggingServerSourceInterface")
    def high_speed_logging_server_source_interface(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        High Speed Logging Source Interface
        """
        return pulumi.get(self, "high_speed_logging_server_source_interface")

    @property
    @pulumi.getter(name="highSpeedLoggingVpn")
    def high_speed_logging_vpn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        High Speed Logging VPN
        """
        return pulumi.get(self, "high_speed_logging_vpn")

    @property
    @pulumi.getter(name="imcpUnreachableAllow")
    def imcp_unreachable_allow(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        ICMP Unreachable Allow
        """
        return pulumi.get(self, "imcp_unreachable_allow")

    @property
    @pulumi.getter
    def loggings(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityPolicyLogging']]]:
        return pulumi.get(self, "loggings")

    @property
    @pulumi.getter(name="matchStatisticsPerFilter")
    def match_statistics_per_filter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Match Statistics per-filter - Choices: `on`, `off`
        """
        return pulumi.get(self, "match_statistics_per_filter")

    @property
    @pulumi.getter(name="maxIncompleteIcmpLimit")
    def max_incomplete_icmp_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Max Incomplete ICMP Limit
        """
        return pulumi.get(self, "max_incomplete_icmp_limit")

    @property
    @pulumi.getter(name="maxIncompleteTcpLimit")
    def max_incomplete_tcp_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Max Incomplete TCP Limit
        """
        return pulumi.get(self, "max_incomplete_tcp_limit")

    @property
    @pulumi.getter(name="maxIncompleteUdpLimit")
    def max_incomplete_udp_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Max Incomplete UDP Limit
        """
        return pulumi.get(self, "max_incomplete_udp_limit")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[builtins.str]:
        """
        The policy mode - Choices: `security`, `unified` - Default value: `security`
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the security policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sessionReclassifyAllow")
    def session_reclassify_allow(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Session Reclassify Allow
        """
        return pulumi.get(self, "session_reclassify_allow")

    @property
    @pulumi.getter(name="tcpSynFloodLimit")
    def tcp_syn_flood_limit(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        TCP SYN Flood Limit, value from 1 to 4294967295
        """
        return pulumi.get(self, "tcp_syn_flood_limit")

    @property
    @pulumi.getter(name="unifiedLogging")
    def unified_logging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Unified Logging
        """
        return pulumi.get(self, "unified_logging")

    @property
    @pulumi.getter(name="useCase")
    def use_case(self) -> pulumi.Output[builtins.str]:
        """
        The use case of the security policy - Choices: `custom`, `compliance`, `guestAccess`, `directCloudAccess`,
        `directInternetAccess`, `directCloudAccess` - Default value: `custom`
        """
        return pulumi.get(self, "use_case")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

