# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceLanVpnInterfaceGreFeatureArgs', 'ServiceLanVpnInterfaceGreFeature']

@pulumi.input_type
class ServiceLanVpnInterfaceGreFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 service_lan_vpn_feature_id: pulumi.Input[builtins.str],
                 application_tunnel_type: Optional[pulumi.Input[builtins.str]] = None,
                 application_tunnel_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_loopback: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_loopback: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceLanVpnInterfaceGreFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] service_lan_vpn_feature_id: Service LAN VPN Feature ID
        :param pulumi.Input[builtins.str] application_tunnel_type: Enable Application Tunnel Type - Choices: `none`, `sig`
        :param pulumi.Input[builtins.str] application_tunnel_type_variable: Variable name
        :param pulumi.Input[builtins.bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[builtins.str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name (1..255)
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.int] ip_mtu: Interface MTU <576..9976>, in bytes - Range: `576`-`9976` - Default value: `1500`
        :param pulumi.Input[builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_subnet_mask: - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] ipv4_subnet_mask_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[builtins.str] tcp_mss_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_destination_ipv4_address: Tunnel destination IP Address
        :param pulumi.Input[builtins.str] tunnel_destination_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_route_via_loopback: <1..32 characters> Interface name, can't be Loopback interface
        :param pulumi.Input[builtins.str] tunnel_route_via_loopback_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_interface: <1..32 characters> Interface name
        :param pulumi.Input[builtins.str] tunnel_source_interface_loopback: <1..32 characters> Interface name
        :param pulumi.Input[builtins.str] tunnel_source_interface_loopback_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_ipv4_address: Tunnel source IP Address
        :param pulumi.Input[builtins.str] tunnel_source_ipv4_address_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "service_lan_vpn_feature_id", service_lan_vpn_feature_id)
        if application_tunnel_type is not None:
            pulumi.set(__self__, "application_tunnel_type", application_tunnel_type)
        if application_tunnel_type_variable is not None:
            pulumi.set(__self__, "application_tunnel_type_variable", application_tunnel_type_variable)
        if clear_dont_fragment is not None:
            pulumi.set(__self__, "clear_dont_fragment", clear_dont_fragment)
        if clear_dont_fragment_variable is not None:
            pulumi.set(__self__, "clear_dont_fragment_variable", clear_dont_fragment_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if ip_mtu_variable is not None:
            pulumi.set(__self__, "ip_mtu_variable", ip_mtu_variable)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable is not None:
            pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if ipv4_subnet_mask is not None:
            pulumi.set(__self__, "ipv4_subnet_mask", ipv4_subnet_mask)
        if ipv4_subnet_mask_variable is not None:
            pulumi.set(__self__, "ipv4_subnet_mask_variable", ipv4_subnet_mask_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if tcp_mss is not None:
            pulumi.set(__self__, "tcp_mss", tcp_mss)
        if tcp_mss_variable is not None:
            pulumi.set(__self__, "tcp_mss_variable", tcp_mss_variable)
        if tunnel_destination_ipv4_address is not None:
            pulumi.set(__self__, "tunnel_destination_ipv4_address", tunnel_destination_ipv4_address)
        if tunnel_destination_ipv4_address_variable is not None:
            pulumi.set(__self__, "tunnel_destination_ipv4_address_variable", tunnel_destination_ipv4_address_variable)
        if tunnel_route_via_loopback is not None:
            pulumi.set(__self__, "tunnel_route_via_loopback", tunnel_route_via_loopback)
        if tunnel_route_via_loopback_variable is not None:
            pulumi.set(__self__, "tunnel_route_via_loopback_variable", tunnel_route_via_loopback_variable)
        if tunnel_source_interface is not None:
            pulumi.set(__self__, "tunnel_source_interface", tunnel_source_interface)
        if tunnel_source_interface_loopback is not None:
            pulumi.set(__self__, "tunnel_source_interface_loopback", tunnel_source_interface_loopback)
        if tunnel_source_interface_loopback_variable is not None:
            pulumi.set(__self__, "tunnel_source_interface_loopback_variable", tunnel_source_interface_loopback_variable)
        if tunnel_source_interface_variable is not None:
            pulumi.set(__self__, "tunnel_source_interface_variable", tunnel_source_interface_variable)
        if tunnel_source_ipv4_address is not None:
            pulumi.set(__self__, "tunnel_source_ipv4_address", tunnel_source_ipv4_address)
        if tunnel_source_ipv4_address_variable is not None:
            pulumi.set(__self__, "tunnel_source_ipv4_address_variable", tunnel_source_ipv4_address_variable)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="serviceLanVpnFeatureId")
    def service_lan_vpn_feature_id(self) -> pulumi.Input[builtins.str]:
        """
        Service LAN VPN Feature ID
        """
        return pulumi.get(self, "service_lan_vpn_feature_id")

    @service_lan_vpn_feature_id.setter
    def service_lan_vpn_feature_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_lan_vpn_feature_id", value)

    @property
    @pulumi.getter(name="applicationTunnelType")
    def application_tunnel_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig`
        """
        return pulumi.get(self, "application_tunnel_type")

    @application_tunnel_type.setter
    def application_tunnel_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_tunnel_type", value)

    @property
    @pulumi.getter(name="applicationTunnelTypeVariable")
    def application_tunnel_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_tunnel_type_variable")

    @application_tunnel_type_variable.setter
    def application_tunnel_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_tunnel_type_variable", value)

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @clear_dont_fragment.setter
    def clear_dont_fragment(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "clear_dont_fragment", value)

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @clear_dont_fragment_variable.setter
    def clear_dont_fragment_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "clear_dont_fragment_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description", value)

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface name (1..255)
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interface MTU <576..9976>, in bytes - Range: `576`-`9976` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ip_mtu", value)

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @ip_mtu_variable.setter
    def ip_mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_mtu_variable", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @ipv4_address_variable.setter
    def ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_address_variable", value)

    @property
    @pulumi.getter(name="ipv4SubnetMask")
    def ipv4_subnet_mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "ipv4_subnet_mask")

    @ipv4_subnet_mask.setter
    def ipv4_subnet_mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_subnet_mask", value)

    @property
    @pulumi.getter(name="ipv4SubnetMaskVariable")
    def ipv4_subnet_mask_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_subnet_mask_variable")

    @ipv4_subnet_mask_variable.setter
    def ipv4_subnet_mask_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_subnet_mask_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Administrative state - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="tcpMss")
    def tcp_mss(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss")

    @tcp_mss.setter
    def tcp_mss(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tcp_mss", value)

    @property
    @pulumi.getter(name="tcpMssVariable")
    def tcp_mss_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_variable")

    @tcp_mss_variable.setter
    def tcp_mss_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_mss_variable", value)

    @property
    @pulumi.getter(name="tunnelDestinationIpv4Address")
    def tunnel_destination_ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tunnel destination IP Address
        """
        return pulumi.get(self, "tunnel_destination_ipv4_address")

    @tunnel_destination_ipv4_address.setter
    def tunnel_destination_ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_destination_ipv4_address", value)

    @property
    @pulumi.getter(name="tunnelDestinationIpv4AddressVariable")
    def tunnel_destination_ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_ipv4_address_variable")

    @tunnel_destination_ipv4_address_variable.setter
    def tunnel_destination_ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_destination_ipv4_address_variable", value)

    @property
    @pulumi.getter(name="tunnelRouteViaLoopback")
    def tunnel_route_via_loopback(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name, can't be Loopback interface
        """
        return pulumi.get(self, "tunnel_route_via_loopback")

    @tunnel_route_via_loopback.setter
    def tunnel_route_via_loopback(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_route_via_loopback", value)

    @property
    @pulumi.getter(name="tunnelRouteViaLoopbackVariable")
    def tunnel_route_via_loopback_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_loopback_variable")

    @tunnel_route_via_loopback_variable.setter
    def tunnel_route_via_loopback_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_route_via_loopback_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name
        """
        return pulumi.get(self, "tunnel_source_interface")

    @tunnel_source_interface.setter
    def tunnel_source_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceLoopback")
    def tunnel_source_interface_loopback(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name
        """
        return pulumi.get(self, "tunnel_source_interface_loopback")

    @tunnel_source_interface_loopback.setter
    def tunnel_source_interface_loopback(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface_loopback", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceLoopbackVariable")
    def tunnel_source_interface_loopback_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_loopback_variable")

    @tunnel_source_interface_loopback_variable.setter
    def tunnel_source_interface_loopback_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface_loopback_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @tunnel_source_interface_variable.setter
    def tunnel_source_interface_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceIpv4Address")
    def tunnel_source_ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source_ipv4_address")

    @tunnel_source_ipv4_address.setter
    def tunnel_source_ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_ipv4_address", value)

    @property
    @pulumi.getter(name="tunnelSourceIpv4AddressVariable")
    def tunnel_source_ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_ipv4_address_variable")

    @tunnel_source_ipv4_address_variable.setter
    def tunnel_source_ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_ipv4_address_variable", value)


@pulumi.input_type
class _ServiceLanVpnInterfaceGreFeatureState:
    def __init__(__self__, *,
                 application_tunnel_type: Optional[pulumi.Input[builtins.str]] = None,
                 application_tunnel_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_loopback: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_loopback: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceLanVpnInterfaceGreFeature resources.
        :param pulumi.Input[builtins.str] application_tunnel_type: Enable Application Tunnel Type - Choices: `none`, `sig`
        :param pulumi.Input[builtins.str] application_tunnel_type_variable: Variable name
        :param pulumi.Input[builtins.bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[builtins.str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name (1..255)
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.int] ip_mtu: Interface MTU <576..9976>, in bytes - Range: `576`-`9976` - Default value: `1500`
        :param pulumi.Input[builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_subnet_mask: - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] ipv4_subnet_mask_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] service_lan_vpn_feature_id: Service LAN VPN Feature ID
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[builtins.str] tcp_mss_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_destination_ipv4_address: Tunnel destination IP Address
        :param pulumi.Input[builtins.str] tunnel_destination_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_route_via_loopback: <1..32 characters> Interface name, can't be Loopback interface
        :param pulumi.Input[builtins.str] tunnel_route_via_loopback_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_interface: <1..32 characters> Interface name
        :param pulumi.Input[builtins.str] tunnel_source_interface_loopback: <1..32 characters> Interface name
        :param pulumi.Input[builtins.str] tunnel_source_interface_loopback_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_ipv4_address: Tunnel source IP Address
        :param pulumi.Input[builtins.str] tunnel_source_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if application_tunnel_type is not None:
            pulumi.set(__self__, "application_tunnel_type", application_tunnel_type)
        if application_tunnel_type_variable is not None:
            pulumi.set(__self__, "application_tunnel_type_variable", application_tunnel_type_variable)
        if clear_dont_fragment is not None:
            pulumi.set(__self__, "clear_dont_fragment", clear_dont_fragment)
        if clear_dont_fragment_variable is not None:
            pulumi.set(__self__, "clear_dont_fragment_variable", clear_dont_fragment_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if ip_mtu_variable is not None:
            pulumi.set(__self__, "ip_mtu_variable", ip_mtu_variable)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable is not None:
            pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if ipv4_subnet_mask is not None:
            pulumi.set(__self__, "ipv4_subnet_mask", ipv4_subnet_mask)
        if ipv4_subnet_mask_variable is not None:
            pulumi.set(__self__, "ipv4_subnet_mask_variable", ipv4_subnet_mask_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_lan_vpn_feature_id is not None:
            pulumi.set(__self__, "service_lan_vpn_feature_id", service_lan_vpn_feature_id)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if tcp_mss is not None:
            pulumi.set(__self__, "tcp_mss", tcp_mss)
        if tcp_mss_variable is not None:
            pulumi.set(__self__, "tcp_mss_variable", tcp_mss_variable)
        if tunnel_destination_ipv4_address is not None:
            pulumi.set(__self__, "tunnel_destination_ipv4_address", tunnel_destination_ipv4_address)
        if tunnel_destination_ipv4_address_variable is not None:
            pulumi.set(__self__, "tunnel_destination_ipv4_address_variable", tunnel_destination_ipv4_address_variable)
        if tunnel_route_via_loopback is not None:
            pulumi.set(__self__, "tunnel_route_via_loopback", tunnel_route_via_loopback)
        if tunnel_route_via_loopback_variable is not None:
            pulumi.set(__self__, "tunnel_route_via_loopback_variable", tunnel_route_via_loopback_variable)
        if tunnel_source_interface is not None:
            pulumi.set(__self__, "tunnel_source_interface", tunnel_source_interface)
        if tunnel_source_interface_loopback is not None:
            pulumi.set(__self__, "tunnel_source_interface_loopback", tunnel_source_interface_loopback)
        if tunnel_source_interface_loopback_variable is not None:
            pulumi.set(__self__, "tunnel_source_interface_loopback_variable", tunnel_source_interface_loopback_variable)
        if tunnel_source_interface_variable is not None:
            pulumi.set(__self__, "tunnel_source_interface_variable", tunnel_source_interface_variable)
        if tunnel_source_ipv4_address is not None:
            pulumi.set(__self__, "tunnel_source_ipv4_address", tunnel_source_ipv4_address)
        if tunnel_source_ipv4_address_variable is not None:
            pulumi.set(__self__, "tunnel_source_ipv4_address_variable", tunnel_source_ipv4_address_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="applicationTunnelType")
    def application_tunnel_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig`
        """
        return pulumi.get(self, "application_tunnel_type")

    @application_tunnel_type.setter
    def application_tunnel_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_tunnel_type", value)

    @property
    @pulumi.getter(name="applicationTunnelTypeVariable")
    def application_tunnel_type_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_tunnel_type_variable")

    @application_tunnel_type_variable.setter
    def application_tunnel_type_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_tunnel_type_variable", value)

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @clear_dont_fragment.setter
    def clear_dont_fragment(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "clear_dont_fragment", value)

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @clear_dont_fragment_variable.setter
    def clear_dont_fragment_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "clear_dont_fragment_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description", value)

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface name (1..255)
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interface MTU <576..9976>, in bytes - Range: `576`-`9976` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ip_mtu", value)

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @ip_mtu_variable.setter
    def ip_mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_mtu_variable", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @ipv4_address_variable.setter
    def ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_address_variable", value)

    @property
    @pulumi.getter(name="ipv4SubnetMask")
    def ipv4_subnet_mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "ipv4_subnet_mask")

    @ipv4_subnet_mask.setter
    def ipv4_subnet_mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_subnet_mask", value)

    @property
    @pulumi.getter(name="ipv4SubnetMaskVariable")
    def ipv4_subnet_mask_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_subnet_mask_variable")

    @ipv4_subnet_mask_variable.setter
    def ipv4_subnet_mask_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_subnet_mask_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceLanVpnFeatureId")
    def service_lan_vpn_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service LAN VPN Feature ID
        """
        return pulumi.get(self, "service_lan_vpn_feature_id")

    @service_lan_vpn_feature_id.setter
    def service_lan_vpn_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_lan_vpn_feature_id", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Administrative state - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="tcpMss")
    def tcp_mss(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss")

    @tcp_mss.setter
    def tcp_mss(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tcp_mss", value)

    @property
    @pulumi.getter(name="tcpMssVariable")
    def tcp_mss_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_variable")

    @tcp_mss_variable.setter
    def tcp_mss_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_mss_variable", value)

    @property
    @pulumi.getter(name="tunnelDestinationIpv4Address")
    def tunnel_destination_ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tunnel destination IP Address
        """
        return pulumi.get(self, "tunnel_destination_ipv4_address")

    @tunnel_destination_ipv4_address.setter
    def tunnel_destination_ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_destination_ipv4_address", value)

    @property
    @pulumi.getter(name="tunnelDestinationIpv4AddressVariable")
    def tunnel_destination_ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_ipv4_address_variable")

    @tunnel_destination_ipv4_address_variable.setter
    def tunnel_destination_ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_destination_ipv4_address_variable", value)

    @property
    @pulumi.getter(name="tunnelRouteViaLoopback")
    def tunnel_route_via_loopback(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name, can't be Loopback interface
        """
        return pulumi.get(self, "tunnel_route_via_loopback")

    @tunnel_route_via_loopback.setter
    def tunnel_route_via_loopback(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_route_via_loopback", value)

    @property
    @pulumi.getter(name="tunnelRouteViaLoopbackVariable")
    def tunnel_route_via_loopback_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_loopback_variable")

    @tunnel_route_via_loopback_variable.setter
    def tunnel_route_via_loopback_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_route_via_loopback_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name
        """
        return pulumi.get(self, "tunnel_source_interface")

    @tunnel_source_interface.setter
    def tunnel_source_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceLoopback")
    def tunnel_source_interface_loopback(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <1..32 characters> Interface name
        """
        return pulumi.get(self, "tunnel_source_interface_loopback")

    @tunnel_source_interface_loopback.setter
    def tunnel_source_interface_loopback(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface_loopback", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceLoopbackVariable")
    def tunnel_source_interface_loopback_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_loopback_variable")

    @tunnel_source_interface_loopback_variable.setter
    def tunnel_source_interface_loopback_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface_loopback_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @tunnel_source_interface_variable.setter
    def tunnel_source_interface_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_interface_variable", value)

    @property
    @pulumi.getter(name="tunnelSourceIpv4Address")
    def tunnel_source_ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source_ipv4_address")

    @tunnel_source_ipv4_address.setter
    def tunnel_source_ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_ipv4_address", value)

    @property
    @pulumi.getter(name="tunnelSourceIpv4AddressVariable")
    def tunnel_source_ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_ipv4_address_variable")

    @tunnel_source_ipv4_address_variable.setter
    def tunnel_source_ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_source_ipv4_address_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/serviceLanVpnInterfaceGreFeature:ServiceLanVpnInterfaceGreFeature")
class ServiceLanVpnInterfaceGreFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_tunnel_type: Optional[pulumi.Input[builtins.str]] = None,
                 application_tunnel_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_loopback: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_loopback: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Service LAN VPN Interface GRE Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ServiceLanVpnInterfaceGreFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            service_lan_vpn_feature_id="140331f6-5418-4755-a059-13c77eb96037",
            interface_name="gre1",
            interface_description="gre1",
            ipv4_address="70.1.1.1",
            ipv4_subnet_mask="255.255.255.0",
            shutdown=True,
            tunnel_source_ipv4_address="78.1.1.1",
            tunnel_destination_ipv4_address="79.1.1.1",
            ip_mtu=1500,
            tcp_mss=1460,
            clear_dont_fragment=False,
            application_tunnel_type="none")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "service_lan_vpn_interface_gre_feature_id,feature_profile_id,service_lan_vpn_feature_id"

        ```sh
        $ pulumi import sdwan:index/serviceLanVpnInterfaceGreFeature:ServiceLanVpnInterfaceGreFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac,140331f6-5418-4755-a059-13c77eb96037"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_tunnel_type: Enable Application Tunnel Type - Choices: `none`, `sig`
        :param pulumi.Input[builtins.str] application_tunnel_type_variable: Variable name
        :param pulumi.Input[builtins.bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[builtins.str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name (1..255)
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.int] ip_mtu: Interface MTU <576..9976>, in bytes - Range: `576`-`9976` - Default value: `1500`
        :param pulumi.Input[builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_subnet_mask: - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] ipv4_subnet_mask_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] service_lan_vpn_feature_id: Service LAN VPN Feature ID
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[builtins.str] tcp_mss_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_destination_ipv4_address: Tunnel destination IP Address
        :param pulumi.Input[builtins.str] tunnel_destination_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_route_via_loopback: <1..32 characters> Interface name, can't be Loopback interface
        :param pulumi.Input[builtins.str] tunnel_route_via_loopback_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_interface: <1..32 characters> Interface name
        :param pulumi.Input[builtins.str] tunnel_source_interface_loopback: <1..32 characters> Interface name
        :param pulumi.Input[builtins.str] tunnel_source_interface_loopback_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_ipv4_address: Tunnel source IP Address
        :param pulumi.Input[builtins.str] tunnel_source_ipv4_address_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceLanVpnInterfaceGreFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service LAN VPN Interface GRE Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ServiceLanVpnInterfaceGreFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            service_lan_vpn_feature_id="140331f6-5418-4755-a059-13c77eb96037",
            interface_name="gre1",
            interface_description="gre1",
            ipv4_address="70.1.1.1",
            ipv4_subnet_mask="255.255.255.0",
            shutdown=True,
            tunnel_source_ipv4_address="78.1.1.1",
            tunnel_destination_ipv4_address="79.1.1.1",
            ip_mtu=1500,
            tcp_mss=1460,
            clear_dont_fragment=False,
            application_tunnel_type="none")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "service_lan_vpn_interface_gre_feature_id,feature_profile_id,service_lan_vpn_feature_id"

        ```sh
        $ pulumi import sdwan:index/serviceLanVpnInterfaceGreFeature:ServiceLanVpnInterfaceGreFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac,140331f6-5418-4755-a059-13c77eb96037"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceLanVpnInterfaceGreFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceLanVpnInterfaceGreFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_tunnel_type: Optional[pulumi.Input[builtins.str]] = None,
                 application_tunnel_type_variable: Optional[pulumi.Input[builtins.str]] = None,
                 clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
                 clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_destination_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_loopback: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_route_via_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_loopback: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_source_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceLanVpnInterfaceGreFeatureArgs.__new__(ServiceLanVpnInterfaceGreFeatureArgs)

            __props__.__dict__["application_tunnel_type"] = application_tunnel_type
            __props__.__dict__["application_tunnel_type_variable"] = application_tunnel_type_variable
            __props__.__dict__["clear_dont_fragment"] = clear_dont_fragment
            __props__.__dict__["clear_dont_fragment_variable"] = clear_dont_fragment_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["interface_description"] = interface_description
            __props__.__dict__["interface_description_variable"] = interface_description_variable
            __props__.__dict__["interface_name"] = interface_name
            __props__.__dict__["interface_name_variable"] = interface_name_variable
            __props__.__dict__["ip_mtu"] = ip_mtu
            __props__.__dict__["ip_mtu_variable"] = ip_mtu_variable
            __props__.__dict__["ipv4_address"] = ipv4_address
            __props__.__dict__["ipv4_address_variable"] = ipv4_address_variable
            __props__.__dict__["ipv4_subnet_mask"] = ipv4_subnet_mask
            __props__.__dict__["ipv4_subnet_mask_variable"] = ipv4_subnet_mask_variable
            __props__.__dict__["name"] = name
            if service_lan_vpn_feature_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_lan_vpn_feature_id'")
            __props__.__dict__["service_lan_vpn_feature_id"] = service_lan_vpn_feature_id
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["tcp_mss"] = tcp_mss
            __props__.__dict__["tcp_mss_variable"] = tcp_mss_variable
            __props__.__dict__["tunnel_destination_ipv4_address"] = tunnel_destination_ipv4_address
            __props__.__dict__["tunnel_destination_ipv4_address_variable"] = tunnel_destination_ipv4_address_variable
            __props__.__dict__["tunnel_route_via_loopback"] = tunnel_route_via_loopback
            __props__.__dict__["tunnel_route_via_loopback_variable"] = tunnel_route_via_loopback_variable
            __props__.__dict__["tunnel_source_interface"] = tunnel_source_interface
            __props__.__dict__["tunnel_source_interface_loopback"] = tunnel_source_interface_loopback
            __props__.__dict__["tunnel_source_interface_loopback_variable"] = tunnel_source_interface_loopback_variable
            __props__.__dict__["tunnel_source_interface_variable"] = tunnel_source_interface_variable
            __props__.__dict__["tunnel_source_ipv4_address"] = tunnel_source_ipv4_address
            __props__.__dict__["tunnel_source_ipv4_address_variable"] = tunnel_source_ipv4_address_variable
            __props__.__dict__["version"] = None
        super(ServiceLanVpnInterfaceGreFeature, __self__).__init__(
            'sdwan:index/serviceLanVpnInterfaceGreFeature:ServiceLanVpnInterfaceGreFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_tunnel_type: Optional[pulumi.Input[builtins.str]] = None,
            application_tunnel_type_variable: Optional[pulumi.Input[builtins.str]] = None,
            clear_dont_fragment: Optional[pulumi.Input[builtins.bool]] = None,
            clear_dont_fragment_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            interface_description: Optional[pulumi.Input[builtins.str]] = None,
            interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
            interface_name: Optional[pulumi.Input[builtins.str]] = None,
            interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
            ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
            shutdown: Optional[pulumi.Input[builtins.bool]] = None,
            shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
            tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
            tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_destination_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_destination_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_route_via_loopback: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_route_via_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_interface: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_interface_loopback: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_interface_loopback_variable: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_interface_variable: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_source_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'ServiceLanVpnInterfaceGreFeature':
        """
        Get an existing ServiceLanVpnInterfaceGreFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_tunnel_type: Enable Application Tunnel Type - Choices: `none`, `sig`
        :param pulumi.Input[builtins.str] application_tunnel_type_variable: Variable name
        :param pulumi.Input[builtins.bool] clear_dont_fragment: Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        :param pulumi.Input[builtins.str] clear_dont_fragment_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name (1..255)
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.int] ip_mtu: Interface MTU <576..9976>, in bytes - Range: `576`-`9976` - Default value: `1500`
        :param pulumi.Input[builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_subnet_mask: - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] ipv4_subnet_mask_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] service_lan_vpn_feature_id: Service LAN VPN Feature ID
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss: TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        :param pulumi.Input[builtins.str] tcp_mss_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_destination_ipv4_address: Tunnel destination IP Address
        :param pulumi.Input[builtins.str] tunnel_destination_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_route_via_loopback: <1..32 characters> Interface name, can't be Loopback interface
        :param pulumi.Input[builtins.str] tunnel_route_via_loopback_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_interface: <1..32 characters> Interface name
        :param pulumi.Input[builtins.str] tunnel_source_interface_loopback: <1..32 characters> Interface name
        :param pulumi.Input[builtins.str] tunnel_source_interface_loopback_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_interface_variable: Variable name
        :param pulumi.Input[builtins.str] tunnel_source_ipv4_address: Tunnel source IP Address
        :param pulumi.Input[builtins.str] tunnel_source_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceLanVpnInterfaceGreFeatureState.__new__(_ServiceLanVpnInterfaceGreFeatureState)

        __props__.__dict__["application_tunnel_type"] = application_tunnel_type
        __props__.__dict__["application_tunnel_type_variable"] = application_tunnel_type_variable
        __props__.__dict__["clear_dont_fragment"] = clear_dont_fragment
        __props__.__dict__["clear_dont_fragment_variable"] = clear_dont_fragment_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["interface_description"] = interface_description
        __props__.__dict__["interface_description_variable"] = interface_description_variable
        __props__.__dict__["interface_name"] = interface_name
        __props__.__dict__["interface_name_variable"] = interface_name_variable
        __props__.__dict__["ip_mtu"] = ip_mtu
        __props__.__dict__["ip_mtu_variable"] = ip_mtu_variable
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv4_address_variable"] = ipv4_address_variable
        __props__.__dict__["ipv4_subnet_mask"] = ipv4_subnet_mask
        __props__.__dict__["ipv4_subnet_mask_variable"] = ipv4_subnet_mask_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["service_lan_vpn_feature_id"] = service_lan_vpn_feature_id
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["tcp_mss"] = tcp_mss
        __props__.__dict__["tcp_mss_variable"] = tcp_mss_variable
        __props__.__dict__["tunnel_destination_ipv4_address"] = tunnel_destination_ipv4_address
        __props__.__dict__["tunnel_destination_ipv4_address_variable"] = tunnel_destination_ipv4_address_variable
        __props__.__dict__["tunnel_route_via_loopback"] = tunnel_route_via_loopback
        __props__.__dict__["tunnel_route_via_loopback_variable"] = tunnel_route_via_loopback_variable
        __props__.__dict__["tunnel_source_interface"] = tunnel_source_interface
        __props__.__dict__["tunnel_source_interface_loopback"] = tunnel_source_interface_loopback
        __props__.__dict__["tunnel_source_interface_loopback_variable"] = tunnel_source_interface_loopback_variable
        __props__.__dict__["tunnel_source_interface_variable"] = tunnel_source_interface_variable
        __props__.__dict__["tunnel_source_ipv4_address"] = tunnel_source_ipv4_address
        __props__.__dict__["tunnel_source_ipv4_address_variable"] = tunnel_source_ipv4_address_variable
        __props__.__dict__["version"] = version
        return ServiceLanVpnInterfaceGreFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationTunnelType")
    def application_tunnel_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enable Application Tunnel Type - Choices: `none`, `sig`
        """
        return pulumi.get(self, "application_tunnel_type")

    @property
    @pulumi.getter(name="applicationTunnelTypeVariable")
    def application_tunnel_type_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "application_tunnel_type_variable")

    @property
    @pulumi.getter(name="clearDontFragment")
    def clear_dont_fragment(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable clear dont fragment (Currently Only SDWAN Tunnel Interface) - Default value: `false`
        """
        return pulumi.get(self, "clear_dont_fragment")

    @property
    @pulumi.getter(name="clearDontFragmentVariable")
    def clear_dont_fragment_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "clear_dont_fragment_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Interface name (1..255)
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Interface MTU <576..9976>, in bytes - Range: `576`-`9976` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @property
    @pulumi.getter(name="ipv4SubnetMask")
    def ipv4_subnet_mask(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "ipv4_subnet_mask")

    @property
    @pulumi.getter(name="ipv4SubnetMaskVariable")
    def ipv4_subnet_mask_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_subnet_mask_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceLanVpnFeatureId")
    def service_lan_vpn_feature_id(self) -> pulumi.Output[builtins.str]:
        """
        Service LAN VPN Feature ID
        """
        return pulumi.get(self, "service_lan_vpn_feature_id")

    @property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Administrative state - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="tcpMss")
    def tcp_mss(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `500`-`1460`
        """
        return pulumi.get(self, "tcp_mss")

    @property
    @pulumi.getter(name="tcpMssVariable")
    def tcp_mss_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_variable")

    @property
    @pulumi.getter(name="tunnelDestinationIpv4Address")
    def tunnel_destination_ipv4_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Tunnel destination IP Address
        """
        return pulumi.get(self, "tunnel_destination_ipv4_address")

    @property
    @pulumi.getter(name="tunnelDestinationIpv4AddressVariable")
    def tunnel_destination_ipv4_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_destination_ipv4_address_variable")

    @property
    @pulumi.getter(name="tunnelRouteViaLoopback")
    def tunnel_route_via_loopback(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        <1..32 characters> Interface name, can't be Loopback interface
        """
        return pulumi.get(self, "tunnel_route_via_loopback")

    @property
    @pulumi.getter(name="tunnelRouteViaLoopbackVariable")
    def tunnel_route_via_loopback_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_route_via_loopback_variable")

    @property
    @pulumi.getter(name="tunnelSourceInterface")
    def tunnel_source_interface(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        <1..32 characters> Interface name
        """
        return pulumi.get(self, "tunnel_source_interface")

    @property
    @pulumi.getter(name="tunnelSourceInterfaceLoopback")
    def tunnel_source_interface_loopback(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        <1..32 characters> Interface name
        """
        return pulumi.get(self, "tunnel_source_interface_loopback")

    @property
    @pulumi.getter(name="tunnelSourceInterfaceLoopbackVariable")
    def tunnel_source_interface_loopback_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_loopback_variable")

    @property
    @pulumi.getter(name="tunnelSourceInterfaceVariable")
    def tunnel_source_interface_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_interface_variable")

    @property
    @pulumi.getter(name="tunnelSourceIpv4Address")
    def tunnel_source_ipv4_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Tunnel source IP Address
        """
        return pulumi.get(self, "tunnel_source_ipv4_address")

    @property
    @pulumi.getter(name="tunnelSourceIpv4AddressVariable")
    def tunnel_source_ipv4_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tunnel_source_ipv4_address_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

