# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CedgePimFeatureTemplateArgs', 'CedgePimFeatureTemplate']

@pulumi.input_type
class CedgePimFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 bsr_candidate: Optional[pulumi.Input[builtins.str]] = None,
                 bsr_candidate_variable: Optional[pulumi.Input[builtins.str]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 default_variable: Optional[pulumi.Input[builtins.str]] = None,
                 hash_mask_length: Optional[pulumi.Input[builtins.str]] = None,
                 hash_mask_length_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateInterfaceArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 priority_variable: Optional[pulumi.Input[builtins.str]] = None,
                 range: Optional[pulumi.Input[builtins.str]] = None,
                 range_variable: Optional[pulumi.Input[builtins.str]] = None,
                 rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAddressArgs']]]] = None,
                 rp_announce_fields: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAnnounceFieldArgs']]]] = None,
                 rp_candidate_access_list: Optional[pulumi.Input[builtins.str]] = None,
                 rp_candidate_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpCandidateArgs']]]] = None,
                 scope: Optional[pulumi.Input[builtins.int]] = None,
                 scope_variable: Optional[pulumi.Input[builtins.str]] = None,
                 spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CedgePimFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] auto_rp: Enable or disable auto-RP - Default value: `false`
        :param pulumi.Input[builtins.str] auto_rp_variable: Variable name
        :param pulumi.Input[builtins.str] bsr_candidate: Set Autonomic-Networking virtual interface
        :param pulumi.Input[builtins.str] bsr_candidate_variable: Variable name
        :param pulumi.Input[builtins.bool] default: Turn SSM On / Off - Default value: `false`
        :param pulumi.Input[builtins.str] default_variable: Variable name
        :param pulumi.Input[builtins.str] hash_mask_length: Hash Mask length for RP selection
        :param pulumi.Input[builtins.str] hash_mask_length_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Set RP Discovery Interface Name
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateInterfaceArgs']]] interfaces: Set PIM interface parameters
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.int] priority: Set RP candidate priority - Range: `0`-`255`
        :param pulumi.Input[builtins.str] priority_variable: Variable name
        :param pulumi.Input[builtins.str] range: Set Access List for PIM SSM
        :param pulumi.Input[builtins.str] range_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAddressArgs']]] rp_addresses: Set Static RP Address(es)
        :param pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAnnounceFieldArgs']]] rp_announce_fields: Enable or disable RP Announce
        :param pulumi.Input[builtins.str] rp_candidate_access_list: Set BSR RP candidate filter
        :param pulumi.Input[builtins.str] rp_candidate_access_list_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpCandidateArgs']]] rp_candidates: Set RP Discovery Scope
        :param pulumi.Input[builtins.int] scope: Set RP Discovery Scope - Range: `1`-`255`
        :param pulumi.Input[builtins.str] scope_variable: Variable name
        :param pulumi.Input[builtins.str] spt_threshold: Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity`
        :param pulumi.Input[builtins.str] spt_threshold_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if auto_rp is not None:
            pulumi.set(__self__, "auto_rp", auto_rp)
        if auto_rp_variable is not None:
            pulumi.set(__self__, "auto_rp_variable", auto_rp_variable)
        if bsr_candidate is not None:
            pulumi.set(__self__, "bsr_candidate", bsr_candidate)
        if bsr_candidate_variable is not None:
            pulumi.set(__self__, "bsr_candidate_variable", bsr_candidate_variable)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if default_variable is not None:
            pulumi.set(__self__, "default_variable", default_variable)
        if hash_mask_length is not None:
            pulumi.set(__self__, "hash_mask_length", hash_mask_length)
        if hash_mask_length_variable is not None:
            pulumi.set(__self__, "hash_mask_length_variable", hash_mask_length_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if priority_variable is not None:
            pulumi.set(__self__, "priority_variable", priority_variable)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if range_variable is not None:
            pulumi.set(__self__, "range_variable", range_variable)
        if rp_addresses is not None:
            pulumi.set(__self__, "rp_addresses", rp_addresses)
        if rp_announce_fields is not None:
            pulumi.set(__self__, "rp_announce_fields", rp_announce_fields)
        if rp_candidate_access_list is not None:
            pulumi.set(__self__, "rp_candidate_access_list", rp_candidate_access_list)
        if rp_candidate_access_list_variable is not None:
            pulumi.set(__self__, "rp_candidate_access_list_variable", rp_candidate_access_list_variable)
        if rp_candidates is not None:
            pulumi.set(__self__, "rp_candidates", rp_candidates)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if scope_variable is not None:
            pulumi.set(__self__, "scope_variable", scope_variable)
        if spt_threshold is not None:
            pulumi.set(__self__, "spt_threshold", spt_threshold)
        if spt_threshold_variable is not None:
            pulumi.set(__self__, "spt_threshold_variable", spt_threshold_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="autoRp")
    def auto_rp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable auto-RP - Default value: `false`
        """
        return pulumi.get(self, "auto_rp")

    @auto_rp.setter
    def auto_rp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_rp", value)

    @property
    @pulumi.getter(name="autoRpVariable")
    def auto_rp_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "auto_rp_variable")

    @auto_rp_variable.setter
    def auto_rp_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_rp_variable", value)

    @property
    @pulumi.getter(name="bsrCandidate")
    def bsr_candidate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set Autonomic-Networking virtual interface
        """
        return pulumi.get(self, "bsr_candidate")

    @bsr_candidate.setter
    def bsr_candidate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bsr_candidate", value)

    @property
    @pulumi.getter(name="bsrCandidateVariable")
    def bsr_candidate_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "bsr_candidate_variable")

    @bsr_candidate_variable.setter
    def bsr_candidate_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bsr_candidate_variable", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Turn SSM On / Off - Default value: `false`
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="defaultVariable")
    def default_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_variable")

    @default_variable.setter
    def default_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_variable", value)

    @property
    @pulumi.getter(name="hashMaskLength")
    def hash_mask_length(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hash Mask length for RP selection
        """
        return pulumi.get(self, "hash_mask_length")

    @hash_mask_length.setter
    def hash_mask_length(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_mask_length", value)

    @property
    @pulumi.getter(name="hashMaskLengthVariable")
    def hash_mask_length_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hash_mask_length_variable")

    @hash_mask_length_variable.setter
    def hash_mask_length_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_mask_length_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set RP Discovery Interface Name
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateInterfaceArgs']]]]:
        """
        Set PIM interface parameters
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set RP candidate priority - Range: `0`-`255`
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="priorityVariable")
    def priority_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "priority_variable")

    @priority_variable.setter
    def priority_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "priority_variable", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set Access List for PIM SSM
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter(name="rangeVariable")
    def range_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "range_variable")

    @range_variable.setter
    def range_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "range_variable", value)

    @property
    @pulumi.getter(name="rpAddresses")
    def rp_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAddressArgs']]]]:
        """
        Set Static RP Address(es)
        """
        return pulumi.get(self, "rp_addresses")

    @rp_addresses.setter
    def rp_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAddressArgs']]]]):
        pulumi.set(self, "rp_addresses", value)

    @property
    @pulumi.getter(name="rpAnnounceFields")
    def rp_announce_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAnnounceFieldArgs']]]]:
        """
        Enable or disable RP Announce
        """
        return pulumi.get(self, "rp_announce_fields")

    @rp_announce_fields.setter
    def rp_announce_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAnnounceFieldArgs']]]]):
        pulumi.set(self, "rp_announce_fields", value)

    @property
    @pulumi.getter(name="rpCandidateAccessList")
    def rp_candidate_access_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set BSR RP candidate filter
        """
        return pulumi.get(self, "rp_candidate_access_list")

    @rp_candidate_access_list.setter
    def rp_candidate_access_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rp_candidate_access_list", value)

    @property
    @pulumi.getter(name="rpCandidateAccessListVariable")
    def rp_candidate_access_list_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rp_candidate_access_list_variable")

    @rp_candidate_access_list_variable.setter
    def rp_candidate_access_list_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rp_candidate_access_list_variable", value)

    @property
    @pulumi.getter(name="rpCandidates")
    def rp_candidates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpCandidateArgs']]]]:
        """
        Set RP Discovery Scope
        """
        return pulumi.get(self, "rp_candidates")

    @rp_candidates.setter
    def rp_candidates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpCandidateArgs']]]]):
        pulumi.set(self, "rp_candidates", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set RP Discovery Scope - Range: `1`-`255`
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="scopeVariable")
    def scope_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "scope_variable")

    @scope_variable.setter
    def scope_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope_variable", value)

    @property
    @pulumi.getter(name="sptThreshold")
    def spt_threshold(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity`
        """
        return pulumi.get(self, "spt_threshold")

    @spt_threshold.setter
    def spt_threshold(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spt_threshold", value)

    @property
    @pulumi.getter(name="sptThresholdVariable")
    def spt_threshold_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_threshold_variable")

    @spt_threshold_variable.setter
    def spt_threshold_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spt_threshold_variable", value)


@pulumi.input_type
class _CedgePimFeatureTemplateState:
    def __init__(__self__, *,
                 auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 bsr_candidate: Optional[pulumi.Input[builtins.str]] = None,
                 bsr_candidate_variable: Optional[pulumi.Input[builtins.str]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 default_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 hash_mask_length: Optional[pulumi.Input[builtins.str]] = None,
                 hash_mask_length_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateInterfaceArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 priority_variable: Optional[pulumi.Input[builtins.str]] = None,
                 range: Optional[pulumi.Input[builtins.str]] = None,
                 range_variable: Optional[pulumi.Input[builtins.str]] = None,
                 rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAddressArgs']]]] = None,
                 rp_announce_fields: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAnnounceFieldArgs']]]] = None,
                 rp_candidate_access_list: Optional[pulumi.Input[builtins.str]] = None,
                 rp_candidate_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpCandidateArgs']]]] = None,
                 scope: Optional[pulumi.Input[builtins.int]] = None,
                 scope_variable: Optional[pulumi.Input[builtins.str]] = None,
                 spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CedgePimFeatureTemplate resources.
        :param pulumi.Input[builtins.bool] auto_rp: Enable or disable auto-RP - Default value: `false`
        :param pulumi.Input[builtins.str] auto_rp_variable: Variable name
        :param pulumi.Input[builtins.str] bsr_candidate: Set Autonomic-Networking virtual interface
        :param pulumi.Input[builtins.str] bsr_candidate_variable: Variable name
        :param pulumi.Input[builtins.bool] default: Turn SSM On / Off - Default value: `false`
        :param pulumi.Input[builtins.str] default_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] hash_mask_length: Hash Mask length for RP selection
        :param pulumi.Input[builtins.str] hash_mask_length_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Set RP Discovery Interface Name
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateInterfaceArgs']]] interfaces: Set PIM interface parameters
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.int] priority: Set RP candidate priority - Range: `0`-`255`
        :param pulumi.Input[builtins.str] priority_variable: Variable name
        :param pulumi.Input[builtins.str] range: Set Access List for PIM SSM
        :param pulumi.Input[builtins.str] range_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAddressArgs']]] rp_addresses: Set Static RP Address(es)
        :param pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAnnounceFieldArgs']]] rp_announce_fields: Enable or disable RP Announce
        :param pulumi.Input[builtins.str] rp_candidate_access_list: Set BSR RP candidate filter
        :param pulumi.Input[builtins.str] rp_candidate_access_list_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpCandidateArgs']]] rp_candidates: Set RP Discovery Scope
        :param pulumi.Input[builtins.int] scope: Set RP Discovery Scope - Range: `1`-`255`
        :param pulumi.Input[builtins.str] scope_variable: Variable name
        :param pulumi.Input[builtins.str] spt_threshold: Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity`
        :param pulumi.Input[builtins.str] spt_threshold_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if auto_rp is not None:
            pulumi.set(__self__, "auto_rp", auto_rp)
        if auto_rp_variable is not None:
            pulumi.set(__self__, "auto_rp_variable", auto_rp_variable)
        if bsr_candidate is not None:
            pulumi.set(__self__, "bsr_candidate", bsr_candidate)
        if bsr_candidate_variable is not None:
            pulumi.set(__self__, "bsr_candidate_variable", bsr_candidate_variable)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if default_variable is not None:
            pulumi.set(__self__, "default_variable", default_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if hash_mask_length is not None:
            pulumi.set(__self__, "hash_mask_length", hash_mask_length)
        if hash_mask_length_variable is not None:
            pulumi.set(__self__, "hash_mask_length_variable", hash_mask_length_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if priority_variable is not None:
            pulumi.set(__self__, "priority_variable", priority_variable)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if range_variable is not None:
            pulumi.set(__self__, "range_variable", range_variable)
        if rp_addresses is not None:
            pulumi.set(__self__, "rp_addresses", rp_addresses)
        if rp_announce_fields is not None:
            pulumi.set(__self__, "rp_announce_fields", rp_announce_fields)
        if rp_candidate_access_list is not None:
            pulumi.set(__self__, "rp_candidate_access_list", rp_candidate_access_list)
        if rp_candidate_access_list_variable is not None:
            pulumi.set(__self__, "rp_candidate_access_list_variable", rp_candidate_access_list_variable)
        if rp_candidates is not None:
            pulumi.set(__self__, "rp_candidates", rp_candidates)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if scope_variable is not None:
            pulumi.set(__self__, "scope_variable", scope_variable)
        if spt_threshold is not None:
            pulumi.set(__self__, "spt_threshold", spt_threshold)
        if spt_threshold_variable is not None:
            pulumi.set(__self__, "spt_threshold_variable", spt_threshold_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="autoRp")
    def auto_rp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable auto-RP - Default value: `false`
        """
        return pulumi.get(self, "auto_rp")

    @auto_rp.setter
    def auto_rp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_rp", value)

    @property
    @pulumi.getter(name="autoRpVariable")
    def auto_rp_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "auto_rp_variable")

    @auto_rp_variable.setter
    def auto_rp_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_rp_variable", value)

    @property
    @pulumi.getter(name="bsrCandidate")
    def bsr_candidate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set Autonomic-Networking virtual interface
        """
        return pulumi.get(self, "bsr_candidate")

    @bsr_candidate.setter
    def bsr_candidate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bsr_candidate", value)

    @property
    @pulumi.getter(name="bsrCandidateVariable")
    def bsr_candidate_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "bsr_candidate_variable")

    @bsr_candidate_variable.setter
    def bsr_candidate_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bsr_candidate_variable", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Turn SSM On / Off - Default value: `false`
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="defaultVariable")
    def default_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_variable")

    @default_variable.setter
    def default_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="hashMaskLength")
    def hash_mask_length(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hash Mask length for RP selection
        """
        return pulumi.get(self, "hash_mask_length")

    @hash_mask_length.setter
    def hash_mask_length(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_mask_length", value)

    @property
    @pulumi.getter(name="hashMaskLengthVariable")
    def hash_mask_length_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hash_mask_length_variable")

    @hash_mask_length_variable.setter
    def hash_mask_length_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_mask_length_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set RP Discovery Interface Name
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateInterfaceArgs']]]]:
        """
        Set PIM interface parameters
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set RP candidate priority - Range: `0`-`255`
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="priorityVariable")
    def priority_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "priority_variable")

    @priority_variable.setter
    def priority_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "priority_variable", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set Access List for PIM SSM
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter(name="rangeVariable")
    def range_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "range_variable")

    @range_variable.setter
    def range_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "range_variable", value)

    @property
    @pulumi.getter(name="rpAddresses")
    def rp_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAddressArgs']]]]:
        """
        Set Static RP Address(es)
        """
        return pulumi.get(self, "rp_addresses")

    @rp_addresses.setter
    def rp_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAddressArgs']]]]):
        pulumi.set(self, "rp_addresses", value)

    @property
    @pulumi.getter(name="rpAnnounceFields")
    def rp_announce_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAnnounceFieldArgs']]]]:
        """
        Enable or disable RP Announce
        """
        return pulumi.get(self, "rp_announce_fields")

    @rp_announce_fields.setter
    def rp_announce_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpAnnounceFieldArgs']]]]):
        pulumi.set(self, "rp_announce_fields", value)

    @property
    @pulumi.getter(name="rpCandidateAccessList")
    def rp_candidate_access_list(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set BSR RP candidate filter
        """
        return pulumi.get(self, "rp_candidate_access_list")

    @rp_candidate_access_list.setter
    def rp_candidate_access_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rp_candidate_access_list", value)

    @property
    @pulumi.getter(name="rpCandidateAccessListVariable")
    def rp_candidate_access_list_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rp_candidate_access_list_variable")

    @rp_candidate_access_list_variable.setter
    def rp_candidate_access_list_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rp_candidate_access_list_variable", value)

    @property
    @pulumi.getter(name="rpCandidates")
    def rp_candidates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpCandidateArgs']]]]:
        """
        Set RP Discovery Scope
        """
        return pulumi.get(self, "rp_candidates")

    @rp_candidates.setter
    def rp_candidates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CedgePimFeatureTemplateRpCandidateArgs']]]]):
        pulumi.set(self, "rp_candidates", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set RP Discovery Scope - Range: `1`-`255`
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="scopeVariable")
    def scope_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "scope_variable")

    @scope_variable.setter
    def scope_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope_variable", value)

    @property
    @pulumi.getter(name="sptThreshold")
    def spt_threshold(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity`
        """
        return pulumi.get(self, "spt_threshold")

    @spt_threshold.setter
    def spt_threshold(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spt_threshold", value)

    @property
    @pulumi.getter(name="sptThresholdVariable")
    def spt_threshold_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_threshold_variable")

    @spt_threshold_variable.setter
    def spt_threshold_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spt_threshold_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/cedgePimFeatureTemplate:CedgePimFeatureTemplate")
class CedgePimFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 bsr_candidate: Optional[pulumi.Input[builtins.str]] = None,
                 bsr_candidate_variable: Optional[pulumi.Input[builtins.str]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 default_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 hash_mask_length: Optional[pulumi.Input[builtins.str]] = None,
                 hash_mask_length_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateInterfaceArgs', 'CedgePimFeatureTemplateInterfaceArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 priority_variable: Optional[pulumi.Input[builtins.str]] = None,
                 range: Optional[pulumi.Input[builtins.str]] = None,
                 range_variable: Optional[pulumi.Input[builtins.str]] = None,
                 rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAddressArgs', 'CedgePimFeatureTemplateRpAddressArgsDict']]]]] = None,
                 rp_announce_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAnnounceFieldArgs', 'CedgePimFeatureTemplateRpAnnounceFieldArgsDict']]]]] = None,
                 rp_candidate_access_list: Optional[pulumi.Input[builtins.str]] = None,
                 rp_candidate_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpCandidateArgs', 'CedgePimFeatureTemplateRpCandidateArgsDict']]]]] = None,
                 scope: Optional[pulumi.Input[builtins.int]] = None,
                 scope_variable: Optional[pulumi.Input[builtins.str]] = None,
                 spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a cEdge PIM feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/cedgePimFeatureTemplate:CedgePimFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_rp: Enable or disable auto-RP - Default value: `false`
        :param pulumi.Input[builtins.str] auto_rp_variable: Variable name
        :param pulumi.Input[builtins.str] bsr_candidate: Set Autonomic-Networking virtual interface
        :param pulumi.Input[builtins.str] bsr_candidate_variable: Variable name
        :param pulumi.Input[builtins.bool] default: Turn SSM On / Off - Default value: `false`
        :param pulumi.Input[builtins.str] default_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] hash_mask_length: Hash Mask length for RP selection
        :param pulumi.Input[builtins.str] hash_mask_length_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Set RP Discovery Interface Name
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateInterfaceArgs', 'CedgePimFeatureTemplateInterfaceArgsDict']]]] interfaces: Set PIM interface parameters
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.int] priority: Set RP candidate priority - Range: `0`-`255`
        :param pulumi.Input[builtins.str] priority_variable: Variable name
        :param pulumi.Input[builtins.str] range: Set Access List for PIM SSM
        :param pulumi.Input[builtins.str] range_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAddressArgs', 'CedgePimFeatureTemplateRpAddressArgsDict']]]] rp_addresses: Set Static RP Address(es)
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAnnounceFieldArgs', 'CedgePimFeatureTemplateRpAnnounceFieldArgsDict']]]] rp_announce_fields: Enable or disable RP Announce
        :param pulumi.Input[builtins.str] rp_candidate_access_list: Set BSR RP candidate filter
        :param pulumi.Input[builtins.str] rp_candidate_access_list_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpCandidateArgs', 'CedgePimFeatureTemplateRpCandidateArgsDict']]]] rp_candidates: Set RP Discovery Scope
        :param pulumi.Input[builtins.int] scope: Set RP Discovery Scope - Range: `1`-`255`
        :param pulumi.Input[builtins.str] scope_variable: Variable name
        :param pulumi.Input[builtins.str] spt_threshold: Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity`
        :param pulumi.Input[builtins.str] spt_threshold_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CedgePimFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a cEdge PIM feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/cedgePimFeatureTemplate:CedgePimFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CedgePimFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CedgePimFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 bsr_candidate: Optional[pulumi.Input[builtins.str]] = None,
                 bsr_candidate_variable: Optional[pulumi.Input[builtins.str]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 default_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 hash_mask_length: Optional[pulumi.Input[builtins.str]] = None,
                 hash_mask_length_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateInterfaceArgs', 'CedgePimFeatureTemplateInterfaceArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 priority_variable: Optional[pulumi.Input[builtins.str]] = None,
                 range: Optional[pulumi.Input[builtins.str]] = None,
                 range_variable: Optional[pulumi.Input[builtins.str]] = None,
                 rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAddressArgs', 'CedgePimFeatureTemplateRpAddressArgsDict']]]]] = None,
                 rp_announce_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAnnounceFieldArgs', 'CedgePimFeatureTemplateRpAnnounceFieldArgsDict']]]]] = None,
                 rp_candidate_access_list: Optional[pulumi.Input[builtins.str]] = None,
                 rp_candidate_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
                 rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpCandidateArgs', 'CedgePimFeatureTemplateRpCandidateArgsDict']]]]] = None,
                 scope: Optional[pulumi.Input[builtins.int]] = None,
                 scope_variable: Optional[pulumi.Input[builtins.str]] = None,
                 spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CedgePimFeatureTemplateArgs.__new__(CedgePimFeatureTemplateArgs)

            __props__.__dict__["auto_rp"] = auto_rp
            __props__.__dict__["auto_rp_variable"] = auto_rp_variable
            __props__.__dict__["bsr_candidate"] = bsr_candidate
            __props__.__dict__["bsr_candidate_variable"] = bsr_candidate_variable
            __props__.__dict__["default"] = default
            __props__.__dict__["default_variable"] = default_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["hash_mask_length"] = hash_mask_length
            __props__.__dict__["hash_mask_length_variable"] = hash_mask_length_variable
            __props__.__dict__["interface_name"] = interface_name
            __props__.__dict__["interface_name_variable"] = interface_name_variable
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["priority_variable"] = priority_variable
            __props__.__dict__["range"] = range
            __props__.__dict__["range_variable"] = range_variable
            __props__.__dict__["rp_addresses"] = rp_addresses
            __props__.__dict__["rp_announce_fields"] = rp_announce_fields
            __props__.__dict__["rp_candidate_access_list"] = rp_candidate_access_list
            __props__.__dict__["rp_candidate_access_list_variable"] = rp_candidate_access_list_variable
            __props__.__dict__["rp_candidates"] = rp_candidates
            __props__.__dict__["scope"] = scope
            __props__.__dict__["scope_variable"] = scope_variable
            __props__.__dict__["spt_threshold"] = spt_threshold
            __props__.__dict__["spt_threshold_variable"] = spt_threshold_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CedgePimFeatureTemplate, __self__).__init__(
            'sdwan:index/cedgePimFeatureTemplate:CedgePimFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_rp: Optional[pulumi.Input[builtins.bool]] = None,
            auto_rp_variable: Optional[pulumi.Input[builtins.str]] = None,
            bsr_candidate: Optional[pulumi.Input[builtins.str]] = None,
            bsr_candidate_variable: Optional[pulumi.Input[builtins.str]] = None,
            default: Optional[pulumi.Input[builtins.bool]] = None,
            default_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            hash_mask_length: Optional[pulumi.Input[builtins.str]] = None,
            hash_mask_length_variable: Optional[pulumi.Input[builtins.str]] = None,
            interface_name: Optional[pulumi.Input[builtins.str]] = None,
            interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateInterfaceArgs', 'CedgePimFeatureTemplateInterfaceArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            priority_variable: Optional[pulumi.Input[builtins.str]] = None,
            range: Optional[pulumi.Input[builtins.str]] = None,
            range_variable: Optional[pulumi.Input[builtins.str]] = None,
            rp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAddressArgs', 'CedgePimFeatureTemplateRpAddressArgsDict']]]]] = None,
            rp_announce_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAnnounceFieldArgs', 'CedgePimFeatureTemplateRpAnnounceFieldArgsDict']]]]] = None,
            rp_candidate_access_list: Optional[pulumi.Input[builtins.str]] = None,
            rp_candidate_access_list_variable: Optional[pulumi.Input[builtins.str]] = None,
            rp_candidates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpCandidateArgs', 'CedgePimFeatureTemplateRpCandidateArgsDict']]]]] = None,
            scope: Optional[pulumi.Input[builtins.int]] = None,
            scope_variable: Optional[pulumi.Input[builtins.str]] = None,
            spt_threshold: Optional[pulumi.Input[builtins.str]] = None,
            spt_threshold_variable: Optional[pulumi.Input[builtins.str]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CedgePimFeatureTemplate':
        """
        Get an existing CedgePimFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_rp: Enable or disable auto-RP - Default value: `false`
        :param pulumi.Input[builtins.str] auto_rp_variable: Variable name
        :param pulumi.Input[builtins.str] bsr_candidate: Set Autonomic-Networking virtual interface
        :param pulumi.Input[builtins.str] bsr_candidate_variable: Variable name
        :param pulumi.Input[builtins.bool] default: Turn SSM On / Off - Default value: `false`
        :param pulumi.Input[builtins.str] default_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] hash_mask_length: Hash Mask length for RP selection
        :param pulumi.Input[builtins.str] hash_mask_length_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Set RP Discovery Interface Name
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateInterfaceArgs', 'CedgePimFeatureTemplateInterfaceArgsDict']]]] interfaces: Set PIM interface parameters
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.int] priority: Set RP candidate priority - Range: `0`-`255`
        :param pulumi.Input[builtins.str] priority_variable: Variable name
        :param pulumi.Input[builtins.str] range: Set Access List for PIM SSM
        :param pulumi.Input[builtins.str] range_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAddressArgs', 'CedgePimFeatureTemplateRpAddressArgsDict']]]] rp_addresses: Set Static RP Address(es)
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpAnnounceFieldArgs', 'CedgePimFeatureTemplateRpAnnounceFieldArgsDict']]]] rp_announce_fields: Enable or disable RP Announce
        :param pulumi.Input[builtins.str] rp_candidate_access_list: Set BSR RP candidate filter
        :param pulumi.Input[builtins.str] rp_candidate_access_list_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CedgePimFeatureTemplateRpCandidateArgs', 'CedgePimFeatureTemplateRpCandidateArgsDict']]]] rp_candidates: Set RP Discovery Scope
        :param pulumi.Input[builtins.int] scope: Set RP Discovery Scope - Range: `1`-`255`
        :param pulumi.Input[builtins.str] scope_variable: Variable name
        :param pulumi.Input[builtins.str] spt_threshold: Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity`
        :param pulumi.Input[builtins.str] spt_threshold_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CedgePimFeatureTemplateState.__new__(_CedgePimFeatureTemplateState)

        __props__.__dict__["auto_rp"] = auto_rp
        __props__.__dict__["auto_rp_variable"] = auto_rp_variable
        __props__.__dict__["bsr_candidate"] = bsr_candidate
        __props__.__dict__["bsr_candidate_variable"] = bsr_candidate_variable
        __props__.__dict__["default"] = default
        __props__.__dict__["default_variable"] = default_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["hash_mask_length"] = hash_mask_length
        __props__.__dict__["hash_mask_length_variable"] = hash_mask_length_variable
        __props__.__dict__["interface_name"] = interface_name
        __props__.__dict__["interface_name_variable"] = interface_name_variable
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["priority_variable"] = priority_variable
        __props__.__dict__["range"] = range
        __props__.__dict__["range_variable"] = range_variable
        __props__.__dict__["rp_addresses"] = rp_addresses
        __props__.__dict__["rp_announce_fields"] = rp_announce_fields
        __props__.__dict__["rp_candidate_access_list"] = rp_candidate_access_list
        __props__.__dict__["rp_candidate_access_list_variable"] = rp_candidate_access_list_variable
        __props__.__dict__["rp_candidates"] = rp_candidates
        __props__.__dict__["scope"] = scope
        __props__.__dict__["scope_variable"] = scope_variable
        __props__.__dict__["spt_threshold"] = spt_threshold
        __props__.__dict__["spt_threshold_variable"] = spt_threshold_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CedgePimFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRp")
    def auto_rp(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable auto-RP - Default value: `false`
        """
        return pulumi.get(self, "auto_rp")

    @property
    @pulumi.getter(name="autoRpVariable")
    def auto_rp_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "auto_rp_variable")

    @property
    @pulumi.getter(name="bsrCandidate")
    def bsr_candidate(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set Autonomic-Networking virtual interface
        """
        return pulumi.get(self, "bsr_candidate")

    @property
    @pulumi.getter(name="bsrCandidateVariable")
    def bsr_candidate_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "bsr_candidate_variable")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Turn SSM On / Off - Default value: `false`
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter(name="defaultVariable")
    def default_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="hashMaskLength")
    def hash_mask_length(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Hash Mask length for RP selection
        """
        return pulumi.get(self, "hash_mask_length")

    @property
    @pulumi.getter(name="hashMaskLengthVariable")
    def hash_mask_length_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hash_mask_length_variable")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set RP Discovery Interface Name
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.CedgePimFeatureTemplateInterface']]]:
        """
        Set PIM interface parameters
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set RP candidate priority - Range: `0`-`255`
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="priorityVariable")
    def priority_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "priority_variable")

    @property
    @pulumi.getter
    def range(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set Access List for PIM SSM
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter(name="rangeVariable")
    def range_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "range_variable")

    @property
    @pulumi.getter(name="rpAddresses")
    def rp_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.CedgePimFeatureTemplateRpAddress']]]:
        """
        Set Static RP Address(es)
        """
        return pulumi.get(self, "rp_addresses")

    @property
    @pulumi.getter(name="rpAnnounceFields")
    def rp_announce_fields(self) -> pulumi.Output[Optional[Sequence['outputs.CedgePimFeatureTemplateRpAnnounceField']]]:
        """
        Enable or disable RP Announce
        """
        return pulumi.get(self, "rp_announce_fields")

    @property
    @pulumi.getter(name="rpCandidateAccessList")
    def rp_candidate_access_list(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set BSR RP candidate filter
        """
        return pulumi.get(self, "rp_candidate_access_list")

    @property
    @pulumi.getter(name="rpCandidateAccessListVariable")
    def rp_candidate_access_list_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rp_candidate_access_list_variable")

    @property
    @pulumi.getter(name="rpCandidates")
    def rp_candidates(self) -> pulumi.Output[Optional[Sequence['outputs.CedgePimFeatureTemplateRpCandidate']]]:
        """
        Set RP Discovery Scope
        """
        return pulumi.get(self, "rp_candidates")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set RP Discovery Scope - Range: `1`-`255`
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="scopeVariable")
    def scope_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "scope_variable")

    @property
    @pulumi.getter(name="sptThreshold")
    def spt_threshold(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set when PIM router joins the SPT (kbps) - Choices: `0`, `infinity`
        """
        return pulumi.get(self, "spt_threshold")

    @property
    @pulumi.getter(name="sptThresholdVariable")
    def spt_threshold_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "spt_threshold_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

