# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoLoggingFeatureTemplateArgs', 'CiscoLoggingFeatureTemplate']

@pulumi.input_type
class CiscoLoggingFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 disk_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 disk_logging_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv4ServerArgs']]]] = None,
                 ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv6ServerArgs']]]] = None,
                 log_rotations: Optional[pulumi.Input[builtins.int]] = None,
                 log_rotations_variable: Optional[pulumi.Input[builtins.str]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 max_size_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tls_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateTlsProfileArgs']]]] = None):
        """
        The set of arguments for constructing a CiscoLoggingFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] disk_logging: Enable logging to local disk - Default value: `true`
        :param pulumi.Input[builtins.str] disk_logging_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv4ServerArgs']]] ipv4_servers: Enable logging to remote server
        :param pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv6ServerArgs']]] ipv6_servers: Enable logging to remote IPv6 server
        :param pulumi.Input[builtins.int] log_rotations: Set number of syslog files to create before discarding oldest files - Range: `1`-`10` - Default value: `10`
        :param pulumi.Input[builtins.str] log_rotations_variable: Variable name
        :param pulumi.Input[builtins.int] max_size: Set maximum size of file before it is rotated - Range: `1`-`20` - Default value: `10`
        :param pulumi.Input[builtins.str] max_size_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateTlsProfileArgs']]] tls_profiles: Configure a TLS profile
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if disk_logging is not None:
            pulumi.set(__self__, "disk_logging", disk_logging)
        if disk_logging_variable is not None:
            pulumi.set(__self__, "disk_logging_variable", disk_logging_variable)
        if ipv4_servers is not None:
            pulumi.set(__self__, "ipv4_servers", ipv4_servers)
        if ipv6_servers is not None:
            pulumi.set(__self__, "ipv6_servers", ipv6_servers)
        if log_rotations is not None:
            pulumi.set(__self__, "log_rotations", log_rotations)
        if log_rotations_variable is not None:
            pulumi.set(__self__, "log_rotations_variable", log_rotations_variable)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_variable is not None:
            pulumi.set(__self__, "max_size_variable", max_size_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tls_profiles is not None:
            pulumi.set(__self__, "tls_profiles", tls_profiles)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="diskLogging")
    def disk_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable logging to local disk - Default value: `true`
        """
        return pulumi.get(self, "disk_logging")

    @disk_logging.setter
    def disk_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disk_logging", value)

    @property
    @pulumi.getter(name="diskLoggingVariable")
    def disk_logging_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "disk_logging_variable")

    @disk_logging_variable.setter
    def disk_logging_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_logging_variable", value)

    @property
    @pulumi.getter(name="ipv4Servers")
    def ipv4_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv4ServerArgs']]]]:
        """
        Enable logging to remote server
        """
        return pulumi.get(self, "ipv4_servers")

    @ipv4_servers.setter
    def ipv4_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv4ServerArgs']]]]):
        pulumi.set(self, "ipv4_servers", value)

    @property
    @pulumi.getter(name="ipv6Servers")
    def ipv6_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv6ServerArgs']]]]:
        """
        Enable logging to remote IPv6 server
        """
        return pulumi.get(self, "ipv6_servers")

    @ipv6_servers.setter
    def ipv6_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv6ServerArgs']]]]):
        pulumi.set(self, "ipv6_servers", value)

    @property
    @pulumi.getter(name="logRotations")
    def log_rotations(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set number of syslog files to create before discarding oldest files - Range: `1`-`10` - Default value: `10`
        """
        return pulumi.get(self, "log_rotations")

    @log_rotations.setter
    def log_rotations(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "log_rotations", value)

    @property
    @pulumi.getter(name="logRotationsVariable")
    def log_rotations_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "log_rotations_variable")

    @log_rotations_variable.setter
    def log_rotations_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_rotations_variable", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set maximum size of file before it is rotated - Range: `1`-`20` - Default value: `10`
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeVariable")
    def max_size_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "max_size_variable")

    @max_size_variable.setter
    def max_size_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_size_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tlsProfiles")
    def tls_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateTlsProfileArgs']]]]:
        """
        Configure a TLS profile
        """
        return pulumi.get(self, "tls_profiles")

    @tls_profiles.setter
    def tls_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateTlsProfileArgs']]]]):
        pulumi.set(self, "tls_profiles", value)


@pulumi.input_type
class _CiscoLoggingFeatureTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 disk_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 disk_logging_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv4ServerArgs']]]] = None,
                 ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv6ServerArgs']]]] = None,
                 log_rotations: Optional[pulumi.Input[builtins.int]] = None,
                 log_rotations_variable: Optional[pulumi.Input[builtins.str]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 max_size_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 tls_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateTlsProfileArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CiscoLoggingFeatureTemplate resources.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] disk_logging: Enable logging to local disk - Default value: `true`
        :param pulumi.Input[builtins.str] disk_logging_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv4ServerArgs']]] ipv4_servers: Enable logging to remote server
        :param pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv6ServerArgs']]] ipv6_servers: Enable logging to remote IPv6 server
        :param pulumi.Input[builtins.int] log_rotations: Set number of syslog files to create before discarding oldest files - Range: `1`-`10` - Default value: `10`
        :param pulumi.Input[builtins.str] log_rotations_variable: Variable name
        :param pulumi.Input[builtins.int] max_size: Set maximum size of file before it is rotated - Range: `1`-`20` - Default value: `10`
        :param pulumi.Input[builtins.str] max_size_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateTlsProfileArgs']]] tls_profiles: Configure a TLS profile
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if disk_logging is not None:
            pulumi.set(__self__, "disk_logging", disk_logging)
        if disk_logging_variable is not None:
            pulumi.set(__self__, "disk_logging_variable", disk_logging_variable)
        if ipv4_servers is not None:
            pulumi.set(__self__, "ipv4_servers", ipv4_servers)
        if ipv6_servers is not None:
            pulumi.set(__self__, "ipv6_servers", ipv6_servers)
        if log_rotations is not None:
            pulumi.set(__self__, "log_rotations", log_rotations)
        if log_rotations_variable is not None:
            pulumi.set(__self__, "log_rotations_variable", log_rotations_variable)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_variable is not None:
            pulumi.set(__self__, "max_size_variable", max_size_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if tls_profiles is not None:
            pulumi.set(__self__, "tls_profiles", tls_profiles)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="diskLogging")
    def disk_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable logging to local disk - Default value: `true`
        """
        return pulumi.get(self, "disk_logging")

    @disk_logging.setter
    def disk_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disk_logging", value)

    @property
    @pulumi.getter(name="diskLoggingVariable")
    def disk_logging_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "disk_logging_variable")

    @disk_logging_variable.setter
    def disk_logging_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_logging_variable", value)

    @property
    @pulumi.getter(name="ipv4Servers")
    def ipv4_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv4ServerArgs']]]]:
        """
        Enable logging to remote server
        """
        return pulumi.get(self, "ipv4_servers")

    @ipv4_servers.setter
    def ipv4_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv4ServerArgs']]]]):
        pulumi.set(self, "ipv4_servers", value)

    @property
    @pulumi.getter(name="ipv6Servers")
    def ipv6_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv6ServerArgs']]]]:
        """
        Enable logging to remote IPv6 server
        """
        return pulumi.get(self, "ipv6_servers")

    @ipv6_servers.setter
    def ipv6_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateIpv6ServerArgs']]]]):
        pulumi.set(self, "ipv6_servers", value)

    @property
    @pulumi.getter(name="logRotations")
    def log_rotations(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set number of syslog files to create before discarding oldest files - Range: `1`-`10` - Default value: `10`
        """
        return pulumi.get(self, "log_rotations")

    @log_rotations.setter
    def log_rotations(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "log_rotations", value)

    @property
    @pulumi.getter(name="logRotationsVariable")
    def log_rotations_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "log_rotations_variable")

    @log_rotations_variable.setter
    def log_rotations_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_rotations_variable", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set maximum size of file before it is rotated - Range: `1`-`20` - Default value: `10`
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeVariable")
    def max_size_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "max_size_variable")

    @max_size_variable.setter
    def max_size_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_size_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="tlsProfiles")
    def tls_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateTlsProfileArgs']]]]:
        """
        Configure a TLS profile
        """
        return pulumi.get(self, "tls_profiles")

    @tls_profiles.setter
    def tls_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoLoggingFeatureTemplateTlsProfileArgs']]]]):
        pulumi.set(self, "tls_profiles", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/ciscoLoggingFeatureTemplate:CiscoLoggingFeatureTemplate")
class CiscoLoggingFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 disk_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 disk_logging_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv4ServerArgs', 'CiscoLoggingFeatureTemplateIpv4ServerArgsDict']]]]] = None,
                 ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv6ServerArgs', 'CiscoLoggingFeatureTemplateIpv6ServerArgsDict']]]]] = None,
                 log_rotations: Optional[pulumi.Input[builtins.int]] = None,
                 log_rotations_variable: Optional[pulumi.Input[builtins.str]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 max_size_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tls_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateTlsProfileArgs', 'CiscoLoggingFeatureTemplateTlsProfileArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco Logging feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoLoggingFeatureTemplate:CiscoLoggingFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] disk_logging: Enable logging to local disk - Default value: `true`
        :param pulumi.Input[builtins.str] disk_logging_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv4ServerArgs', 'CiscoLoggingFeatureTemplateIpv4ServerArgsDict']]]] ipv4_servers: Enable logging to remote server
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv6ServerArgs', 'CiscoLoggingFeatureTemplateIpv6ServerArgsDict']]]] ipv6_servers: Enable logging to remote IPv6 server
        :param pulumi.Input[builtins.int] log_rotations: Set number of syslog files to create before discarding oldest files - Range: `1`-`10` - Default value: `10`
        :param pulumi.Input[builtins.str] log_rotations_variable: Variable name
        :param pulumi.Input[builtins.int] max_size: Set maximum size of file before it is rotated - Range: `1`-`20` - Default value: `10`
        :param pulumi.Input[builtins.str] max_size_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateTlsProfileArgs', 'CiscoLoggingFeatureTemplateTlsProfileArgsDict']]]] tls_profiles: Configure a TLS profile
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoLoggingFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco Logging feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoLoggingFeatureTemplate:CiscoLoggingFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoLoggingFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoLoggingFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 disk_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 disk_logging_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv4ServerArgs', 'CiscoLoggingFeatureTemplateIpv4ServerArgsDict']]]]] = None,
                 ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv6ServerArgs', 'CiscoLoggingFeatureTemplateIpv6ServerArgsDict']]]]] = None,
                 log_rotations: Optional[pulumi.Input[builtins.int]] = None,
                 log_rotations_variable: Optional[pulumi.Input[builtins.str]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 max_size_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tls_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateTlsProfileArgs', 'CiscoLoggingFeatureTemplateTlsProfileArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoLoggingFeatureTemplateArgs.__new__(CiscoLoggingFeatureTemplateArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["disk_logging"] = disk_logging
            __props__.__dict__["disk_logging_variable"] = disk_logging_variable
            __props__.__dict__["ipv4_servers"] = ipv4_servers
            __props__.__dict__["ipv6_servers"] = ipv6_servers
            __props__.__dict__["log_rotations"] = log_rotations
            __props__.__dict__["log_rotations_variable"] = log_rotations_variable
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["max_size_variable"] = max_size_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["tls_profiles"] = tls_profiles
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoLoggingFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoLoggingFeatureTemplate:CiscoLoggingFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            disk_logging: Optional[pulumi.Input[builtins.bool]] = None,
            disk_logging_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv4ServerArgs', 'CiscoLoggingFeatureTemplateIpv4ServerArgsDict']]]]] = None,
            ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv6ServerArgs', 'CiscoLoggingFeatureTemplateIpv6ServerArgsDict']]]]] = None,
            log_rotations: Optional[pulumi.Input[builtins.int]] = None,
            log_rotations_variable: Optional[pulumi.Input[builtins.str]] = None,
            max_size: Optional[pulumi.Input[builtins.int]] = None,
            max_size_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            tls_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateTlsProfileArgs', 'CiscoLoggingFeatureTemplateTlsProfileArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CiscoLoggingFeatureTemplate':
        """
        Get an existing CiscoLoggingFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.bool] disk_logging: Enable logging to local disk - Default value: `true`
        :param pulumi.Input[builtins.str] disk_logging_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv4ServerArgs', 'CiscoLoggingFeatureTemplateIpv4ServerArgsDict']]]] ipv4_servers: Enable logging to remote server
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateIpv6ServerArgs', 'CiscoLoggingFeatureTemplateIpv6ServerArgsDict']]]] ipv6_servers: Enable logging to remote IPv6 server
        :param pulumi.Input[builtins.int] log_rotations: Set number of syslog files to create before discarding oldest files - Range: `1`-`10` - Default value: `10`
        :param pulumi.Input[builtins.str] log_rotations_variable: Variable name
        :param pulumi.Input[builtins.int] max_size: Set maximum size of file before it is rotated - Range: `1`-`20` - Default value: `10`
        :param pulumi.Input[builtins.str] max_size_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoLoggingFeatureTemplateTlsProfileArgs', 'CiscoLoggingFeatureTemplateTlsProfileArgsDict']]]] tls_profiles: Configure a TLS profile
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoLoggingFeatureTemplateState.__new__(_CiscoLoggingFeatureTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["disk_logging"] = disk_logging
        __props__.__dict__["disk_logging_variable"] = disk_logging_variable
        __props__.__dict__["ipv4_servers"] = ipv4_servers
        __props__.__dict__["ipv6_servers"] = ipv6_servers
        __props__.__dict__["log_rotations"] = log_rotations
        __props__.__dict__["log_rotations_variable"] = log_rotations_variable
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["max_size_variable"] = max_size_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["tls_profiles"] = tls_profiles
        __props__.__dict__["version"] = version
        return CiscoLoggingFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="diskLogging")
    def disk_logging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable logging to local disk - Default value: `true`
        """
        return pulumi.get(self, "disk_logging")

    @property
    @pulumi.getter(name="diskLoggingVariable")
    def disk_logging_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "disk_logging_variable")

    @property
    @pulumi.getter(name="ipv4Servers")
    def ipv4_servers(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoLoggingFeatureTemplateIpv4Server']]]:
        """
        Enable logging to remote server
        """
        return pulumi.get(self, "ipv4_servers")

    @property
    @pulumi.getter(name="ipv6Servers")
    def ipv6_servers(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoLoggingFeatureTemplateIpv6Server']]]:
        """
        Enable logging to remote IPv6 server
        """
        return pulumi.get(self, "ipv6_servers")

    @property
    @pulumi.getter(name="logRotations")
    def log_rotations(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set number of syslog files to create before discarding oldest files - Range: `1`-`10` - Default value: `10`
        """
        return pulumi.get(self, "log_rotations")

    @property
    @pulumi.getter(name="logRotationsVariable")
    def log_rotations_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "log_rotations_variable")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set maximum size of file before it is rotated - Range: `1`-`20` - Default value: `10`
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeVariable")
    def max_size_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "max_size_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="tlsProfiles")
    def tls_profiles(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoLoggingFeatureTemplateTlsProfile']]]:
        """
        Configure a TLS profile
        """
        return pulumi.get(self, "tls_profiles")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

