# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsSecurityPolicyDefinitionArgs', 'DnsSecurityPolicyDefinition']

@pulumi.input_type
class DnsSecurityPolicyDefinitionArgs:
    def __init__(__self__, *,
                 cisco_sig_credentials_feature_template_id: pulumi.Input[builtins.str],
                 description: pulumi.Input[builtins.str],
                 match_all_vpn: pulumi.Input[builtins.bool],
                 umbrella_dns_default: pulumi.Input[builtins.bool],
                 cisco_sig_credentials_feature_template_version: Optional[pulumi.Input[builtins.int]] = None,
                 custom_dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 dnscrypt: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 domain_list_version: Optional[pulumi.Input[builtins.int]] = None,
                 local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyDefinitionTargetVpnArgs']]]] = None):
        """
        The set of arguments for constructing a DnsSecurityPolicyDefinition resource.
        :param pulumi.Input[builtins.str] cisco_sig_credentials_feature_template_id: Credentials feature template ID
        :param pulumi.Input[builtins.str] description: The description of the policy definition.
        :param pulumi.Input[builtins.bool] match_all_vpn: Should use match all VPN
        :param pulumi.Input[builtins.bool] umbrella_dns_default: Should use umbrella as DNS Server
        :param pulumi.Input[builtins.int] cisco_sig_credentials_feature_template_version: Credentials feature template version
        :param pulumi.Input[builtins.str] custom_dns_server_ip: Only relevant when `umbrella_dns_default` is `false`
        :param pulumi.Input[builtins.bool] dnscrypt: Should DNSCrypt be enabled
        :param pulumi.Input[builtins.str] domain_list_id: Local domain bypass list ID
        :param pulumi.Input[builtins.int] domain_list_version: Local domain bypass list version
        :param pulumi.Input[builtins.bool] local_domain_bypass_enabled: Should the local domain bypass list be enabled
        :param pulumi.Input[builtins.str] name: The name of the policy definition.
        :param pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyDefinitionTargetVpnArgs']]] target_vpns: Only relevant when `match_all_vpn` is `false`
        """
        pulumi.set(__self__, "cisco_sig_credentials_feature_template_id", cisco_sig_credentials_feature_template_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "match_all_vpn", match_all_vpn)
        pulumi.set(__self__, "umbrella_dns_default", umbrella_dns_default)
        if cisco_sig_credentials_feature_template_version is not None:
            pulumi.set(__self__, "cisco_sig_credentials_feature_template_version", cisco_sig_credentials_feature_template_version)
        if custom_dns_server_ip is not None:
            pulumi.set(__self__, "custom_dns_server_ip", custom_dns_server_ip)
        if dnscrypt is not None:
            pulumi.set(__self__, "dnscrypt", dnscrypt)
        if domain_list_id is not None:
            pulumi.set(__self__, "domain_list_id", domain_list_id)
        if domain_list_version is not None:
            pulumi.set(__self__, "domain_list_version", domain_list_version)
        if local_domain_bypass_enabled is not None:
            pulumi.set(__self__, "local_domain_bypass_enabled", local_domain_bypass_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_vpns is not None:
            pulumi.set(__self__, "target_vpns", target_vpns)

    @property
    @pulumi.getter(name="ciscoSigCredentialsFeatureTemplateId")
    def cisco_sig_credentials_feature_template_id(self) -> pulumi.Input[builtins.str]:
        """
        Credentials feature template ID
        """
        return pulumi.get(self, "cisco_sig_credentials_feature_template_id")

    @cisco_sig_credentials_feature_template_id.setter
    def cisco_sig_credentials_feature_template_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cisco_sig_credentials_feature_template_id", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the policy definition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> pulumi.Input[builtins.bool]:
        """
        Should use match all VPN
        """
        return pulumi.get(self, "match_all_vpn")

    @match_all_vpn.setter
    def match_all_vpn(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "match_all_vpn", value)

    @property
    @pulumi.getter(name="umbrellaDnsDefault")
    def umbrella_dns_default(self) -> pulumi.Input[builtins.bool]:
        """
        Should use umbrella as DNS Server
        """
        return pulumi.get(self, "umbrella_dns_default")

    @umbrella_dns_default.setter
    def umbrella_dns_default(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "umbrella_dns_default", value)

    @property
    @pulumi.getter(name="ciscoSigCredentialsFeatureTemplateVersion")
    def cisco_sig_credentials_feature_template_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Credentials feature template version
        """
        return pulumi.get(self, "cisco_sig_credentials_feature_template_version")

    @cisco_sig_credentials_feature_template_version.setter
    def cisco_sig_credentials_feature_template_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cisco_sig_credentials_feature_template_version", value)

    @property
    @pulumi.getter(name="customDnsServerIp")
    def custom_dns_server_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Only relevant when `umbrella_dns_default` is `false`
        """
        return pulumi.get(self, "custom_dns_server_ip")

    @custom_dns_server_ip.setter
    def custom_dns_server_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_dns_server_ip", value)

    @property
    @pulumi.getter
    def dnscrypt(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should DNSCrypt be enabled
        """
        return pulumi.get(self, "dnscrypt")

    @dnscrypt.setter
    def dnscrypt(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dnscrypt", value)

    @property
    @pulumi.getter(name="domainListId")
    def domain_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Local domain bypass list ID
        """
        return pulumi.get(self, "domain_list_id")

    @domain_list_id.setter
    def domain_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_list_id", value)

    @property
    @pulumi.getter(name="domainListVersion")
    def domain_list_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Local domain bypass list version
        """
        return pulumi.get(self, "domain_list_version")

    @domain_list_version.setter
    def domain_list_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "domain_list_version", value)

    @property
    @pulumi.getter(name="localDomainBypassEnabled")
    def local_domain_bypass_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the local domain bypass list be enabled
        """
        return pulumi.get(self, "local_domain_bypass_enabled")

    @local_domain_bypass_enabled.setter
    def local_domain_bypass_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_domain_bypass_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyDefinitionTargetVpnArgs']]]]:
        """
        Only relevant when `match_all_vpn` is `false`
        """
        return pulumi.get(self, "target_vpns")

    @target_vpns.setter
    def target_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyDefinitionTargetVpnArgs']]]]):
        pulumi.set(self, "target_vpns", value)


@pulumi.input_type
class _DnsSecurityPolicyDefinitionState:
    def __init__(__self__, *,
                 cisco_sig_credentials_feature_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 cisco_sig_credentials_feature_template_version: Optional[pulumi.Input[builtins.int]] = None,
                 custom_dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dnscrypt: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 domain_list_version: Optional[pulumi.Input[builtins.int]] = None,
                 local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyDefinitionTargetVpnArgs']]]] = None,
                 umbrella_dns_default: Optional[pulumi.Input[builtins.bool]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering DnsSecurityPolicyDefinition resources.
        :param pulumi.Input[builtins.str] cisco_sig_credentials_feature_template_id: Credentials feature template ID
        :param pulumi.Input[builtins.int] cisco_sig_credentials_feature_template_version: Credentials feature template version
        :param pulumi.Input[builtins.str] custom_dns_server_ip: Only relevant when `umbrella_dns_default` is `false`
        :param pulumi.Input[builtins.str] description: The description of the policy definition.
        :param pulumi.Input[builtins.bool] dnscrypt: Should DNSCrypt be enabled
        :param pulumi.Input[builtins.str] domain_list_id: Local domain bypass list ID
        :param pulumi.Input[builtins.int] domain_list_version: Local domain bypass list version
        :param pulumi.Input[builtins.bool] local_domain_bypass_enabled: Should the local domain bypass list be enabled
        :param pulumi.Input[builtins.bool] match_all_vpn: Should use match all VPN
        :param pulumi.Input[builtins.str] name: The name of the policy definition.
        :param pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyDefinitionTargetVpnArgs']]] target_vpns: Only relevant when `match_all_vpn` is `false`
        :param pulumi.Input[builtins.bool] umbrella_dns_default: Should use umbrella as DNS Server
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        if cisco_sig_credentials_feature_template_id is not None:
            pulumi.set(__self__, "cisco_sig_credentials_feature_template_id", cisco_sig_credentials_feature_template_id)
        if cisco_sig_credentials_feature_template_version is not None:
            pulumi.set(__self__, "cisco_sig_credentials_feature_template_version", cisco_sig_credentials_feature_template_version)
        if custom_dns_server_ip is not None:
            pulumi.set(__self__, "custom_dns_server_ip", custom_dns_server_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dnscrypt is not None:
            pulumi.set(__self__, "dnscrypt", dnscrypt)
        if domain_list_id is not None:
            pulumi.set(__self__, "domain_list_id", domain_list_id)
        if domain_list_version is not None:
            pulumi.set(__self__, "domain_list_version", domain_list_version)
        if local_domain_bypass_enabled is not None:
            pulumi.set(__self__, "local_domain_bypass_enabled", local_domain_bypass_enabled)
        if match_all_vpn is not None:
            pulumi.set(__self__, "match_all_vpn", match_all_vpn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_vpns is not None:
            pulumi.set(__self__, "target_vpns", target_vpns)
        if umbrella_dns_default is not None:
            pulumi.set(__self__, "umbrella_dns_default", umbrella_dns_default)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="ciscoSigCredentialsFeatureTemplateId")
    def cisco_sig_credentials_feature_template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Credentials feature template ID
        """
        return pulumi.get(self, "cisco_sig_credentials_feature_template_id")

    @cisco_sig_credentials_feature_template_id.setter
    def cisco_sig_credentials_feature_template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cisco_sig_credentials_feature_template_id", value)

    @property
    @pulumi.getter(name="ciscoSigCredentialsFeatureTemplateVersion")
    def cisco_sig_credentials_feature_template_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Credentials feature template version
        """
        return pulumi.get(self, "cisco_sig_credentials_feature_template_version")

    @cisco_sig_credentials_feature_template_version.setter
    def cisco_sig_credentials_feature_template_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cisco_sig_credentials_feature_template_version", value)

    @property
    @pulumi.getter(name="customDnsServerIp")
    def custom_dns_server_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Only relevant when `umbrella_dns_default` is `false`
        """
        return pulumi.get(self, "custom_dns_server_ip")

    @custom_dns_server_ip.setter
    def custom_dns_server_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_dns_server_ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the policy definition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dnscrypt(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should DNSCrypt be enabled
        """
        return pulumi.get(self, "dnscrypt")

    @dnscrypt.setter
    def dnscrypt(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dnscrypt", value)

    @property
    @pulumi.getter(name="domainListId")
    def domain_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Local domain bypass list ID
        """
        return pulumi.get(self, "domain_list_id")

    @domain_list_id.setter
    def domain_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_list_id", value)

    @property
    @pulumi.getter(name="domainListVersion")
    def domain_list_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Local domain bypass list version
        """
        return pulumi.get(self, "domain_list_version")

    @domain_list_version.setter
    def domain_list_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "domain_list_version", value)

    @property
    @pulumi.getter(name="localDomainBypassEnabled")
    def local_domain_bypass_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the local domain bypass list be enabled
        """
        return pulumi.get(self, "local_domain_bypass_enabled")

    @local_domain_bypass_enabled.setter
    def local_domain_bypass_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_domain_bypass_enabled", value)

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should use match all VPN
        """
        return pulumi.get(self, "match_all_vpn")

    @match_all_vpn.setter
    def match_all_vpn(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "match_all_vpn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyDefinitionTargetVpnArgs']]]]:
        """
        Only relevant when `match_all_vpn` is `false`
        """
        return pulumi.get(self, "target_vpns")

    @target_vpns.setter
    def target_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyDefinitionTargetVpnArgs']]]]):
        pulumi.set(self, "target_vpns", value)

    @property
    @pulumi.getter(name="umbrellaDnsDefault")
    def umbrella_dns_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should use umbrella as DNS Server
        """
        return pulumi.get(self, "umbrella_dns_default")

    @umbrella_dns_default.setter
    def umbrella_dns_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "umbrella_dns_default", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/dnsSecurityPolicyDefinition:DnsSecurityPolicyDefinition")
class DnsSecurityPolicyDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cisco_sig_credentials_feature_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 cisco_sig_credentials_feature_template_version: Optional[pulumi.Input[builtins.int]] = None,
                 custom_dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dnscrypt: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 domain_list_version: Optional[pulumi.Input[builtins.int]] = None,
                 local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyDefinitionTargetVpnArgs', 'DnsSecurityPolicyDefinitionTargetVpnArgsDict']]]]] = None,
                 umbrella_dns_default: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource can manage a DNS Security Policy Definition .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.DnsSecurityPolicyDefinition("example",
            name="Example",
            description="Example",
            domain_list_id="84f10c9d-def7-45a3-8c64-6df26163c861",
            local_domain_bypass_enabled=False,
            match_all_vpn=True,
            dnscrypt=True,
            umbrella_dns_default=True,
            cisco_sig_credentials_feature_template_id="3ac6eef9-bd8f-458d-96a7-a932c90b1e75")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/dnsSecurityPolicyDefinition:DnsSecurityPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cisco_sig_credentials_feature_template_id: Credentials feature template ID
        :param pulumi.Input[builtins.int] cisco_sig_credentials_feature_template_version: Credentials feature template version
        :param pulumi.Input[builtins.str] custom_dns_server_ip: Only relevant when `umbrella_dns_default` is `false`
        :param pulumi.Input[builtins.str] description: The description of the policy definition.
        :param pulumi.Input[builtins.bool] dnscrypt: Should DNSCrypt be enabled
        :param pulumi.Input[builtins.str] domain_list_id: Local domain bypass list ID
        :param pulumi.Input[builtins.int] domain_list_version: Local domain bypass list version
        :param pulumi.Input[builtins.bool] local_domain_bypass_enabled: Should the local domain bypass list be enabled
        :param pulumi.Input[builtins.bool] match_all_vpn: Should use match all VPN
        :param pulumi.Input[builtins.str] name: The name of the policy definition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyDefinitionTargetVpnArgs', 'DnsSecurityPolicyDefinitionTargetVpnArgsDict']]]] target_vpns: Only relevant when `match_all_vpn` is `false`
        :param pulumi.Input[builtins.bool] umbrella_dns_default: Should use umbrella as DNS Server
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsSecurityPolicyDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a DNS Security Policy Definition .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.DnsSecurityPolicyDefinition("example",
            name="Example",
            description="Example",
            domain_list_id="84f10c9d-def7-45a3-8c64-6df26163c861",
            local_domain_bypass_enabled=False,
            match_all_vpn=True,
            dnscrypt=True,
            umbrella_dns_default=True,
            cisco_sig_credentials_feature_template_id="3ac6eef9-bd8f-458d-96a7-a932c90b1e75")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/dnsSecurityPolicyDefinition:DnsSecurityPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param DnsSecurityPolicyDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsSecurityPolicyDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cisco_sig_credentials_feature_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 cisco_sig_credentials_feature_template_version: Optional[pulumi.Input[builtins.int]] = None,
                 custom_dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dnscrypt: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 domain_list_version: Optional[pulumi.Input[builtins.int]] = None,
                 local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyDefinitionTargetVpnArgs', 'DnsSecurityPolicyDefinitionTargetVpnArgsDict']]]]] = None,
                 umbrella_dns_default: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsSecurityPolicyDefinitionArgs.__new__(DnsSecurityPolicyDefinitionArgs)

            if cisco_sig_credentials_feature_template_id is None and not opts.urn:
                raise TypeError("Missing required property 'cisco_sig_credentials_feature_template_id'")
            __props__.__dict__["cisco_sig_credentials_feature_template_id"] = cisco_sig_credentials_feature_template_id
            __props__.__dict__["cisco_sig_credentials_feature_template_version"] = cisco_sig_credentials_feature_template_version
            __props__.__dict__["custom_dns_server_ip"] = custom_dns_server_ip
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["dnscrypt"] = dnscrypt
            __props__.__dict__["domain_list_id"] = domain_list_id
            __props__.__dict__["domain_list_version"] = domain_list_version
            __props__.__dict__["local_domain_bypass_enabled"] = local_domain_bypass_enabled
            if match_all_vpn is None and not opts.urn:
                raise TypeError("Missing required property 'match_all_vpn'")
            __props__.__dict__["match_all_vpn"] = match_all_vpn
            __props__.__dict__["name"] = name
            __props__.__dict__["target_vpns"] = target_vpns
            if umbrella_dns_default is None and not opts.urn:
                raise TypeError("Missing required property 'umbrella_dns_default'")
            __props__.__dict__["umbrella_dns_default"] = umbrella_dns_default
            __props__.__dict__["version"] = None
        super(DnsSecurityPolicyDefinition, __self__).__init__(
            'sdwan:index/dnsSecurityPolicyDefinition:DnsSecurityPolicyDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cisco_sig_credentials_feature_template_id: Optional[pulumi.Input[builtins.str]] = None,
            cisco_sig_credentials_feature_template_version: Optional[pulumi.Input[builtins.int]] = None,
            custom_dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dnscrypt: Optional[pulumi.Input[builtins.bool]] = None,
            domain_list_id: Optional[pulumi.Input[builtins.str]] = None,
            domain_list_version: Optional[pulumi.Input[builtins.int]] = None,
            local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyDefinitionTargetVpnArgs', 'DnsSecurityPolicyDefinitionTargetVpnArgsDict']]]]] = None,
            umbrella_dns_default: Optional[pulumi.Input[builtins.bool]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'DnsSecurityPolicyDefinition':
        """
        Get an existing DnsSecurityPolicyDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cisco_sig_credentials_feature_template_id: Credentials feature template ID
        :param pulumi.Input[builtins.int] cisco_sig_credentials_feature_template_version: Credentials feature template version
        :param pulumi.Input[builtins.str] custom_dns_server_ip: Only relevant when `umbrella_dns_default` is `false`
        :param pulumi.Input[builtins.str] description: The description of the policy definition.
        :param pulumi.Input[builtins.bool] dnscrypt: Should DNSCrypt be enabled
        :param pulumi.Input[builtins.str] domain_list_id: Local domain bypass list ID
        :param pulumi.Input[builtins.int] domain_list_version: Local domain bypass list version
        :param pulumi.Input[builtins.bool] local_domain_bypass_enabled: Should the local domain bypass list be enabled
        :param pulumi.Input[builtins.bool] match_all_vpn: Should use match all VPN
        :param pulumi.Input[builtins.str] name: The name of the policy definition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyDefinitionTargetVpnArgs', 'DnsSecurityPolicyDefinitionTargetVpnArgsDict']]]] target_vpns: Only relevant when `match_all_vpn` is `false`
        :param pulumi.Input[builtins.bool] umbrella_dns_default: Should use umbrella as DNS Server
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsSecurityPolicyDefinitionState.__new__(_DnsSecurityPolicyDefinitionState)

        __props__.__dict__["cisco_sig_credentials_feature_template_id"] = cisco_sig_credentials_feature_template_id
        __props__.__dict__["cisco_sig_credentials_feature_template_version"] = cisco_sig_credentials_feature_template_version
        __props__.__dict__["custom_dns_server_ip"] = custom_dns_server_ip
        __props__.__dict__["description"] = description
        __props__.__dict__["dnscrypt"] = dnscrypt
        __props__.__dict__["domain_list_id"] = domain_list_id
        __props__.__dict__["domain_list_version"] = domain_list_version
        __props__.__dict__["local_domain_bypass_enabled"] = local_domain_bypass_enabled
        __props__.__dict__["match_all_vpn"] = match_all_vpn
        __props__.__dict__["name"] = name
        __props__.__dict__["target_vpns"] = target_vpns
        __props__.__dict__["umbrella_dns_default"] = umbrella_dns_default
        __props__.__dict__["version"] = version
        return DnsSecurityPolicyDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ciscoSigCredentialsFeatureTemplateId")
    def cisco_sig_credentials_feature_template_id(self) -> pulumi.Output[builtins.str]:
        """
        Credentials feature template ID
        """
        return pulumi.get(self, "cisco_sig_credentials_feature_template_id")

    @property
    @pulumi.getter(name="ciscoSigCredentialsFeatureTemplateVersion")
    def cisco_sig_credentials_feature_template_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Credentials feature template version
        """
        return pulumi.get(self, "cisco_sig_credentials_feature_template_version")

    @property
    @pulumi.getter(name="customDnsServerIp")
    def custom_dns_server_ip(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Only relevant when `umbrella_dns_default` is `false`
        """
        return pulumi.get(self, "custom_dns_server_ip")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the policy definition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dnscrypt(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should DNSCrypt be enabled
        """
        return pulumi.get(self, "dnscrypt")

    @property
    @pulumi.getter(name="domainListId")
    def domain_list_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Local domain bypass list ID
        """
        return pulumi.get(self, "domain_list_id")

    @property
    @pulumi.getter(name="domainListVersion")
    def domain_list_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Local domain bypass list version
        """
        return pulumi.get(self, "domain_list_version")

    @property
    @pulumi.getter(name="localDomainBypassEnabled")
    def local_domain_bypass_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the local domain bypass list be enabled
        """
        return pulumi.get(self, "local_domain_bypass_enabled")

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> pulumi.Output[builtins.bool]:
        """
        Should use match all VPN
        """
        return pulumi.get(self, "match_all_vpn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> pulumi.Output[Optional[Sequence['outputs.DnsSecurityPolicyDefinitionTargetVpn']]]:
        """
        Only relevant when `match_all_vpn` is `false`
        """
        return pulumi.get(self, "target_vpns")

    @property
    @pulumi.getter(name="umbrellaDnsDefault")
    def umbrella_dns_default(self) -> pulumi.Output[builtins.bool]:
        """
        Should use umbrella as DNS Server
        """
        return pulumi.get(self, "umbrella_dns_default")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

