# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FeatureDeviceTemplateArgs', 'FeatureDeviceTemplate']

@pulumi.input_type
class FeatureDeviceTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_type: pulumi.Input[builtins.str],
                 device_role: Optional[pulumi.Input[builtins.str]] = None,
                 general_templates: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureDeviceTemplateGeneralTemplateArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_version: Optional[pulumi.Input[builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy_version: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a FeatureDeviceTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the device template
        :param pulumi.Input[builtins.str] device_type: The device type (e.g., `vedge-ISR-4331`)
        :param pulumi.Input[builtins.str] device_role: The device role - Choices: `sdwan-edge`, `service-node`
        :param pulumi.Input[Sequence[pulumi.Input['FeatureDeviceTemplateGeneralTemplateArgs']]] general_templates: List of general templates
        :param pulumi.Input[builtins.str] name: The name of the device template
        :param pulumi.Input[builtins.str] policy_id: The policy ID
        :param pulumi.Input[builtins.int] policy_version: The policy version
        :param pulumi.Input[builtins.str] security_policy_id: The security policy ID
        :param pulumi.Input[builtins.int] security_policy_version: The security policy version
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_type", device_type)
        if device_role is not None:
            pulumi.set(__self__, "device_role", device_role)
        if general_templates is not None:
            pulumi.set(__self__, "general_templates", general_templates)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_version is not None:
            pulumi.set(__self__, "policy_version", policy_version)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if security_policy_version is not None:
            pulumi.set(__self__, "security_policy_version", security_policy_version)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the device template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> pulumi.Input[builtins.str]:
        """
        The device type (e.g., `vedge-ISR-4331`)
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "device_type", value)

    @property
    @pulumi.getter(name="deviceRole")
    def device_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The device role - Choices: `sdwan-edge`, `service-node`
        """
        return pulumi.get(self, "device_role")

    @device_role.setter
    def device_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_role", value)

    @property
    @pulumi.getter(name="generalTemplates")
    def general_templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureDeviceTemplateGeneralTemplateArgs']]]]:
        """
        List of general templates
        """
        return pulumi.get(self, "general_templates")

    @general_templates.setter
    def general_templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureDeviceTemplateGeneralTemplateArgs']]]]):
        pulumi.set(self, "general_templates", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the device template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy ID
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The policy version
        """
        return pulumi.get(self, "policy_version")

    @policy_version.setter
    def policy_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "policy_version", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The security policy ID
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @property
    @pulumi.getter(name="securityPolicyVersion")
    def security_policy_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The security policy version
        """
        return pulumi.get(self, "security_policy_version")

    @security_policy_version.setter
    def security_policy_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "security_policy_version", value)


@pulumi.input_type
class _FeatureDeviceTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_role: Optional[pulumi.Input[builtins.str]] = None,
                 device_type: Optional[pulumi.Input[builtins.str]] = None,
                 general_templates: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureDeviceTemplateGeneralTemplateArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_version: Optional[pulumi.Input[builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy_version: Optional[pulumi.Input[builtins.int]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering FeatureDeviceTemplate resources.
        :param pulumi.Input[builtins.str] description: The description of the device template
        :param pulumi.Input[builtins.str] device_role: The device role - Choices: `sdwan-edge`, `service-node`
        :param pulumi.Input[builtins.str] device_type: The device type (e.g., `vedge-ISR-4331`)
        :param pulumi.Input[Sequence[pulumi.Input['FeatureDeviceTemplateGeneralTemplateArgs']]] general_templates: List of general templates
        :param pulumi.Input[builtins.str] name: The name of the device template
        :param pulumi.Input[builtins.str] policy_id: The policy ID
        :param pulumi.Input[builtins.int] policy_version: The policy version
        :param pulumi.Input[builtins.str] security_policy_id: The security policy ID
        :param pulumi.Input[builtins.int] security_policy_version: The security policy version
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_role is not None:
            pulumi.set(__self__, "device_role", device_role)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if general_templates is not None:
            pulumi.set(__self__, "general_templates", general_templates)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_version is not None:
            pulumi.set(__self__, "policy_version", policy_version)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if security_policy_version is not None:
            pulumi.set(__self__, "security_policy_version", security_policy_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the device template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceRole")
    def device_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The device role - Choices: `sdwan-edge`, `service-node`
        """
        return pulumi.get(self, "device_role")

    @device_role.setter
    def device_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_role", value)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The device type (e.g., `vedge-ISR-4331`)
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_type", value)

    @property
    @pulumi.getter(name="generalTemplates")
    def general_templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureDeviceTemplateGeneralTemplateArgs']]]]:
        """
        List of general templates
        """
        return pulumi.get(self, "general_templates")

    @general_templates.setter
    def general_templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureDeviceTemplateGeneralTemplateArgs']]]]):
        pulumi.set(self, "general_templates", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the device template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy ID
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The policy version
        """
        return pulumi.get(self, "policy_version")

    @policy_version.setter
    def policy_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "policy_version", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The security policy ID
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @property
    @pulumi.getter(name="securityPolicyVersion")
    def security_policy_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The security policy version
        """
        return pulumi.get(self, "security_policy_version")

    @security_policy_version.setter
    def security_policy_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "security_policy_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/featureDeviceTemplate:FeatureDeviceTemplate")
class FeatureDeviceTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_role: Optional[pulumi.Input[builtins.str]] = None,
                 device_type: Optional[pulumi.Input[builtins.str]] = None,
                 general_templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureDeviceTemplateGeneralTemplateArgs', 'FeatureDeviceTemplateGeneralTemplateArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_version: Optional[pulumi.Input[builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy_version: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource can manage a Feature Device Template .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.FeatureDeviceTemplate("example",
            name="Example",
            description="My description",
            device_type="vedge-ISR-4331",
            general_templates=[{
                "id": "2081c2f4-3f9f-4fee-8078-dcc8904e368d",
                "type": "cisco_system",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/featureDeviceTemplate:FeatureDeviceTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the device template
        :param pulumi.Input[builtins.str] device_role: The device role - Choices: `sdwan-edge`, `service-node`
        :param pulumi.Input[builtins.str] device_type: The device type (e.g., `vedge-ISR-4331`)
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeatureDeviceTemplateGeneralTemplateArgs', 'FeatureDeviceTemplateGeneralTemplateArgsDict']]]] general_templates: List of general templates
        :param pulumi.Input[builtins.str] name: The name of the device template
        :param pulumi.Input[builtins.str] policy_id: The policy ID
        :param pulumi.Input[builtins.int] policy_version: The policy version
        :param pulumi.Input[builtins.str] security_policy_id: The security policy ID
        :param pulumi.Input[builtins.int] security_policy_version: The security policy version
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FeatureDeviceTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Feature Device Template .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.FeatureDeviceTemplate("example",
            name="Example",
            description="My description",
            device_type="vedge-ISR-4331",
            general_templates=[{
                "id": "2081c2f4-3f9f-4fee-8078-dcc8904e368d",
                "type": "cisco_system",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/featureDeviceTemplate:FeatureDeviceTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param FeatureDeviceTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeatureDeviceTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_role: Optional[pulumi.Input[builtins.str]] = None,
                 device_type: Optional[pulumi.Input[builtins.str]] = None,
                 general_templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureDeviceTemplateGeneralTemplateArgs', 'FeatureDeviceTemplateGeneralTemplateArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_version: Optional[pulumi.Input[builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 security_policy_version: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeatureDeviceTemplateArgs.__new__(FeatureDeviceTemplateArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["device_role"] = device_role
            if device_type is None and not opts.urn:
                raise TypeError("Missing required property 'device_type'")
            __props__.__dict__["device_type"] = device_type
            __props__.__dict__["general_templates"] = general_templates
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["policy_version"] = policy_version
            __props__.__dict__["security_policy_id"] = security_policy_id
            __props__.__dict__["security_policy_version"] = security_policy_version
            __props__.__dict__["version"] = None
        super(FeatureDeviceTemplate, __self__).__init__(
            'sdwan:index/featureDeviceTemplate:FeatureDeviceTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_role: Optional[pulumi.Input[builtins.str]] = None,
            device_type: Optional[pulumi.Input[builtins.str]] = None,
            general_templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureDeviceTemplateGeneralTemplateArgs', 'FeatureDeviceTemplateGeneralTemplateArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            policy_id: Optional[pulumi.Input[builtins.str]] = None,
            policy_version: Optional[pulumi.Input[builtins.int]] = None,
            security_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            security_policy_version: Optional[pulumi.Input[builtins.int]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'FeatureDeviceTemplate':
        """
        Get an existing FeatureDeviceTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the device template
        :param pulumi.Input[builtins.str] device_role: The device role - Choices: `sdwan-edge`, `service-node`
        :param pulumi.Input[builtins.str] device_type: The device type (e.g., `vedge-ISR-4331`)
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeatureDeviceTemplateGeneralTemplateArgs', 'FeatureDeviceTemplateGeneralTemplateArgsDict']]]] general_templates: List of general templates
        :param pulumi.Input[builtins.str] name: The name of the device template
        :param pulumi.Input[builtins.str] policy_id: The policy ID
        :param pulumi.Input[builtins.int] policy_version: The policy version
        :param pulumi.Input[builtins.str] security_policy_id: The security policy ID
        :param pulumi.Input[builtins.int] security_policy_version: The security policy version
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FeatureDeviceTemplateState.__new__(_FeatureDeviceTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device_role"] = device_role
        __props__.__dict__["device_type"] = device_type
        __props__.__dict__["general_templates"] = general_templates
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["policy_version"] = policy_version
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["security_policy_version"] = security_policy_version
        __props__.__dict__["version"] = version
        return FeatureDeviceTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the device template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceRole")
    def device_role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The device role - Choices: `sdwan-edge`, `service-node`
        """
        return pulumi.get(self, "device_role")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> pulumi.Output[builtins.str]:
        """
        The device type (e.g., `vedge-ISR-4331`)
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter(name="generalTemplates")
    def general_templates(self) -> pulumi.Output[Optional[Sequence['outputs.FeatureDeviceTemplateGeneralTemplate']]]:
        """
        List of general templates
        """
        return pulumi.get(self, "general_templates")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the device template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The policy ID
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The policy version
        """
        return pulumi.get(self, "policy_version")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The security policy ID
        """
        return pulumi.get(self, "security_policy_id")

    @property
    @pulumi.getter(name="securityPolicyVersion")
    def security_policy_version(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The security policy version
        """
        return pulumi.get(self, "security_policy_version")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

