# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoWirelessLanFeatureTemplateResult',
    'AwaitableGetCiscoWirelessLanFeatureTemplateResult',
    'get_cisco_wireless_lan_feature_template',
    'get_cisco_wireless_lan_feature_template_output',
]

@pulumi.output_type
class GetCiscoWirelessLanFeatureTemplateResult:
    """
    A collection of values returned by getCiscoWirelessLanFeatureTemplate.
    """
    def __init__(__self__, controller_default_gateway=None, controller_default_gateway_variable=None, controller_ip_address=None, controller_ip_address_variable=None, controller_subnet_mask=None, controller_subnet_mask_variable=None, country=None, country_variable=None, description=None, device_types=None, id=None, name=None, password=None, password_variable=None, shutdown24ghz=None, shutdown24ghz_variable=None, shutdown5ghz=None, shutdown5ghz_variable=None, ssids=None, template_type=None, username=None, username_variable=None, version=None):
        if controller_default_gateway and not isinstance(controller_default_gateway, str):
            raise TypeError("Expected argument 'controller_default_gateway' to be a str")
        pulumi.set(__self__, "controller_default_gateway", controller_default_gateway)
        if controller_default_gateway_variable and not isinstance(controller_default_gateway_variable, str):
            raise TypeError("Expected argument 'controller_default_gateway_variable' to be a str")
        pulumi.set(__self__, "controller_default_gateway_variable", controller_default_gateway_variable)
        if controller_ip_address and not isinstance(controller_ip_address, str):
            raise TypeError("Expected argument 'controller_ip_address' to be a str")
        pulumi.set(__self__, "controller_ip_address", controller_ip_address)
        if controller_ip_address_variable and not isinstance(controller_ip_address_variable, str):
            raise TypeError("Expected argument 'controller_ip_address_variable' to be a str")
        pulumi.set(__self__, "controller_ip_address_variable", controller_ip_address_variable)
        if controller_subnet_mask and not isinstance(controller_subnet_mask, str):
            raise TypeError("Expected argument 'controller_subnet_mask' to be a str")
        pulumi.set(__self__, "controller_subnet_mask", controller_subnet_mask)
        if controller_subnet_mask_variable and not isinstance(controller_subnet_mask_variable, str):
            raise TypeError("Expected argument 'controller_subnet_mask_variable' to be a str")
        pulumi.set(__self__, "controller_subnet_mask_variable", controller_subnet_mask_variable)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if country_variable and not isinstance(country_variable, str):
            raise TypeError("Expected argument 'country_variable' to be a str")
        pulumi.set(__self__, "country_variable", country_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if password_variable and not isinstance(password_variable, str):
            raise TypeError("Expected argument 'password_variable' to be a str")
        pulumi.set(__self__, "password_variable", password_variable)
        if shutdown24ghz and not isinstance(shutdown24ghz, bool):
            raise TypeError("Expected argument 'shutdown24ghz' to be a bool")
        pulumi.set(__self__, "shutdown24ghz", shutdown24ghz)
        if shutdown24ghz_variable and not isinstance(shutdown24ghz_variable, str):
            raise TypeError("Expected argument 'shutdown24ghz_variable' to be a str")
        pulumi.set(__self__, "shutdown24ghz_variable", shutdown24ghz_variable)
        if shutdown5ghz and not isinstance(shutdown5ghz, bool):
            raise TypeError("Expected argument 'shutdown5ghz' to be a bool")
        pulumi.set(__self__, "shutdown5ghz", shutdown5ghz)
        if shutdown5ghz_variable and not isinstance(shutdown5ghz_variable, str):
            raise TypeError("Expected argument 'shutdown5ghz_variable' to be a str")
        pulumi.set(__self__, "shutdown5ghz_variable", shutdown5ghz_variable)
        if ssids and not isinstance(ssids, list):
            raise TypeError("Expected argument 'ssids' to be a list")
        pulumi.set(__self__, "ssids", ssids)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if username_variable and not isinstance(username_variable, str):
            raise TypeError("Expected argument 'username_variable' to be a str")
        pulumi.set(__self__, "username_variable", username_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="controllerDefaultGateway")
    def controller_default_gateway(self) -> builtins.str:
        """
        Set mobile express default gateway
        """
        return pulumi.get(self, "controller_default_gateway")

    @property
    @pulumi.getter(name="controllerDefaultGatewayVariable")
    def controller_default_gateway_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "controller_default_gateway_variable")

    @property
    @pulumi.getter(name="controllerIpAddress")
    def controller_ip_address(self) -> builtins.str:
        """
        Set mobile express controller address
        """
        return pulumi.get(self, "controller_ip_address")

    @property
    @pulumi.getter(name="controllerIpAddressVariable")
    def controller_ip_address_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "controller_ip_address_variable")

    @property
    @pulumi.getter(name="controllerSubnetMask")
    def controller_subnet_mask(self) -> builtins.str:
        """
        Set mobile express controller subnet mask
        """
        return pulumi.get(self, "controller_subnet_mask")

    @property
    @pulumi.getter(name="controllerSubnetMaskVariable")
    def controller_subnet_mask_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "controller_subnet_mask_variable")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Select country
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="countryVariable")
    def country_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "country_variable")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[builtins.str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Set management password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordVariable")
    def password_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "password_variable")

    @property
    @pulumi.getter
    def shutdown24ghz(self) -> builtins.bool:
        """
        2.4GHz Shutdown
        """
        return pulumi.get(self, "shutdown24ghz")

    @property
    @pulumi.getter(name="shutdown24ghzVariable")
    def shutdown24ghz_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown24ghz_variable")

    @property
    @pulumi.getter
    def shutdown5ghz(self) -> builtins.bool:
        """
        5GHz Shutdown
        """
        return pulumi.get(self, "shutdown5ghz")

    @property
    @pulumi.getter(name="shutdown5ghzVariable")
    def shutdown5ghz_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown5ghz_variable")

    @property
    @pulumi.getter
    def ssids(self) -> Sequence['outputs.GetCiscoWirelessLanFeatureTemplateSsidResult']:
        """
        Configure Wi-Fi SSID
        """
        return pulumi.get(self, "ssids")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> builtins.str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Set management username
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameVariable")
    def username_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "username_variable")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCiscoWirelessLanFeatureTemplateResult(GetCiscoWirelessLanFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoWirelessLanFeatureTemplateResult(
            controller_default_gateway=self.controller_default_gateway,
            controller_default_gateway_variable=self.controller_default_gateway_variable,
            controller_ip_address=self.controller_ip_address,
            controller_ip_address_variable=self.controller_ip_address_variable,
            controller_subnet_mask=self.controller_subnet_mask,
            controller_subnet_mask_variable=self.controller_subnet_mask_variable,
            country=self.country,
            country_variable=self.country_variable,
            description=self.description,
            device_types=self.device_types,
            id=self.id,
            name=self.name,
            password=self.password,
            password_variable=self.password_variable,
            shutdown24ghz=self.shutdown24ghz,
            shutdown24ghz_variable=self.shutdown24ghz_variable,
            shutdown5ghz=self.shutdown5ghz,
            shutdown5ghz_variable=self.shutdown5ghz_variable,
            ssids=self.ssids,
            template_type=self.template_type,
            username=self.username,
            username_variable=self.username_variable,
            version=self.version)


def get_cisco_wireless_lan_feature_template(id: Optional[builtins.str] = None,
                                            name: Optional[builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoWirelessLanFeatureTemplateResult:
    """
    This data source can read the Cisco Wireless LAN feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_wireless_lan_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param builtins.str id: The id of the feature template
    :param builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoWirelessLanFeatureTemplate:getCiscoWirelessLanFeatureTemplate', __args__, opts=opts, typ=GetCiscoWirelessLanFeatureTemplateResult).value

    return AwaitableGetCiscoWirelessLanFeatureTemplateResult(
        controller_default_gateway=pulumi.get(__ret__, 'controller_default_gateway'),
        controller_default_gateway_variable=pulumi.get(__ret__, 'controller_default_gateway_variable'),
        controller_ip_address=pulumi.get(__ret__, 'controller_ip_address'),
        controller_ip_address_variable=pulumi.get(__ret__, 'controller_ip_address_variable'),
        controller_subnet_mask=pulumi.get(__ret__, 'controller_subnet_mask'),
        controller_subnet_mask_variable=pulumi.get(__ret__, 'controller_subnet_mask_variable'),
        country=pulumi.get(__ret__, 'country'),
        country_variable=pulumi.get(__ret__, 'country_variable'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        password=pulumi.get(__ret__, 'password'),
        password_variable=pulumi.get(__ret__, 'password_variable'),
        shutdown24ghz=pulumi.get(__ret__, 'shutdown24ghz'),
        shutdown24ghz_variable=pulumi.get(__ret__, 'shutdown24ghz_variable'),
        shutdown5ghz=pulumi.get(__ret__, 'shutdown5ghz'),
        shutdown5ghz_variable=pulumi.get(__ret__, 'shutdown5ghz_variable'),
        ssids=pulumi.get(__ret__, 'ssids'),
        template_type=pulumi.get(__ret__, 'template_type'),
        username=pulumi.get(__ret__, 'username'),
        username_variable=pulumi.get(__ret__, 'username_variable'),
        version=pulumi.get(__ret__, 'version'))
def get_cisco_wireless_lan_feature_template_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                   name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCiscoWirelessLanFeatureTemplateResult]:
    """
    This data source can read the Cisco Wireless LAN feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_wireless_lan_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param builtins.str id: The id of the feature template
    :param builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getCiscoWirelessLanFeatureTemplate:getCiscoWirelessLanFeatureTemplate', __args__, opts=opts, typ=GetCiscoWirelessLanFeatureTemplateResult)
    return __ret__.apply(lambda __response__: GetCiscoWirelessLanFeatureTemplateResult(
        controller_default_gateway=pulumi.get(__response__, 'controller_default_gateway'),
        controller_default_gateway_variable=pulumi.get(__response__, 'controller_default_gateway_variable'),
        controller_ip_address=pulumi.get(__response__, 'controller_ip_address'),
        controller_ip_address_variable=pulumi.get(__response__, 'controller_ip_address_variable'),
        controller_subnet_mask=pulumi.get(__response__, 'controller_subnet_mask'),
        controller_subnet_mask_variable=pulumi.get(__response__, 'controller_subnet_mask_variable'),
        country=pulumi.get(__response__, 'country'),
        country_variable=pulumi.get(__response__, 'country_variable'),
        description=pulumi.get(__response__, 'description'),
        device_types=pulumi.get(__response__, 'device_types'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        password=pulumi.get(__response__, 'password'),
        password_variable=pulumi.get(__response__, 'password_variable'),
        shutdown24ghz=pulumi.get(__response__, 'shutdown24ghz'),
        shutdown24ghz_variable=pulumi.get(__response__, 'shutdown24ghz_variable'),
        shutdown5ghz=pulumi.get(__response__, 'shutdown5ghz'),
        shutdown5ghz_variable=pulumi.get(__response__, 'shutdown5ghz_variable'),
        ssids=pulumi.get(__response__, 'ssids'),
        template_type=pulumi.get(__response__, 'template_type'),
        username=pulumi.get(__response__, 'username'),
        username_variable=pulumi.get(__response__, 'username_variable'),
        version=pulumi.get(__response__, 'version')))
